/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMoleculeFactory;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.Dihedral;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.ForceFieldInterface;
import chemaxon.marvin.alignment.FunctionOneFlexibleMol;
import chemaxon.marvin.alignment.MMFF;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.Molecule;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TwoDPlot {
    private FunctionOneFlexibleMol f;
    private FlexibleMolecule fm;
    private static final int STEP_COUNT = 50;

    public TwoDPlot(Molecule m, ForceFieldInterface ffi) throws AlignmentException {
        AlignmentMoleculeFactory amf = new AlignmentMoleculeFactory();
        amf.setAromatize(true);
        amf.setDehidrogenize(false);
        amf.setCreateRingCenters(false);
        amf.setColor(AlignmentProperties.ColoringScheme.SAME);
        amf.setForceFieldPotential(ffi);
        amf.setGenerateDistanceRanges(false);
        amf.setNodeType(AlignmentProperties.NodeType.SIMPLE);
        amf.setShape(AlignmentProperties.ShapeDescriptorPoints.NOTHING);
        if (ffi != null) {
            ffi.init(m);
            double[][] crds = ffi.optimize();
            MolGeom.putCoordinates(m, crds);
        }
        this.fm = (FlexibleMolecule)amf.generate(0, m, false, true);
        for (int i = 0; i < this.fm.getDihedrals().size(); ++i) {
            Dihedral d = this.fm.getDihedrals().get(i);
            System.err.println(i + " " + d.nB + " " + d.nC);
        }
        this.f = new FunctionOneFlexibleMol(this.fm);
    }

    public void go(int index1, int index2) throws MolGeom.LinearBondAngleException, AlignmentException {
        Dihedral d1 = this.fm.getDihedrals().get(index1);
        Dihedral d2 = this.fm.getDihedrals().get(index2);
        d1.setEnabled(false);
        d2.setEnabled(false);
        d1.rotateTo(0.0);
        d2.rotateTo(0.0);
        double delta = 0.12566370614359174;
        for (int i1 = 0; i1 < 50; ++i1) {
            double a1 = d1.calcAngle();
            a1 = a1 / Math.PI * 180.0;
            for (int i2 = 0; i2 < 50; ++i2) {
                double a2 = d2.calcAngle();
                a2 = a2 / Math.PI * 180.0;
                double energy = this.getEnergy();
                System.err.println(a1 + " " + a2 + " " + energy);
                d2.rotateBy(delta);
            }
            d1.rotateBy(delta);
        }
    }

    public void go2(int index1) throws MolGeom.LinearBondAngleException, AlignmentException {
        Dihedral d1 = this.fm.getDihedrals().get(index1);
        d1.setEnabled(false);
        d1.rotateTo(0.0);
        double delta = 0.12566370614359174;
        for (int i1 = 0; i1 < 50; ++i1) {
            double a1 = d1.calcAngle();
            a1 = a1 / Math.PI * 180.0;
            double energy = this.getEnergy();
            System.err.println(a1 + " " + energy);
            d1.rotateBy(delta);
        }
    }

    private double getEnergy() throws AlignmentException {
        this.f.reset();
        GradientOptimization opt = new GradientOptimization(this.f);
        opt.setMaxStepComponent(0.7853981633974483);
        opt.setGradientRMSLimit(0.01);
        try {
            opt.run();
        }
        catch (GradientOptimization.GradientOptimizationException ex) {
            throw new AlignmentException(ex);
        }
        return this.f.getFunctionValue();
    }

    public static void main(String[] args) {
        try {
            Molecule m2 = MolGeom.readMols(args[0])[0];
            Molecule m = MolGeom.breakMol(m2)[1];
            m.clean(3, null);
            m.aromatize(1);
            m.hydrogenize(true);
            MolGeom.writeMol(m, "start2.mrv");
            TwoDPlot td = new TwoDPlot(m, new MMFF());
            td.go(0, 1);
        }
        catch (Exception ex) {
            Logger.getLogger(TwoDPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

