/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.core.util.BondTable;
import chemaxon.formats.MolExporter;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.GaussianSum;
import chemaxon.marvin.alignment.Interaction;
import chemaxon.marvin.alignment.MolecularConstraint;
import chemaxon.marvin.alignment.MolecularGaussianProduct;
import chemaxon.marvin.alignment.MultiCenterGaussian;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeList;
import chemaxon.marvin.alignment.NodeSimple;
import chemaxon.marvin.alignment.VolumeOverlap;
import chemaxon.marvin.alignment.VolumeOverlapConstraint;
import chemaxon.marvin.alignment.VolumeOverlapGrid;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

class Visualizer {
    Molecule m2show;
    double[] crdOneDim;
    double[][] crd;
    BondTable btab;
    boolean ringsRestored = false;
    boolean showExtraNodes = false;
    boolean wantCenter = false;
    boolean writeMolStream = false;
    boolean calcVolume = false;
    boolean coloredVolume = false;
    boolean showSelectedNodes = true;
    boolean showProxy = false;
    boolean showMolCenter = false;
    MolExporter me;
    List<AlignmentMolecule> am;
    Molecule mvol;
    ObjectOutputStream oo;
    VolumeOverlapGrid vg;
    int step = 0;
    List<Node> myNodes = new ArrayList<Node>();
    VolumeOverlap vol;
    private boolean showAtomic = false;
    double scale = 10.0;

    Visualizer() {
    }

    public void setVol(VolumeOverlap vol) {
        this.vol = vol;
    }

    public void setVg(VolumeOverlapGrid vg) {
        this.vg = vg;
    }

    public void setShowExtraNodes(boolean showExtraNodes) {
        this.showExtraNodes = showExtraNodes;
    }

    public void setShowRingCenter(boolean showRingCenter) {
        this.showSelectedNodes = showRingCenter;
    }

    private int getAtomSeq(Node ai) {
        int ret = -1;
        for (int i = 0; i < this.myNodes.size(); ++i) {
            if (!ai.equals(this.myNodes.get(i))) continue;
            if (ret != -1) {
                int p = 0;
                for (Node node : this.myNodes) {
                    System.err.println(p + " " + node);
                    ++p;
                }
                System.err.println("");
                System.err.println("want:");
                System.err.println(ai);
                System.err.println("found: " + ret + " and " + i);
                throw new UnsupportedOperationException();
            }
            ret = i;
        }
        return ret;
    }

    public void setWriteMolStream(boolean writeMolStream) {
        this.writeMolStream = writeMolStream;
    }

    public void setCalcVolume(boolean calcVolume) {
        this.calcVolume = calcVolume;
    }

    private Molecule createMolecule(AlignmentMolecule am) {
        int i;
        GaussianSum g;
        Molecule ret = am.getMoleculeOrig().cloneMolecule();
        for (int i2 = 0; i2 < am.getAtomCount(); ++i2) {
            this.myNodes.add(am.getAtom(i2));
        }
        if (this.showExtraNodes) {
            am.addGaussProducts(ret);
            NodeList<? extends Node> n = am.nodes;
            if (n instanceof GaussianSum) {
                g = (GaussianSum)n;
                for (i = g.getRealAtomCount(); i < g.size() - g.getMulticenterNodeCount(); ++i) {
                    this.myNodes.add((Node)g.get(i));
                }
            }
        }
        if (this.showSelectedNodes) {
            am.addRingCenterNodes(ret, false);
            NodeList<? extends Node> n = am.nodes;
            if (n instanceof GaussianSum) {
                g = (GaussianSum)n;
                for (i = g.size() - g.getMulticenterNodeCount(); i < g.size(); ++i) {
                    this.myNodes.add((Node)g.get(i));
                }
            }
        }
        if (this.showMolCenter) {
            am.addMolCenters(ret);
            if (am.center != null) {
                this.myNodes.add(new NodeSimple(am.molID, am.nodes.size(), am.center, 0, 0));
                this.myNodes.add(new NodeSimple(am.molID, am.nodes.size(), am.centerActual, 0, 0));
            }
        }
        return ret;
    }

    private int fillCrds(AlignmentMolecule am, int start) {
        Node n;
        int i;
        int pos = start;
        for (i = 0; i < am.getAtomCount(); ++i) {
            this.crd[pos++] = am.getAtom(i).getCrd();
        }
        if (this.showExtraNodes) {
            for (i = am.getAtomCount(); i < am.getNodeCount(); ++i) {
                n = am.nodes.get(i);
                if (!(n instanceof MolecularGaussianProduct)) continue;
                this.crd[pos++] = n.getCrd();
            }
        }
        if (this.showSelectedNodes) {
            for (i = am.getAtomCount(); i < am.getNodeCount(); ++i) {
                n = am.nodes.get(i);
                if (!(n instanceof MultiCenterGaussian)) continue;
                this.crd[pos++] = n.getCrd();
            }
        }
        if (this.showMolCenter && am.center != null) {
            this.crd[pos++] = am.center;
            this.crd[pos++] = am.centerActual;
        }
        return pos;
    }

    /*
     * WARNING - void declaration
     */
    public void init(List<AlignmentMolecule> am, List<? extends Interaction> external) {
        void var5_17;
        this.myNodes.clear();
        this.am = am;
        this.m2show = this.createMolecule(am.get(0));
        for (int i = 1; i < am.size(); ++i) {
            this.m2show.fuse(this.createMolecule(am.get(i)));
        }
        this.btab = this.m2show.getBondTable();
        this.crd = new double[this.m2show.getAtomCount()][];
        int pos = 0;
        for (int i = 0; i < am.size(); ++i) {
            int n;
            pos = n = this.fillCrds(am.get(i), pos);
        }
        this.crdOneDim = new double[this.crd.length * 3];
        MolGeom.putCoordinates(this.m2show, this.crd);
        for (AlignmentMolecule alignmentMolecule : am) {
            int atom2;
            int atom1;
            if (alignmentMolecule.isRigid()) continue;
            FlexibleMolecule f = (FlexibleMolecule)alignmentMolecule;
            for (MolecularConstraint rc : f.getRingConstraints()) {
                atom1 = this.getAtomSeq(rc.getNode1());
                atom2 = this.getAtomSeq(rc.getNode2());
                this.addInternalConstraint(atom1, atom2);
            }
            if (f.getWishes() != null) {
                for (MolecularConstraint il : f.getWishes()) {
                    atom1 = this.getAtomSeq(il.getNode1());
                    atom2 = this.getAtomSeq(il.getNode2());
                    this.addInternalConstraint(atom1, atom2);
                }
            }
            if (!this.showProxy) continue;
            Node[][] n = f.getProximityEnabledNodes();
            for (int i = 0; i < n.length; ++i) {
                if (!(n[i][0] instanceof MultiCenterGaussian) && !(n[i][1] instanceof MultiCenterGaussian)) continue;
                atom1 = this.getAtomSeq(n[i][0]);
                atom2 = this.getAtomSeq(n[i][1]);
                this.addInternalConstraint(atom1, atom2);
            }
        }
        if (external != null && !this.calcVolume) {
            System.err.println("ex: " + external.size());
            for (Interaction interaction : external) {
                int atom1 = -1;
                int atom2 = -1;
                atom1 = this.getAtomSeq(interaction.getNode1());
                atom2 = this.getAtomSeq(interaction.getNode2());
                if (atom1 != -1 && atom2 != -1) continue;
            }
        }
        if (this.vol != null) {
            if (this.showAtomic) {
                for (int i = 0; i < this.vol.atomicOverlaps.size(); ++i) {
                    VolumeOverlapConstraint volumeOverlapConstraint = this.vol.atomicOverlaps.get(i);
                    if (volumeOverlapConstraint.isDisabled()) continue;
                    int atom1 = this.getAtomSeq(volumeOverlapConstraint.getNode1());
                    int atom2 = this.getAtomSeq(volumeOverlapConstraint.getNode2());
                    this.addInternalConstraint(atom1, atom2);
                }
            }
            if (this.showExtraNodes) {
                for (int i = 0; i < this.vol.productOverlaps.size(); ++i) {
                    VolumeOverlapConstraint volumeOverlapConstraint = this.vol.productOverlaps.get(i);
                    int atom1 = this.getAtomSeq(volumeOverlapConstraint.getNode1());
                    int atom2 = this.getAtomSeq(volumeOverlapConstraint.getNode2());
                    this.addInternalConstraint(atom1, atom2);
                }
            }
            if (this.showSelectedNodes) {
                for (int i = 0; i < this.vol.selectedNodeOverlaps.size(); ++i) {
                    VolumeOverlapConstraint volumeOverlapConstraint = this.vol.selectedNodeOverlaps.get(i);
                    int atom1 = this.getAtomSeq(volumeOverlapConstraint.getNode1());
                    int atom2 = this.getAtomSeq(volumeOverlapConstraint.getNode2());
                    this.addInternalConstraint(atom1, atom2);
                }
            }
        }
        if (this.wantCenter) {
            MolGeom.center(this.crd);
        }
        int t = 0;
        boolean bl = false;
        while (var5_17 < this.crd.length) {
            this.crdOneDim[t++] = this.crd[var5_17][0];
            this.crdOneDim[t++] = this.crd[var5_17][1];
            this.crdOneDim[t++] = this.crd[var5_17][2];
            ++var5_17;
        }
        if (this.writeMolStream && !this.calcVolume) {
            String string = "" + System.currentTimeMillis() + ".sdf";
            System.err.println("write stream to: " + string);
            try {
                this.me = new MolExporter(new FileOutputStream(string), "sdf");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.calcVolume && !this.writeMolStream) {
            String string = "2strucSingleCol_2.ser";
            try {
                this.oo = new ObjectOutputStream(new FileOutputStream(string));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void addInternalConstraint(int atom1, int atom2) {
        if (this.btab.getBondIndex(atom1, atom2) == -1) {
            MolAtom a1 = this.m2show.getAtom(atom1);
            MolAtom a2 = this.m2show.getAtom(atom2);
            MolBond mb = new MolBond(a1, a2);
            mb.setType(0);
            this.m2show.add(mb);
        } else {
            MolBond mb = this.m2show.getBond(this.btab.getBondIndex(atom1, atom2));
            mb.setType(0);
        }
    }

    public void showSteps() {
        int t = 0;
        for (int i = 0; i < this.crd.length; ++i) {
            this.crdOneDim[t++] = this.crd[i][0];
            this.crdOneDim[t++] = this.crd[i][1];
            this.crdOneDim[t++] = this.crd[i][2];
        }
        if (this.calcVolume) {
            this.mvol = this.m2show.cloneMolecule();
            MolGeom.putCoordinates(this.mvol, this.crd);
            try {
                this.vg.update();
                this.vg.fillVolData(this.mvol);
                String s = "vol_" + this.step++ + ".ser";
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(s));
                out.writeObject(this.mvol);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(0);
            }
        }
    }

    public void closeFile() {
        if (this.writeMolStream) {
            try {
                this.me.close();
            }
            catch (MolExportException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
        }
        if (this.calcVolume) {
            try {
                this.oo.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
        }
    }
}

