/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.Gaussian;
import chemaxon.marvin.alignment.Interaction;
import chemaxon.marvin.alignment.MolecularGaussian;
import chemaxon.marvin.alignment.NodeColor;

class VolumeOverlapConstraint
implements Interaction {
    private final MolecularGaussian node1;
    private final MolecularGaussian node2;
    private final Gaussian prod = new Gaussian();
    private double derivate = 0.0;
    private double energy = 0.0;
    private double typeScale = 0.0;
    private double currentColorWeight = 1.0;
    boolean disabled = false;

    VolumeOverlapConstraint(MolecularGaussian ag1, MolecularGaussian ag2) {
        this.node1 = ag1;
        this.node2 = ag2;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setDisabled(AlignmentConstraint a) {
        if (this.node1.equalsForDisabling(a.getNode1()) || this.node1.equalsForDisabling(a.getNode2()) || this.node2.equalsForDisabling(a.getNode1()) || this.node2.equalsForDisabling(a.getNode2())) {
            this.setDisabled(true);
        }
    }

    @Override
    public void update() {
        Gaussian.productOf(this.node1, this.node2, this.prod);
        double x = Math.PI / this.prod.a;
        x = Math.sqrt(x * x * x);
        double sign = -1.0;
        if ((this.node1.getMemberCount() + this.node2.getMemberCount()) % 2 == 0) {
            sign = 1.0;
        }
        this.derivate = -2.0 * (this.node1.a * this.node2.a / this.prod.a) * this.prod.p * x * sign;
        this.energy = this.prod.integral() * sign;
    }

    public void calcTypeScale(int type1, int type2, NodeColor c) {
        this.typeScale = this.node1.getTypeScale(type1, c) * this.node2.getTypeScale(type2, c);
    }

    public double getValue(double[] crd) {
        double sign = -1.0;
        if ((this.node1.getMemberCount() + this.node2.getMemberCount()) % 2 == 0) {
            sign = 1.0;
        }
        return this.prod.getValue(crd) * this.typeScale * this.currentColorWeight * sign;
    }

    @Override
    public MolecularGaussian getNode1() {
        return this.node1;
    }

    @Override
    public MolecularGaussian getNode2() {
        return this.node2;
    }

    @Override
    public double getDist() {
        return Math.sqrt(this.getDistSQ());
    }

    @Override
    public double getDistSQ() {
        return this.node1.getDistSQ(this.node2);
    }

    @Override
    public double derivateDividedByDist() {
        return -this.derivate * this.typeScale * this.currentColorWeight;
    }

    @Override
    public double getEnergy() {
        return -this.energy * this.typeScale;
    }

    public void setCurrentColorWeight(double currentColorWeight) {
        this.currentColorWeight = currentColorWeight;
    }

    public String toString() {
        this.update();
        return "VolumeOverlapConstraint between: \n" + this.node1.toString() + "\n" + this.node2.toString() + " tscale: " + this.typeScale;
    }

    public double getCurrentColorWeight() {
        return this.currentColorWeight;
    }
}

