/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.VolumeOverlap;
import chemaxon.marvin.alignment.VolumeOverlapConstraint;
import chemaxon.marvin.modules.mprop.VolumetricData;
import chemaxon.struc.Molecule;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Iterator;

public class VolumeOverlapGrid
extends VolumeOverlap {
    float scaleVis = 100.0f;
    private float margin = 1.0f;
    private float bin = 0.5f;
    private TypePairIterator it = new TypePairIterator();

    public VolumeOverlapGrid(AlignmentMolecule am1, AlignmentMolecule am2) throws AlignmentException {
        super(am1, am2);
    }

    public void setBin(float bin) {
        this.bin = bin;
    }

    public void setMargin(float margin) {
        this.margin = margin;
    }

    double getMinMax(int i, boolean max, int ty1, int ty2) {
        double v1 = this.sum1.getMinMax(i, max, ty1);
        double v2 = this.sum2.getMinMax(i, max, ty2);
        if (max) {
            return Math.max(v1, v2);
        }
        return Math.min(v1, v2);
    }

    public Molecule fillVolData(Molecule m) throws AlignmentException {
        this.it.reset();
        while (this.it.hasNext()) {
            int[] p = this.it.next();
            VolumetricData vol = this.volData(p[0], p[1]);
            m.properties().set("VOLUMETRIC_DATA:" + p[0] + "_" + p[1], vol);
        }
        return m;
    }

    double value(double[] crd, int i1, int i2) throws AlignmentException {
        double f = 0.0;
        double w = this.col.getWeight(i1, i2);
        if (w > 0.0) {
            for (VolumeOverlapConstraint vc : this.atomicOverlaps) {
                vc.calcTypeScale(i1, i2, this.am1.getColors());
                vc.setCurrentColorWeight(w);
                f += vc.getValue(crd);
            }
            for (VolumeOverlapConstraint vc : this.productOverlaps) {
                vc.calcTypeScale(i1, i2, this.am1.getColors());
                vc.setCurrentColorWeight(w);
                f += vc.getValue(crd);
            }
            f *= (double)this.scaleVis;
        }
        return f;
    }

    public void setScaleVis(float scaleVis) {
        this.scaleVis = scaleVis;
    }

    public VolumetricData volData(int type1, int type2) throws AlignmentException {
        double[] crdPos = new double[3];
        float[] step = new float[]{this.bin, this.bin, this.bin};
        float[][] axes = new float[][]{{this.bin, 0.0f, 0.0f}, {0.0f, this.bin, 0.0f}, {0.0f, 0.0f, this.bin}};
        float[] origo = new float[3];
        origo[0] = (float)(this.getMinMax(0, false, type1, type2) - (double)this.margin);
        double maxX = this.getMinMax(0, true, type1, type2) + (double)this.margin;
        origo[1] = (float)(this.getMinMax(1, false, type1, type2) - (double)this.margin);
        double maxY = this.getMinMax(1, true, type1, type2) + (double)this.margin;
        origo[2] = (float)(this.getMinMax(2, false, type1, type2) - (double)this.margin);
        double maxZ = this.getMinMax(2, true, type1, type2) + (double)this.margin;
        int sizeX = (int)((maxX - (double)origo[0]) / (double)this.bin);
        int sizeY = (int)((maxY - (double)origo[1]) / (double)this.bin);
        int sizeZ = (int)((maxZ - (double)origo[2]) / (double)this.bin);
        int tot = sizeZ * sizeY * sizeX;
        System.err.println("total gridpoint : " + tot);
        int c = 0;
        float[][][] grid = new float[sizeZ][sizeY][sizeX];
        double last = Double.MAX_VALUE;
        DecimalFormat d = new DecimalFormat("0.");
        for (int ix = 0; ix < sizeX; ++ix) {
            crdPos[0] = origo[0] + (float)ix * this.bin;
            for (int iy = 0; iy < sizeY; ++iy) {
                crdPos[1] = origo[1] + (float)iy * this.bin;
                for (int iz = 0; iz < sizeZ; ++iz) {
                    double per;
                    crdPos[2] = origo[2] + (float)iz * this.bin;
                    grid[iz][iy][ix] = (float)this.value(crdPos, type1, type2);
                    if ((per = (double)(++c) / (double)tot * 100.0) % 10.0 < last) {
                        System.err.println(d.format(per) + "%");
                    }
                    last = per % 10.0;
                }
            }
        }
        return new VolumetricData(axes, step, origo, grid);
    }

    public TypePairIterator getIterator() {
        return this.it;
    }

    public class TypePairIterator
    implements Iterator<int[]> {
        private int[] nextIndexes = new int[2];
        private int[] ret = new int[2];

        private int getMaxPos(int i) {
            if (i == 0) {
                return VolumeOverlapGrid.this.t1.length - 1;
            }
            if (i == 1) {
                return VolumeOverlapGrid.this.t2.length - 1;
            }
            throw new IllegalStateException("Index exceeded");
        }

        private void calcNext() {
            int i;
            if (this.nextIndexes == null) {
                this.ret = null;
                return;
            }
            this.ret[0] = VolumeOverlapGrid.this.t1[this.nextIndexes[0]];
            this.ret[1] = VolumeOverlapGrid.this.t2[this.nextIndexes[1]];
            for (i = 0; i < this.nextIndexes.length && this.nextIndexes[i] == this.getMaxPos(i); ++i) {
                this.nextIndexes[i] = 0;
            }
            if (i == this.nextIndexes.length) {
                this.nextIndexes = null;
            } else {
                int n = i;
                this.nextIndexes[n] = this.nextIndexes[n] + 1;
            }
            try {
                double w = VolumeOverlapGrid.this.col.getWeight(this.ret[0], this.ret[1]);
                if (w > 0.0) {
                    return;
                }
            }
            catch (AlignmentException ali) {
                throw new IllegalStateException(ali);
            }
            this.calcNext();
        }

        @Override
        public boolean hasNext() {
            this.calcNext();
            return this.ret != null;
        }

        @Override
        public int[] next() {
            return this.ret;
        }

        public void reset() {
            Arrays.fill(this.nextIndexes, 0);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

