/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.beans;

import chemaxon.formats.MolImporter;
import chemaxon.marvin.beans.MarvinPane;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.CommonActions;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.sketch.AbstractSelectSM;
import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.LassoSelectSM;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.RectangleSelectSM;
import chemaxon.marvin.sketch.RubberSM;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.prop.MIntegerProp;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

public class MSketchPane
extends MarvinPane {
    private static final long serialVersionUID = 602496692422927170L;
    public static final int SM_SELECT = 0;
    public static final int SM_DELETE = 1;
    public static final int SM_ATOM = 2;
    public static final int SM_BOND = 3;
    public static final int SM_SELECT_LASSO = 4;
    public static final int SM_MASK = 255;
    public static final int SM_FLAGS_OFF = 8;
    private CommonActions commonActions;

    public MSketchPane() {
        this(null, true);
    }

    public MSketchPane(UserSettings settings) {
        this(settings, true);
    }

    public MSketchPane(UserSettings settings, boolean loadtmpl) {
        this.molPanel = new SketchPanel(null, 2, -1, this, settings);
        this.init(this.molPanel, loadtmpl);
        this.molPanel.addPropertyChangeListener(this);
        this.molPanel.setAutoScale(false);
    }

    public JComponent getCanvasComponent() {
        return this.getSketchPanel().getCanvas();
    }

    public void setAutoScale(boolean as) {
        this.molPanel.setAutoScale(as);
    }

    public boolean getAutoScale() {
        return this.molPanel.getAutoScale();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        super.propertyChange(ev);
        String name = ev.getPropertyName();
        Object value = ev.getNewValue();
        if (name.equals("winmode") && value.equals(Boolean.FALSE)) {
            this.closeWindows();
            Container p = this;
            while ((p = p.getParent()) != null) {
                if (p instanceof Window) {
                    Window w = (Window)p;
                    w.setVisible(false);
                    w.dispose();
                    break;
                }
                if (!(p instanceof JInternalFrame)) continue;
                JInternalFrame f = (JInternalFrame)p;
                f.setVisible(false);
                f.dispose();
                break;
            }
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    public Molecule getMol() {
        Molecule m = this.getSketchPanel().getMol();
        if (m != null) {
            MDocument doc = m.getDocument();
            m = doc != null ? doc.cloneMainMolecule() : m.cloneMolecule();
            m.setGUIContracted(false);
        }
        return m;
    }

    public String getMol(String fmt) {
        try {
            return this.getMol().toFormat(fmt);
        }
        catch (SecurityException sex) {
            this.molPanel.getErrorDisplay().firewallError(sex, null);
            return null;
        }
    }

    public void setMol(Molecule m) {
        this.setMol(m, true);
    }

    public void setMol(Molecule m, boolean init) {
        if (m != null) {
            MDocument doc = m.getDocument();
            m = doc != null ? doc.cloneMainMolecule() : m.cloneMolecule();
            m.setGUIContracted(true);
        }
        this.getSketchPanel().molLoaded(new Molecule[]{m}, 0L);
    }

    public void setMol(String s) {
        this.setMol(s, null);
    }

    public void setMol(String s, String opts) {
        this.getSketchPanel().setMol(s, opts);
    }

    public void setMol(File f, String opts) {
        this.getSketchPanel().setMol(f, opts);
    }

    public MDocument getDocument() {
        Molecule m = this.getSketchPanel().getMol();
        MDocument doc = m != null ? m.getDocument() : null;
        return doc;
    }

    public void setDocument(MDocument doc) {
        Molecule m = null;
        if (doc != null) {
            m = (Molecule)doc.getMainMoleculeGraph();
        }
        this.setMol(m);
    }

    public Molecule getSelection() {
        return this.getSketchPanel().getEditor().getMolSelection();
    }

    public Object getObjectAtPointer() {
        return this.getSketchPanel().getObjectAtPointer();
    }

    public String getPiece(String fmt) {
        try {
            return this.getSketchPanel().getPiece().toFormat(fmt);
        }
        catch (SecurityException sex) {
            this.molPanel.getErrorDisplay().firewallError(sex, null);
            return null;
        }
    }

    public void setPiece(String s) {
        this.molPanel.startLoader(s, null, 131072L, false);
    }

    public Image getImage(double scale) {
        return this.getSketchPanel().getCanvas().getImage(scale);
    }

    public Image getImage(Dimension size) {
        return this.getSketchPanel().getCanvas().getImage(size);
    }

    public double[] getBoundRectSize() {
        return this.getSketchPanel().getCanvas().getBoundRectSize();
    }

    public static double getDefaultScale() {
        return 28.0;
    }

    public synchronized double getScale() {
        return this.getSketchPanel().getScale();
    }

    public synchronized void setScale(double m) {
        this.getSketchPanel().setScale(m);
    }

    public double getStickdst() {
        return this.getSketchPanel().getStickdst();
    }

    public void setStickdst(double d) {
        this.getSketchPanel().setStickdst(d);
    }

    public double getMergedst() {
        return this.getSketchPanel().getMergedst();
    }

    public void setMergedst(double d) {
        this.getSketchPanel().setMergedst(d);
    }

    public int getUndo() {
        return this.getSketchPanel().getUndo();
    }

    public void setUndo(int u) {
        this.getSketchPanel().setUndo(u);
    }

    public boolean getReactionSupport() {
        return this.getSketchPanel().getReactionSupport();
    }

    public void setReactionSupport(boolean v) {
        this.getSketchPanel().setReactionSupport(v);
    }

    @Deprecated
    public boolean isReactionErrorVisible() {
        return false;
    }

    @Deprecated
    public synchronized void setReactionErrorVisible(boolean v) {
    }

    public boolean isValenceErrorVisible() {
        return this.getSketchPanel().getUserSettings().isValenceErrorVisible();
    }

    public synchronized void setValenceErrorVisible(boolean v) {
        this.getSketchPanel().setValenceErrorVisible(v);
    }

    public boolean isBondDraggedAlong() {
        return this.getSketchPanel().getUserSettings().isBondDraggedAlong();
    }

    public void setBondDraggedAlong(boolean v) {
        this.getSketchPanel().setBondDraggedAlong(v);
    }

    public void setSketchMode(int mode) {
        SketchPanel sp = this.getSketchPanel();
        MolEditor ed = sp.getEditor();
        SketchMode sm = null;
        int flags = mode >> 8;
        if ((mode &= 0xFF) == 0) {
            sm = new RectangleSelectSM(ed);
        } else if (mode == 4) {
            sm = new LassoSelectSM(ed);
        } else if (mode == 1) {
            sm = new RubberSM(ed);
        } else if (mode == 2) {
            sm = new AtomSM(ed, new MolAtom(flags));
        } else if (mode == 3) {
            sm = new BondSM(ed, flags);
        } else {
            throw new IllegalArgumentException("invalid sketch mode " + mode);
        }
        sp.setSketchMode(sm, false, false, false, true);
    }

    public int getSketchMode() {
        SketchMode sm = this.getSketchPanel().getEditor().getSketchMode();
        if (sm != null) {
            if (sm instanceof LassoSelectSM) {
                return 4;
            }
            if (sm instanceof AbstractSelectSM) {
                return 0;
            }
            if (sm instanceof RubberSM) {
                return 1;
            }
            if (sm instanceof AtomSM) {
                MolAtom a = ((AtomSM)sm).getAtom();
                return 2 | a.getAtno() << 8;
            }
            if (sm instanceof BondSM) {
                int f = ((BondSM)sm).getType();
                return 3 | f << 8;
            }
        }
        return -1;
    }

    public int getSimpView() {
        return this.isBondDraggedAlong() ? 0 : 1;
    }

    public void setSimpView(int v) {
        this.setBondDraggedAlong(v == 0);
    }

    public double getMag() {
        return this.getScale();
    }

    public synchronized void setMag(double m) {
        this.setScale(m);
    }

    private SketchPanel getSketchPanel() {
        return (SketchPanel)this.molPanel;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.mrvSerialize(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version < 2) {
            this.readExternal0(in, version);
        } else {
            this.mrvDeserialize(in, version);
        }
    }

    private void readExternal0(ObjectInput in, int version) throws IOException, ClassNotFoundException {
        if (version > 1) {
            throw new IOException("Cannot deserialize MSketchPane with future version (" + version + ")");
        }
        super.readExternal(in);
        this.setScale(in.readDouble());
        this.setStickdst(in.readDouble());
        this.setMergedst(in.readDouble());
        int flags = in.readInt();
        this.setReactionSupport((flags & 1) != 0);
        this.setDocument(MSketchPane.readDoc(in));
        if (version > 0) {
            MolPainter p = this.getSketchPanel().getCanvas().getPainter();
            CTransform3D t = new CTransform3D();
            t.readExternal(in);
            p.setRTransform(t);
        }
    }

    private void mrvSerialize(ObjectOutput out) throws IOException {
        Molecule m = this.getMol();
        this.writeProperties(m.getDocument().properties());
        out.writeInt(2);
        MSketchPane.writeMol(out, m);
    }

    private void mrvDeserialize(ObjectInput in, int version) throws IOException {
        if (version > 2) {
            throw new IOException("Cannot deserialize MSketchPane with future version (" + version + ")");
        }
        MDocument doc = MSketchPane.readDoc(in);
        this.setDocument(doc);
        this.readProperties(doc.properties());
    }

    void writeProperties(MPropertyContainer ppc) {
        ppc.setString("chemaxon.double.scale", Double.toString(this.getScale()));
        ppc.setString("chemaxon.double.stickdst", Double.toString(this.getStickdst()));
        ppc.setString("chemaxon.double.mergedst", Double.toString(this.getMergedst()));
        int flags = 0;
        if (this.getReactionSupport()) {
            flags |= 1;
        }
        ppc.setString("chemaxon.int.reactionsupport", Integer.toString(flags));
        this.writeCommonProperties(ppc);
        MolPainter painter = this.getSketchPanel().getCanvas().getPainter();
        CTransform3D t = painter.getRTransformRef();
        ppc.setString("chemaxon.string.ctransform3d", t.toString());
    }

    private void writeCommonProperties(MPropertyContainer ppc) {
        UserSettings settings = this.molPanel.getUserSettings();
        int flags = 0;
        if (this.arePopupMenusEnabled()) {
            flags |= 1;
        }
        if (this.isSetColoringEnabled()) {
            flags |= 2;
        }
        if (this.isAtomSymbolsVisible()) {
            flags |= 4;
        }
        if (this.isAtomNumbersVisible()) {
            flags |= 8;
        }
        if (this.isAtomMappingVisible()) {
            flags |= 0x10;
        }
        if (this.isGrinvVisible()) {
            flags |= 0x20;
        }
        if (this.getExplicitH()) {
            flags |= 0x40;
        }
        if (this.isEzVisible()) {
            flags |= 0x100;
        }
        if (this.isBondLengthVisible()) {
            flags |= 0x200;
        }
        if (settings.isBondDraggedAlong()) {
            flags |= 0x400;
        }
        if (settings.isValenceErrorVisible()) {
            flags |= 0x800;
        }
        if (settings.isValenceErrorVisibleInView()) {
            flags |= 0x2000;
        }
        ppc.setString("chemaxon.int.flags", Integer.toString(flags));
        ppc.setString("chemaxon.int.background", Integer.toString(this.getBackground().getRGB()));
        ppc.setString("chemaxon.int.molbg", Integer.toString(this.getMolbg().getRGB()));
        ppc.setString("chemaxon.int.sketchMolbg2d", Integer.toString(settings.getSketchMolbg2d().getRGB()));
        ppc.setString("chemaxon.int.sketchMolbg3d", Integer.toString(settings.getSketchMolbg3d().getRGB()));
        ppc.setString("chemaxon.int.viewMolbg2d", Integer.toString(settings.getViewMolbg2d().getRGB()));
        ppc.setString("chemaxon.int.viewMolbg3d", Integer.toString(settings.getViewMolbg3d().getRGB()));
        ppc.setString("chemaxon.int.cleanDim", Integer.toString(this.getCleanDim()));
        ppc.setString("chemaxon.short.dispQuality", Integer.toString(this.getDispQuality()));
        int chir = this.getChiralitySupport();
        ppc.setString("chemaxon.short.chiralitySupport", Integer.toString(chir == 1 ? 1 : (chir == 2 ? 2 : 0)));
        ppc.setString("chemaxon.long.invisibleSets", Long.toString(this.getInvisibleSets()));
        ppc.setString("chemaxon.double.atomsize", Double.toString(this.getAtomsize()));
        ppc.setString("chemaxon.double.bondSpacing", Double.toString(this.getBondSpacing()));
        ppc.setString("chemaxon.double.wireThickness", Double.toString(this.getWireThickness()));
        ppc.setString("chemaxon.double.stickThickness", Double.toString(this.getStickThickness()));
        ppc.setString("chemaxon.double.ballRadius", Double.toString(this.getBallRadius()));
        ppc.setString("chemaxon.double.sketchArrowHeadLength", Double.toString(settings.getSketchArrowHeadLength()));
        ppc.setString("chemaxon.double.sketchArrowHeadWidth", Double.toString(settings.getSketchArrowHeadWidth()));
        ppc.setString("chemaxon.double.sketchArrowTailLength", Double.toString(settings.getSketchArrowTailLength()));
        ppc.setString("chemaxon.double.sketchArrowTailWidth", Double.toString(settings.getSketchArrowTailWidth()));
        ppc.setString("chemaxon.string.colorScheme", this.molPanel.getColorScheme());
        ppc.setString("chemaxon.string.sketchColorScheme", settings.getSketchColorScheme());
        ppc.setString("chemaxon.string.viewColorScheme", settings.getViewColorScheme());
        ppc.setString("chemaxon.string.rendering", this.molPanel.getRendering());
        ppc.setString("chemaxon.string.sketchRendering2d", settings.getSketchRendering2d());
        ppc.setString("chemaxon.string.sketchRendering3d", settings.getSketchRendering3d());
        ppc.setString("chemaxon.string.viewRendering2d", settings.getViewRendering2d());
        ppc.setString("chemaxon.string.viewRendering3d", settings.getViewRendering3d());
        ppc.setString("chemaxon.string.navmode", this.molPanel.getNavmode());
        ppc.setString("chemaxon.string.viewNavmode2d", settings.getViewNavmode2d());
        ppc.setString("chemaxon.string.viewNavmode3d", settings.getViewNavmode3d());
        ppc.setString("chemaxon.string.downWedge", this.getDownWedge());
        ppc.setString("chemaxon.string.implicitH", this.molPanel.getImplicitH());
        ppc.setString("chemaxon.string.sketchImplicitH", settings.getSketchImplicitH());
        ppc.setString("chemaxon.string.viewImplicitH", settings.getViewImplicitH());
        ppc.setString("chemaxon.string.anyBond", this.molPanel.getAnyBond());
        ppc.setString("chemaxon.string.sketchAnyBond", settings.getSketchAnyBond());
        ppc.setString("chemaxon.string.viewAnyBond", settings.getViewAnyBond());
        ppc.setString("chemaxon.string.format", this.getFormat());
        ppc.setString("chemaxon.string.clean2dOpts", settings.getClean2dOpts());
        ppc.setString("chemaxon.string.clean3dOpts", settings.getClean3dOpts());
    }

    void readProperties(MPropertyContainer ppc) {
        String value = null;
        if (ppc.size() == 0) {
            return;
        }
        value = ppc.getString("chemaxon.double.scale");
        if (value != null) {
            this.setScale(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.double.stickdst")) != null) {
            this.setStickdst(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.double.mergedst")) != null) {
            this.setMergedst(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.int.reactionsupport")) != null) {
            this.setReactionSupport((Integer.parseInt(value) & 1) != 0);
        }
        this.readCommonProperties(ppc);
        CTransform3D t = new CTransform3D();
        double[][] matrix = new double[4][4];
        String arraystr = ppc.getString("chemaxon.string.ctransform3d");
        if (arraystr != null) {
            StringTokenizer rowstkn = new StringTokenizer(arraystr, "\n");
            int rowi = 0;
            while (rowstkn.hasMoreTokens()) {
                String token = rowstkn.nextToken();
                String row = token.substring(token.lastIndexOf(91) + 1, token.indexOf(93));
                StringTokenizer elemtkn = new StringTokenizer(row, ", ");
                int coli = 0;
                while (elemtkn.hasMoreTokens()) {
                    matrix[rowi][coli] = Double.parseDouble(elemtkn.nextToken());
                    ++coli;
                }
                ++rowi;
            }
            t.m00 = matrix[0][0];
            t.m01 = matrix[0][1];
            t.m02 = matrix[0][2];
            t.m03 = matrix[0][3];
            t.m10 = matrix[1][0];
            t.m11 = matrix[1][1];
            t.m12 = matrix[1][2];
            t.m13 = matrix[1][3];
            t.m20 = matrix[2][0];
            t.m21 = matrix[2][1];
            t.m22 = matrix[2][2];
            t.m23 = matrix[2][3];
            t.m30 = matrix[3][0];
            t.m31 = matrix[3][1];
            t.m32 = matrix[3][2];
            t.m33 = matrix[3][3];
        }
        MolPainter p = this.getSketchPanel().getCanvas().getPainter();
        p.setRTransform(t);
    }

    private void readCommonProperties(MPropertyContainer ppc) {
        String value = null;
        UserSettings settings = this.getUserSettings();
        value = ppc.getString("chemaxon.int.flags");
        if (value != null) {
            this.setPopupMenusEnabled((Integer.parseInt(value) & 1) != 0);
            this.setSetColoringEnabled((Integer.parseInt(value) & 2) != 0);
            this.setAtomSymbolsVisible((Integer.parseInt(value) & 4) != 0);
            this.setAtomNumbersVisible((Integer.parseInt(value) & 8) != 0);
            this.setAtomMappingVisible((Integer.parseInt(value) & 0x10) != 0);
            this.setGrinvVisible((Integer.parseInt(value) & 0x20) != 0);
            this.setEzVisible((Integer.parseInt(value) & 0x100) != 0);
            this.setBondLengthVisible((Integer.parseInt(value) & 0x200) != 0);
            this.molPanel.setBondDraggedAlong((Integer.parseInt(value) & 0x400) != 0);
            this.molPanel.setValenceErrorVisible((Integer.parseInt(value) & 0x800) != 0);
            this.molPanel.setValenceErrorVisibleInView((Integer.parseInt(value) & 0x2000) != 0);
        }
        if ((value = ppc.getString("chemaxon.int.molbg")) != null) {
            this.molPanel.setMolbg(new Color(Integer.parseInt(value)));
        }
        if ((value = ppc.getString("chemaxon.int.sketchMolbg2d")) != null) {
            settings.setSketchMolbg2d(new Color(Integer.parseInt(value)));
        }
        if ((value = ppc.getString("chemaxon.int.sketchMolbg3d")) != null) {
            settings.setSketchMolbg3d(new Color(Integer.parseInt(value)));
        }
        if ((value = ppc.getString("chemaxon.int.viewMolbg2d")) != null) {
            settings.setViewMolbg2d(new Color(Integer.parseInt(value)));
        }
        if ((value = ppc.getString("chemaxon.int.viewMolbg3d")) != null) {
            settings.setViewMolbg2d(new Color(Integer.parseInt(value)));
        }
        if ((value = ppc.getString("chemaxon.int.cleanDim")) != null) {
            this.setCleanDim(Integer.parseInt(value));
        }
        if ((value = ppc.getString("chemaxon.short.dispQuality")) != null) {
            this.setDispQuality(Short.parseShort(value));
        }
        if ((value = ppc.getString("chemaxon.short.chiralitySupport")) != null) {
            short chirsupsi = Short.parseShort(value);
            int[] chirsups = new int[]{0, 1, 2};
            this.setChiralitySupport(chirsups[chirsupsi]);
        }
        if ((value = ppc.getString("chemaxon.long.invisibleSets")) != null) {
            this.setInvisibleSets(Long.parseLong(value));
        }
        if ((value = ppc.getString("chemaxon.double.atomsize")) != null) {
            this.setAtomsize(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.double.bondSpacing")) != null) {
            this.setBondSpacing(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.double.wireThickness")) != null) {
            this.setWireThickness(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.double.stickThickness")) != null) {
            this.setStickThickness(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.double.ballRadius")) != null) {
            this.setBallRadius(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.double.sketchArrowHeadLength")) != null) {
            settings.setSketchArrowHeadLength(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.double.sketchArrowHeadWidth")) != null) {
            settings.setSketchArrowHeadWidth(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.double.sketchArrowTailLength")) != null) {
            settings.setSketchArrowTailLength(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.double.sketchArrowTailWidth")) != null) {
            settings.setSketchArrowTailWidth(Double.parseDouble(value));
        }
        if ((value = ppc.getString("chemaxon.string.colorScheme")) != null) {
            this.molPanel.setColorScheme(value);
        }
        if ((value = ppc.getString("chemaxon.string.sketchColorScheme")) != null) {
            settings.setSketchColorScheme(value);
        }
        if ((value = ppc.getString("chemaxon.string.viewColorScheme")) != null) {
            settings.setViewColorScheme(value);
        }
        if ((value = ppc.getString("chemaxon.string.rendering")) != null) {
            this.molPanel.setRendering(value);
        }
        if ((value = ppc.getString("chemaxon.string.sketchRendering2d")) != null) {
            settings.setSketchRendering2d(value);
        }
        if ((value = ppc.getString("chemaxon.string.sketchRendering3d")) != null) {
            settings.setSketchRendering3d(value);
        }
        if ((value = ppc.getString("chemaxon.string.viewRendering2d")) != null) {
            settings.setViewRendering2d(value);
        }
        if ((value = ppc.getString("chemaxon.string.viewRendering3d")) != null) {
            settings.setViewRendering3d(value);
        }
        if ((value = ppc.getString("chemaxon.string.navmode")) != null) {
            this.molPanel.setNavmode(value);
        }
        if ((value = ppc.getString("chemaxon.string.viewNavmode2d")) != null) {
            settings.setViewNavmode2d(value);
        }
        if ((value = ppc.getString("chemaxon.string.viewNavmode3d")) != null) {
            settings.setViewNavmode3d(value);
        }
        if ((value = ppc.getString("chemaxon.string.downWedge")) != null) {
            this.setDownWedge(value);
        }
        if ((value = ppc.getString("chemaxon.string.implicitH")) != null) {
            this.molPanel.setImplicitH(value);
        }
        if ((value = ppc.getString("chemaxon.string.sketchImplicitH")) != null) {
            settings.setSketchImplicitH(value);
        }
        if ((value = ppc.getString("chemaxon.string.viewImplicitH")) != null) {
            settings.setViewImplicitH(value);
        }
        if ((value = ppc.getString("chemaxon.string.anyBond")) != null) {
            this.molPanel.setAnyBond(value);
        }
        if ((value = ppc.getString("chemaxon.string.sketchAnyBond")) != null) {
            settings.setSketchAnyBond(value);
        }
        if ((value = ppc.getString("chemaxon.string.viewAnyBond")) != null) {
            settings.setViewAnyBond(value);
        }
        if ((value = ppc.getString("chemaxon.string.format")) != null) {
            this.setFormat(value);
        }
        if ((value = ppc.getString("chemaxon.string.clean2dOpts")) != null) {
            settings.setClean2dOpts(value);
        }
        if ((value = ppc.getString("chemaxon.string.clean3dOpts")) != null) {
            settings.setClean3dOpts(value);
        }
    }

    public String getMrvWithSettings() {
        MDocument d = this.getDocument();
        this.writeProperties(d.properties());
        MPropertyContainer guiProperties = this.getGUIProperties();
        d.setGUIPropertyContainer(guiProperties);
        Molecule m = (Molecule)d.getMainMoleculeGraph();
        return m.toFormat("mrv");
    }

    public void setMrvWithSettings(String mrvsource) {
        if (mrvsource == null) {
            return;
        }
        try {
            ByteArrayInputStream datain = new ByteArrayInputStream(mrvsource.getBytes());
            MolImporter mi = new MolImporter(datain, "mrv");
            MDocument doc = mi.readDoc(null, null);
            MPropertyContainer gProperties = null;
            gProperties = mi.getGlobalProperties();
            this.setGUIProperties(gProperties);
            this.setDocument(doc);
            this.readProperties(doc.properties());
        }
        catch (IOException ioe) {
            System.err.println("MRV import is failed.");
        }
    }

    public boolean isCloseEnabled() {
        SketchPanel p = (SketchPanel)this.molPanel;
        return p.isEnabled();
    }

    public void setCloseEnabled(boolean b) {
        SketchPanel p = (SketchPanel)this.molPanel;
        p.setCloseEnabled(b);
    }

    private MPropertyContainer getGUIProperties() {
        MPropertyContainer guiProperties = new MPropertyContainer();
        Rectangle bRect = topLevelContainer.getBounds();
        MIntegerProp width = new MIntegerProp((int)bRect.getWidth());
        MIntegerProp height = new MIntegerProp((int)bRect.getHeight());
        guiProperties.set("windowwidth", width);
        guiProperties.set("windowheight", height);
        return guiProperties;
    }

    private void setGUIProperties(MPropertyContainer gp) {
        if (gp != null && gp.size() > 0) {
            Rectangle bRect = this.getBounds();
            int width = (int)bRect.getWidth();
            int height = (int)bRect.getHeight();
            String value = gp.getString("windowwidth");
            if (value != null) {
                width = Integer.parseInt(value);
            }
            if ((value = gp.getString("windowheight")) != null) {
                height = Integer.parseInt(value);
            }
            Dimension d = new Dimension(width, height);
            if (topLevelContainer != null) {
                topLevelContainer.setSize(d);
                topLevelContainer.validate();
            }
        }
    }

    public void undo() {
        ((SketchPanel)this.molPanel).undo();
    }

    public void redo() {
        ((SketchPanel)this.molPanel).redo();
    }

    public void setConfirmExit(boolean b) {
        ((SketchPanel)this.molPanel).setConfirmExit(b);
    }

    public boolean isConfirmExit() {
        return ((SketchPanel)this.molPanel).isConfirmExit();
    }

    public boolean isLoadedMolModified() {
        return this.getSketchPanel().getEditor().isDocumentEdited() && !this.getSketchPanel().getEditor().isEmpty();
    }

    @Override
    public void doPaste() {
        this.molPanel.doPaste();
    }

    public void clearHistory() {
        ((SketchPanel)this.molPanel).clearHistory();
    }

    @Override
    public CommonActions getCommonActions() {
        if (this.commonActions == null) {
            this.commonActions = new CommonActions(this.molPanel, new int[0], null);
        }
        return this.commonActions;
    }

    public void centralizeMoleculeDisplay() {
        ((SketchPanel)this.molPanel).centralizeMoleculeDisplay();
    }

    public void setDisabledGroupTypes(List<String> disabledGroupTypes) {
        ((SketchPanel)this.molPanel).setDisabledGroupTypes(disabledGroupTypes);
    }

    public List<String> getDisabledGroupTypes() {
        return ((SketchPanel)this.molPanel).getDisabledGroupTypes();
    }

    static {
        MSketchPane.readResources(MSketchPane.class, "MSketchPane.properties");
    }
}

