/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.beans;

import java.util.ArrayList;

public class MViewParams {
    private String sep = ":";
    private int rowCount;
    private int colCount;
    private int visibleRows;
    private int w = 0;
    private int h = 0;
    private int layoutHR;
    private int layoutHC;
    private String layout = null;
    private int fontSize = 0;
    private boolean bold;
    private boolean italics;
    private ArrayList components = new ArrayList();
    private boolean paramset = false;

    public String getMViewParam() {
        this.initLayout();
        return "rows=" + this.rowCount + "\n" + "cols=" + this.colCount + "\n" + "visibleRows=" + this.visibleRows + "\n" + this.layout + "\n";
    }

    public void setRowCount(int i) {
        this.rowCount = i;
    }

    public void setColumnCount(int i) {
        this.colCount = i;
    }

    public void setVisibleRows(int i) {
        this.visibleRows = i;
    }

    public void setHeaderCellSize(int row, int column) {
        this.layoutHR = row;
        this.layoutHC = column;
    }

    public void addLabel(int startRow, int startColumn, int rows, int columns) {
        this.components.add("L" + this.sep + startRow + this.sep + startColumn + this.sep + rows + this.sep + columns);
    }

    public void addMolecule(int startRow, int startColumn, int rows, int columns) {
        this.components.add("M" + this.sep + startRow + this.sep + startColumn + this.sep + rows + this.sep + columns);
    }

    public void addLabel(int startRow, int startColumn, int rows, int columns, int anchor, int fill, int weightx, int weighty) {
        String label = "L" + this.sep + startRow + this.sep + startColumn + this.sep + rows + this.sep + columns;
        label = label + this.sep + this.getConstraints(anchor, fill, weightx, weighty);
        this.components.add(label);
    }

    public void addMolecule(int startRow, int startColumn, int rows, int columns, int anchor, int fill, int weighty, int weightx) {
        String mol = "M" + this.sep + startRow + this.sep + startColumn + this.sep + rows + this.sep + columns;
        mol = mol + this.sep + this.getConstraints(anchor, fill, weightx, weighty);
        this.components.add(mol);
    }

    public void setMoleculeCellSize(int width, int height) {
        this.w = width;
        this.h = height;
        this.paramset = true;
    }

    public void setLabelProperty(int fontSize, boolean bold, boolean italics) {
        this.fontSize = fontSize;
        this.bold = bold;
        this.italics = italics;
        this.paramset = true;
    }

    private String getConstraints(int anchor, int fill, int weighty, int weightx) {
        String cc;
        switch (anchor) {
            case 11: {
                cc = "n";
                break;
            }
            case 12: {
                cc = "ne";
                break;
            }
            case 13: {
                cc = "e";
                break;
            }
            case 14: {
                cc = "se";
                break;
            }
            case 15: {
                cc = "s";
                break;
            }
            case 16: {
                cc = "sw";
                break;
            }
            case 17: {
                cc = "w";
                break;
            }
            case 18: {
                cc = "nw";
                break;
            }
            default: {
                cc = "c";
            }
        }
        cc = cc + this.sep;
        switch (fill) {
            case 2: {
                cc = cc + "h";
                break;
            }
            case 3: {
                cc = cc + "v";
                break;
            }
            case 1: {
                cc = cc + "b";
                break;
            }
            default: {
                cc = cc + "n";
            }
        }
        cc = cc + this.sep + weighty + this.sep + weightx;
        return cc;
    }

    private void initLayout() {
        if (this.components.size() == 0) {
            this.layout = "";
            return;
        }
        this.layout = "layout0=" + this.sep + this.layoutHR + this.sep + this.layoutHC;
        for (int i = 0; i < this.components.size(); ++i) {
            this.layout = this.layout + this.sep + this.components.get(i).toString();
        }
        this.layout = this.layout + "\n";
        if (this.paramset) {
            String param = "";
            if (this.w != 0 || this.h != 0) {
                param = param + "param0=" + this.sep + "M" + this.sep + this.w + this.sep + this.h;
            }
            if (this.fontSize != 0) {
                param = param + (param.equals("") ? "param0=" + this.sep : this.sep);
                param = param + "L" + this.sep + this.fontSize;
                param = param + (this.bold ? "b" : "");
                param = param + (this.italics ? "i" : "");
            }
            this.layout = this.layout + param + "\n";
        }
    }
}

