/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.beans.splash;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.net.URL;

public class MarvinSplashScreen
extends Window {
    private static MarvinSplashScreen instance;
    private Image splashImage;
    private BufferedImage overlayImage = null;
    private boolean paintCalled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarvinSplashScreen(Frame parent, Image image) {
        super(parent);
        this.splashImage = image;
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (mt.isErrorID(0)) {
            this.setSize(0, 0);
            MarvinSplashScreen ie = this;
            synchronized (ie) {
                this.paintCalled = true;
                this.notifyAll();
            }
            return;
        }
        int imgWidth = image.getWidth(this);
        int imgHeight = image.getHeight(this);
        this.setSize(imgWidth, imgHeight);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDim.width - imgWidth) / 2, (screenDim.height - imgHeight) / 2);
    }

    public static void invokeMain(String className, String[] args) {
        try {
            Class.forName(className).getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            InternalError error = new InternalError("Failed to invoke main method");
            error.initCause(e);
            throw error;
        }
    }

    public static void splash(URL imageURL) {
        if (imageURL != null) {
            MarvinSplashScreen.splash(Toolkit.getDefaultToolkit().createImage(imageURL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splash(Image image) {
        if (instance == null && image != null) {
            Frame f = new Frame();
            instance = new MarvinSplashScreen(f, image);
            instance.setVisible(true);
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                MarvinSplashScreen marvinSplashScreen = instance;
                synchronized (marvinSplashScreen) {
                    while (!MarvinSplashScreen.instance.paintCalled) {
                        try {
                            instance.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    public Graphics2D createGraphics() {
        if (this.overlayImage == null) {
            Dimension dim = this.getSize();
            this.overlayImage = new BufferedImage(Math.max(dim.width, 0), Math.max(dim.height, 0), 2);
        }
        return this.overlayImage.createGraphics();
    }

    public static MarvinSplashScreen getInstance() {
        return instance;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (this.overlayImage != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            BufferedImage tmp = new BufferedImage(this.splashImage.getWidth(this), this.splashImage.getHeight(this), 5);
            tmp.getGraphics().drawImage(this.splashImage, 0, 0, this);
            tmp.getGraphics().drawImage(this.overlayImage, 0, 0, this);
            g2.drawImage((Image)tmp, 0, 0, this);
            g2.dispose();
        } else {
            g.drawImage(this.splashImage, 0, 0, this);
        }
        if (!this.paintCalled) {
            this.paintCalled = true;
            MarvinSplashScreen marvinSplashScreen = this;
            synchronized (marvinSplashScreen) {
                this.notifyAll();
            }
        }
    }

    public static void disposeSplash() {
        if (instance != null) {
            instance.getOwner().dispose();
            instance = null;
        }
    }
}

