/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.alignment.Alignment;
import chemaxon.marvin.alignment.AlignmentAccuracyMode;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;

public class AlignmentPlugin
extends CalculatorPlugin {
    public static int STEP_DEFAULT = 2000;
    private Alignment a;
    private Molecule result;
    private Object[] types = new Object[]{"Alignment"};
    private String error;
    private Molecule[] mg;
    private MProgressMonitor progressMonitor;
    private double volumeTanimoto = 0.0;

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return true;
    }

    @Override
    public String getProductName() {
        return "3D Alignment";
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.result = mol;
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
        this.progressMonitor = pmon;
    }

    @Override
    public String getWarningMessage() {
        return this.error;
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        return this.result;
    }

    public void setAccuracyMode(AlignmentAccuracyMode acc) throws PluginException {
        if (this.a == null) {
            this.a = new Alignment();
        }
        this.a.setMode(acc);
    }

    public void setRingFlexibility(int size, int rotBondCount) {
        if (this.a == null) {
            this.a = new Alignment();
        }
        this.a.setFlexibleRingRotatableBondCount(rotBondCount);
        this.a.setFlexibleRingSize(size);
    }

    public void setMinimumCommonSize(int mcsSize) throws PluginException {
        if (this.a == null) {
            this.a = new Alignment(AlignmentProperties.GAUSS_FAST_EXTENDED_ATOMTYPE_MCS);
        }
        this.a.setMinimumCommonSize(mcsSize);
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String method = params.getProperty("calctype", "cxn").toLowerCase();
        if (method.equals("cxn")) {
            this.a = new Alignment(AlignmentProperties.GAUSS_FAST_EXTENDED_ATOMTYPE);
        } else if (method.equals("mcs")) {
            this.a = new Alignment(AlignmentProperties.GAUSS_FAST_EXTENDED_ATOMTYPE_MCS);
            int minimumCommonSize = Integer.parseInt((String)params.get("mcssize"));
            this.a.setMinimumCommonSize(minimumCommonSize);
        } else if (method.equals("phr")) {
            this.a = new Alignment(AlignmentProperties.GAUSS_FAST_PHARMACOPHORE);
        }
        int limit = Integer.parseInt((String)params.get("confcount"));
        int mode = Integer.parseInt((String)params.get("mode"));
        AlignmentAccuracyMode amode = AlignmentAccuracyMode.NORMAL;
        if (mode == 0) {
            amode = AlignmentAccuracyMode.FAST;
        } else if (limit == 1) {
            amode = AlignmentAccuracyMode.NORMAL;
        } else if (limit == 2) {
            amode = AlignmentAccuracyMode.ACCURATE;
        }
        this.a.setMode(amode);
        this.a.setConformerCount(limit);
    }

    @Override
    public boolean run() throws PluginException {
        int i;
        this.error = "";
        if (this.result.getDim() != 3) {
            this.result.clean(3, null);
        }
        this.mg = MolGeom.breakMol(this.result);
        boolean[] rigid = new boolean[this.mg.length];
        for (i = 0; i < rigid.length; ++i) {
            rigid[i] = false;
            for (int j = 0; j < this.mg[i].getAtomCount() && !rigid[i]; ++j) {
                rigid[i] = this.mg[i].getAtom(j).isSelected();
            }
            this.mg[i].aromatize(1);
            if (this.mg[i].hydrogenize(false)) continue;
            throw new PluginException("Hydrogen removal failed for input molecules.");
        }
        if (this.a == null) {
            this.a = new Alignment();
        }
        this.a.setLicenseEnvironment(this.licenseEnvironment);
        if (this.progressMonitor != null) {
            this.a.setProgressMonitor(this.progressMonitor);
        }
        this.a.removeAllConstraints();
        this.a.removeAllMolecules();
        try {
            this.a.addMolecule(this.mg[0], !rigid[0], false);
            for (i = 1; i < rigid.length; ++i) {
                this.a.addMolecule(this.mg[i], !rigid[i], true);
            }
            this.a.addConstraintsFromUserMappedAtoms();
            this.a.align();
            this.result = this.a.getAlignedMoleculesAsFragments();
            this.volumeTanimoto = this.a.tanimoto();
        }
        catch (AlignmentException e) {
            this.error = e.getMessage();
            return false;
        }
        return true;
    }

    public double getVolumeTanimoto() {
        return this.volumeTanimoto;
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
    }
}

