/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.calculations.AlignmentPlugin;
import chemaxon.marvin.plugin.CalculatorPluginDisplay;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.swing.MDialogProgressMonitor;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.text.NameConverter;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JOptionPane;

public class AlignmentPluginDisplay
extends CalculatorPluginDisplay {
    Color[] c = new Color[]{Color.BLUE, Color.YELLOW, Color.CYAN, Color.ORANGE, Color.PINK, Color.RED};
    private static int SIZE = 500;

    @Override
    public MProgressMonitor getProgressMonitor(Component parent) {
        return new MDialogProgressMonitor(parent, "");
    }

    @Override
    protected Component createSpacePanel(Molecule[] mols) throws PluginException {
        if (mols == null || mols.length == 0) {
            return null;
        }
        try {
            Class.forName("chemaxon.marvin.space.gui.MSpace");
        }
        catch (ClassNotFoundException cne) {
            cne.printStackTrace();
            this.displayInMarvinSpace = false;
            return new JOptionPane("MarvinSpace is not available", 0);
        }
        Class<?> MSpacePluginDisplayClass = null;
        CallbackIface mspd = null;
        try {
            MSpacePluginDisplayClass = Class.forName("chemaxon.marvin.space.MSpacePluginAlignment");
            mspd = (CallbackIface)MSpacePluginDisplayClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            this.displayInMarvinSpace = false;
            t.printStackTrace();
            return new JOptionPane("Error opening MarvinSpace", 0);
        }
        AlignmentPlugin al = (AlignmentPlugin)this.getPlugin();
        Double d = new Double(al.getVolumeTanimoto());
        mspd.callback("setVolumeTanimoto", d);
        mspd.callback("setMolecule", mols[0]);
        mspd.callback("setParent", this.parent);
        return (Component)mspd.callback("getMSpaceDialog", null);
    }

    private static String getIUPACName(Molecule m, int i) {
        String name = "";
        Molecule tmp = m.cloneMolecule();
        int c = 0;
        while (c < tmp.getAtomCount()) {
            if (tmp.getAtom(c).getAtno() == 130) {
                tmp.removeAtom(c);
                continue;
            }
            ++c;
        }
        try {
            name = tmp.toFormat("name");
        }
        catch (Exception e) {
            name = "Molecule " + i;
            e.printStackTrace();
        }
        return name;
    }

    @Override
    protected ViewPanel createViewPanel(Molecule[] mols) throws PluginException {
        if (mols == null || mols.length == 0) {
            return null;
        }
        if (mols.length != 1) {
            throw new UnsupportedOperationException("Molecule count must equal to one. ");
        }
        return this.createViewPanel(mols, 1, 1, 380, 0);
    }

    @Override
    protected ViewPanel createViewPanel(Molecule[] mols, int rows, int cols, int size, int propertyDisplayType) {
        if (mols == null || mols.length == 0) {
            return null;
        }
        int dim = mols[0].getDim();
        Color bgcolor = dim == 3 ? Color.black : Color.white;
        String bgstr = dim == 3 ? "#000000" : "#ffffff";
        String rendering = dim == 3 ? "sticks" : "wireframe";
        int nrows = (mols.length + (cols - 1)) / cols;
        rows = Math.min(rows, nrows);
        ViewPanel vp = new ViewPanel(null, dim, null);
        Properties viewProps = new Properties();
        viewProps.put("rendering", rendering);
        viewProps.put("extrabonds", "arom,wedge");
        viewProps.put("molbg", bgstr);
        viewProps.put("viewmolbg2d", bgstr);
        viewProps.put("viewmolbg3d", bgstr);
        viewProps.put("rows", "" + nrows);
        viewProps.put("cols", "" + cols);
        viewProps.put("visibleCols", "" + cols);
        viewProps.put("atomSymbolsVisible", "false");
        if (!Double.isNaN(this.getPlugin().getpH()) && propertyDisplayType == 0) {
            propertyDisplayType = 1;
        }
        String layout = null;
        String param = null;
        if (nrows > rows) {
            switch (propertyDisplayType) {
                case 1: {
                    layout = ":2:1:M:0:0:1:1:c:b:1:1:L:1:0:1:1:c:n:0:1";
                    param = ":M:" + size + ":" + size + ":L:12b";
                    break;
                }
                case 2: {
                    layout = ":2:1:M:0:0:1:1:c:b:1:1:T:1:0:1:1:w:n:0:1";
                    param = ":M:" + size + ":" + size + ":T:12b";
                    break;
                }
                case 3: {
                    layout = ":2:1:M:0:0:1:1:c:b:1:1:T:1:0:1:1:w:n:0:1";
                    param = ":M:" + size + ":" + size + ":T:12b:0";
                    break;
                }
                default: {
                    layout = ":1:1:M:0:0:1:1:c:b:1:1";
                    param = ":M:" + size + ":" + size;
                }
            }
            viewProps.put("visibleRows", "" + rows);
        } else {
            switch (propertyDisplayType) {
                case 1: {
                    layout = ":2:1:M:1:0:1:1:c:b:1:1:L:0:0:1:1:c:n:0:1";
                    param = ":M:" + size + ":" + size + ":L:12b";
                    break;
                }
                case 2: {
                    layout = ":2:1:M:1:0:1:1:c:b:1:1:T:0:0:1:1:w:h:0:1";
                    param = ":M:" + size + ":" + size + ":T:12b";
                    break;
                }
                case 3: {
                    layout = ":2:1:M:1:0:1:1:c:b:1:1:T:0:0:1:1:w:n:0:1";
                    param = ":M:" + size + ":" + size + ":T:12b:0";
                    break;
                }
                default: {
                    layout = ":1:1:M:0:0:1:1:c:b:1:1";
                    param = ":M:" + size + ":" + size;
                }
            }
        }
        viewProps.put("layout", layout);
        viewProps.put("param", param);
        vp.setProperties(viewProps);
        vp.setBorderWidth(1);
        if (propertyDisplayType == 1) {
            vp.setBackground(new Color(0xCCCCCC));
        } else {
            vp.setBackground(bgcolor);
        }
        vp.setMolbg(bgcolor);
        vp.setEditable(0);
        vp.setDetachable(false);
        for (int i = 0; i < mols.length; ++i) {
            Molecule mol = mols[i];
            if (propertyDisplayType != 0) {
                String text = null;
                text = this.getPropertyText(mol);
                if ((text = this.appendpHText(text)) != null) {
                    switch (propertyDisplayType) {
                        case 1: {
                            vp.setL(i, text);
                            break;
                        }
                        case 2: {
                            vp.setT(i, text);
                            break;
                        }
                        case 3: {
                            vp.setT(i, NameConverter.convertToSuperscriptedString(text));
                        }
                    }
                }
            }
            vp.molLoaded(new Molecule[]{mol}, i);
        }
        return vp;
    }
}

