/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.HBondViewer;
import chemaxon.calculations.clean.Clean3D;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginMDocSource;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MPolyline;
import java.awt.Color;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConformerPlugin
extends CalculatorPlugin {
    private static final int CONFORMERS = 0;
    private static final int LECONFORMER = 1;
    private static final int HAS_VALID_CONFORMER = 2;
    public static final int OPTIMIZATION_VERY_LOOSE = 0;
    public static final int OPTIMIZATION_NORMAL = 1;
    public static final int OPTIMIZATION_STRICT = 2;
    public static final int OPTIMIZATION_VERY_STRICT = 3;
    private static final Color HBOND_COLOR = Color.cyan.darker();
    private static final double CALORIE_TO_JOULE = 4.184;
    int calcType = 0;
    private static String warningmsg = "";
    private static String[] TYPE_RANGE = new String[]{"structure", "structures", "count", "hasvalidconformer"};
    private Object[] types = new Object[]{"structures"};
    private String displayoptions = "conformers";
    private Molecule mol = null;
    private Molecule leconformer = null;
    private Molecule[] conformers = null;
    private int count = 0;
    private String prehydrogenize = "";
    private String hyperfine = "";
    private String maxNumberOfConformers = "100";
    private String timelimit = "900";
    private String optlimit = "1";
    private String diversity = "0.1";
    private boolean existValidConformer;
    private MProgressMonitor progressMonitor = null;
    private HBondViewer hbondViewer = new HBondViewer();
    private boolean hbondCalculationSelected = false;
    private int[] numberOfHBonds = null;
    private int[][][] hbondDAAtomIndexes = null;
    private boolean molHasHBonds = false;
    private boolean isDefaultEnergyUnit = true;
    private MMFF94 mmff;
    private boolean mmff94Optimization;
    private double mmff94Energy;
    private Molecule mmff94OptimizedStructure;

    @Override
    public String getProductName() {
        return "Conformation Plugin Group";
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return false;
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
        this.progressMonitor = pmon;
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        this.calcType = 0;
        String chtypes = params.getProperty("type");
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
                if (!token.equalsIgnoreCase("hasvalidconformer")) continue;
                this.calcType = 2;
            }
        }
        this.optlimit = params.getProperty("optimization", "1");
        this.maxNumberOfConformers = params.getProperty("maxconformers", "100");
        this.timelimit = params.getProperty("timelimit", "900");
        this.diversity = params.getProperty("diversity", "0.1");
        this.setHyperfine("true".equalsIgnoreCase(params.getProperty("hyperfine", "")));
        this.setLowestEnergyConformerCalculation("true".equalsIgnoreCase(params.getProperty("leconformercalculation")));
        this.setMMFF94Optimization("true".equalsIgnoreCase(params.getProperty("mmff94optimization")));
        this.hbondCalculationSelected = "true".equalsIgnoreCase(params.getProperty("hbonds"));
        this.setPrehydrogenize("true".equalsIgnoreCase(params.getProperty("prehydrogenize", "[prehydrogenize]")));
        this.displayoptions = params.getProperty("displayoptions", "conformers");
        this.isDefaultEnergyUnit = params.getProperty("energyunit", "kcal/mol").equalsIgnoreCase("kcal/mol");
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        if (mol.isQuery()) {
            throw new PluginException(ConformerPlugin.getQueryMoleculeErrorMessage(mol));
        }
        if (ConformerPlugin.containsPseudoAtom(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with pseudo atoms.");
        }
        if (ConformerPlugin.containsSRUSgroup(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with SRU S-groups.");
        }
        if (mol.isReaction()) {
            throw new PluginException("Calculation result is not defined for reactions.");
        }
        if (ConformerPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.mol = mol;
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        if (this.calcType == 0) {
            if (!this.calculateConformers(this.mol)) {
                return false;
            }
        } else if (this.calcType == 1) {
            if (!this.calculateLowestEnergyConformer(this.mol)) {
                return false;
            }
            if (this.mmff94Optimization) {
                return this.calculateMMFF94Structure();
            }
        } else if (this.calcType == 2) {
            this.existValidConformer = this.calculateHasValidConformer(this.mol);
        }
        if (this.hbondCalculationSelected) {
            this.molHasHBonds = this.calculateHBonds(this.conformers);
        }
        return true;
    }

    public void setMMFF94Optimization(boolean opt) {
        this.mmff94Optimization = opt;
    }

    private boolean calculateMMFF94Structure() throws PluginException {
        if (this.leconformer == null) {
            this.leconformer = this.mol.cloneMoleculeWithDocument();
            this.leconformer.clean(3, null);
        }
        this.leconformer.setProperty("Energy", null);
        if (this.mmff == null) {
            this.mmff = new MMFF94();
        }
        if (!this.mmff.init(this.leconformer)) {
            warningmsg = "MMFF94 initialization failed.";
            return false;
        }
        try {
            if (!this.mmff.optimize()) {
                warningmsg = "MMFF94 optimization failed.";
                return false;
            }
        }
        catch (GradientOptimization.GradientOptimizationException e) {
            throw new PluginException(e);
        }
        this.mmff94Energy = this.mmff.getEnergy();
        if (Double.isNaN(this.mmff94Energy)) {
            warningmsg = "MMFF94 energy calculation failed.";
            return false;
        }
        this.mmff94OptimizedStructure = this.mmff.getMoleculeWithLastUsedCoordinates();
        this.mmff94OptimizedStructure.setProperty("MMFF94 energy", Double.toString(Math.rint(this.getMMFF94Energy() * 100.0) / 100.0));
        this.leconformer = this.mmff94OptimizedStructure;
        this.conformers = new Molecule[]{this.leconformer};
        this.count = this.conformers.length;
        return true;
    }

    public Molecule getMMFF94OptimizedStrucutre() {
        return this.mmff94OptimizedStructure;
    }

    private double getMMFF94Energy() {
        return this.mmff94Energy;
    }

    public void setLowestEnergyConformerCalculation(boolean le) {
        if (le) {
            this.calcType = 1;
        }
    }

    public void setMaxNumberOfConformers(int n) {
        this.maxNumberOfConformers = Integer.toString(n);
    }

    public void setTimelimit(int sec) {
        this.timelimit = Integer.toString(sec);
    }

    public void setDiversity(double limit) {
        this.diversity = Double.toString(limit);
    }

    public void setOptimization(int optimization) throws PluginException {
        if (optimization < 0 || optimization > 3) {
            throw new PluginException("Optimization value must be 0, 1, 2 or 3.");
        }
        this.optlimit = Integer.toString(optimization);
    }

    public void setPrehydrogenize(boolean preH) {
        this.prehydrogenize = preH ? "[prehydrogenize]" : "";
    }

    public void setHyperfine(boolean hyp) {
        this.hyperfine = hyp ? "[hyperfine]" : "";
    }

    private Molecule[] calcConformersCallback(Molecule m) throws PluginException {
        Clean3D module = new Clean3D();
        return module.calcConformers(m);
    }

    private boolean calculateConformers(Molecule m) throws PluginException {
        m = m.cloneMoleculeWithDocument();
        String args = "c3" + this.prehydrogenize + this.hyperfine + "[ca]{" + this.maxNumberOfConformers + "}{" + this.maxNumberOfConformers + "}[timelimit]{" + this.timelimit + "}L{" + this.optlimit + "}[diversity]{" + this.diversity + "}E";
        m.clean(3, args, this.progressMonitor);
        String energyStr = m.getProperty("Energy");
        if (energyStr != null) {
            if (energyStr.equals("CLEAN3D_ABORTED")) {
                warningmsg = "Timelimit exceeded or calculation aborted by user.";
                this.count = 0;
                return false;
            }
            if (energyStr.equals("CLEAN3D_FAILED")) {
                warningmsg = "No valid conformer or structure generation failed.";
                this.count = 0;
                return false;
            }
        }
        this.conformers = this.calcConformersCallback(m);
        if (this.conformers != null) {
            this.count = this.conformers.length;
        }
        if (this.count == 0) {
            warningmsg = "No conformers.";
        }
        return true;
    }

    private boolean calculateLowestEnergyConformer(Molecule m) throws PluginException {
        this.leconformer = m.cloneMoleculeWithDocument();
        String args = "c3" + this.prehydrogenize + this.hyperfine + "S{fine}L{" + this.optlimit + "}[timelimit]{" + this.timelimit + "}E";
        this.leconformer.clean(3, args, this.progressMonitor);
        String energyStr = this.leconformer.getProperty("Energy");
        if (energyStr.equals("CLEAN3D_ABORTED")) {
            warningmsg = "Timelimit exceeded or calculation aborted by user.";
            this.leconformer = null;
            this.count = 0;
            return false;
        }
        if (energyStr.equals("CLEAN3D_FAILED")) {
            warningmsg = "No valid conformer or structure generation failed.";
            this.leconformer = null;
            this.count = 0;
            return false;
        }
        this.count = 1;
        this.conformers = new Molecule[]{this.leconformer};
        return true;
    }

    private boolean calculateHasValidConformer(Molecule m) throws PluginException {
        String args = "[ca]{1}{1}E";
        Molecule rndconformer = m.cloneMolecule();
        rndconformer.clean(3, args, null);
        String energyStr = rndconformer.getProperty("Energy");
        if (energyStr.equals("CLEAN3D_ABORTED")) {
            return false;
        }
        return !energyStr.equals("CLEAN3D_FAILED");
    }

    public boolean hasValidConformer() throws PluginException {
        return this.existValidConformer;
    }

    public Molecule getLowestEnergyConformer() {
        return this.leconformer;
    }

    public double getEnergy() {
        return Double.parseDouble(this.leconformer.getProperty("Energy"));
    }

    public double getEnergy(int i) {
        return Double.parseDouble(this.conformers[i].getProperty("Energy"));
    }

    private boolean calculateHBonds(Molecule[] mols) {
        boolean foundHBond = false;
        this.numberOfHBonds = new int[mols.length];
        this.hbondDAAtomIndexes = new int[mols.length][][];
        this.hbondViewer.setTakeConformers(false);
        for (int i = 0; i < mols.length; ++i) {
            this.hbondViewer.setMolecule(mols[i]);
            this.hbondViewer.calcDACouples();
            if (this.hbondViewer.getConformerCount() == 0) {
                this.numberOfHBonds[i] = 0;
                continue;
            }
            foundHBond = true;
            this.numberOfHBonds[i] = this.hbondViewer.getHBondCountOfConformer(0);
            this.hbondDAAtomIndexes[i] = new int[this.numberOfHBonds[i]][];
            for (int bi = 0; bi < this.numberOfHBonds[i]; ++bi) {
                this.hbondDAAtomIndexes[i][bi] = new int[2];
                this.hbondDAAtomIndexes[i][bi][0] = this.hbondViewer.getADCoupleOfConformer(0, bi)[0];
                this.hbondDAAtomIndexes[i][bi][1] = this.hbondViewer.getADCoupleOfConformer(0, bi)[1];
            }
        }
        return foundHBond;
    }

    boolean hasHBondsConformer(int index) {
        return this.numberOfHBonds[index] != 0;
    }

    int getHBondCountOfConformer(int index) {
        return this.numberOfHBonds[index];
    }

    int[] getHBondOfConformer(int conformerIndex, int bondIndex) {
        return this.hbondDAAtomIndexes[conformerIndex][bondIndex];
    }

    void setHBondCalculation(boolean hb) {
        this.hbondCalculationSelected = hb;
    }

    boolean getDisplayHBonds() {
        return this.hbondCalculationSelected && this.molHasHBonds;
    }

    @Override
    public PluginMDocSource getResultSource() throws PluginException {
        return new ResultSource(new ResultIterator(), this.getStructureCount());
    }

    public int getConformerCount() {
        return this.getStructureCount();
    }

    int getStructureCount() {
        return this.count;
    }

    public Molecule getConformer(int index) {
        Molecule structure = this.getStructure(index);
        structure.setProperty("Clean3DConformersDescriptor", null);
        return structure;
    }

    Molecule getStructure(int index) {
        return this.conformers[index];
    }

    public Molecule[] getConformers() {
        Molecule[] structures = this.getStructures();
        for (int i = 0; i < structures.length; ++i) {
            structures[i].setProperty("Clean3DConformersDescriptor", null);
        }
        return structures;
    }

    Molecule[] getStructures() {
        return this.conformers;
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("structure")) {
            return "Conformer";
        }
        if (typestr.equals("structures")) {
            return "Conformers";
        }
        if (typestr.equals("count")) {
            return "Conformer count";
        }
        if (typestr.equals("hasvalidconformer")) {
            return "Has valid conformer";
        }
        return type.toString();
    }

    @Override
    public int getResultDomain(Object type) {
        return 4;
    }

    @Override
    public int getResultCount(Object type) {
        String typestr = type.toString();
        return typestr.equalsIgnoreCase("structure") ? this.getConformerCount() : 1;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("structure")) {
            return this.getStructure(index);
        }
        if (typestr.equalsIgnoreCase("structures")) {
            return this.getStructures();
        }
        if (typestr.equalsIgnoreCase("count")) {
            return new Integer(this.getStructureCount());
        }
        if (typestr.equalsIgnoreCase("hasvalidconformer")) {
            return new Boolean(this.hasValidConformer());
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Molecule) {
            return ((Molecule)result).toFormat("sdf:-a");
        }
        if (result instanceof Molecule[]) {
            Molecule[] mols = (Molecule[])result;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < mols.length; ++i) {
                buffer.append(mols[i].toFormat("sdf:-a"));
            }
            return new String(buffer);
        }
        if (result instanceof Boolean) {
            return String.valueOf((Boolean)result);
        }
        if (result instanceof Integer) {
            return result.toString();
        }
        throw new PluginException("Result should be a molecule, integer or boolean object\ninstead of: " + result);
    }

    @Override
    public String getWarningMessage() {
        return this.getConformerCount() == 0 ? warningmsg : "";
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
    }

    private class ResultSource
    extends PluginMDocSource {
        public ResultSource(Iterator iterator, int maxCount) {
            super(iterator, maxCount);
        }

        @Override
        public String getDocLabel(int k, MDocument doc) {
            Molecule mol = (Molecule)doc.getMainMoleculeGraph();
            if (ConformerPlugin.this.mmff94Optimization) {
                if (!ConformerPlugin.this.isDefaultEnergyUnit) {
                    return "MMFF94 energy: " + Math.rint(ConformerPlugin.this.getMMFF94Energy() * 4.184 * 100.0) / 100.0 + " kJ/mol";
                }
                return "MMFF94 energy: " + Math.rint(ConformerPlugin.this.getMMFF94Energy() * 100.0) / 100.0 + " kcal/mol";
            }
            if (!ConformerPlugin.this.isDefaultEnergyUnit) {
                return "Conf: " + String.valueOf(k + 1) + "  Energy: " + Math.rint(Double.parseDouble(mol.getProperty("Energy")) * 4.184 * 100.0) / 100.0 + " kJ/mol";
            }
            return "Conf: " + String.valueOf(k + 1) + "  Energy: " + Math.rint(Double.parseDouble(mol.getProperty("Energy")) * 100.0) / 100.0 + " kcal/mol";
        }
    }

    private class ResultIterator
    implements Iterator {
        private int currentCount = 0;

        private ResultIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentCount < ConformerPlugin.this.getStructureCount();
        }

        public Object next() {
            if (this.hasNext()) {
                Molecule structure = ConformerPlugin.this.getStructure(this.currentCount);
                MDocument doc = CalculatorPlugin.getDocument(structure);
                if (ConformerPlugin.this.displayoptions.equals("conformers")) {
                    structure.setProperty("Clean3DConformersDescriptor", null);
                    if (ConformerPlugin.this.getDisplayHBonds() && ConformerPlugin.this.hasHBondsConformer(this.currentCount)) {
                        int hBondCount = ConformerPlugin.this.getHBondCountOfConformer(this.currentCount);
                        for (int j = 0; j < hBondCount; ++j) {
                            int[] hb = ConformerPlugin.this.getHBondOfConformer(this.currentCount, j);
                            MolAtom atom1 = structure.getAtom(hb[0]);
                            MolAtom atom2 = structure.getAtom(hb[1]);
                            MPolyline line = new MPolyline(new MAtomSetPoint(new MolAtom[]{atom1}), (MPoint)new MAtomSetPoint(new MolAtom[]{atom2}));
                            line.setColor(HBOND_COLOR);
                            line.setThickness(0.04);
                            doc.addObject(line);
                        }
                    }
                }
                ++this.currentCount;
                return doc;
            }
            return null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Element removal is not supported.");
        }
    }
}

