/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.calculations.ConformerPlugin;
import chemaxon.marvin.calculations.MultipleMoleculeOutput;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;

public class ConformerPluginOutput
extends MultipleMoleculeOutput {
    private boolean saveConformerInfoInProperty = false;

    @Override
    public void setParameters(Properties params) throws PluginException {
        super.setParameters(params);
        this.saveConformerInfoInProperty = "true".equalsIgnoreCase(params.getProperty("saveconfdesc"));
    }

    @Override
    public String getResult(Molecule target) throws PluginException {
        ConformerPlugin plugin = (ConformerPlugin)this.getPlugin();
        int count = plugin.getStructureCount();
        if ("count".equalsIgnoreCase((String)plugin.getResultTypes()[0])) {
            return "" + count;
        }
        if ("hasvalidconformer".equalsIgnoreCase((String)plugin.getResultTypes()[0])) {
            return "" + plugin.hasValidConformer();
        }
        if (this.isMolecular()) {
            if (this.isOK()) {
                if (this.saveConformerInfoInProperty) {
                    Molecule mol = plugin.getStructure(0);
                    this.exportMolecule(mol);
                } else {
                    for (int i = 0; i < count; ++i) {
                        Molecule mol = plugin.getStructure(i);
                        mol.setProperty("Clean3DConformersDescriptor", null);
                        this.exportMolecule(mol);
                    }
                }
            }
            return "";
        }
        return super.getResult(target);
    }
}

