/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.core.calculations.ElementalAnalysisCalc;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Properties;
import java.util.StringTokenizer;

public class ElementalAnalyserPlugin
extends CalculatorPlugin {
    private static String[] TYPE_RANGE = new String[]{"mass", "exactmass", "formula", "isotopeformula", "dotdisconnectedformula", "dotdisconnectedisotopeformula", "composition", "isotopecomposition", "atomcount"};
    private Object[] types = new Object[]{"mass", "exactmass", "formula", "composition"};
    private ElementalAnalysisCalc elemanal = new ElementalAnalysisCalc();
    private int precision = -1;
    private int atno = -1;
    private int massno = -1;
    private boolean symbolD = true;
    private boolean single = false;
    private String errorMessage = "";

    public void setMolecule(String formula) throws IllegalArgumentException {
        this.elemanal.setMolecule(formula);
    }

    @Override
    public String getProductName() {
        return "Free Plugin";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String m;
        String pr;
        this.single = "true".equalsIgnoreCase(params.getProperty("single"));
        this.precision = -1;
        this.atno = -1;
        this.massno = -1;
        String chtypes = params.getProperty("type");
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equalsIgnoreCase("exact mass")) {
                    token = "exactmass";
                }
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
            }
        }
        if ((pr = params.getProperty("precision")) != null) {
            this.precision = Integer.parseInt(pr);
        }
        this.setDoublePrecision(pr);
        String z = params.getProperty("z");
        if (z != null) {
            this.atno = Integer.parseInt(z);
        }
        if ((z = params.getProperty("atno")) != null) {
            this.atno = Integer.parseInt(z);
        }
        if ((m = params.getProperty("m")) != null) {
            this.massno = Integer.parseInt(m);
        }
        if ((m = params.getProperty("massno")) != null) {
            this.massno = Integer.parseInt(m);
        }
        this.symbolD = params.getProperty("symbolD") == null && params.getProperty("symbold") == null || params.getProperty("symbolD") != null && "true".equalsIgnoreCase(params.getProperty("symbolD")) || params.getProperty("symbold") != null && "true".equalsIgnoreCase(params.getProperty("symbold"));
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return !this.single;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        if (mol.isQuery()) {
            throw new PluginException(ElementalAnalyserPlugin.getQueryMoleculeErrorMessage(mol));
        }
        if (ElementalAnalyserPlugin.containsPseudoAtom(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with pseudo atoms.");
        }
        if (ElementalAnalyserPlugin.containsSRUSgroup(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with SRU S-groups.");
        }
        if (mol.isReaction()) {
            throw new PluginException("Calculation result is not defined for reactions.");
        }
        if (ElementalAnalyserPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.elemanal.setMolecule(mol);
    }

    public double getMass() {
        return this.elemanal.mass();
    }

    public double getExactMass() {
        return this.elemanal.exactMass();
    }

    public String getFormula() {
        return this.elemanal.formula();
    }

    public String getIsotopeFormula() {
        return this.elemanal.isotopeFormula();
    }

    public String getIsotopeFormula(boolean symbolD) {
        return this.elemanal.isotopeFormula(symbolD);
    }

    public String getDotDisconnectedFormula() {
        return this.elemanal.dotDisconnectedFormula();
    }

    public String getDotDisconnectedIsotopeFormula() {
        return this.elemanal.dotDisconnectedIsotopeFormula();
    }

    public String getDotDisconnectedIsotopeFormula(boolean symbolD) {
        return this.elemanal.dotDisconnectedIsotopeFormula(symbolD);
    }

    public String getComposition() {
        int p = this.precision >= 0 ? this.precision : 2;
        return this.elemanal.composition(p);
    }

    public String getIsotopeComposition() {
        int p = this.precision >= 0 ? this.precision : 2;
        return this.elemanal.isotopeComposition(p);
    }

    public String getIsotopeComposition(boolean symbolD) {
        int p = this.precision >= 0 ? this.precision : 2;
        return this.elemanal.isotopeComposition(p, symbolD);
    }

    public int getAllAtomCount() {
        return this.elemanal.atomCount();
    }

    public int getAtomCount(int z) {
        return this.elemanal.atomCount(z);
    }

    public int getAtomCount(int z, int m) {
        return this.elemanal.atomCount(z, m);
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("mass")) {
            return new Double(this.getMass());
        }
        if (typestr.equalsIgnoreCase("exactmass")) {
            return new Double(this.getExactMass());
        }
        if (typestr.equalsIgnoreCase("formula")) {
            return this.getFormula();
        }
        if (typestr.equalsIgnoreCase("isotopeformula") || typestr.equalsIgnoreCase("isotope formula")) {
            return this.getIsotopeFormula(this.symbolD);
        }
        if (typestr.equalsIgnoreCase("dotdisconnectedformula") || typestr.equalsIgnoreCase("dot-disconnected formula")) {
            return this.getDotDisconnectedFormula();
        }
        if (typestr.equalsIgnoreCase("dotdisconnectedisotopeformula") || typestr.equalsIgnoreCase("dot-disconnected isotope formula")) {
            return this.getDotDisconnectedIsotopeFormula(this.symbolD);
        }
        if (typestr.equalsIgnoreCase("composition")) {
            return this.getComposition();
        }
        if (typestr.equalsIgnoreCase("isotopecomposition") || typestr.equalsIgnoreCase("isotope composition")) {
            return this.getIsotopeComposition(this.symbolD);
        }
        if (typestr.equalsIgnoreCase("atomcount") || typestr.equalsIgnoreCase("atom count")) {
            if (this.atno < 0) {
                return new Integer(this.getAllAtomCount());
            }
            if (this.massno >= 0) {
                return new Integer(this.getAtomCount(this.atno, this.massno));
            }
            return new Integer(this.getAtomCount(this.atno));
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public Object getResult(Object type, String arg) throws PluginException {
        int n = -1;
        int m = -1;
        if (arg != null) {
            try {
                int k = arg.indexOf(".");
                if (k != -1) {
                    m = Integer.parseInt(arg.substring(k + 1));
                    n = Integer.parseInt(arg.substring(0, k));
                } else {
                    n = Integer.parseInt(arg);
                }
            }
            catch (NumberFormatException e) {
                throw new PluginException("Argument string is invalid: " + arg);
            }
        }
        if (n > 0) {
            if (m > 0) {
                return new Integer(this.elemanal.atomCount(n, m));
            }
            return new Integer(this.elemanal.atomCount(n));
        }
        return new Integer(this.elemanal.atomCount());
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("mass")) {
            int p = -1;
            if (this.precision == -1) {
                p = this.elemanal.massPrecision();
                this.setDoublePrecision(p, true);
            }
            String res = this.format((Double)result);
            if (p == 3) {
                res = res + " ";
            }
            return res;
        }
        if (typestr.equalsIgnoreCase("exactmass") || typestr.equalsIgnoreCase("exact mass")) {
            if (this.precision == -1) {
                this.setDoublePrecision(this.elemanal.exactMassPrecision(), true);
            }
            return this.format((Double)result);
        }
        return result.toString();
    }

    @Override
    public int getResultCount(Object type) {
        return 1;
    }

    @Override
    public int getResultDomain(Object type) {
        return 2;
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("mass")) {
            return "Mass";
        }
        if (typestr.equals("exactmass")) {
            return "Exact mass";
        }
        if (typestr.equals("formula")) {
            return "Formula";
        }
        if (typestr.equals("isotopeformula")) {
            return "Isotope formula";
        }
        if (typestr.equals("dotdisconnectedformula")) {
            return "Dot-disconnected formula";
        }
        if (typestr.equals("dotdisconnectedisotopeformula")) {
            return "Dot-disconnected isotope formula";
        }
        if (typestr.equals("composition")) {
            return "Composition";
        }
        if (typestr.equals("isotopecomposition")) {
            return "Isotope composition";
        }
        if (typestr.equals("atomcount")) {
            String str = "Atom count";
            if (this.atno != -1) {
                str = str + " (" + MolAtom.symbolOf(this.atno) + ")";
            }
            if (this.massno != -1) {
                str = str + " (m=" + this.massno + ")";
            }
            return str;
        }
        return typestr;
    }

    @Override
    public boolean run() throws PluginException {
        Molecule calcMolecule = this.getCalcMolecule();
        if (calcMolecule != null) {
            try {
                this.checkMolecule(calcMolecule);
                this.errorMessage = "";
            }
            catch (PluginException e) {
                this.errorMessage = e.getMessage();
                return false;
            }
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        for (int t = 0; t < this.types.length; ++t) {
            Object type = this.types[t];
            Object result = this.getResult(type, 0);
            mol.setProperty(type.toString(), this.getResultAsString(type, 0, result));
        }
        return mol;
    }

    @Override
    public void standardize(Molecule mol) {
    }
}

