/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.HuckelAnalysis;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.calculations.MajorMicrospeciesAccessorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;
import java.util.StringTokenizer;

public class HuckelAnalysisPlugin
extends MajorMicrospeciesAccessorPlugin {
    private static final String WARNING1 = "No aromatic bonds found.";
    private static final String WARNING2 = "No delocalizable bonds found.";
    private static String[] TYPE_RANGE = new String[]{"order", "order:e", "order:n", "localizationenergy", "localizationenergy:e", "localizationenergy:n", "pienergy", "eigenvalue", "eigenvector", "orbitals", "electrondensity", "pichargedensity", "chargedensity", "totalchargedensity", "hmoorder", "hmoorder:e", "hmoorder:n", "hmolocalizationenergy", "hmolocalizationenergy:e", "hmolocalizationenergy:n", "hmopienergy", "hmoeigenvalue", "hmoeigenvector", "hmoorbitals", "hmoelectrondensity", "hmochargedensity"};
    private HuckelAnalysis huckelAnalysis = null;
    private HuckelAnalysis hmoHuckelAnalysis = null;
    private Object[] types = new Object[]{"hmoorder"};

    public HuckelAnalysisPlugin() {
        this.huckelAnalysis = new HuckelAnalysis(false);
        this.hmoHuckelAnalysis = new HuckelAnalysis(true);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed(this.getProductName(), this.licenseEnvironment);
    }

    @Override
    public String getProductName() {
        return "Huckel Analysis Plugin";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String chtypes;
        super.setParameters(params);
        int subtypes = 0;
        String chsubtypes = params.getProperty("subtype");
        if (chsubtypes != null) {
            if ((chsubtypes = chsubtypes.toLowerCase()).indexOf("+") != -1 || chsubtypes.indexOf("e") != -1) {
                subtypes += 2;
            }
            if (chsubtypes.indexOf("-") != -1 || chsubtypes.indexOf("n") != -1) {
                ++subtypes;
            }
        }
        if ((chtypes = params.getProperty("type")) == null) {
            chtypes = "hmoorder";
        }
        chtypes = chtypes.toLowerCase();
        StringTokenizer st = new StringTokenizer(chtypes, ",");
        this.types = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().toLowerCase();
            token = this.getType(token, subtypes);
            this.checkType(token, TYPE_RANGE);
            this.types[i++] = token;
        }
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
    }

    private String getType(String type, int subtypes) {
        if ((type = this.getType(type)).equals("order") || type.equals("hmoorder") || type.equals("localizationenergy") || type.equals("hmolocalizationenergy")) {
            if (subtypes == 2) {
                type = type + ":e";
            } else if (subtypes == 1) {
                type = type + ":n";
            }
        }
        return type;
    }

    private String getType(String type) {
        if (type.indexOf(" ") == -1) {
            return type;
        }
        if (type.indexOf("order") != -1) {
            return "order";
        }
        if (type.indexOf("localization") != -1) {
            return "localizationenergy";
        }
        if (type.equals("pi energy")) {
            return "pienergy";
        }
        if (type.equals("eigenvalue")) {
            return "eigenvalue";
        }
        if (type.equals("eigenvector")) {
            return "eigenvector";
        }
        if (type.equals("orbitals")) {
            return "orbitals";
        }
        if (type.equals("electron density")) {
            return "electrondensity";
        }
        if (type.equals("pi charge density")) {
            return "pichargedensity";
        }
        if (type.equals("charge density")) {
            return "chargedensity";
        }
        if (type.equals("total charge density")) {
            return "totalchargedensity";
        }
        return type;
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.huckelAnalysis.setMolecule(mol);
        this.hmoHuckelAnalysis.setMolecule(mol);
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        for (int i = 0; i < this.types.length; ++i) {
            String type = (String)this.types[i];
            if (type.equals("order")) {
                this.huckelAnalysis.calcAtomicElectrophility();
                this.huckelAnalysis.calcAtomicNucleophility();
                continue;
            }
            if (type.equals("hmoorder")) {
                this.hmoHuckelAnalysis.calcAtomicElectrophility();
                this.hmoHuckelAnalysis.calcAtomicNucleophility();
                continue;
            }
            if (type.equals("order:e")) {
                this.huckelAnalysis.calcAtomicElectrophility();
                continue;
            }
            if (type.equals("hmoorder:e")) {
                this.hmoHuckelAnalysis.calcAtomicElectrophility();
                continue;
            }
            if (type.equals("order:n")) {
                this.huckelAnalysis.calcAtomicNucleophility();
                continue;
            }
            if (type.equals("hmoorder:n")) {
                this.hmoHuckelAnalysis.calcAtomicNucleophility();
                continue;
            }
            if (type.equals("localizationenergy")) {
                this.huckelAnalysis.calcAtomicElectrophility();
                this.huckelAnalysis.calcAtomicNucleophility();
                continue;
            }
            if (type.equals("hmolocalizationenergy")) {
                this.hmoHuckelAnalysis.calcAtomicElectrophility();
                this.hmoHuckelAnalysis.calcAtomicNucleophility();
                continue;
            }
            if (type.equals("localizationenergy:e")) {
                this.huckelAnalysis.calcAtomicElectrophility();
                continue;
            }
            if (type.equals("hmolocalizationenergy:e")) {
                this.hmoHuckelAnalysis.calcAtomicElectrophility();
                continue;
            }
            if (type.equals("localizationenergy:n")) {
                this.huckelAnalysis.calcAtomicNucleophility();
                continue;
            }
            if (type.equals("hmolocalizationenergy:n")) {
                this.hmoHuckelAnalysis.calcAtomicNucleophility();
                continue;
            }
            if (type.equals("pienergy") || type.equals("eigenvalue") || type.equals("eigenvector") || type.equals("orbitals")) {
                this.huckelAnalysis.calcHMOPiEnergy();
                continue;
            }
            if (type.equals("hmopienergy") || type.equals("hmoeigenvalue") || type.equals("hmoeigenvector") || type.equals("hmoorbitals")) {
                this.hmoHuckelAnalysis.calcHMOPiEnergy();
                continue;
            }
            if (!type.startsWith("hmo") && type.endsWith("density")) {
                this.huckelAnalysis.calcHMOChargeDensity();
                continue;
            }
            if (!type.startsWith("hmo") || !type.endsWith("density")) continue;
            this.hmoHuckelAnalysis.calcHMOChargeDensity();
        }
        return !this.huckelAnalysis.getCriticalErrorFlag() && !this.hmoHuckelAnalysis.getCriticalErrorFlag();
    }

    @Override
    public String getErrorMessage() {
        if (this.huckelAnalysis.getCriticalErrorFlag() || this.hmoHuckelAnalysis.getCriticalErrorFlag()) {
            return "Inconsistent molecular structure.";
        }
        return "";
    }

    @Override
    public String getWarningMessage() {
        if (this.huckelAnalysis.isResultAvailable() || this.hmoHuckelAnalysis.isResultAvailable()) {
            return "";
        }
        String typestr = this.types[0].toString().toLowerCase();
        if (typestr.indexOf("order") != -1 || typestr.indexOf("hmoorder") != -1 || typestr.indexOf("localization") != -1 || typestr.indexOf("hmolocalization") != -1) {
            return WARNING1;
        }
        return WARNING2;
    }

    public int getElectrophilicOrder(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return -1;
        }
        return this.huckelAnalysis.getElectrophilicOrder()[atom];
    }

    public int getHMOElectrophilicOrder(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return -1;
        }
        return this.hmoHuckelAnalysis.getElectrophilicOrder()[atom];
    }

    public int getNucleophilicOrder(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return -1;
        }
        return this.huckelAnalysis.getNucleophilicOrder()[atom];
    }

    public int getHMONucleophilicOrder(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return -1;
        }
        return this.hmoHuckelAnalysis.getNucleophilicOrder()[atom];
    }

    public double getElectrophilicEnergy(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return Double.NaN;
        }
        return this.huckelAnalysis.getElecLocEnergy()[atom];
    }

    public double getHMOElectrophilicEnergy(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return Double.NaN;
        }
        return this.hmoHuckelAnalysis.getElecLocEnergy()[atom];
    }

    public double getNucleophilicEnergy(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return Double.NaN;
        }
        return this.huckelAnalysis.getNucLocEnergy()[atom];
    }

    public double getHMONucleophilicEnergy(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return Double.NaN;
        }
        return this.hmoHuckelAnalysis.getNucLocEnergy()[atom];
    }

    public double getTotalPiEnergy() {
        return this.huckelAnalysis.getTotalPiEnergy();
    }

    public double getHMOTotalPiEnergy() {
        return this.hmoHuckelAnalysis.getTotalPiEnergy();
    }

    public double[] getRealEigenValue() {
        return this.huckelAnalysis.getRealEigenValue();
    }

    public double[] getHMORealEigenValue() {
        return this.hmoHuckelAnalysis.getRealEigenValue();
    }

    public double[][] getEigenVector() {
        return this.huckelAnalysis.getEigenVector();
    }

    public double[][] getHMOEigenVector() {
        return this.hmoHuckelAnalysis.getEigenVector();
    }

    public double[][] getHuckelOrbitalCoefficients() {
        return this.huckelAnalysis.getHuckelOrbital();
    }

    public double[][] getHMOHuckelOrbitalCoefficients() {
        return this.hmoHuckelAnalysis.getHuckelOrbital();
    }

    public double getElectronDensity(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return Double.NaN;
        }
        return this.huckelAnalysis.getPiCDens()[atom];
    }

    public double getHMOElectronDensity(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return Double.NaN;
        }
        return this.hmoHuckelAnalysis.getPiCDens()[atom];
    }

    public double getChargeDensity(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return Double.NaN;
        }
        return this.huckelAnalysis.getTotCDens()[atom];
    }

    public double getHMOChargeDensity(int atom) {
        if ((atom = this.getAtomIndex(atom)) == -1) {
            return Double.NaN;
        }
        return this.hmoHuckelAnalysis.getTotCDens()[atom];
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("order") || typestr.equals("hmoorder")) {
            return "Aromatic E(+)/Nu(-) order";
        }
        if (typestr.equals("order:e") || typestr.equals("hmoorder:e")) {
            return "Aromatic E(+) order";
        }
        if (typestr.equals("order:n") || typestr.equals("hmoorder:n")) {
            return "Aromatic Nu(-) order";
        }
        if (typestr.equals("localizationenergy") || typestr.equals("hmolocalizationenergy")) {
            return "Localization energy L(+)/L(-)";
        }
        if (typestr.equals("localizationenergy:e") || typestr.equals("hmolocalizationenergy:e")) {
            return "Localization energy L(+)";
        }
        if (typestr.equals("localizationenergy:n") || typestr.equals("hmolocalizationenergy:n")) {
            return "Localization energy L(-)";
        }
        if (typestr.equals("pienergy") || typestr.equals("hmopienergy")) {
            return "Pi energy";
        }
        if (typestr.equals("eigenvalue") || typestr.equals("hmoeigenvalue")) {
            return "Eigenvalue";
        }
        if (typestr.equals("eigenvector") || typestr.equals("hmoeigenvector")) {
            return "Eigenvector";
        }
        if (typestr.equals("orbitals") || typestr.equals("hmoorbitals")) {
            return "Orbitals";
        }
        if (typestr.equals("electrondensity") || typestr.equals("hmoelectrondensity")) {
            return "Electron density";
        }
        if (typestr.equals("pichargedensity")) {
            return "Pi charge density";
        }
        if (typestr.equals("chargedensity") || typestr.equals("hmochargedensity")) {
            return "Charge density";
        }
        if (typestr.equals("totalchargedensity")) {
            return "Total charge density";
        }
        return typestr;
    }

    @Override
    public int getResultDomain(Object type) {
        if (type.toString().equals("pienergy") || type.toString().equals("eigenvalue") || type.toString().equals("eigenvector") || type.toString().equals("orbitals") || type.toString().equals("hmopienergy") || type.toString().equals("hmoeigenvalue") || type.toString().equals("hmoeigenvector") || type.toString().equals("hmoorbitals")) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getResultCount(Object type) {
        if (type.toString().equals("pienergy") || type.toString().equals("eigenvalue") || type.toString().equals("eigenvector") || type.toString().equals("orbitals") || type.toString().equals("hmopienergy") || type.toString().equals("hmoeigenvalue") || type.toString().equals("hmoeigenvector") || type.toString().equals("hmoorbitals")) {
            return 1;
        }
        return this.getAtomCount();
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("order")) {
            return new int[]{this.getElectrophilicOrder(index), this.getNucleophilicOrder(index)};
        }
        if (typestr.equals("order:e")) {
            return new Integer(this.getElectrophilicOrder(index));
        }
        if (typestr.equals("order:n")) {
            return new Integer(this.getNucleophilicOrder(index));
        }
        if (typestr.equals("localizationenergy")) {
            return new double[]{this.getElectrophilicEnergy(index), this.getNucleophilicEnergy(index)};
        }
        if (typestr.equals("localizationenergy:e")) {
            return new Double(this.getElectrophilicEnergy(index));
        }
        if (typestr.equals("localizationenergy:n")) {
            return new Double(this.getNucleophilicEnergy(index));
        }
        if (typestr.equals("pienergy")) {
            return new Double(this.getTotalPiEnergy());
        }
        if (typestr.equals("eigenvalue")) {
            return this.getRealEigenValue();
        }
        if (typestr.equals("eigenvector")) {
            return this.getEigenVector();
        }
        if (typestr.equals("orbitals")) {
            return this.getHuckelOrbitalCoefficients();
        }
        if (typestr.equals("electrondensity")) {
            return new Double(this.getElectronDensity(index));
        }
        if (typestr.equals("pichargedensity")) {
            return new Double(this.getElectronDensity(index));
        }
        if (typestr.equals("chargedensity")) {
            return new Double(this.getChargeDensity(index));
        }
        if (typestr.equals("totalchargedensity")) {
            return new Double(this.getChargeDensity(index));
        }
        if (typestr.equals("hmoorder")) {
            return new int[]{this.getHMOElectrophilicOrder(index), this.getHMONucleophilicOrder(index)};
        }
        if (typestr.equals("hmoorder:e")) {
            return new Integer(this.getHMOElectrophilicOrder(index));
        }
        if (typestr.equals("hmoorder:n")) {
            return new Integer(this.getHMONucleophilicOrder(index));
        }
        if (typestr.equals("hmolocalizationenergy")) {
            return new double[]{this.getHMOElectrophilicEnergy(index), this.getHMONucleophilicEnergy(index)};
        }
        if (typestr.equals("hmolocalizationenergy:e")) {
            return new Double(this.getHMOElectrophilicEnergy(index));
        }
        if (typestr.equals("hmolocalizationenergy:n")) {
            return new Double(this.getHMONucleophilicEnergy(index));
        }
        if (typestr.equals("hmopienergy")) {
            return new Double(this.getHMOTotalPiEnergy());
        }
        if (typestr.equals("hmoeigenvalue")) {
            return this.getHMORealEigenValue();
        }
        if (typestr.equals("hmoeigenvector")) {
            return this.getHMOEigenVector();
        }
        if (typestr.equals("hmoorbitals")) {
            return this.getHMOHuckelOrbitalCoefficients();
        }
        if (typestr.equals("hmoelectrondensity")) {
            return new Double(this.getHMOElectronDensity(index));
        }
        if (typestr.equals("hmochargedensity")) {
            return new Double(this.getHMOChargeDensity(index));
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Integer) {
            int x = (Integer)result;
            if (x == -1) {
                return "";
            }
            return "" + x;
        }
        if (result instanceof Double) {
            double x = (Double)result;
            if (Double.isNaN(x)) {
                return "";
            }
            return this.format(x);
        }
        if (result instanceof int[]) {
            int[] x = (int[])result;
            if (x[0] == -1 && x[1] == -1) {
                return "";
            }
            if (x[0] == -1) {
                return "[;" + x[1] + "]";
            }
            if (x[1] == -1) {
                return "[" + x[0] + ";]";
            }
            return "[" + x[0] + ";" + x[1] + "]";
        }
        if (result instanceof double[]) {
            double[] x = (double[])result;
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            for (int i = 0; i < x.length; ++i) {
                if (Double.isNaN(x[i])) {
                    sb.append("");
                } else {
                    sb.append(this.format(x[i]));
                }
                if (i >= x.length - 1) continue;
                sb.append(";");
            }
            sb.append("]");
            return sb.toString();
        }
        if (result instanceof double[][]) {
            double[][] xx = (double[][])result;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < xx.length; ++i) {
                double[] x = xx[i];
                sb.append("[");
                for (int j = 0; j < x.length; ++j) {
                    if (Double.isNaN(x[j])) {
                        sb.append("");
                    } else {
                        sb.append(this.format(x[j]));
                    }
                    if (j >= x.length - 1) continue;
                    sb.append(";");
                }
                sb.append("]");
            }
            return sb.toString();
        }
        throw new PluginException("Invalid result object type: " + result);
    }

    @Override
    public String getResultsAsString(Object type, int index, Object result) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("order") || typestr.equals("hmoorder")) {
            int[] r = (int[])result;
            if (r[0] != -1 && r[1] != -1) {
                return "" + (r[0] + 1) + "|" + (r[1] + 1);
            }
            if (r[0] != -1) {
                return "" + (r[0] + 1);
            }
            if (r[1] != -1) {
                return "" + (r[1] + 1);
            }
            return "";
        }
        if (typestr.equals("order:e") || typestr.equals("order:n") || typestr.equals("hmoorder:e") || typestr.equals("hmoorder:n")) {
            int r = (Integer)result;
            if (r != -1) {
                return "" + (r + 1);
            }
            return "";
        }
        if (typestr.equals("localizationenergy") || typestr.equals("hmolocalizationenergy")) {
            double[] r = (double[])result;
            if (!Double.isNaN(r[0]) && !Double.isNaN(r[1])) {
                return this.format(r[0]) + "|" + this.format(r[1]);
            }
            if (!Double.isNaN(r[0])) {
                return this.format(r[0]);
            }
            if (!Double.isNaN(r[1])) {
                return this.format(r[1]);
            }
            return "";
        }
        if (typestr.equals("localizationenergy:e") || typestr.equals("localizationenergy:n") || typestr.equals("hmolocalizationenergy:e") || typestr.equals("hmolocalizationenergy:n")) {
            double r = (Double)result;
            return this.format(r);
        }
        return this.getResultAsString(type, index, result);
    }

    @Override
    public long getResultsAsRGB(Object type, int index, Object result) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("order") || typestr.equals("hmoorder")) {
            int[] r = (int[])result;
            if (r[0] != -1 && r[1] != -1) {
                return 0xFF00FF0000L;
            }
            if (r[0] != -1) {
                return 0xFF0000L;
            }
            if (r[1] != -1) {
                return 255L;
            }
            return 0L;
        }
        if (typestr.equals("order:e") || typestr.equals("hmoorder:e")) {
            return 0xFF0000L;
        }
        if (typestr.equals("order:n") || typestr.equals("hmoorder:n")) {
            return 255L;
        }
        if (typestr.equals("localizationenergy") || typestr.equals("hmolocalizationenergy")) {
            double[] r = (double[])result;
            if (!Double.isNaN(r[0]) && !Double.isNaN(r[1])) {
                return 0xFF00FF0000L;
            }
            if (!Double.isNaN(r[0])) {
                return 0xFF0000L;
            }
            if (!Double.isNaN(r[1])) {
                return 255L;
            }
            return 0L;
        }
        if (typestr.equals("localizationenergy:e") || typestr.equals("hmolocalizationenergy:e")) {
            return 0xFF0000L;
        }
        if (typestr.equals("localizationenergy:n") || typestr.equals("hmolocalizationenergy:n")) {
            return 255L;
        }
        return this.getResultAsRGB(type, index, result);
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        for (int t = 0; t < this.types.length; ++t) {
            Object type = this.types[t];
            if (this.getResultDomain(type) == 1) {
                for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
                    Object result = this.getResult(type, i);
                    String label = this.getResultsAsString(type, i, result);
                    long rgbs = this.getResultsAsRGB(type, i, result);
                    mol.getAtom(i).setExtraLabel(label);
                    mol.getAtom(i).setExtraLabelColor(rgbs);
                }
                continue;
            }
            Object result = this.getResult(type, 0);
            mol.setProperty(type.toString(), this.getResultAsString(type, 0, result));
        }
        return mol;
    }
}

