/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.license.Licensable;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;
import java.util.StringTokenizer;

public class IUPACNamingPlugin
extends CalculatorPlugin {
    private static String[] TYPE_RANGE = new String[]{"preferred", "traditional"};
    private Object[] types = new Object[]{"preferred"};
    private Molecule mol;
    private String preferredIUPACName = null;
    private String traditionalIUPACName = null;
    private boolean generatePreferredIUPACName = false;
    private boolean generateTraditionalIUPACName = false;
    private boolean single = false;

    @Override
    public void setParameters(Properties params) throws PluginException {
        this.single = "true".equalsIgnoreCase(params.getProperty("single"));
        String chtypes = params.getProperty("type", "preferred");
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
            }
        }
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i].equals("preferred")) {
                this.setGeneratePreferredIUPACName(true);
            }
            if (!this.types[i].equals("traditional")) continue;
            this.setGenerateTraditionalIUPACName(true);
        }
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return !this.single;
    }

    @Override
    public void checkMolecule(Molecule mol) {
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.mol = mol;
    }

    public void setGeneratePreferredIUPACName(boolean g) {
        this.generatePreferredIUPACName = g;
    }

    public void setGenerateTraditionalIUPACName(boolean g) {
        this.generateTraditionalIUPACName = g;
    }

    @Override
    public boolean run() throws PluginException {
        this.preferredIUPACName = null;
        this.traditionalIUPACName = null;
        if (this.generatePreferredIUPACName) {
            this.preferredIUPACName = this.getPreferredIUPACName();
        }
        if (this.generateTraditionalIUPACName) {
            this.traditionalIUPACName = this.getTraditionalName();
        }
        return true;
    }

    public String getPreferredIUPACName() throws PluginException {
        if (this.preferredIUPACName != null) {
            return this.preferredIUPACName;
        }
        try {
            return this.getName("name:i");
        }
        catch (MolExportException e) {
            throw new PluginException(e);
        }
    }

    public String getTraditionalName() throws PluginException {
        if (this.traditionalIUPACName != null) {
            return this.traditionalIUPACName;
        }
        try {
            return this.getName("name:t");
        }
        catch (MolExportException e) {
            throw new PluginException(e);
        }
    }

    private String getName(String format2) throws MolExportException {
        MolExportModule mod;
        try {
            mod = MFileFormatUtil.createExportModule("name");
        }
        catch (MolExportException mee) {
            throw new RuntimeException(mee.getMessage());
        }
        mod.open(format2);
        if (mod instanceof Licensable) {
            ((Licensable)((Object)mod)).setLicenseEnvironment(this.licenseEnvironment);
        }
        return ((String)mod.convert(this.mol)).trim();
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("preferred")) {
            return "Preferred IUPAC Name";
        }
        if (typestr.equals("traditional")) {
            return "Traditional Name";
        }
        return type.toString();
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        if (type.equals("traditional")) {
            return this.getTraditionalName();
        }
        return this.getPreferredIUPACName();
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (type.equals("traditional")) {
            return this.getTraditionalName();
        }
        return this.getPreferredIUPACName();
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        this.checkLicense();
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i].equals("traditional")) {
                mol.setProperty(this.getTypeString(this.types[i]), this.getTraditionalName());
                continue;
            }
            if (this.types[i].equals("preferred")) {
                mol.setProperty(this.getTypeString(this.types[i]), this.getPreferredIUPACName());
                continue;
            }
            throw new PluginException("Unknown type: " + this.types[i]);
        }
        return mol;
    }

    @Override
    public String getProductName() {
        return "Structure to Name Plugin";
    }

    @Override
    public void setLicenseEnvironment(String env) {
        super.setLicenseEnvironment(env);
    }

    @Override
    public void standardize(Molecule mol) {
    }
}

