/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.pka.PKaLargeModel;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;
import java.util.StringTokenizer;

public class IsoelectricPointPlugin
extends CalculatorPlugin {
    private static final String WARNING = "No isoelectric point.";
    private static String[] TYPE_RANGE = new String[]{"pI", "chargedistr"};
    private static final double DEF_LOWER = 0.0;
    private static final double DEF_UPPER = 14.0;
    private static final double DEF_STEP = 0.5;
    public static final String TYPE_DISTR = "chargedistr";
    private boolean chargeCalc = true;
    private PKaLargeModel proteinIonization = null;
    private Object[] types = new Object[]{"pI", "chargedistr"};

    public IsoelectricPointPlugin() {
        this.proteinIonization = new PKaLargeModel();
    }

    @Override
    public String getProductName() {
        return "Protonation Plugin Group";
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
        this.proteinIonization.setProgressMonitor(pmon);
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
        String pHstr = params.getProperty("pH");
        if (pHstr != null && pHstr.length() > 0) {
            double pH = Double.valueOf(pHstr);
            this.setpH(pH);
        } else {
            double lower = 0.0;
            String lstr = params.getProperty("lower");
            if (lstr != null && lstr.length() > 0) {
                lower = Double.valueOf(lstr);
            }
            double upper = 14.0;
            String ustr = params.getProperty("upper");
            if (ustr != null && ustr.length() > 0) {
                upper = Double.valueOf(ustr);
            }
            if (upper < lower) {
                double tmp = lower;
                lower = upper;
                upper = tmp;
            }
            double step = 0.5;
            String sstr = params.getProperty("step");
            if (sstr != null && sstr.length() > 0) {
                step = Double.valueOf(sstr);
                if (step < 0.0) {
                    step = -step;
                } else if (step == 0.0) {
                    throw new PluginException("Step size is zero.");
                }
            }
            this.setpHLower(lower);
            this.setpHUpper(upper);
            this.setpHStep(step);
        }
        this.chargeCalc = !"false".equalsIgnoreCase(params.getProperty(TYPE_DISTR));
        String chtypes = params.getProperty("type");
        if (chtypes == null) {
            chtypes = this.chargeCalc ? "pI,chargedistr" : "pI";
        }
        StringTokenizer st = new StringTokenizer(chtypes, ",");
        this.types = new Object[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.checkType(token, TYPE_RANGE);
            this.types[i++] = token;
        }
    }

    protected boolean isChargeCalc() {
        return this.chargeCalc;
    }

    public void setpHLower(double lower) {
        this.proteinIonization.setpHL(lower);
    }

    public void setpHUpper(double upper) {
        this.proteinIonization.setpHU(upper);
    }

    public void setpHStep(double step) {
        this.proteinIonization.setpHS(step);
    }

    public void setpH(double pH) {
        this.proteinIonization.setpHL(pH);
        this.proteinIonization.setpHU(pH);
        this.proteinIonization.setpHS(0.0);
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (IsoelectricPointPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.proteinIonization.setMolecule(mol);
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        this.proteinIonization.calcIsoelectricPoint();
        return !this.proteinIonization.getCriticalErrorFlag();
    }

    @Override
    public String getErrorMessage() {
        if (this.proteinIonization.getCriticalErrorFlag()) {
            return "Inconsistent molecular structure.";
        }
        return "";
    }

    public double getpI() {
        return this.proteinIonization.getpI();
    }

    public double[] getpHs() {
        return this.proteinIonization.getpHPoints();
    }

    public double[] getChargeDistribution() {
        return this.proteinIonization.getChargepHDistribution();
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        return 2;
    }

    @Override
    public int getResultCount(Object type) {
        return 1;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase(TYPE_DISTR)) {
            return new double[][]{this.getpHs(), this.getChargeDistribution()};
        }
        if (typestr.equalsIgnoreCase("pI")) {
            return new Double(this.getpI());
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public Object getResult(Object type, String arg) throws PluginException {
        double pH = Double.NaN;
        try {
            pH = Double.parseDouble(arg);
        }
        catch (NumberFormatException e) {
            throw new PluginException("Argument string is not a pH value: " + arg);
        }
        if (Double.isNaN(pH)) {
            return Double.NaN;
        }
        this.setpH(pH);
        return new Double(this.getChargeDistribution()[0]);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (type.toString().equalsIgnoreCase(TYPE_DISTR)) {
            if (!(result instanceof double[][])) {
                throw new PluginException("Result is not a double[][] object: " + result);
            }
            return this.format((double[][])result, 3);
        }
        if (!(result instanceof Double)) {
            throw new PluginException("Result is not a Double object: " + result);
        }
        double x = (Double)result;
        if (Double.isNaN(x)) {
            return "";
        }
        return this.format(x);
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase(TYPE_DISTR)) {
            return "Charge";
        }
        return typestr;
    }

    @Override
    public String getWarningMessage() {
        return !this.isChargeCalc() && Double.isNaN(this.getpI()) ? WARNING : "";
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        double pI = this.getpI();
        if (!Double.isNaN(pI)) {
            mol.setProperty("pI", this.format(pI));
        } else {
            mol.setProperty(WARNING, "");
        }
        return mol;
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
        mol.implicitizeHydrogens(2047);
        IsoelectricPointPlugin.standardizeIonicGroups(mol);
        mol.dearomatize();
        mol.aromatize(1);
    }
}

