/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.MolSurfaceArea;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.calculations.MajorMicrospeciesAccessorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;
import java.util.StringTokenizer;

public class MSAPlugin
extends MajorMicrospeciesAccessorPlugin {
    public static final int VAN_DER_WAALS = 0;
    public static final int SOLVENT = 1;
    private static String[] TYPE_RANGE = new String[]{"vanderwaals", "solvent", "ASA", "ASA+", "ASA-", "ASA_H", "ASA_P", "increments"};
    private Object[] types = new Object[]{"vanderwaals"};
    private MolSurfaceArea msa = new MolSurfaceArea();
    private int saType = 0;
    private boolean increments = false;

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed(this.getProductName(), this.licenseEnvironment);
    }

    @Override
    public String getProductName() {
        return "Geometry Plugin Group";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        super.setParameters(params);
        this.increments = "true".equalsIgnoreCase(params.getProperty("increments"));
        int sa = 0;
        String chtypes = params.getProperty("type");
        if (chtypes != null) {
            if (this.increments) {
                chtypes = chtypes + ",increments";
            }
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                token = MSAPlugin.removeWhitespace(token);
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
                if (token.equalsIgnoreCase("vanderwaals")) {
                    sa = 0;
                    continue;
                }
                if (!token.equalsIgnoreCase("solvent") && !token.toLowerCase().startsWith("asa")) continue;
                sa = 1;
            }
        }
        this.setSurfaceAreaType(sa);
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
        this.setSolventRadius(Double.parseDouble(params.getProperty("solventradius", "1.4")));
    }

    public void setSurfaceAreaType(int saType) {
        this.saType = saType;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (mol.isReaction()) {
            throw new PluginException("Calculation is not defined for reactions.");
        }
        if (MSAPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.msa.setMolecule(mol);
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        switch (this.saType) {
            case 0: {
                this.msa.calcVDWSA();
                break;
            }
            case 1: {
                this.msa.calcSASA();
            }
        }
        return !this.msa.getCriticalErrorFlag();
    }

    @Override
    public String getErrorMessage() {
        if (this.msa.getCriticalErrorFlag()) {
            return "Inconsistent molecular structure.";
        }
        return "";
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        return type.toString().equalsIgnoreCase("increments") ? 1 : 2;
    }

    @Override
    public int getResultCount(Object type) {
        return type.toString().equalsIgnoreCase("increments") ? this.getAtomCount() : 1;
    }

    public void setSolventRadius(double r) {
        this.msa.setRpobe(r);
    }

    public double getSurfaceArea() {
        return this.saType == 1 ? this.msa.getSASA() : this.msa.getVDWSA();
    }

    public double getVDWSA() {
        return this.msa.getVDWSA();
    }

    public double getASA() {
        return this.msa.getSASA();
    }

    public double getASAPlus() {
        return this.msa.getASAPlus();
    }

    public double getASANegative() {
        return this.msa.getASANegative();
    }

    public double getASAHydrophobic() {
        return this.msa.getASAHydrophobic();
    }

    public double getASAPolar() {
        return this.msa.getASAPolar();
    }

    public double getAtomicSurfaceAreaIncrement(int index) {
        return this.msa.getAtomicSA(this.getAtomIndex(index));
    }

    public Molecule get3DMolecule() {
        return this.msa.getMolecule();
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("increments")) {
            return new Double(this.getAtomicSurfaceAreaIncrement(index));
        }
        if (typestr.equalsIgnoreCase("ASA")) {
            return new Double(this.getASA());
        }
        if (typestr.equalsIgnoreCase("ASA+")) {
            return new Double(this.getASAPlus());
        }
        if (typestr.equalsIgnoreCase("ASA-")) {
            return new Double(this.getASANegative());
        }
        if (typestr.equalsIgnoreCase("ASA_H")) {
            return new Double(this.getASAHydrophobic());
        }
        if (typestr.equalsIgnoreCase("ASA_P")) {
            return new Double(this.getASAPolar());
        }
        return new Double(this.getSurfaceArea());
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (!(result instanceof Double)) {
            throw new PluginException("Result is not a Double object: " + result);
        }
        double x = (Double)result;
        return this.format(x);
    }

    @Override
    protected Molecule getDisplayMolecule() {
        Molecule mol = this.msa.getMolecule().cloneMoleculeWithDocument();
        mol.clearProperties();
        return mol;
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("vanderwaals")) {
            return "Van der Waals surface area (3D)";
        }
        if (typestr.equalsIgnoreCase("solvent")) {
            return "Solvent accessible surface area (3D)";
        }
        if (typestr.equalsIgnoreCase("ASA")) {
            return "ASA";
        }
        if (typestr.equalsIgnoreCase("ASA+")) {
            return "ASA+";
        }
        if (typestr.equalsIgnoreCase("ASA-")) {
            return "ASA-";
        }
        if (typestr.equalsIgnoreCase("ASA_H")) {
            return "ASA_H";
        }
        if (typestr.equalsIgnoreCase("ASA_P")) {
            return "ASA_P";
        }
        return typestr;
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        String[] prop = null;
        switch (this.saType) {
            case 0: {
                prop = new String[]{"vanderwaals"};
                break;
            }
            case 1: {
                prop = new String[]{"ASA", "ASA+", "ASA-", "ASA_H", "ASA_P"};
            }
        }
        for (int i = 0; i < prop.length; ++i) {
            mol.setProperty(prop[i], this.format((Double)this.getResult((Object)prop[i], 0)));
        }
        if (this.increments) {
            int count = mol.getAtomCount();
            for (int i = 0; i < count; ++i) {
                String label = this.format(this.msa.getAtomicSA(i));
                mol.getAtom(i).setExtraLabel(label);
            }
        }
        return mol;
    }

    @Override
    public boolean isMultiThreadedRunEnabled() {
        return false;
    }
}

