/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.pka.PKaLargeModel;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;

public class MajorMicrospeciesPlugin
extends CalculatorPlugin {
    private static String ACCESS_ERROR_MSG = "Call run() before getting results.";
    private static String PHSET_ERROR_MSG = "Microspecies are calculated only if pH is not set.";
    private static String PHUNSET_ERROR_MSG = "Major microspecies are calculated only if pH is set.";
    private static String PHNOTSET_ERROR_MSG = "Microspecies distribution is calculated only if pH is set.";
    private static String NOMSDISTR_ERROR_MSG = "Microspecies distribution calculation is not available in ";
    private static String[] TYPE_RANGE = new String[]{"major-ms", "ms", "ms-count", "ms-distr"};
    private Object[] types = new Object[]{"major-ms"};
    private Molecule mol = null;
    private Molecule majorms = null;
    private boolean valid = false;
    private String format = "smiles";
    private boolean msdistr = true;
    private double pH = Double.NaN;
    private Ionizer ionizer = new Ionizer();
    private PKaLargeModel proteinIonization = null;
    private boolean takeMajorTautomericForm = false;

    @Override
    public String getProductName() {
        return "Protonation Plugin Group";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        boolean microspecies;
        this.pH = Double.NaN;
        boolean bl = microspecies = !"false".equalsIgnoreCase(params.getProperty("microspecies"));
        if (microspecies) {
            String pHstr = params.getProperty("pH");
            if (pHstr == null || pHstr.length() == 0) {
                pHstr = params.getProperty("ph");
            }
            if (pHstr != null && pHstr.length() > 0) {
                this.pH = Double.valueOf(pHstr);
            }
        }
        this.msdistr = "true".equalsIgnoreCase(params.getProperty("msdistr"));
        String chtype = params.getProperty("type");
        if ("major-ms".equalsIgnoreCase(chtype) || "ms-count".equalsIgnoreCase(chtype)) {
            this.types[0] = chtype.toLowerCase();
        } else if ("ms".equalsIgnoreCase(chtype) || "ms-distr".equalsIgnoreCase(chtype)) {
            this.types[0] = chtype.toLowerCase();
            this.msdistr = true;
        }
        this.format = params.getProperty("format");
        if (this.format == null) {
            this.format = "smiles";
        }
        this.setTakeMajorTatomericForm("true".equalsIgnoreCase(params.getProperty("majortautomer")));
    }

    public void setpH(double pH) {
        this.pH = pH;
    }

    @Override
    public double getpH() {
        return this.pH;
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.mol = mol;
        this.ionizer.setMolecule(mol);
    }

    public void setTakeMajorTatomericForm(boolean takeMajorTautomericForm) {
        this.takeMajorTautomericForm = takeMajorTautomericForm;
    }

    @Override
    protected final Molecule createModifiedInputMolecule(Molecule mol) throws PluginException {
        if (this.takeMajorTautomericForm) {
            TautomerizationPlugin tplugin = new TautomerizationPlugin();
            tplugin.setLicenseEnvironment("LicenseEnvironmentForPartitioningPluginGroup");
            tplugin.setMolecule(mol);
            tplugin.setDominantTautomerDistributionCalculation(true);
            tplugin.run();
            Molecule majorTautomericForm = tplugin.getStructure(0);
            this.standardize(majorTautomericForm);
            return majorTautomericForm;
        }
        return mol;
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        this.majorms = null;
        this.valid = true;
        double pH = this.getpH();
        if (this.msdistr || Double.isNaN(pH)) {
            this.mol.implicitizeHydrogens(2047);
            this.ionizer.setMolecule(this.mol);
            this.ionizer.calcMicroSpecies();
            if (this.msdistr && !Double.isNaN(pH)) {
                this.ionizer.calcMsDistribution(pH);
            }
        } else {
            this.majorms = this.getMajorMicrospecies(pH, this.mol);
        }
        return !this.ionizer.getCriticalErrorFlag();
    }

    public Molecule getMajorMicrospecies() throws PluginException {
        if (Double.isNaN(this.getpH())) {
            throw new PluginException(PHUNSET_ERROR_MSG);
        }
        if (this.valid) {
            Molecule mainmol;
            Molecule molecule = mainmol = this.majorms != null ? this.majorms : this.getMajorMicrospecies(this.getpH(), this.mol);
            if (!this.isInputMoleculeAromatized()) {
                mainmol.dearomatize();
            }
            return mainmol;
        }
        throw new PluginException(ACCESS_ERROR_MSG);
    }

    private Molecule getMajorMicrospecies(double pH, Molecule mol) {
        if (!Double.isNaN(pH)) {
            mol = this.ionizer.getMajorMicroSpecies(pH, mol);
            if (this.ionizer.getIonOverflowStatus()) {
                if (this.proteinIonization == null) {
                    this.proteinIonization = new PKaLargeModel();
                }
                mol = this.proteinIonization.getMajorMicroSpecies(pH, mol);
            }
        }
        return mol;
    }

    public int getMicrospeciesCount() throws PluginException {
        if (this.valid) {
            return this.ionizer.getMicroSpeciesCount();
        }
        throw new PluginException(ACCESS_ERROR_MSG);
    }

    public Molecule getMicrospecies(int index) throws PluginException {
        if (this.valid) {
            if (!Double.isNaN(this.getpH())) {
                throw new PluginException(PHSET_ERROR_MSG);
            }
            Molecule ms = this.ionizer.getMicroSpecies(index);
            if (!this.isInputMoleculeAromatized()) {
                ms.dearomatize();
            }
            return ms;
        }
        throw new PluginException(ACCESS_ERROR_MSG);
    }

    public Molecule getSortedMicrospecies(int index) throws PluginException {
        if (this.valid) {
            if (!this.msdistr) {
                throw new PluginException(NOMSDISTR_ERROR_MSG + this.getClass().getName());
            }
            if (Double.isNaN(this.getpH())) {
                throw new PluginException(PHNOTSET_ERROR_MSG);
            }
            Molecule ms = this.ionizer.getSortedMicroSpecies(index);
            if (!this.isInputMoleculeAromatized()) {
                ms.dearomatize();
            }
            return ms;
        }
        throw new PluginException(ACCESS_ERROR_MSG);
    }

    public double getSortedMsDistribution(int index) throws PluginException {
        if (this.valid) {
            if (!this.msdistr) {
                throw new PluginException(NOMSDISTR_ERROR_MSG + this.getClass().getName());
            }
            if (Double.isNaN(this.getpH())) {
                throw new PluginException(PHNOTSET_ERROR_MSG);
            }
            return this.ionizer.getSortedMsDistribution(index);
        }
        throw new PluginException(ACCESS_ERROR_MSG);
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        return 2;
    }

    @Override
    public int getResultCount(Object type) {
        return 1;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("major-ms")) {
            return this.getMajorMicrospecies();
        }
        if (typestr.equals("ms")) {
            return this.getSortedMicrospecies(index);
        }
        if (typestr.equals("ms-count")) {
            return new Integer(this.getMicrospeciesCount());
        }
        if (typestr.equals("ms-distr")) {
            return new Double(this.getSortedMsDistribution(index));
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Molecule) {
            Molecule mol = (Molecule)result;
            if (MFileFormatUtil.isOutputCleanable(this.format) && mol.getDim() == 0) {
                mol = mol.cloneMoleculeWithDocument();
                mol.clean(2, null);
            }
            return mol.toFormat(this.format);
        }
        if (result instanceof Integer) {
            return String.valueOf((Integer)result);
        }
        if (result instanceof Double) {
            double x = (Double)result;
            return this.format(x);
        }
        throw new PluginException("Cannot convert result to String: " + result);
    }

    @Override
    protected Molecule getDisplayMolecule() throws PluginException {
        return this.getMajorMicrospecies();
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        if (this.valid) {
            Molecule mol = this.getDisplayMolecule();
            mol.ungroupSgroups();
            return mol;
        }
        throw new PluginException(ACCESS_ERROR_MSG);
    }

    @Override
    public String getErrorMessage() {
        return this.ionizer.getCriticalErrorFlag() ? "Inconsistent molecular structure." : "";
    }

    public String getIonizerErrorMessage() {
        String msg = "";
        if (this.ionizer.getIonOverflowStatus()) {
            msg = msg + "The number of ionizable atoms (" + this.ionizer.getMaxIonsCounter() + ") exceeds the specified limit (" + this.ionizer.getMaxIons() + ").";
        }
        if (this.ionizer.getCriticalErrorFlag()) {
            if (msg.length() > 0) {
                msg = msg + "\n";
            }
            msg = msg + "Inconsistent molecular structure.";
        }
        return msg;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (MajorMicrospeciesPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
        if (!Double.isNaN(this.pH)) {
            mol.implicitizeHydrogens(2047);
        }
        MajorMicrospeciesPlugin.standardizeIonicGroups(mol);
        mol.dearomatize();
        mol.aromatize(1);
    }
}

