/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.calculations.MajorMicrospeciesPlugin;
import chemaxon.marvin.plugin.CalculatorPluginOutput;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;

public class MajorMicrospeciesPluginOutput
extends CalculatorPluginOutput {
    private String format = null;
    private boolean msdistr = false;
    private String tag = null;

    @Override
    public void setParameters(Properties params) throws PluginException {
        super.setParameters(params);
        this.format = params.getProperty("format");
        this.msdistr = "true".equalsIgnoreCase(params.getProperty("msdistr"));
        String pHstr = params.getProperty("pH");
        if (pHstr == null || pHstr.length() == 0) {
            pHstr = params.getProperty("ph");
        }
        if (this.msdistr && pHstr == null) {
            throw new PluginException("No pH is set for microspecies distribution.");
        }
        this.tag = params.getProperty("tag");
        if (this.msdistr && this.tag == null) {
            this.tag = "DISTR[pH=" + pHstr + "]";
        }
    }

    @Override
    public boolean isMolecular() {
        return this.format != null;
    }

    @Override
    public String getResult(Molecule target) throws PluginException {
        if (this.format != null) {
            return "";
        }
        MajorMicrospeciesPlugin msplugin = (MajorMicrospeciesPlugin)this.getPlugin();
        if (msplugin.isOK()) {
            if (this.msdistr || Double.isNaN(msplugin.getpH())) {
                int count = msplugin.getMicrospeciesCount();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < count; ++i) {
                    Molecule ms = msplugin.getMicrospecies(i);
                    if (i > 0) {
                        sb.append(".");
                    }
                    sb.append(ms.toFormat("smiles"));
                }
                return new String(sb);
            }
            Molecule ms = msplugin.getMajorMicrospecies();
            return msplugin.getResultAsString("major-ms", 0, ms);
        }
        return "";
    }

    @Override
    public Molecule[] getResultMolecules(Molecule target) throws PluginException {
        if (this.format == null) {
            return null;
        }
        MajorMicrospeciesPlugin msplugin = (MajorMicrospeciesPlugin)this.getPlugin();
        if (this.msdistr || Double.isNaN(msplugin.getpH())) {
            int count = msplugin.getMicrospeciesCount();
            Molecule[] mols = new Molecule[count];
            if (this.msdistr) {
                for (int i = 0; i < count; ++i) {
                    mols[i] = msplugin.getSortedMicrospecies(i);
                    double distr = msplugin.getSortedMsDistribution(i);
                    mols[i].setProperty(this.tag, msplugin.format(distr));
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    mols[i] = msplugin.getMicrospecies(i);
                }
            }
            return mols;
        }
        return new Molecule[]{msplugin.getMajorMicrospecies()};
    }
}

