/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.calculations.MarkushEnumerationPlugin;
import chemaxon.marvin.calculations.MultipleMoleculeOutput;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.Properties;

public class MarkushEnumerationPluginOutput
extends MultipleMoleculeOutput {
    private boolean magnitude = false;
    private int cleanDim = 0;
    private String cleanOpts = "t2000";

    @Override
    public void setParameters(Properties params) throws PluginException {
        int len;
        super.setParameters(params);
        this.magnitude = "true".equalsIgnoreCase(params.getProperty("magnitude"));
        String cleanStr = params.getProperty("clean");
        this.cleanDim = 0;
        this.cleanOpts = "t2000";
        if (cleanStr != null && (len = cleanStr.length()) > 0) {
            this.cleanDim = Integer.parseInt(cleanStr.substring(0, 1));
            if (len > 2) {
                this.cleanOpts = cleanStr.substring(2);
            } else if (len == 2) {
                this.cleanOpts = null;
            }
        }
    }

    @Override
    protected void exportMolecule(Molecule mol) throws PluginException {
        if (this.cleanDim != 0) {
            mol.clean(this.cleanDim, this.cleanOpts);
        }
        try {
            this.exporter.write(mol);
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    @Override
    protected String getCountString() throws PluginException {
        String countString = ((MarkushEnumerationPlugin)this.plugin).countEnumerations().toString();
        int m = countString.length();
        return countString + (this.magnitude && m > 5 ? " (~ 10^" + m + ")" : "");
    }

    @Override
    public String getResult(Molecule target) throws PluginException {
        int type = "count".equalsIgnoreCase((String)this.plugin.getResultTypes()[0]) ? TYPE_COUNT : TYPE_STRUCTURES;
        return this.getResult(target, type);
    }
}

