/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.plugin.CalculatorPluginDisplay;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.Molecule;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.InputMap;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MultipleDataDisplay
extends CalculatorPluginDisplay {
    private int cellSize1 = 150;
    private int cellSize2 = 150;

    @Override
    public void store() throws PluginException {
        Molecule[] mols = this.getPlugin().getResultMolecules();
        if (mols != null) {
            if (this.resultMolList == null) {
                this.resultMolList = new ArrayList();
            }
            this.resultMolList.add(mols);
        }
    }

    protected void setCellSize(int cellSize1, int cellSize2) {
        this.cellSize1 = cellSize1;
        this.cellSize2 = cellSize2;
    }

    @Override
    public Component getResultComponent() throws PluginException {
        if (this.resultMolList == null || this.resultMolList.isEmpty()) {
            return null;
        }
        Molecule[] m = (Molecule[])this.resultMolList.get(0);
        int t = m.length;
        int s = this.resultMolList.size();
        int rows = 1;
        int cols1 = 1;
        int cols2 = t - 1;
        Molecule[] mols1 = new Molecule[s];
        Molecule[] mols2 = new Molecule[(t - 1) * s];
        int k = 0;
        for (int i = 0; i < s; ++i) {
            m = (Molecule[])this.resultMolList.get(i);
            if (m.length != t) {
                throw new PluginException("Unexpected number of result molecules: " + m.length);
            }
            mols1[i] = m[0];
            for (int j = 1; j < t; ++j) {
                mols2[k++] = m[j];
            }
        }
        ViewPanel panel1 = this.createViewPanel(mols1, rows, cols1, this.cellSize1, 2);
        if (t == 1) {
            return panel1;
        }
        ViewPanel panel2 = this.createViewPanel(mols2, rows, cols2, this.cellSize2, 1);
        JSplitPane splitPane = new JSplitPane(1, true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setRightComponent(panel2);
        splitPane.setLeftComponent(panel1);
        InputMap map = SwingUtilities.getUIInputMap(splitPane, 1);
        map.remove(KeyStroke.getKeyStroke(119, 0));
        map.remove(KeyStroke.getKeyStroke(117, 0));
        return splitPane;
    }
}

