/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.formats.MolExporter;
import chemaxon.marvin.io.MDocSource;
import chemaxon.marvin.plugin.CalculatorPluginOutput;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginMDocSource;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class MultipleMoleculeOutput
extends CalculatorPluginOutput {
    public static int TYPE_COUNT = 0;
    public static int TYPE_STRUCTURES = 1;
    protected MolExporter exporter = null;
    private String format = null;

    @Override
    public void setParameters(Properties params) throws PluginException {
        super.setParameters(params);
        this.format = params.getProperty("format");
    }

    @Override
    public boolean isMolecular() {
        return this.format != null;
    }

    @Override
    public void setOutputStream(OutputStream os) throws IOException {
        if (this.format != null) {
            this.exporter = new MolExporter(os, this.format);
        }
    }

    @Override
    public void close(int opts) throws IOException {
        if (this.exporter != null) {
            this.exporter.close(opts);
        }
    }

    protected void exportMolecule(Molecule mol) throws PluginException {
        if (this.exporter.isCleanable() && mol.getDim() == 0) {
            mol.clean(2, null);
        }
        try {
            this.exporter.write(mol);
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    protected void exportMolecules(MDocSource docSource) throws PluginException {
        try {
            MDocument doc = null;
            while ((doc = docSource.nextDoc()) != null) {
                this.exportMolecule((Molecule)doc.getMainMoleculeGraph());
            }
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    protected String exportConcatenatedSMILES(MDocSource docSource) throws PluginException {
        try {
            StringBuffer sb = new StringBuffer();
            MDocument doc = null;
            while ((doc = docSource.nextDoc()) != null) {
                Molecule structure = (Molecule)doc.getMainMoleculeGraph();
                if (sb.length() > 0) {
                    sb.append(".");
                }
                sb.append(structure.isQuery() ? structure.toFormat("smarts") : structure.toFormat("smiles"));
            }
            return new String(sb);
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    protected String getCountString() throws PluginException {
        return String.valueOf(this.plugin.getResultSource().getRecordCountMax());
    }

    public String getResult(Molecule target, int type) throws PluginException {
        if (this.isOK()) {
            if (type == TYPE_COUNT) {
                return "" + this.getCountString();
            }
            PluginMDocSource docSource = this.plugin.getResultSource();
            if (this.exporter != null) {
                this.exportMolecules(docSource);
                return "";
            }
            return this.exportConcatenatedSMILES(docSource);
        }
        return "";
    }
}

