/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.Refractivity;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.Properties;
import java.util.StringTokenizer;

public class RefractivityPlugin
extends CalculatorPlugin {
    private static String[] TYPE_RANGE = new String[]{"refractivity", "increments", "inch"};
    private Object[] types = new Object[]{"refractivity"};
    private Refractivity refractivity = new Refractivity();
    private boolean inch = false;

    @Override
    public String getProductName() {
        return "Refractivity Plugin";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String chtypes = params.getProperty("type");
        if (chtypes == null) {
            chtypes = "refractivity";
        }
        chtypes = chtypes.toLowerCase();
        StringTokenizer st = new StringTokenizer(chtypes, ",");
        this.types = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().toLowerCase();
            this.checkType(token, TYPE_RANGE);
            this.types[i++] = token;
        }
        this.inch = "true".equalsIgnoreCase(params.getProperty("inch")) || "true".equalsIgnoreCase(params.getProperty("implh"));
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (mol.isReaction()) {
            throw new PluginException("Calculation is not defined for reactions.");
        }
        if (RefractivityPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.refractivity.setMolecule(mol);
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        this.refractivity.calcAtomicRefrac();
        return !this.refractivity.getCriticalErrorFlag();
    }

    @Override
    public String getErrorMessage() {
        if (this.refractivity.getCriticalErrorFlag()) {
            return "Inconsistent molecular structure.";
        }
        return "";
    }

    public double getRefractivity() {
        return this.refractivity.getRefractivity();
    }

    public double getRefractivityIncrement(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.refractivity.getAtomRefracIncrement(index)[1];
    }

    public double getRefractivityHIncrement(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.refractivity.getAtomRefracIncrement(index)[2];
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("refractivity")) {
            return "Refractivity";
        }
        return typestr;
    }

    @Override
    public int getResultDomain(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("refractivity")) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getResultCount(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("refractivity")) {
            return 1;
        }
        return this.getAtomCount();
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equals("refractivity")) {
            return new Double(this.getRefractivity());
        }
        if (typestr.equals("increments")) {
            return new Double(this.getRefractivityIncrement(index));
        }
        if (typestr.equals("inch") || typestr.equals("implh")) {
            return new Double(this.getRefractivityHIncrement(index));
        }
        throw new PluginException("Unknown type: " + typestr);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        String typestr = type.toString().toLowerCase();
        if (typestr.equalsIgnoreCase("increments")) {
            if ((index = this.getAtomIndex(index)) == -1) {
                return "";
            }
            double[] x = this.refractivity.getAtomRefracIncrement(index);
            if (!this.inch || x[2] == 0.0 || Double.isNaN(x[2])) {
                return this.format(x[1]);
            }
            return this.format(x[1]) + " (" + this.format(x[2]) + ")";
        }
        if (!(result instanceof Double)) {
            throw new PluginException("Result is not a Double object: " + result);
        }
        double x = (Double)result;
        if ((x == 0.0 || Double.isNaN(x)) && (typestr.equalsIgnoreCase("inch") || typestr.equals("implh"))) {
            return "";
        }
        return this.format(x);
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        for (int t = 0; t < this.types.length; ++t) {
            Object type = this.types[t];
            if (this.getResultDomain(type) == 1) {
                for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
                    Object result = this.getResult(type, i);
                    String label = this.getResultAsString(type, i, result);
                    mol.getAtom(i).setExtraLabel(label);
                }
                continue;
            }
            Object result = this.getResult(type, 0);
            mol.setProperty(type.toString(), this.getResultAsString(type, 0, result));
        }
        return mol;
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
        mol.implicitizeHydrogens(2047);
        super.standardize(mol);
    }
}

