/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.CanonicResonant;
import chemaxon.calculations.Tautomerization;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginMDocSource;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class ResonancePlugin
extends CalculatorPlugin {
    private Tautomerization tautomerization = null;
    private Molecule canonicResonant = null;
    private boolean canonicResonantCalculation = false;
    private boolean modifyInputStructure = false;
    private Molecule inputMol = null;
    private static final String WARNING = "No multiple structures.";
    private static String[] TYPE_RANGE = new String[]{"structure", "structures", "count"};
    private Object[] types = new Object[]{"structure"};
    private boolean single = false;
    private boolean criticalError = false;
    private boolean cleanResultStructures;

    public ResonancePlugin() {
        this.tautomerization = new Tautomerization();
        this.tautomerization.setResonantCalc(true);
    }

    @Override
    public String getProductName() {
        return "Free Plugin";
    }

    @Override
    public boolean handlesMultiFragmentMolecules() {
        return !this.single;
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
        this.tautomerization.setProgressMonitor(pmon);
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        this.single = "true".equalsIgnoreCase(params.getProperty("single"));
        String chtypes = params.getProperty("type");
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.types = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.checkType(token, TYPE_RANGE);
                this.types[i++] = token;
            }
        }
        boolean symfilter = !"false".equalsIgnoreCase(params.getProperty("symfilter", "true"));
        this.setSymmetryFiltering(symfilter);
        int max = Integer.parseInt(params.getProperty("max", "1000"));
        this.setMaxStructureCount(max);
        boolean canonical = "true".equalsIgnoreCase(params.getProperty("canonical"));
        this.setTakeCanonicalForm(canonical);
        boolean mcontrib = !"false".equalsIgnoreCase(params.getProperty("mcontrib"));
        this.setTakeMajorContributors(mcontrib);
    }

    public void setCleanResultStructures(boolean clean) {
        this.cleanResultStructures = clean;
    }

    public void setSymmetryFiltering(boolean filtering) {
        this.tautomerization.setSymmetryFiltering(filtering);
    }

    public void setMaxStructureCount(int max) {
        this.tautomerization.setMaxSpeciesCount(max);
    }

    public void setpH(double pH) {
    }

    public void setInputMoleculeModified(boolean inputMoleculeModified) {
        this.modifyInputStructure = inputMoleculeModified;
    }

    private boolean isInputMoleculeModified() {
        return this.modifyInputStructure;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (ResonancePlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected Molecule createStandardizedMolecule(Molecule mol, boolean om) throws PluginException {
        return this.createStandardizedMolecule(mol);
    }

    @Override
    protected Molecule createStandardizedMolecule(Molecule mol) throws PluginException {
        boolean modify = this.isInputMoleculeModified();
        if (!modify) {
            mol = mol.cloneMoleculeWithDocument();
        }
        if (!this.handlesMultiFragmentMolecules() && mol.getFragCount() > 1) {
            MoleculeGraph[] frags = mol.findFrags(mol.getClass());
            MoleculeGraph frag = frags[0];
            int m = frag.getAtomCount();
            for (int i = 1; i < frags.length; ++i) {
                if (frags[i].getAtomCount() <= m) continue;
                frag = frags[i];
                m = frag.getAtomCount();
            }
            if (modify) {
                mol.clear();
                mol.fuse(frag);
            } else {
                mol = (Molecule)frag;
            }
        }
        this.standardize(mol);
        return mol;
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.inputMol = mol;
        this.tautomerization.setMolecule(mol);
        this.tautomerization.setRowInputMolecule(this.inputMol);
    }

    public void setTakeCanonicalForm(boolean canonical) {
        this.canonicResonantCalculation = canonical;
    }

    public void setTakeMajorContributors(boolean mcontrib) {
        this.tautomerization.setMajorResonantCalc(mcontrib);
    }

    @Override
    public boolean run() throws PluginException {
        if (this.canonicResonantCalculation) {
            this.canonicResonant = this.calcCanonicResonant(this.inputMol, this.isInputMoleculeModified());
        } else {
            this.tautomerization.createDACouples();
            this.criticalError = this.tautomerization.getCriticalErrorFlag();
        }
        return !this.criticalError;
    }

    private Molecule calcCanonicResonant(Molecule mol, boolean modifyInputStructure) {
        CanonicResonant cr = new CanonicResonant();
        cr.setMolecule(mol);
        cr.setParentOfCanonicalStructureConserved(modifyInputStructure);
        cr.calcCanonicalResonant();
        return cr.getCanonicResonant();
    }

    @Override
    public PluginMDocSource getResultSource() throws PluginException {
        return new PluginMDocSource(new ResultIterator(), this.getStructureCount());
    }

    public int getStructureCount() {
        return this.canonicResonantCalculation ? 1 : this.tautomerization.getTCount();
    }

    public Molecule getStructure(int index) {
        Molecule struc = null;
        struc = this.criticalError ? this.inputMol : (this.canonicResonantCalculation ? this.canonicResonant : this.tautomerization.getTMolecule(index));
        if (this.cleanResultStructures) {
            if (struc.getDim() == 0) {
                struc.clean(2, null);
            } else if (this.tautomerization.getFixedAtomIndexesForPartialClean() != null) {
                struc.partialClean(2, this.tautomerization.getFixedAtomIndexesForPartialClean(), null);
            }
        }
        return struc;
    }

    public Molecule[] getStructures() {
        Molecule[] mols = new Molecule[this.getStructureCount()];
        for (int i = 0; i < mols.length; ++i) {
            mols[i] = this.getStructure(i);
        }
        return mols;
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        return 4;
    }

    @Override
    public int getResultCount(Object type) {
        String typestr = type.toString();
        return typestr.equalsIgnoreCase("structure") ? this.getStructureCount() : 1;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("structure")) {
            return this.getStructure(index);
        }
        if (typestr.equalsIgnoreCase("structures")) {
            return this.getStructures();
        }
        if (typestr.equalsIgnoreCase("count")) {
            return new Integer(this.getStructureCount());
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (result instanceof Molecule) {
            return ((Molecule)result).toFormat("smiles");
        }
        if (result instanceof Molecule[]) {
            Molecule[] mols = (Molecule[])result;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < mols.length; ++i) {
                buffer.append(mols[i].toFormat("smiles"));
            }
            return new String(buffer);
        }
        if (result instanceof Integer) {
            return result.toString();
        }
        throw new PluginException("Result should be a molecule or integer object\ninstead of: " + result);
    }

    @Override
    public String getRemark() {
        return this.getStructureCount() == 0 ? WARNING : null;
    }

    @Override
    public String getErrorMessage() {
        return this.criticalError ? "Inconsistent molecular structure." : "";
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
        mol.aromatize(2);
        ResonancePlugin.standardizeIonicGroups(mol);
    }

    @Override
    public boolean isMultiThreadedRunEnabled() {
        return false;
    }

    private class ResultIterator
    implements Iterator {
        private int currentCount = 0;

        private ResultIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentCount < ResonancePlugin.this.getStructureCount();
        }

        public Object next() {
            return this.hasNext() ? CalculatorPlugin.getDocument(ResonancePlugin.this.getStructure(this.currentCount++)) : null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Element removal is not supported.");
        }
    }
}

