/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.training.TrainerUtils;
import chemaxon.calculations.training.logp.LogDPredictor;
import chemaxon.marvin.calculations.logPPlugin;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.Properties;

public class logDPlugin
extends CalculatorPlugin {
    private static final String TITLE = "logD";
    private static final String NO_USER_DATASET_ERROR_MSG = "No dataset found for user defined method.";
    public static final int METHOD_VG = 1;
    public static final int METHOD_KLOP = 2;
    public static final int METHOD_PHYS = 3;
    public static final int METHOD_USER_DEFINED = 4;
    public static final int METHOD_WEIGHTED = 5;
    private static final double DEF_ANION = 0.1;
    private static final double DEF_KATION = 0.1;
    private static final double DEF_LOWER = 0.0;
    private static final double DEF_UPPER = 14.0;
    private static final double DEF_STEP = 0.5;
    private static final int REF_COUNT = 4;
    private static final double[] DEF_REFS = new double[]{1.5, 5.0, 6.5, 7.4};
    private LogDPredictor logDPredictor = null;
    private Molecule mol = null;
    private double[] logDs = null;
    private double[] refpHs = new double[4];
    private double[] reflogDs = new double[4];
    private Object[] types = new Object[]{"logD", "reflogD"};
    private int refcount = 0;
    private int method;
    private double userDefinedMethodWeight = 0.0;

    public logDPlugin() {
        this.logDPredictor = new LogDPredictor();
        for (int i = 0; i < 4; ++i) {
            this.refpHs[i] = DEF_REFS[i];
            this.reflogDs[i] = Double.NaN;
        }
    }

    @Override
    public String getProductName() {
        return "Partitioning Plugin Group";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String pHstr;
        String method = params.getProperty("method", "weighted").toLowerCase();
        if (method.equals("vg")) {
            this.setlogPMethod(1);
        } else if (method.equals("klop")) {
            this.setlogPMethod(2);
        } else if (method.equals("phys")) {
            this.setlogPMethod(3);
        } else if (method.equals("user")) {
            this.setlogPMethod(4);
        } else if (method.equals("weighted")) {
            this.setlogPMethod(5);
        } else {
            throw new PluginException("No such method: " + method);
        }
        if (params.getProperty("method") != null && params.getProperty("method").toLowerCase().equals("weighted") && params.getProperty("wvg") != null && params.getProperty("wklop") != null && params.getProperty("wphys") != null && params.getProperty("wuser") != null) {
            try {
                double wVG = Double.parseDouble(params.getProperty("wvg"));
                double wKLOP = Double.parseDouble(params.getProperty("wklop"));
                double wPHYS = Double.parseDouble(params.getProperty("wphys"));
                double wUSER = Double.parseDouble(params.getProperty("wuser"));
                this.setWeightOfMethods(wVG, wKLOP, wPHYS, wUSER);
            }
            catch (NumberFormatException e) {
                throw new PluginException("Incorrect method weights.");
            }
        }
        if (params.getProperty("weights") != null && params.getProperty("weights").length() > 0) {
            String weightsString = params.getProperty("weights");
            String[] weights = weightsString.split(":");
            if (weights.length != 4) {
                throw new PluginException("Incorrect method weights: " + weightsString);
            }
            try {
                double wVG = Double.parseDouble(weights[0]);
                double wKLOP = Double.parseDouble(weights[1]);
                double wPHYS = Double.parseDouble(weights[2]);
                double wUSER = Double.parseDouble(weights[3]);
                this.setWeightOfMethods(wVG, wKLOP, wPHYS, wUSER);
            }
            catch (NumberFormatException e) {
                throw new PluginException("Incorrect method weights: " + weightsString);
            }
        }
        if (this.method == 4 || this.method == 5 && this.userDefinedMethodWeight != 0.0) {
            this.setLogPTrainingId(params.getProperty("logptrainingid"));
        }
        double anion = 0.1;
        String astr = params.getProperty("anion");
        if (astr != null && astr.length() > 0) {
            anion = Double.valueOf(astr);
        }
        double kation = 0.1;
        String kstr = params.getProperty("kation");
        if (kstr != null && kstr.length() > 0) {
            kation = Double.valueOf(kstr);
        }
        if ((pHstr = params.getProperty("pH")) == null || pHstr.length() == 0) {
            pHstr = params.getProperty("ph");
        }
        if (pHstr != null && pHstr.length() > 0) {
            double pH = Double.valueOf(pHstr);
            this.setpH(pH);
        } else {
            double lower = 0.0;
            String lstr = params.getProperty("lower");
            if (lstr != null && lstr.length() > 0) {
                lower = Double.valueOf(lstr);
            }
            double upper = 14.0;
            String ustr = params.getProperty("upper");
            if (ustr != null && ustr.length() > 0) {
                upper = Double.valueOf(ustr);
            }
            if (upper < lower) {
                double tmp = lower;
                lower = upper;
                upper = tmp;
            }
            double step = 0.5;
            String sstr = params.getProperty("step");
            if (sstr != null && sstr.length() > 0) {
                step = Double.valueOf(sstr);
                if (step < 0.0) {
                    step = -step;
                } else if (step == 0.0 && lower != upper) {
                    throw new PluginException("Step size is zero.");
                }
            }
            this.logDPredictor.setpHLowerLimit(lower);
            this.logDPredictor.setpHUpperLimit(upper);
            this.logDPredictor.setpHStepSize(step);
        }
        for (int i = 0; i < 4; ++i) {
            this.refpHs[i] = DEF_REFS[i];
            String refstr = params.getProperty("ref" + (i + 1));
            if (refstr == null) continue;
            this.refpHs[i] = refstr.length() > 0 ? Double.valueOf(refstr) : Double.NaN;
        }
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
        this.logDPredictor.setCloridIonConcentration(anion);
        this.logDPredictor.setNaKIonConcentration(kation);
        this.setpKaCorrectionLibrary(params.getProperty("pkacorrectionlibrary"));
        this.setConsiderTautomerization("true".equalsIgnoreCase(params.getProperty("considertautomerization")));
    }

    public void setCloridIonConcentration(double c) {
        this.logDPredictor.setCloridIonConcentration(c);
    }

    public void setNaKIonConcentration(double c) {
        this.logDPredictor.setNaKIonConcentration(c);
    }

    public void setpHLower(double lower) {
        this.logDPredictor.setpHLowerLimit(lower);
    }

    public void setpHUpper(double upper) {
        this.logDPredictor.setpHUpperLimit(upper);
    }

    public void setpHStep(double step) {
        this.logDPredictor.setpHStepSize(step);
    }

    public void setpH(double pH) {
        this.logDPredictor.setpHLowerLimit(pH);
        this.logDPredictor.setpHUpperLimit(pH);
        this.logDPredictor.setpHStepSize(1.0);
    }

    public void setConsiderTautomerization(boolean considerTautomerization) {
        this.logDPredictor.setTakeTautomerizaiton(considerTautomerization);
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (mol.isReaction()) {
            throw new PluginException("Calculation result is not defined for reactions.");
        }
        if (logDPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.mol = mol;
        this.logDs = null;
    }

    public void setlogPMethod(int method) {
        this.method = method;
        switch (method) {
            case 1: {
                this.setWeightOfMethods(1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 2: {
                this.setWeightOfMethods(0.0, 1.0, 0.0, 0.0);
                break;
            }
            case 3: {
                this.setWeightOfMethods(0.0, 0.0, 1.0, 0.0);
                break;
            }
            case 4: {
                this.setWeightOfMethods(0.0, 0.0, 0.0, 1.0);
                break;
            }
            case 5: {
                this.setWeightOfMethods(1.0, 1.0, 1.0, 0.0);
                break;
            }
            default: {
                this.setWeightOfMethods(1.0, 1.0, 1.0, 0.0);
            }
        }
    }

    public void setWeightOfMethods(double wVG, double wKLOP, double wPHYS, double wUSER) {
        this.userDefinedMethodWeight = wUSER;
        this.logDPredictor.setWeightOflogPMethods(wVG, wKLOP, wPHYS, wUSER);
    }

    public static String[] getLogPTrainingIds() {
        return logPPlugin.getTrainingIds();
    }

    public void setLogPTrainingId(String trainingId) throws PluginException {
        if (trainingId == null || trainingId.length() == 0) {
            throw new PluginException("Training ID is not set.");
        }
        String trainingIdWithPrefix = trainingId;
        if (!trainingId.startsWith("logp:")) {
            trainingIdWithPrefix = "logp:" + trainingId;
        }
        try {
            this.logDPredictor.setLogPTrainingResults(TrainerUtils.loadParameters(trainingIdWithPrefix));
        }
        catch (IOException e) {
            throw new PluginException("Cannot load parameter file for training '" + trainingId + "'.", e);
        }
    }

    public void setpKaCorrectionLibrary(String correctionLibraryId) {
        this.logDPredictor.setpKaCorrectionLibrary(correctionLibraryId);
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        this.logDs = this.logDPredictor.predict(this.mol);
        this.refcount = 0;
        for (int i = 0; i < 4; ++i) {
            if (Double.isNaN(this.refpHs[i])) continue;
            this.reflogDs[i] = this.logDPredictor.calclogDatFixpH(this.refpHs[i]);
            ++this.refcount;
        }
        return !this.logDPredictor.getCriticalErrorFlag();
    }

    @Override
    public String getErrorMessage() {
        if (this.logDPredictor.getCriticalErrorFlag()) {
            return "Inconsistent molecular structure.";
        }
        return "";
    }

    public double calclogD(double pH) throws PluginException {
        this.checkLicense();
        return this.logDPredictor.calclogDatFixpH(pH);
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    public double[] getRefpHs() {
        double[] r = new double[this.refcount];
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            if (Double.isNaN(this.refpHs[i])) continue;
            r[k++] = this.refpHs[i];
        }
        return r;
    }

    public double[] getReflogDs() {
        double[] r = new double[this.refcount];
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            if (Double.isNaN(this.refpHs[i])) continue;
            r[k++] = this.reflogDs[i];
        }
        return r;
    }

    public double getlogD() {
        return this.logDs[0];
    }

    public double[] getpHs() {
        double[] pHs = this.logDPredictor.getpH();
        double[] r = new double[pHs.length];
        for (int i = 0; i < pHs.length; ++i) {
            r[i] = pHs[i];
        }
        return r;
    }

    public double[] getlogDs() {
        return this.logDs;
    }

    @Override
    public int getResultDomain(Object type) {
        return 2;
    }

    @Override
    public int getResultCount(Object type) {
        return 1;
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase(TITLE)) {
            return new double[][]{this.getpHs(), this.getlogDs()};
        }
        if (typestr.equalsIgnoreCase("reflogD")) {
            return new double[][]{this.getRefpHs(), this.getReflogDs()};
        }
        throw new PluginException("Unknown type: " + type);
    }

    @Override
    public Object getResult(Object type, String arg) throws PluginException {
        double pH = 0.0;
        try {
            pH = Double.parseDouble(arg);
        }
        catch (NumberFormatException e) {
            throw new PluginException("Argument string is not a pH value: " + arg);
        }
        return new Double(this.calclogD(pH));
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (!(result instanceof double[][])) {
            throw new PluginException("Result is not a double[][] object: " + result);
        }
        return this.format((double[][])result, 3);
    }

    protected Molecule getImageMolecule() throws PluginException {
        return this.getDisplayMolecule();
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
        mol.implicitizeHydrogens(2047);
        logDPlugin.standardizeIonicGroups(mol);
        mol.dearomatize();
        mol.aromatize(1);
    }
}

