/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.marvin.Calculator;
import chemaxon.marvin.calculations.logDPlugin;
import chemaxon.marvin.plugin.CalculatorPluginOutput;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;

public class logDPluginOutput
extends CalculatorPluginOutput {
    @Override
    public String getHeader() {
        StringBuffer s = new StringBuffer();
        double step = 0.0;
        double lower = 0.0;
        double upper = 0.0;
        int count = 0;
        String pHstr = this.params.getProperty("pH");
        if (pHstr == null || pHstr.length() == 0) {
            pHstr = this.params.getProperty("ph");
        }
        if (pHstr != null && pHstr.length() > 0) {
            step = 2.0;
            lower = Double.parseDouble(pHstr);
            upper = lower + 1.0;
            count = 0;
            s.append("logD[pH=" + pHstr + "]");
        } else {
            step = Double.parseDouble(this.params.getProperty("step"));
            lower = Double.parseDouble(this.params.getProperty("lower"));
            upper = Double.parseDouble(this.params.getProperty("upper"));
            count = (int)Math.round((upper - lower) / step);
            double pH = lower;
            for (int i = 0; i <= count; ++i) {
                if (i > 0) {
                    s.append(this.separator);
                }
                s.append("pH=" + this.plugin.format(pH));
                pH += step;
            }
        }
        for (int i = 1; i <= 4; ++i) {
            String r = this.params.getProperty("ref" + i);
            if (r == null || r.length() <= 0) continue;
            s.append(this.separator);
            s.append("logD[pH=" + r + "]");
        }
        return new String(s);
    }

    @Override
    public String getResult(Molecule target) throws PluginException {
        int i;
        StringBuffer s = new StringBuffer();
        double[] result = ((logDPlugin)this.plugin).getlogDs();
        for (i = 0; i < result.length; ++i) {
            if (i > 0) {
                s.append(this.separator);
            }
            s.append(this.plugin.format(result[i]));
        }
        result = ((logDPlugin)this.plugin).getReflogDs();
        for (i = 0; i < result.length; ++i) {
            if (s.length() > 0) {
                s.append(this.separator);
            }
            s.append(this.plugin.format(result[i]));
        }
        return new String(s);
    }

    @Override
    public double getSpecResult(Molecule target, String arg) throws PluginException {
        Calculator.runPlugin(this.plugin, target);
        Object result = this.plugin.getResult(arg);
        return (Double)result;
    }
}

