/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.training.TrainerUtils;
import chemaxon.calculations.training.logp.LogPPredictor;
import chemaxon.calculations.training.logp.LogPPredictorImpl;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class logPPlugin
extends CalculatorPlugin {
    public static final int METHOD_VG = 1;
    public static final int METHOD_KLOP = 2;
    public static final int METHOD_PHYS = 3;
    public static final int METHOD_USER_DEFINED = 4;
    public static final int METHOD_WEIGHTED = 5;
    private static final double DEF_ANION = 0.1;
    private static final double DEF_KATION = 0.1;
    private static final double STRUCTURAL_INCREMENT_DISPLAY_LIMIT = 0.001;
    static final String LOGP_TRAINING_ID_PREFIX = "logp:";
    private static String[] TYPE_RANGE = new String[]{"logP", "logPTrue", "logPMicro", "logPNonionic", "logDpI", "increments", "inch", "structuralincrement"};
    private Object[] types = new Object[]{"logPTrue"};
    private Object[] utypes = new Object[]{"logPTrue"};
    private LogPPredictorImpl logPPredictor = null;
    private Molecule mol = null;
    private boolean inch = false;
    private double[] logPMicro = new double[]{Double.NaN, Double.NaN};
    private double[] logPNonionic = new double[]{Double.NaN, Double.NaN};
    private double[] logDpI = new double[]{Double.NaN, Double.NaN};
    private double[] logPTrue = new double[]{Double.NaN, Double.NaN};
    private double[] logPSingle = new double[]{Double.NaN, Double.NaN};
    private int method;
    private double userDefinedMethodWeight = 0.0;
    private boolean considerTautomerization = false;
    private double[] atomicIncrements;
    private boolean needError = false;

    public logPPlugin() {
        this.logPPredictor = new LogPPredictorImpl();
    }

    @Override
    public String getProductName() {
        return "Partitioning Plugin Group";
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String method = params.getProperty("method", "weighted").toLowerCase();
        if (method.equals("vg")) {
            this.setlogPMethod(1);
        } else if (method.equals("klop")) {
            this.setlogPMethod(2);
        } else if (method.equals("phys")) {
            this.setlogPMethod(3);
        } else if (method.equals("user")) {
            this.setlogPMethod(4);
        } else if (method.equals("weighted")) {
            this.setlogPMethod(5);
        } else {
            throw new PluginException("No such method: " + method);
        }
        if (params.getProperty("error") != null) {
            this.needError = params.getProperty("error").equalsIgnoreCase("true");
        }
        if (params.getProperty("method") != null && params.getProperty("method").toLowerCase().equals("weighted") && params.getProperty("wvg") != null && params.getProperty("wklop") != null && params.getProperty("wphys") != null && params.getProperty("wuser") != null) {
            try {
                double wVG = Double.parseDouble(params.getProperty("wvg"));
                double wKLOP = Double.parseDouble(params.getProperty("wklop"));
                double wPHYS = Double.parseDouble(params.getProperty("wphys"));
                double wUSER = Double.parseDouble(params.getProperty("wuser"));
                this.setWeightOfMethods(wVG, wKLOP, wPHYS, wUSER);
            }
            catch (NumberFormatException e) {
                throw new PluginException("Incorrect method weights.");
            }
        }
        if (params.getProperty("weights") != null && params.getProperty("weights").length() > 0) {
            String weightsString = params.getProperty("weights");
            String[] weights = weightsString.split(":");
            if (weights.length != 4) {
                throw new PluginException("Incorrect method weights: " + weightsString);
            }
            try {
                double wVG = Double.parseDouble(weights[0]);
                double wKLOP = Double.parseDouble(weights[1]);
                double wPHYS = Double.parseDouble(weights[2]);
                double wUSER = Double.parseDouble(weights[3]);
                this.setWeightOfMethods(wVG, wKLOP, wPHYS, wUSER);
            }
            catch (NumberFormatException e) {
                throw new PluginException("Incorrect method weights: " + weightsString);
            }
        }
        if (this.method == 4 || this.method == 5 && this.userDefinedMethodWeight != 0.0) {
            this.setTraining(params.getProperty("trainingid"));
        }
        double anion = 0.1;
        String astr = params.getProperty("anion");
        if (astr != null && astr.length() > 0) {
            anion = Double.valueOf(astr);
        }
        double kation = 0.1;
        String kstr = params.getProperty("kation");
        if (kstr != null && kstr.length() > 0) {
            kation = Double.valueOf(kstr);
        }
        String chtypes = params.getProperty("type");
        this.setUserTypes(chtypes);
        this.inch = "true".equalsIgnoreCase(params.getProperty("inch")) || "true".equalsIgnoreCase(params.getProperty("implh"));
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
        this.setCloridIonConcentration(anion);
        this.setNaKIonConcentration(kation);
        this.setConsiderTautomerization("true".equalsIgnoreCase(params.getProperty("considertautomerization")) || "true".equalsIgnoreCase(params.getProperty("majortautomer")));
        String pHString = params.getProperty("pH");
        if (pHString == null || pHString.length() == 0) {
            pHString = params.getProperty("ph");
        }
        if (pHString != null && pHString.length() > 0) {
            try {
                double pH = Double.parseDouble(pHString);
                this.logPPredictor.setPH(pH);
            }
            catch (NumberFormatException e) {
                throw new PluginException("Cannot recognize pH " + pHString + " as number.");
            }
        }
    }

    public void setCloridIonConcentration(double c) {
        this.logPPredictor.setCloridIonConcentration(c);
    }

    public void setNaKIonConcentration(double c) {
        this.logPPredictor.setNaKIonConcentration(c);
    }

    public void setConsiderTautomerization(boolean considerTautomerization) {
        this.considerTautomerization = considerTautomerization;
    }

    public void setTakeMajorTatomericForm(boolean takeMajorTautomericForm) {
        this.setConsiderTautomerization(takeMajorTautomericForm);
    }

    @Override
    protected final Molecule createModifiedInputMolecule(Molecule mol) throws PluginException {
        if (this.considerTautomerization) {
            TautomerizationPlugin tplugin = new TautomerizationPlugin();
            tplugin.setMolecule(mol);
            tplugin.setTakeCanonicalForm(true);
            tplugin.setTakePartialNeutralization(true);
            tplugin.run();
            Molecule canonicalTautomericForm = tplugin.getStructure(0);
            this.standardize(canonicalTautomericForm);
            return canonicalTautomericForm;
        }
        return mol;
    }

    public void setUserTypes(String chtypes) throws PluginException {
        if (chtypes != null) {
            StringTokenizer st = new StringTokenizer(chtypes, ",");
            this.utypes = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.checkType(token, TYPE_RANGE);
                this.utypes[i++] = token;
            }
        }
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (mol.isReaction()) {
            throw new PluginException("Calculation is not defined for reactions.");
        }
        if (logPPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.mol = mol;
    }

    public void setlogPMethod(int method) {
        this.method = method;
        switch (method) {
            case 1: {
                this.logPPredictor.setWeightOfMethods(1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 2: {
                this.logPPredictor.setWeightOfMethods(0.0, 1.0, 0.0, 0.0);
                break;
            }
            case 3: {
                this.logPPredictor.setWeightOfMethods(0.0, 0.0, 1.0, 0.0);
                break;
            }
            case 4: {
                this.logPPredictor.setWeightOfMethods(0.0, 0.0, 0.0, 1.0);
                break;
            }
            case 5: {
                this.logPPredictor.setWeightOfMethods(1.0, 1.0, 1.0, 0.0);
                break;
            }
            default: {
                this.logPPredictor.setWeightOfMethods(1.0, 1.0, 1.0, 0.0);
            }
        }
    }

    public void setWeightOfMethods(double wVG, double wKLOP, double wPHYS, double wUSER) {
        this.userDefinedMethodWeight = wUSER;
        this.logPPredictor.setWeightOfMethods(wVG, wKLOP, wPHYS, wUSER);
    }

    public static String[] getTrainingIds() {
        List<String> allTrainingIds = Arrays.asList(TrainerUtils.getTrainingIds());
        ArrayList<String> logPTrainingIds = new ArrayList<String>();
        for (String trainingId : allTrainingIds) {
            if (!trainingId.startsWith(LOGP_TRAINING_ID_PREFIX)) continue;
            logPTrainingIds.add(trainingId.substring(LOGP_TRAINING_ID_PREFIX.length()));
        }
        String[] trainingIds = new String[logPTrainingIds.size()];
        logPTrainingIds.toArray(trainingIds);
        return trainingIds;
    }

    public void setTraining(String trainingId) throws PluginException {
        if (trainingId == null || trainingId.length() == 0) {
            throw new PluginException("Training ID is not set.");
        }
        String trainingIdWithPrefix = trainingId;
        if (!trainingId.startsWith(LOGP_TRAINING_ID_PREFIX)) {
            trainingIdWithPrefix = LOGP_TRAINING_ID_PREFIX + trainingId;
        }
        try {
            this.logPPredictor.setTrainingResults(TrainerUtils.loadParameters(trainingIdWithPrefix));
        }
        catch (IOException e) {
            throw new PluginException("Cannot load parameter file for training '" + trainingId + "'.", e);
        }
    }

    @Override
    public boolean run() throws PluginException {
        int i;
        this.checkLicense();
        this.atomicIncrements = null;
        this.logPMicro = new double[]{Double.NaN, Double.NaN};
        this.logPNonionic = new double[]{Double.NaN, Double.NaN};
        this.logDpI = new double[]{Double.NaN, Double.NaN};
        this.logPTrue = new double[]{Double.NaN, Double.NaN};
        this.logPSingle = new double[]{Double.NaN, Double.NaN};
        for (int i2 = 0; i2 < this.utypes.length; ++i2) {
            String typestr = this.utypes[i2].toString();
            if (typestr.equalsIgnoreCase("logP")) {
                this.logPPredictor.setLogPMethod(LogPPredictor.MethodType.NEUTRAL);
                this.logPNonionic = this.logPPredictor.predictWithError(this.mol);
                this.logPPredictor.setLogPMethod(LogPPredictor.MethodType.AMPHOTER);
                this.logDpI = this.logPPredictor.predictWithError(this.mol);
                this.logPPredictor.setLogPMethod(LogPPredictor.MethodType.IONIC);
                this.logPMicro = this.logPPredictor.predictWithError(this.mol);
                this.logPSingle = this.getSingleValue(this.logPMicro, this.logPNonionic, this.logDpI);
                continue;
            }
            if (typestr.equalsIgnoreCase("logPNonionic")) {
                this.logPPredictor.setLogPMethod(LogPPredictor.MethodType.NEUTRAL);
                this.logPNonionic = this.logPPredictor.predictWithError(this.mol);
                continue;
            }
            if (typestr.equalsIgnoreCase("logDpI")) {
                this.logPPredictor.setLogPMethod(LogPPredictor.MethodType.AMPHOTER);
                this.logDpI = this.logPPredictor.predictWithError(this.mol);
                continue;
            }
            if (typestr.equalsIgnoreCase("logPTrue")) {
                this.logPPredictor.setLogPMethod(LogPPredictor.MethodType.TRUE);
                this.logPTrue = this.logPPredictor.predictWithError(this.mol);
                continue;
            }
            this.logPPredictor.setLogPMethod(LogPPredictor.MethodType.IONIC);
            this.logPMicro = this.logPPredictor.predictWithError(this.mol);
        }
        Vector<String> v = new Vector<String>();
        for (i = 0; i < this.utypes.length; ++i) {
            String typestr = this.utypes[i].toString();
            if (typestr.equalsIgnoreCase("logP")) {
                if (!Double.isNaN(this.logPSingle[0])) {
                    v.addElement("logP");
                    continue;
                }
                if (!Double.isNaN(this.logPMicro[0]) && !this.format(this.logPMicro[0]).equals(this.format(this.logPNonionic[0]))) {
                    v.addElement("logPMicro");
                }
                if (!Double.isNaN(this.logPNonionic[0])) {
                    v.addElement("logPNonionic");
                }
                if (Double.isNaN(this.logDpI[0])) continue;
                v.addElement("logDpI");
                continue;
            }
            v.addElement(this.utypes[i].toString());
        }
        this.types = new Object[v.size()];
        for (i = 0; i < this.types.length; ++i) {
            this.types[i] = v.elementAt(i);
        }
        return this.logPPredictor.isValid();
    }

    @Override
    public String getErrorMessage() {
        if (!this.logPPredictor.isValid()) {
            return "Inconsistent molecular structure.";
        }
        return "";
    }

    private double[] getSingleValue(double[] x1, double[] x2, double[] x3) {
        return new double[]{this.getSingleValue(x1[0], x2[0], x3[0]), this.getSingleValue(x1[1], x2[1], x3[1])};
    }

    private double getSingleValue(double x1, double x2, double x3) {
        String str3;
        String str1 = Double.isNaN(x1) ? null : this.format(x1);
        String str2 = Double.isNaN(x2) ? null : this.format(x2);
        String string = str3 = Double.isNaN(x3) ? null : this.format(x3);
        if (str1 != null) {
            if (str2 != null) {
                if (str3 != null) {
                    return str1.equals(str2) && str1.equals(str3) ? x1 : Double.NaN;
                }
                return str1.equals(str2) ? x1 : Double.NaN;
            }
            if (str3 != null) {
                return str1.equals(str3) ? x1 : Double.NaN;
            }
            return x1;
        }
        if (str2 != null) {
            if (str3 != null) {
                return str2.equals(str3) ? x2 : Double.NaN;
            }
            return x2;
        }
        return x3;
    }

    public double getlogPMicro() {
        return this.logPMicro[0];
    }

    public double getlogPNonionic() {
        return this.logPNonionic[0];
    }

    public double getlogDpI() {
        return this.logDpI[0];
    }

    public double getlogPTrue() {
        return this.logPTrue[0];
    }

    public double getAtomlogPIncrement(int index) {
        if (this.atomicIncrements == null) {
            this.atomicIncrements = this.logPPredictor.predictAtomicIncrements(this.mol);
        }
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.atomicIncrements[index];
    }

    public double getAtomlogPHIncrement(int index) {
        return this.getAtomlogPIncrement(index);
    }

    public double getStructurallogPIncrement() {
        return this.logPPredictor.predictStructuralIncrement(new Molecule[]{this.mol})[0];
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    public Object[] getUserTypes() {
        return this.utypes;
    }

    @Override
    public String getTypeString(Object type) {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("logPMicro")) {
            return "logP of ionic species";
        }
        if (typestr.equalsIgnoreCase("logPNonionic")) {
            return "logP of nonionic species";
        }
        if (typestr.equalsIgnoreCase("logDpI")) {
            return "logD at pI";
        }
        if (typestr.equalsIgnoreCase("logPTrue")) {
            return "logP";
        }
        if (typestr.equalsIgnoreCase("structuralincrement")) {
            return "Structural increment";
        }
        return typestr;
    }

    @Override
    public int getResultDomain(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.startsWith("log")) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getResultCount(Object type) {
        String typestr = type.toString().toLowerCase();
        if (typestr.startsWith("log")) {
            return 1;
        }
        return this.getAtomCount();
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        return this.getResult(type, index, 0);
    }

    public double getStandardError(Object type, int index) {
        return this.getResult(type, index, 1);
    }

    private double getResult(Object type, int index, int resultIndex) {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("increments")) {
            return resultIndex == 0 ? this.getAtomlogPIncrement(index) : Double.NaN;
        }
        if (typestr.equalsIgnoreCase("inch") || typestr.equalsIgnoreCase("implh")) {
            return resultIndex == 0 ? this.getAtomlogPHIncrement(index) : Double.NaN;
        }
        if (typestr.equalsIgnoreCase("structuralincrement")) {
            return resultIndex == 0 ? this.getStructurallogPIncrement() : Double.NaN;
        }
        if (typestr.equalsIgnoreCase("logPNonionic")) {
            return this.logPNonionic[resultIndex];
        }
        if (typestr.equalsIgnoreCase("logDpI")) {
            return this.logDpI[resultIndex];
        }
        if (typestr.equalsIgnoreCase("logPTrue")) {
            return this.logPTrue[resultIndex];
        }
        if (typestr.equalsIgnoreCase("logP")) {
            return this.logPSingle[resultIndex];
        }
        return this.logPMicro[resultIndex];
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase("increments")) {
            if ((index = this.getAtomIndex(index)) == -1) {
                return "";
            }
            double atomLogPIncrement = this.getAtomlogPIncrement(index);
            double[] x = new double[]{atomLogPIncrement, atomLogPIncrement, atomLogPIncrement};
            if (!this.inch || x[2] == 0.0 || Double.isNaN(x[2])) {
                return this.format(x[1]);
            }
            return this.format(x[1]) + " (" + this.format(x[2]) + ")";
        }
        if (!(result instanceof Double)) {
            throw new PluginException("Result is not a Double object: " + result);
        }
        double x = (Double)result;
        if ((x == 0.0 || Double.isNaN(x)) && (typestr.equalsIgnoreCase("inch") || typestr.equalsIgnoreCase("implh"))) {
            return "";
        }
        if (Double.isNaN(x)) {
            return "";
        }
        return this.format(x);
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        for (int t = 0; t < this.types.length; ++t) {
            Object type = this.types[t];
            if (this.getResultDomain(type) == 1) {
                for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
                    Object result = this.getResult(type, i);
                    String label = this.getResultAsString(type, i, result);
                    mol.getAtom(i).setExtraLabel(label);
                }
                continue;
            }
            Object result = this.getResult(type, 0);
            double error = this.getStandardError(type, 0);
            String errorString = Double.isNaN(error) ? "" : " \u00b1 " + this.format(error);
            mol.setProperty(type.toString(), this.getResultAsString(type, 0, result) + errorString);
        }
        if (Arrays.asList(this.types).contains("increments") && Math.abs(this.getStructurallogPIncrement()) > 0.001) {
            mol.setProperty(this.getTypeString("structuralincrement"), this.getResultAsString("structuralincrement", 0, this.getResult((Object)"structuralincrement", 0)));
        }
        return mol;
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
        mol.implicitizeHydrogens(2047);
        logPPlugin.standardizeIonicGroups(mol);
        mol.dearomatize();
        mol.aromatize(1);
    }

    public boolean needError() {
        return this.needError;
    }
}

