/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.pka.PKaLargeModel;
import chemaxon.calculations.training.TrainerUtils;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class pKaPlugin
extends CalculatorPlugin {
    private static final String WARNING = "No ionizable atoms found.";
    public static final int ACIDIC = -1;
    public static final int BASIC = 1;
    public static final String TYPE_DISTR = "msdistr";
    public static final int STATICpKaPREFIX = 1;
    public static final int DYNAMICpKaPREFIX = 2;
    private static String[] TYPE_RANGE = new String[]{"pka", "acidic", "basic", "msdistr"};
    public static final int DEF_MAXIONS = 8;
    public static final double DEF_TEMPERATURE = 298.0;
    public static final int MODEL_SMALL = 0;
    public static final int MODEL_LARGE = 1;
    private static final double DEF_LOWER = 0.0;
    private static final double DEF_UPPER = 14.0;
    private static final double DEF_STEP = 0.2;
    private static final String PKA_CORRECTION_LIBRARY_ID_PREFIX = "pka:";
    private Ionizer ionizer = null;
    private PKaLargeModel proteinIonization = null;
    private Object[] types = new Object[]{"pKa"};
    private double minB = -1.7976931348623157E308;
    private double maxA = Double.MAX_VALUE;
    private boolean mscalc = true;
    private int model = 0;
    private boolean currentOverflowCalc = false;
    private boolean considerTautomerization = false;

    public pKaPlugin() {
        this.ionizer = new Ionizer();
        this.proteinIonization = new PKaLargeModel();
    }

    @Override
    public String getProductName() {
        return "Protonation Plugin Group";
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
        this.proteinIonization.setProgressMonitor(pmon);
    }

    @Override
    public void setParameters(Properties params) throws PluginException {
        String minBstr;
        String mode;
        String pr = params.getProperty("precision");
        this.setDoublePrecision(pr);
        if ("true".equalsIgnoreCase(params.getProperty("calcAlways")) || "true".equalsIgnoreCase(params.getProperty("calcalways")) || "large".equalsIgnoreCase(params.getProperty("model"))) {
            this.setModel(1);
        }
        boolean micro = (mode = params.getProperty("mode")) != null && mode.equalsIgnoreCase("micro");
        int maxions = 8;
        String maxionsStr = params.getProperty("ions");
        if (maxionsStr != null && maxionsStr.length() > 0 && (maxions = Integer.valueOf(maxionsStr).intValue()) < 0) {
            maxions = 0;
        }
        this.minB = (minBstr = params.getProperty("min")) != null && minBstr.length() > 0 ? Double.valueOf(minBstr) : -1.7976931348623157E308;
        String maxAstr = params.getProperty("max");
        this.maxA = maxAstr != null && maxAstr.length() > 0 ? Double.valueOf(maxAstr) : Double.MAX_VALUE;
        double temperature = 298.0;
        String tempstr = params.getProperty("temperature");
        if (tempstr != null && tempstr.length() > 0) {
            temperature = Double.valueOf(tempstr);
        }
        this.ionizer.setmicropKaCalc(micro);
        this.ionizer.setMaxIons(maxions);
        this.ionizer.setAcidicpKaUpperLimit(this.maxA);
        this.ionizer.setBasicpKaLowerLimit(this.minB);
        this.ionizer.setTemperature(temperature);
        this.proteinIonization.setAcidicpKaUpperLimit(this.maxA);
        this.proteinIonization.setBasicpKaLowerLimit(this.minB);
        this.ionizer.setpKaPrefixType(params.getProperty("prefix", "static").equalsIgnoreCase("static") ? 1 : 2);
        this.proteinIonization.setpKaPrefixType(params.getProperty("prefix", "static").equalsIgnoreCase("static") ? 1 : 2);
        this.mscalc = false;
        if (!micro) {
            this.mscalc = "true".equalsIgnoreCase(params.getProperty("mscalc"));
            if (this.mscalc) {
                double lower = 0.0;
                String lstr = params.getProperty("lower");
                if (lstr != null && lstr.length() > 0) {
                    lower = Double.valueOf(lstr);
                }
                double upper = 14.0;
                String ustr = params.getProperty("upper");
                if (ustr != null && ustr.length() > 0) {
                    upper = Double.valueOf(ustr);
                }
                if (upper < lower) {
                    double tmp = lower;
                    lower = upper;
                    upper = tmp;
                }
                double step = 0.2;
                String sstr = params.getProperty("step");
                if (sstr != null && sstr.length() > 0) {
                    step = Double.valueOf(sstr);
                    if (step < 0.0) {
                        step = -step;
                    } else if (step == 0.0 && lower != upper) {
                        throw new PluginException("Step size is zero.");
                    }
                }
                this.ionizer.setpHL(lower);
                this.ionizer.setpHU(upper);
                this.ionizer.setpHS(step);
                this.proteinIonization.setpHL(lower);
                this.proteinIonization.setpHU(upper);
                this.proteinIonization.setpHS(step);
            }
        }
        this.ionizer.setMspHCalc(this.mscalc);
        String chtypes = params.getProperty("type");
        if (chtypes == null) {
            chtypes = "pKa";
        }
        int n = this.mscalc ? 1 : 0;
        StringTokenizer st = new StringTokenizer(chtypes, ",");
        this.types = new Object[st.countTokens() + n];
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.checkType(token, TYPE_RANGE);
            this.types[i++] = token;
        }
        if (this.mscalc) {
            this.types[i] = TYPE_DISTR;
        }
        this.setConsiderTautomerization("true".equalsIgnoreCase(params.getProperty("considertautomerization")) || "true".equalsIgnoreCase(params.getProperty("majortautomer")));
        this.useCorrectionLibrary("true".equalsIgnoreCase(params.getProperty("usecorrectionlibrary")));
        this.setCorrectionLibrary(params.getProperty("correctionlibrary"));
    }

    public void useCorrectionLibrary(boolean use) {
        this.ionizer.useCorrectionLibrary(use);
    }

    public void setCorrectionLibrary(String correctionLibraryId) {
        this.ionizer.setCorrectionLibrary(correctionLibraryId);
    }

    public static String[] getCorrectionLibraryIds() {
        List<String> allTrainingIds = Arrays.asList(TrainerUtils.getTrainingIds());
        ArrayList<String> pKaTrainingIds = new ArrayList<String>();
        for (String trainingId : allTrainingIds) {
            if (!trainingId.startsWith(PKA_CORRECTION_LIBRARY_ID_PREFIX)) continue;
            pKaTrainingIds.add(trainingId.substring(PKA_CORRECTION_LIBRARY_ID_PREFIX.length()));
        }
        String[] trainingIds = new String[pKaTrainingIds.size()];
        pKaTrainingIds.toArray(trainingIds);
        return trainingIds;
    }

    public void setMicropKaCalc(boolean micro) {
        this.ionizer.setmicropKaCalc(micro);
    }

    public void setCalcAlways(boolean calcAlways) {
        this.setModel(calcAlways ? 1 : 0);
    }

    public void setModel(int model) {
        this.model = model;
    }

    public void setMaxIons(int n) {
        this.ionizer.setMaxIons(n);
    }

    public void setBasicpKaLowerLimit(double minB) {
        this.ionizer.setBasicpKaLowerLimit(minB);
        this.proteinIonization.setBasicpKaLowerLimit(minB);
    }

    public void setAcidicpKaUpperLimit(double maxA) {
        this.ionizer.setAcidicpKaUpperLimit(maxA);
        this.proteinIonization.setAcidicpKaUpperLimit(maxA);
    }

    public void setTemperature(double temperature) {
        this.ionizer.setTemperature(temperature);
    }

    public void setpHLower(double lower) {
        this.ionizer.setpHL(lower);
        this.proteinIonization.setpHL(lower);
        this.setMsCalc(true);
    }

    public void setpHUpper(double upper) {
        this.ionizer.setpHU(upper);
        this.proteinIonization.setpHU(upper);
        this.setMsCalc(true);
    }

    public void setpHStep(double step) {
        this.ionizer.setpHS(step);
        this.proteinIonization.setpHS(step);
        this.setMsCalc(true);
    }

    public void setpH(double pH) {
        this.ionizer.setpHL(pH);
        this.ionizer.setpHU(pH + 1.0);
        this.ionizer.setpHS(2.0);
        this.setMsCalc(true);
    }

    public void setMsCalc(boolean mscalc) {
        this.mscalc = mscalc;
        this.ionizer.setMspHCalc(mscalc);
    }

    @Override
    protected boolean isMsCalc() {
        return this.mscalc;
    }

    public void setpKaPrefixType(int pKaPtype) {
        this.ionizer.setpKaPrefixType(pKaPtype);
        this.proteinIonization.setpKaPrefixType(pKaPtype);
    }

    public int getpKaPrefixType() {
        return this.ionizer.getpKaPrefixType();
    }

    public void setConsiderTautomerization(boolean considerTautomerization) {
        this.considerTautomerization = considerTautomerization;
    }

    public void setTakeMajorTatomericForm(boolean takeMajorTautomericForm) {
        this.setConsiderTautomerization(takeMajorTautomericForm);
    }

    @Override
    protected final Molecule createModifiedInputMolecule(Molecule mol) throws PluginException {
        if (this.considerTautomerization) {
            TautomerizationPlugin tplugin = new TautomerizationPlugin();
            tplugin.setLicenseEnvironment("LicenseEnvironmentForPartitioningPluginGroup");
            tplugin.setMolecule(mol);
            tplugin.setWigglyBondVisibility(false);
            tplugin.setTakeCanonicalForm(true);
            tplugin.setTakePartialNeutralization(false);
            tplugin.run();
            Molecule canonicalTautomericForm = tplugin.getStructure(0);
            this.standardize(canonicalTautomericForm);
            return canonicalTautomericForm;
        }
        return mol;
    }

    @Override
    public void checkMolecule(Molecule mol) throws PluginException {
        super.checkMolecule(mol);
        if (pKaPlugin.isRgrouped(mol)) {
            throw new PluginException("Calculation is not defined for molecules with R-groups.");
        }
    }

    @Override
    protected void setInputMolecule(Molecule mol) throws PluginException {
        this.ionizer.setMolecule(mol);
    }

    @Override
    public boolean run() throws PluginException {
        this.checkLicense();
        this.ionizer.setModelType(this.model == 1);
        this.ionizer.calculatepKa();
        boolean bl = this.currentOverflowCalc = this.model == 1 && this.ionizer.getIonOverflowStatus();
        if (this.currentOverflowCalc) {
            this.proteinIonization.setMolecule(this.ionizer.getMolecule());
            this.proteinIonization.setCorrectionLibraryAbsolutePath(this.ionizer.getCorrectionLibraryAbsolutePath());
            this.proteinIonization.calcMacropKa();
            if (this.mscalc) {
                this.proteinIonization.calcMacroSpeciesDistribution();
            }
        }
        return !this.ionizer.getCriticalErrorFlag();
    }

    public int getMsCount() {
        return this.currentOverflowCalc ? this.proteinIonization.getMacroSpeciesCount() : this.ionizer.getMicroSpeciesCount();
    }

    public Molecule getMsMolecule(int msIndex) {
        return this.currentOverflowCalc ? null : this.ionizer.getMspHMolecule(msIndex);
    }

    public double getSingleMsDistribution(int msIndex) {
        return this.currentOverflowCalc ? this.proteinIonization.getMacroSpeciesDistribution(msIndex)[0] : this.ionizer.getMspH(msIndex)[0];
    }

    public double[] getpHs() {
        return this.currentOverflowCalc ? this.proteinIonization.getpHPoints() : this.ionizer.getpH();
    }

    public double[] getMsDistribution(int msIndex) {
        return this.currentOverflowCalc ? this.proteinIonization.getMacroSpeciesDistribution(msIndex) : this.ionizer.getMspH(msIndex);
    }

    public double[][] getMsDistributions() {
        int count = this.getMsCount();
        double[][] distributions = new double[count][];
        for (int i = 0; i < count; ++i) {
            distributions[i] = this.getMsDistribution(i);
        }
        return distributions;
    }

    public double getpKa(int index) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.currentOverflowCalc ? this.proteinIonization.getMacropKa(index) : this.ionizer.getpKa(index);
    }

    public double getpKa(int index, int type) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return Double.NaN;
        }
        return this.currentOverflowCalc ? this.proteinIonization.getMacropKa(index, type) : this.ionizer.getpKa(index, type);
    }

    public double[] getpKaValues(int index, int type) {
        if ((index = this.getAtomIndex(index)) == -1) {
            return null;
        }
        return this.currentOverflowCalc ? this.proteinIonization.getpKaSet(index, type) : this.ionizer.getpKaSet(index, type);
    }

    public int getpKaType(int index) {
        int type;
        if ((index = this.getAtomIndex(index)) == -1) {
            return 0;
        }
        int n = type = this.currentOverflowCalc ? this.proteinIonization.getMacropKaType(index) : this.ionizer.getpKaType(index);
        if (type == -2) {
            type = 0;
        }
        return type;
    }

    public int getMacroSpeciesCharge(int msIndex) {
        return this.proteinIonization.getMacroSpeciesCharge(msIndex);
    }

    public boolean isOverflowCalculation() {
        return this.currentOverflowCalc;
    }

    @Override
    public String getErrorMessage() {
        String msg = "";
        if (this.model == 0 && this.ionizer.getIonOverflowStatus()) {
            msg = msg + "The number of ionizable atoms (" + this.ionizer.getMaxIonsCounter() + ") exceeds the specified limit (" + this.ionizer.getMaxIons() + ").";
        }
        if (this.ionizer.getCriticalErrorFlag()) {
            if (msg.length() > 0) {
                msg = msg + "\n";
            }
            msg = msg + "Inconsistent molecular structure.";
        }
        return msg;
    }

    @Override
    public String getWarningMessage() {
        return this.ionizer.getIonizableAtomCount() == 0 ? WARNING : "";
    }

    @Override
    public Object[] getResultTypes() {
        return this.types;
    }

    @Override
    public int getResultDomain(Object type) {
        if (type.toString().equalsIgnoreCase(TYPE_DISTR)) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getResultCount(Object type) {
        if (type.toString().equalsIgnoreCase(TYPE_DISTR)) {
            return this.getMsCount();
        }
        return this.getAtomCount();
    }

    @Override
    public Object getResult(Object type, int index) throws PluginException {
        String typestr = type.toString();
        if (typestr.equalsIgnoreCase(TYPE_DISTR)) {
            return new double[][]{this.getpHs(), this.getMsDistribution(index)};
        }
        double value = Double.NaN;
        if (typestr.equalsIgnoreCase("pKa")) {
            value = this.getpKa(index);
        } else if (typestr.equalsIgnoreCase("acidic")) {
            double[] values = this.getpKaValues(index, -1);
            value = values != null ? values[0] : Double.NaN;
        } else if (typestr.equalsIgnoreCase("basic")) {
            double[] values = this.getpKaValues(index, 1);
            value = values != null ? values[0] : Double.NaN;
        } else {
            throw new PluginException("Unknown type: " + type);
        }
        return new Double(value);
    }

    @Override
    public Object getResult(Object type, String arg) throws PluginException {
        int n = 0;
        try {
            n = arg != null ? Integer.parseInt(arg) : 1;
        }
        catch (NumberFormatException e) {
            throw new PluginException("Argument string is not an order index: " + arg);
        }
        int pkatype = "acidic".equalsIgnoreCase(type.toString()) ? -1 : 1;
        double[] values = new double[n];
        this.getMacropKaValues(pkatype, values, null);
        return new Double(values[values.length - 1]);
    }

    public void getSortedValues(int pkatype, double[] values, int[] indexes) throws PluginException {
        this.getMacropKaValues(pkatype, values, indexes);
    }

    public void getMacropKaValues(int pkatype, double[] values, int[] indexes) throws PluginException {
        int i;
        Arrays.fill(values, Double.NaN);
        ArrayList<Double> vals = new ArrayList<Double>();
        ArrayList<Integer> inds = null;
        if (indexes != null) {
            Arrays.fill(indexes, -1);
            inds = new ArrayList<Integer>();
        }
        double sign = pkatype == -1 ? 1.0 : -1.0;
        for (int i2 = 0; i2 < this.getAtomCount(); ++i2) {
            double[] v = this.getpKaValues(i2, pkatype);
            if (v == null) continue;
            for (int j = 0; j < v.length; ++j) {
                if (Double.isNaN(v[j])) continue;
                int n = j;
                v[n] = v[n] * sign;
                vals.add(new Double(v[j]));
                if (indexes == null) continue;
                inds.add(new Integer(i2));
            }
        }
        ArrayList sortVals = (ArrayList)vals.clone();
        Collections.sort(sortVals);
        for (i = 0; i < sortVals.size() && i < values.length; ++i) {
            values[i] = (Double)sortVals.get(i);
            if (indexes == null || i >= indexes.length) continue;
            int indexInList = vals.indexOf(sortVals.get(i));
            indexes[i] = (Integer)inds.get(indexInList);
            vals.remove(indexInList);
            inds.remove(indexInList);
        }
        i = 0;
        while (i < values.length && !Double.isNaN(values[i])) {
            int n = i++;
            values[n] = values[n] * sign;
        }
    }

    private Molecule getMolecule() {
        return this.ionizer.getMolecule();
    }

    public double[] getMacropKaValues(int pkatype) throws PluginException {
        int count;
        double[] values = new double[this.getMolecule().getAtomCount() + this.getMolecule().getImplicitHcount()];
        this.getMacropKaValues(pkatype, values, null);
        for (count = 0; count < values.length && !Double.isNaN(values[count]); ++count) {
        }
        if (count == 0) {
            return null;
        }
        double[] retval = new double[count];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = values[i];
        }
        return retval;
    }

    @Override
    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        if (type.toString().equalsIgnoreCase(TYPE_DISTR)) {
            if (!(result instanceof double[][])) {
                throw new PluginException("Result is not a double[][] object: " + result);
            }
            return this.format((double[][])result, 3);
        }
        if (!(result instanceof Double)) {
            throw new PluginException("Result is not a Double object: " + result);
        }
        double x = (Double)result;
        if (Double.isNaN(x)) {
            return "";
        }
        return this.format(x);
    }

    @Override
    public String getResultsAsString(Object type, int index, Object result) throws PluginException {
        int i;
        if (!type.toString().equalsIgnoreCase("pka")) {
            return this.getResultAsString(type, index, result);
        }
        String str = "";
        double[] acidicValues = this.getpKaValues(index, -1);
        double[] basicValues = this.getpKaValues(index, 1);
        if (acidicValues != null) {
            for (i = 0; i < acidicValues.length; ++i) {
                str = str + this.format(acidicValues[i]) + ",";
            }
            str = str.substring(0, str.length() - 1);
        }
        if (basicValues != null) {
            if (str.length() > 0) {
                str = str + "|";
            }
            for (i = 0; i < basicValues.length; ++i) {
                str = str + this.format(basicValues[i]) + ",";
            }
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public int getResultAsRGB(Object type, int index, Object result) throws PluginException {
        if (type.toString().equalsIgnoreCase(TYPE_DISTR)) {
            return 0;
        }
        if (!(result instanceof Double)) {
            throw new PluginException("Result is not a Double object: " + result);
        }
        int pkatype = this.getpKaType(index);
        switch (pkatype) {
            case -1: {
                return 0xFF0000;
            }
            case 1: {
                return 255;
            }
        }
        return 0;
    }

    @Override
    public long getResultsAsRGB(Object type, int index, Object result) throws PluginException {
        boolean basic;
        if (!type.toString().equalsIgnoreCase("pka")) {
            return this.getResultAsRGB(type, index, result);
        }
        boolean acidic = this.getpKaValues(index, -1) != null;
        boolean bl = basic = this.getpKaValues(index, 1) != null;
        if (acidic && basic) {
            return 0xFF00FF0000L;
        }
        if (acidic) {
            return 0xFF0000L;
        }
        if (basic) {
            return 255L;
        }
        return 0L;
    }

    @Override
    public boolean isNegligibleResult(Object type, int index, Object result) throws PluginException {
        if (!type.toString().equalsIgnoreCase(TYPE_DISTR)) {
            return false;
        }
        if (!(result instanceof double[][])) {
            throw new PluginException("Result is not a double[][] object: " + result);
        }
        double[] distr = ((double[][])result)[1];
        return this.isNegligible(distr);
    }

    protected boolean isNegligible(double[] distr) {
        for (int i = 0; i < distr.length; ++i) {
            if (!(distr[i] >= 0.1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Molecule getResultMolecule() throws PluginException {
        Molecule mol = this.getDisplayMolecule();
        for (int t = 0; t < this.types.length; ++t) {
            Object type = this.types[t];
            if (this.getResultDomain(type) != 1) continue;
            for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
                Object result = this.getResult(type, i);
                String label = this.getResultsAsString(type, i, result);
                long rgbs = this.getResultsAsRGB(type, i, result);
                mol.getAtom(i).setExtraLabel(label);
                mol.getAtom(i).setExtraLabelColor(rgbs);
            }
        }
        return mol;
    }

    @Override
    public void standardize(Molecule mol) {
        mol.ungroupSgroups();
        mol.implicitizeHydrogens(2047);
        mol.dearomatize();
        pKaPlugin.standardizeIonicGroups(mol);
        mol.aromatize(1);
    }
}

