/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.calculations;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.calculations.pKaPlugin;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.CalculatorPluginDisplay;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.gui.ResultView;
import chemaxon.marvin.swing.MDialogProgressMonitor;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.Molecule;
import java.awt.Component;
import java.util.ArrayList;

public class pKaPluginDisplay
extends CalculatorPluginDisplay {
    @Override
    public synchronized void setPlugin(CalculatorPlugin plugin) {
        super.setPlugin(plugin);
        ((pKaPlugin)this.getPlugin()).setModel(1);
    }

    @Override
    public MProgressMonitor getProgressMonitor(Component parent) {
        return new MDialogProgressMonitor(parent, "Macro pKa");
    }

    @Override
    public boolean isMultipleDisplay() {
        return !((pKaPlugin)this.getPlugin()).isMsCalc();
    }

    @Override
    public Component getResultComponent() throws PluginException {
        pKaPlugin plugin = (pKaPlugin)this.getPlugin();
        if (!plugin.isMsCalc()) {
            return super.getResultComponent();
        }
        if (this.resultMolList == null || this.resultMolList.isEmpty()) {
            return null;
        }
        if (this.resultMolList.size() > 1) {
            throw new PluginException("pKa cannot display microspecies data for more molecules.");
        }
        MolPanel mpan = this.parent instanceof MolPanel ? (MolPanel)this.parent : null;
        ResultView view = this.createResultView("pKa", mpan);
        view.setTopMolViewer((Molecule)this.resultMolList.get(0));
        view.setMenu(new String[]{"pKa Values", "Open Viewer"});
        MarvinModule chart = (MarvinModule)MarvinModule.load("MChart", null);
        if (chart != null) {
            String[] labels = this.getLabels(plugin.getpHs());
            double[][] distributions = plugin.getMsDistributions();
            boolean overflowCalc = plugin.isOverflowCalculation();
            ArrayList<double[]> dlist = new ArrayList<double[]>(distributions.length);
            ArrayList<Object> mlist = new ArrayList<Object>(distributions.length);
            String header = "| pH";
            for (int i = 0; i < distributions.length; ++i) {
                if (plugin.isNegligible(distributions[i])) continue;
                dlist.add(distributions[i]);
                if (overflowCalc) {
                    String label = this.getLegendLabel(i);
                    mlist.add(label);
                    header = header + "|" + label;
                    continue;
                }
                mlist.add(this.getLegendMolecule(i));
                header = header + "| " + this.getLegendLabel(dlist.size() - 1);
            }
            double[][] values = new double[dlist.size()][];
            dlist.toArray((T[])values);
            chart.modfunc(new Object[]{"setTitle", this.getChartTitle()});
            chart.modfunc(new Object[]{"setSampleLabels", labels});
            chart.modfunc(new Object[]{"setSampleValues", values});
            chart.modfunc(new Object[]{"setRange", new double[]{0.0, 100.0}});
            if (overflowCalc) {
                String[] legendlabels = new String[mlist.size()];
                mlist.toArray(legendlabels);
                chart.modfunc(new Object[]{"setLegendLabels", legendlabels});
            } else {
                Molecule[] msmols = new Molecule[mlist.size()];
                mlist.toArray(msmols);
                chart.modfunc(new Object[]{"setLegendImages", msmols});
            }
            chart.modfunc(new Object[]{"setSampleHighlightOn", new Boolean(false)});
            chart.modfunc(new Object[]{"setRangeDecimalCount", new Integer(0)});
            view.setChart(chart);
            view.setBottomTextArea(this.getTableText(header, labels, values));
        } else {
            System.err.println("Could not load chart.jar.");
        }
        view.build();
        return view;
    }

    private Molecule getLegendMolecule(int index) {
        pKaPlugin plugin = (pKaPlugin)this.getPlugin();
        if (plugin.isOverflowCalculation()) {
            return null;
        }
        Molecule msmol = plugin.getMsMolecule(index);
        msmol.ungroupSgroups();
        msmol.clearExtraLabels();
        if (!plugin.isInputMoleculeAromatized()) {
            msmol.dearomatize();
        }
        return msmol;
    }

    public String getLegendLabel(int index) {
        pKaPlugin plugin = (pKaPlugin)this.getPlugin();
        String label = "%";
        if (plugin.getMsCount() > 1) {
            label = label + (plugin.isOverflowCalculation() ? "(" + plugin.getMacroSpeciesCharge(index) + ")" : "-" + (index + 1));
        }
        return label;
    }

    private String getChartTitle() {
        return ((pKaPlugin)this.getPlugin()).isOverflowCalculation() ? "Macrospecies distribution (%)" : "Microspecies distribution (%)";
    }
}

