/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common;

import chemaxon.common.util.IntVector;
import chemaxon.struc.MoleculeGraph;

public class AtomSelectionHandler {
    public static final int ALL = -2;
    private static final int ALL_SELECT = 1;
    private static final int ALL_UNSELECT = 2;
    private IntVector selection = null;
    private IntVector unselection = null;
    private int allOption = 0;

    public final void selectAtom(int atom, boolean v) {
        IntVector sel = this.selection;
        IntVector unsel = this.unselection;
        if (atom == -2) {
            this.selection = null;
            this.unselection = null;
            this.allOption = v ? 1 : 2;
        } else if (v) {
            int i;
            if (this.allOption != 1) {
                if (sel == null) {
                    this.selection = sel = new IntVector();
                }
                if ((i = sel.indexOf(atom)) < 0) {
                    sel.add(atom);
                }
            }
            if (unsel != null && (i = unsel.indexOf(atom)) >= 0) {
                unsel.remove(i);
                if (unsel.size() == 0) {
                    this.unselection = null;
                }
            }
        } else {
            int i;
            if (this.allOption != 2) {
                if (unsel == null) {
                    this.unselection = unsel = new IntVector();
                }
                if ((i = unsel.indexOf(atom)) < 0) {
                    unsel.add(atom);
                }
            }
            if (sel != null && (i = sel.indexOf(atom)) >= 0) {
                sel.remove(i);
                if (sel.size() == 0) {
                    this.selection = null;
                }
            }
        }
    }

    public final void apply(MoleculeGraph mol) {
        int i;
        int k;
        mol = mol.getGraphUnion();
        int na = mol.getAtomCount();
        IntVector sel = this.selection;
        IntVector unsel = this.unselection;
        if (this.allOption != 0) {
            boolean v = this.allOption == 1;
            for (k = 0; k < na; ++k) {
                this.apply(mol, k, v);
            }
        }
        if (sel != null) {
            for (i = 0; i < sel.size(); ++i) {
                k = sel.get(i);
                this.apply(mol, k, true);
            }
        }
        if (unsel != null) {
            for (i = 0; i < unsel.size(); ++i) {
                k = unsel.get(i);
                this.apply(mol, k, false);
            }
        }
    }

    public void apply(MoleculeGraph mol, int k, boolean v) {
        mol.getAtom(k).setSelected(v);
    }
}

