/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing;

import chemaxon.struc.MDocument;
import chemaxon.struc.PageSettings;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class CommonStatusBar
extends JPanel {
    private JPanel pagesPanel;
    private JTextField selectedPageField;
    private JLabel allPagesLabel;
    private JLabel pagesLabel;
    private JButton previousPageButton;
    private JButton nextPageButton;
    private JButton firstPageButton;
    private JButton lastPageButton;
    private final ResourceBundle RESOURCES = ResourceBundle.getBundle(CommonStatusBar.class.getName());
    private PageActionProvider pgActions;

    public abstract void relayout(boolean var1);

    public CommonStatusBar(PageActionProvider pgActions) {
        this.pgActions = pgActions;
    }

    protected boolean hasPagesPanel() {
        return this.pagesPanel != null;
    }

    protected JPanel getPagesPanel() {
        this.ensureStatusBarPagesItemsExists();
        return this.pagesPanel;
    }

    private void ensureStatusBarPagesItemsExists() {
        if (this.firstPageButton != null) {
            return;
        }
        this.firstPageButton = this.createFirstPageButton(this.pgActions);
        this.previousPageButton = this.createPreviousPageButton(this.pgActions);
        this.nextPageButton = this.createNextPageButton(this.pgActions);
        this.lastPageButton = this.createLastPageButton(this.pgActions);
        this.selectedPageField = this.createPageField(this.pgActions);
        this.pagesLabel = new JLabel(this.RESOURCES.getString("page") + ":  ");
        Font f = this.pagesLabel.getFont();
        Font font = new Font(f.getName(), 0, f.getSize());
        this.pagesLabel.setFont(font);
        this.selectedPageField.setFont(font);
        this.pagesLabel.setSize(this.pagesLabel.getWidth(), this.nextPageButton.getHeight());
        this.allPagesLabel = new JLabel();
        this.allPagesLabel.setSize(this.allPagesLabel.getWidth(), this.nextPageButton.getHeight());
        this.allPagesLabel.setFont(font);
        this.pagesPanel = new JPanel();
        this.pagesPanel.setLayout(new BoxLayout(this.pagesPanel, 0));
        this.pagesPanel.add(this.pagesLabel);
        this.pagesPanel.add(this.firstPageButton);
        this.pagesPanel.add(this.previousPageButton);
        this.pagesPanel.add(this.selectedPageField);
        this.pagesPanel.add(this.nextPageButton);
        this.pagesPanel.add(this.lastPageButton);
        this.pagesPanel.add(this.allPagesLabel);
        this.pagesPanel.setEnabled(this.isEnabled());
    }

    private JButton createNextPageButton(PageActionProvider pgActions) {
        return this.makeNavigationButton(this.RESOURCES.getString("forwardToolTipText"), this.RESOURCES.getString("next"), "next16.png", pgActions.getNextPageAction());
    }

    private JButton createLastPageButton(PageActionProvider pgActions) {
        return this.makeNavigationButton(this.RESOURCES.getString("lastToolTipText"), this.RESOURCES.getString("last"), "last16.png", pgActions.getLastPageAction());
    }

    private JButton createFirstPageButton(PageActionProvider pgActions) {
        return this.makeNavigationButton(this.RESOURCES.getString("firstToolTipText"), this.RESOURCES.getString("first"), "first16.png", pgActions.getFirstPageAction());
    }

    private JButton createPreviousPageButton(PageActionProvider pgActions) {
        return this.makeNavigationButton(this.RESOURCES.getString("backToolTipText"), this.RESOURCES.getString("back"), "previous16.png", pgActions.getPreviousPageAction());
    }

    private JTextField createPageField(PageActionProvider pgActions) {
        JTextField field = new JTextField(5);
        field.setAction(pgActions.getGoToPageAction());
        field.setText("     ");
        field.setColumns(5);
        field.setMaximumSize(new Dimension(50, 25));
        return field;
    }

    private void updatePagesItems(PageSettings ps) {
        this.selectedPageField.setText(Integer.toString(ps.getSelectedPage() + 1));
        this.allPagesLabel.setText("   of " + ps.getColumnCount() * ps.getRowCount());
        this.previousPageButton.setEnabled(ps.getSelectedPage() != 0);
        int lastPage = ps.getRowCount() * ps.getColumnCount() - 1;
        this.nextPageButton.setEnabled(ps.getSelectedPage() != lastPage);
    }

    public JTextField getSelectedPageField() {
        return this.selectedPageField;
    }

    protected void update(MDocument doc) {
        if (doc != null) {
            PageSettings ps = doc.getPageSettings();
            if (ps.isMultiPageEnabled()) {
                this.ensureStatusBarPagesItemsExists();
                if (!this.isAncestorOf(this.pagesPanel)) {
                    this.relayout(true);
                }
                this.updatePagesItems(ps);
            } else if (this.isAncestorOf(this.pagesPanel)) {
                this.relayout(false);
            }
        }
    }

    private JButton makeNavigationButton(String toolTipText, String altText, String imageName, Action action) {
        String imgLocation = "/chemaxon/icons/marvin/pages/" + imageName;
        URL imageURL = CommonStatusBar.class.getResource(imgLocation);
        JButton button = new JButton(action);
        ImageIcon imageIcon = null;
        if (imageURL != null) {
            imageIcon = new ImageIcon(imageURL, altText);
            button.setIcon(imageIcon);
            button.setText("");
        } else {
            button.setText(altText);
        }
        button.setToolTipText(toolTipText);
        button.setBorder(BorderFactory.createRaisedBevelBorder());
        button.setRolloverEnabled(true);
        button.setMaximumSize(new Dimension(25, 20));
        return button;
    }

    public static interface PageActionProvider {
        public Action getNextPageAction();

        public Action getPreviousPageAction();

        public Action getFirstPageAction();

        public Action getLastPageAction();

        public Action getGoToPageAction();
    }
}

