/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.action.AbsLabelVisibleAction;
import chemaxon.marvin.common.swing.action.AtomMappingVisibleAction;
import chemaxon.marvin.common.swing.action.AtomNumbersVisibleAction;
import chemaxon.marvin.common.swing.action.AtomPropertiesVisibleAction;
import chemaxon.marvin.common.swing.action.AtomSymbolsVisibleAction;
import chemaxon.marvin.common.swing.action.BondLengthVisibleAction;
import chemaxon.marvin.common.swing.action.ChiralitySupportActions;
import chemaxon.marvin.common.swing.action.ColorSchemeActions;
import chemaxon.marvin.common.swing.action.DispQualityActions;
import chemaxon.marvin.common.swing.action.EzVisibleAction;
import chemaxon.marvin.common.swing.action.GrinvVisibleAction;
import chemaxon.marvin.common.swing.action.ImplicitHActions;
import chemaxon.marvin.common.swing.action.LigandErrorVisibleAction;
import chemaxon.marvin.common.swing.action.LonePairsAutoCalc;
import chemaxon.marvin.common.swing.action.LonePairsVisibleAction;
import chemaxon.marvin.common.swing.action.NavmodeActions;
import chemaxon.marvin.common.swing.action.RLogicVisibleAction;
import chemaxon.marvin.common.swing.action.RenderingActions;
import chemaxon.marvin.common.swing.action.RgroupsVisibleAction;
import chemaxon.marvin.common.swing.action.SetColoringEnabledAction;
import chemaxon.marvin.common.swing.action.ValencePropertiesVisibleAction;
import chemaxon.marvin.paint.DispOptConsts;
import chemaxon.marvin.swing.BasicActions;
import chemaxon.marvin.swing.Collaction;
import chemaxon.marvin.swing.ToggleButtonAction;
import chemaxon.marvin.swing.ToggleButtonActionGroup;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.util.text.MStringTokenizer;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JSeparator;

public class DispOptsActions
extends Collaction
implements DispOptConsts {
    private static final Hashtable COLOR_SCHEME_NAMES;
    private static final ResourceBundle RESOURCES;
    private ToggleButtonActionGroup[] rbPropActions;
    private ToggleButtonActionGroup implicitHActions;
    private ToggleButtonActionGroup navmodeActions;
    private ToggleButtonActionGroup colorSchemeActions;
    private ToggleButtonActionGroup renderingActions;
    private ToggleButtonActionGroup dispQualityActions;
    private ToggleButtonActionGroup chiralitySupportActions;
    private ToggleButtonAction[] flagPropActions;
    private ToggleButtonAction absLabelVisibleAction;
    private ToggleButtonAction setColoringEnabledAction;
    private ToggleButtonAction atomSymbolsVisibleAction;
    private ToggleButtonAction grinvVisibleAction;
    private ToggleButtonAction atomNumbersVisibleAction;
    private ToggleButtonAction atomPropertiesVisibleAction;
    private ToggleButtonAction atomMappingVisibleAction;
    private ToggleButtonAction lonePairsVisibleAction;
    private ToggleButtonAction lonePairsAutoCalcAction;
    private ToggleButtonAction valencePropertiesVisibleAction;
    private ToggleButtonAction ligandErrorVisibleAction;
    private ToggleButtonAction bondLengthVisibleAction;
    private ToggleButtonAction rgroupsVisibleAction;
    private ToggleButtonAction rlogicVisibleAcion;
    private ToggleButtonAction ezVisibleAction;

    public DispOptsActions(MolPanel p, int[] map, String navnonelabel) {
        this.navmodeActions = new NavmodeActions(RESOURCES, p, navnonelabel, map);
        this.add(this.navmodeActions);
        this.implicitHActions = new ImplicitHActions(RESOURCES, p);
        this.add(this.implicitHActions);
        this.colorSchemeActions = new ColorSchemeActions(RESOURCES, p);
        this.add(this.colorSchemeActions);
        this.renderingActions = new RenderingActions(RESOURCES, p);
        this.add(this.renderingActions);
        this.dispQualityActions = new DispQualityActions(RESOURCES, p);
        this.add(this.dispQualityActions);
        this.chiralitySupportActions = new ChiralitySupportActions(RESOURCES, p);
        this.add(this.chiralitySupportActions);
        this.rbPropActions = new ToggleButtonActionGroup[6];
        this.rbPropActions[0] = this.implicitHActions;
        this.rbPropActions[1] = this.navmodeActions;
        this.rbPropActions[2] = this.colorSchemeActions;
        this.rbPropActions[3] = this.renderingActions;
        this.rbPropActions[4] = this.dispQualityActions;
        this.rbPropActions[5] = this.chiralitySupportActions;
        this.setColoringEnabledAction = new SetColoringEnabledAction(RESOURCES, p);
        this.add(this.setColoringEnabledAction);
        this.atomSymbolsVisibleAction = new AtomSymbolsVisibleAction(RESOURCES, p);
        this.add(this.atomSymbolsVisibleAction);
        this.grinvVisibleAction = new GrinvVisibleAction(RESOURCES, p);
        this.add(this.grinvVisibleAction);
        this.atomNumbersVisibleAction = new AtomNumbersVisibleAction(RESOURCES, p);
        this.add(this.atomNumbersVisibleAction);
        this.atomPropertiesVisibleAction = new AtomPropertiesVisibleAction(RESOURCES, p);
        this.add(this.atomPropertiesVisibleAction);
        this.atomMappingVisibleAction = new AtomMappingVisibleAction(RESOURCES, p);
        this.add(this.atomMappingVisibleAction);
        this.lonePairsVisibleAction = new LonePairsVisibleAction(RESOURCES, p);
        this.add(this.lonePairsVisibleAction);
        this.valencePropertiesVisibleAction = new ValencePropertiesVisibleAction(RESOURCES, p);
        this.add(this.valencePropertiesVisibleAction);
        this.ligandErrorVisibleAction = new LigandErrorVisibleAction(RESOURCES, p);
        this.add(this.ligandErrorVisibleAction);
        this.bondLengthVisibleAction = new BondLengthVisibleAction(RESOURCES, p);
        this.add(this.bondLengthVisibleAction);
        this.rgroupsVisibleAction = new RgroupsVisibleAction(RESOURCES, p);
        this.add(this.rgroupsVisibleAction);
        this.ezVisibleAction = new EzVisibleAction(RESOURCES, p);
        this.add(this.ezVisibleAction);
        this.absLabelVisibleAction = new AbsLabelVisibleAction(RESOURCES, p);
        this.add(this.absLabelVisibleAction);
        this.lonePairsAutoCalcAction = new LonePairsAutoCalc(RESOURCES, p);
        this.add(this.lonePairsAutoCalcAction);
        this.rlogicVisibleAcion = new RLogicVisibleAction(RESOURCES, p);
        this.add(this.rlogicVisibleAcion);
        this.flagPropActions = new ToggleButtonAction[13];
        this.flagPropActions[0] = this.setColoringEnabledAction;
        this.flagPropActions[1] = this.atomSymbolsVisibleAction;
        this.flagPropActions[2] = this.grinvVisibleAction;
        this.flagPropActions[3] = this.atomNumbersVisibleAction;
        this.flagPropActions[4] = this.atomMappingVisibleAction;
        this.flagPropActions[5] = this.lonePairsVisibleAction;
        this.flagPropActions[6] = this.bondLengthVisibleAction;
        this.flagPropActions[7] = this.rgroupsVisibleAction;
        this.flagPropActions[8] = this.ezVisibleAction;
        this.flagPropActions[9] = this.absLabelVisibleAction;
        this.flagPropActions[10] = this.lonePairsAutoCalcAction;
        this.flagPropActions[11] = this.atomPropertiesVisibleAction;
    }

    @Override
    public void initAccelerators(JComponent c) {
        super.initAccelerators(c);
        this.navmodeActions.initInputMap(c, 2);
    }

    public void setDispOpts(int opts) {
        int[] maskoff = new int[]{3, 0, 0, 3, 192, 6, 917504, 17, 0x800000, 23, 49152, 14};
        for (int i = 0; i < this.rbPropActions.length; ++i) {
            int mask = maskoff[2 * i];
            int off = maskoff[2 * i + 1];
            int v = (opts & mask) >> off;
            if (mask == 0) continue;
            this.rbPropActions[i].setSelectedIndex(v);
        }
        try {
            this.navmodeActions.setValue(MM_MODES[(opts & 0x38) >> 3]);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        int[] flags = new int[]{256, 1024, 512, 2048, 4096, 0x1000000, 8192, 0x4000000, 65536, 0x2000000, 0x8000000, 8};
        for (int i = 0; i < flags.length; ++i) {
            boolean v = (opts & flags[i]) != 0;
            this.flagPropActions[i].setSelected(v);
        }
    }

    public void setDispOptsExt(int f) {
        boolean v = (f & 0x10) != 0;
        this.rlogicVisibleAcion.setSelected(v);
        v = (f & 0x40) != 0;
        this.valencePropertiesVisibleAction.setSelected(v);
        v = (f & 0x80) != 0;
        this.ligandErrorVisibleAction.setSelected(v);
    }

    public static String getColorSchemeName(String key) {
        return (String)COLOR_SCHEME_NAMES.get(key);
    }

    public ToggleButtonActionGroup getNavmodeActions() {
        return this.navmodeActions;
    }

    public ToggleButtonActionGroup getImplicitHActions() {
        return this.implicitHActions;
    }

    public ToggleButtonActionGroup getColorSchemeActions() {
        return this.colorSchemeActions;
    }

    public ToggleButtonActionGroup getRenderingActions() {
        return this.renderingActions;
    }

    public ToggleButtonActionGroup getDispQualityActions() {
        return this.dispQualityActions;
    }

    public ToggleButtonActionGroup getChiralitySupportActions() {
        return this.chiralitySupportActions;
    }

    public ToggleButtonAction getAbsLabelVisibleAction() {
        return this.absLabelVisibleAction;
    }

    public ToggleButtonAction getSetColoringEnabledAction() {
        return this.setColoringEnabledAction;
    }

    public ToggleButtonAction getAtomSymbolsVisibleAction() {
        return this.atomSymbolsVisibleAction;
    }

    public ToggleButtonAction getGrinvVisibleAction() {
        return this.grinvVisibleAction;
    }

    public ToggleButtonAction getAtomNumbersVisibleAction() {
        return this.atomNumbersVisibleAction;
    }

    public ToggleButtonAction getAtomPropertiesVisibleAction() {
        return this.atomPropertiesVisibleAction;
    }

    public ToggleButtonAction getAtomMappingVisibleAction() {
        return this.atomMappingVisibleAction;
    }

    public ToggleButtonAction getLonePairsVisibleAction() {
        return this.lonePairsVisibleAction;
    }

    public ToggleButtonAction getValencePropertiesVisibleAction() {
        return this.valencePropertiesVisibleAction;
    }

    public ToggleButtonAction getLigandErrorVisibleAction() {
        return this.ligandErrorVisibleAction;
    }

    public ToggleButtonAction getLonePairsAutoCalcAction() {
        return this.lonePairsAutoCalcAction;
    }

    public JMenu createHydrogenMenu(boolean inPopup) {
        int f = inPopup ? 44 : 0;
        JMenu menu = SwingUtil.createMenu(RESOURCES, "hydrogens", !inPopup);
        menu.setName("hydrogens.view");
        this.implicitHActions.addTo(menu, 0, f);
        return menu;
    }

    public JMenu createStereoMenu(boolean inPopup) {
        int f = inPopup ? 44 : 0;
        JMenu menu = SwingUtil.createMenu(RESOURCES, "stereo", !inPopup);
        menu.setName("stereo.view");
        JMenu submenu = SwingUtil.createMenu(RESOURCES, "chirality", !inPopup);
        menu.add(submenu);
        submenu.setName("chirality.stereo.view");
        this.chiralitySupportActions.addTo(submenu, 0, f);
        this.ezVisibleAction.addTo(menu, f);
        this.absLabelVisibleAction.addTo(menu, f);
        return menu;
    }

    public JMenu createMiscMenu(boolean inPopup) {
        int f = inPopup ? 44 : 0;
        JMenu menu = SwingUtil.createMenu(RESOURCES, "misc", !inPopup);
        menu.setName("misc.view");
        this.atomNumbersVisibleAction.addTo(menu, f);
        this.atomPropertiesVisibleAction.addTo(menu, f);
        this.atomMappingVisibleAction.addTo(menu, f);
        this.grinvVisibleAction.addTo(menu, f);
        this.bondLengthVisibleAction.addTo(menu, f);
        menu.add(new JSeparator());
        this.lonePairsVisibleAction.addTo(menu, f);
        menu.add(new JSeparator());
        this.rgroupsVisibleAction.addTo(menu, f);
        this.rlogicVisibleAcion.addTo(menu, f);
        this.valencePropertiesVisibleAction.addTo(menu, f);
        this.ligandErrorVisibleAction.addTo(menu, f);
        return menu;
    }

    public JMenu createMenu() {
        return this.createMenu(false);
    }

    public JMenu createMenu(boolean inPopup) {
        return SwingUtil.createMenu(RESOURCES, "pages", !inPopup);
    }

    static {
        RESOURCES = BasicActions.getResourceBundle(DispOptsActions.class.getName());
        COLOR_SCHEME_NAMES = new Hashtable();
        String[] cs = MStringTokenizer.getStringArrayRC("colorSchemeLabels", RESOURCES);
        for (int i = 0; i < COLOR_SCHEMES.length; ++i) {
            COLOR_SCHEME_NAMES.put(COLOR_SCHEMES[i], cs[i]);
        }
    }
}

