/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;

public class MolButton
extends AbstractButton
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -1042182748993396025L;
    protected static final int ICONBLACK_ENABLED = -16777216;
    protected static final int ICONBLACK_DISABLED = 0x7F000000;
    public static final int LABEL = 1;
    public static final int NOHIDDEN3D = 2;
    public static final int ONESTATE = 0;
    public static final int TWOSTATE = 1;
    public static final int NOTOGGLE = 2;
    public static final int DOWN = 1;
    public static final int MOUSEOVER = 2;
    public static final int DISABLED = 4;
    public static Vector fontcache = new Vector();
    private boolean wasDownBeforePress;
    private static Random rnd = new Random();
    private Dimension reqsize = null;
    private int style = 0;
    private String[] descriptions = new String[2];
    private int state = 0;
    private int prevstate = -1;
    private int ptrx;
    private int ptry;
    private boolean dragged;
    private int downx;
    private int downy;
    private boolean msdown;
    private int[] crossX = new int[8];
    private boolean crossreq = false;
    private int cbsize = 0;
    private String[] label = new String[4];
    private String labelg;
    private int labelascent;
    private int labelwidth;
    private int labelheight;
    private boolean haslabel;
    private int behaviour = 0;
    private transient Image[] icons;
    private String[] iconData = new String[8];
    private Molecule theMolecule;
    private DPoint3 molcenter;
    private int[] iconleft = new int[4];
    private int[] icontop = new int[4];
    private int iconwidth;
    private int iconheight;
    private MolPainter painter = null;
    private boolean rotatable;
    private int rotdelay = -1;
    private double rotdphi;
    private long timetorotate;
    private boolean rotmode = false;
    private boolean rotshown;
    private boolean rotshown_lastmove;
    private double rotphi;
    private double rotphic;
    private double rotphi0;
    private transient CTransform3D transformMatrix = new CTransform3D();
    private static int depth = 2;

    public MolButton(String l) {
        if (l != null && l.length() == 0) {
            l = null;
        }
        this.label[3] = this.labelg = l;
        this.label[2] = this.labelg;
        this.label[1] = this.labelg;
        this.label[0] = this.labelg;
        this.haslabel = l != null;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.initTransient();
        this.setModel(new JToggleButton.ToggleButtonModel());
    }

    public MolButton(String l, int b) {
        this(l);
        this.behaviour = b;
    }

    public final void setDescriptions(String d0, String d1) {
        this.descriptions[0] = d0;
        this.descriptions[1] = d1;
    }

    @Override
    public final void setBackground(Color c) {
        super.setBackground(c);
        MolPainter p = this.painter;
        if (p != null) {
            p.setBackground(c);
            this.repaint();
        }
    }

    @Override
    public final void setFont(Font f) {
        super.setFont(f);
        this.geom();
    }

    public final void setStyle(int s) {
        this.style = s;
    }

    public final int getDispopts() {
        MolPainter p = this.painter;
        return p != null ? p.getCommon().getDispopts() : 0;
    }

    public final void setDispopts(int x, int mask) {
        MolPainter p = this.painter;
        if (p != null) {
            MolPainterCommon c = p.getCommon();
            int opts0 = c.getDispopts();
            c.setDispopts(x, mask);
            if (opts0 != c.getDispopts()) {
                this.repaint();
            }
        }
    }

    public final synchronized boolean hasIcon() {
        return this.icons[0] != null || this.theMolecule != null && this.painter != null;
    }

    public final int getBehavior() {
        return this.behaviour;
    }

    public final void setBehavior(int b) {
        this.behaviour = b;
    }

    @Override
    public final synchronized void setSelected(boolean v) {
        if ((this.style & 1) != 0 || (this.state & 1) != 0 == v) {
            return;
        }
        if (v) {
            this.doClick();
        } else {
            super.setSelected(v);
        }
        if (v) {
            this.state |= 1;
            this.mkCross();
        } else {
            this.state &= 0xFFFFFFFE;
        }
        if (this.state != this.prevstate) {
            this.repaint1();
        }
    }

    @Override
    public final boolean isEnabled() {
        return (this.state & 4) == 0;
    }

    @Override
    public final synchronized void setEnabled(boolean e) {
        this.state = e ? (this.state &= 0xFFFFFFFB) : (this.state |= 4);
        if (this.state != this.prevstate) {
            this.repaint1();
        }
    }

    @Override
    public final String getLabel() {
        return this.getText();
    }

    @Override
    public final void setLabel(String s) {
        this.setText(s);
    }

    @Override
    public final String getText() {
        return this.label[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setText(int state, String l) {
        boolean needinvalidate;
        MolButton molButton = this;
        synchronized (molButton) {
            if (l != null && l.length() == 0) {
                l = null;
            }
            this.label[state] = l;
            this.label[state | 2] = l;
            this.haslabel = this.label[0] != null || this.label[1] != null;
            int maxi = 0;
            int maxw = -1;
            Font f = this.getFont();
            if (f != null) {
                FontMetrics fm = this.getFontMetrics(f);
                for (int i = 0; i < this.label.length; ++i) {
                    int w;
                    String s = this.label[i];
                    if (s == null || (w = fm.stringWidth(s)) <= maxw) continue;
                    maxw = w;
                    maxi = i;
                }
            }
            if (this.label[maxi] != this.labelg) {
                this.labelg = this.label[maxi];
                needinvalidate = true;
            } else {
                needinvalidate = false;
            }
        }
        if (needinvalidate) {
            this.invalidate();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setText(String l) {
        MolButton molButton = this;
        synchronized (molButton) {
            if (l != null && l.length() == 0) {
                l = null;
            }
            this.label[3] = this.labelg = l;
            this.label[2] = this.labelg;
            this.label[1] = this.labelg;
            this.label[0] = this.labelg;
            this.haslabel = l != null;
        }
        this.invalidate();
        this.repaint();
    }

    public final synchronized String getDescription() {
        return (this.state & 1) == 0 || this.behaviour == 0 ? this.descriptions[0] : this.descriptions[1];
    }

    public final void setRotDelay(int t) {
        this.rotdelay = t;
    }

    public double getRotDiff() {
        return this.rotdphi;
    }

    public final void setRotDiff(double d) {
        this.rotatable = d != 0.0;
        this.rotdphi = d;
    }

    @Override
    public final synchronized Dimension getMinimumSize() {
        int d = 2 * depth;
        int w1 = 0;
        int h1 = 0;
        this.geom();
        if (this.haslabel) {
            w1 = this.labelwidth;
            h1 = this.labelheight;
        } else if (this.behaviour != 0 && !this.hasIcon()) {
            w1 = h1 = d + this.cbsize;
        }
        int w2 = 0;
        int h2 = 0;
        if (this.icons[0] != null) {
            w2 = this.icons[0].getWidth(null);
            h2 = this.icons[0].getHeight(null);
        } else if (this.theMolecule != null && this.painter != null) {
            Rectangle bounds = this.painter.getBounds();
            w2 = bounds.width;
            h2 = bounds.height;
        }
        int h = h1 + h2;
        if (h < this.labelheight) {
            h = this.labelheight;
        }
        return this.reqsize != null ? this.reqsize : new Dimension((w1 > w2 ? w1 : w2) + d, h + d);
    }

    public final synchronized void setReqSize(Dimension d) {
        this.reqsize = d;
    }

    public final void setIcon(Image ico) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = ico;
        }
    }

    public final synchronized void setIcons(String[] iconData) {
        int i;
        for (i = 0; i < iconData.length; ++i) {
            this.iconData[i] = iconData[i == 0 || iconData[i] != null ? i : 0];
        }
        for (i = iconData.length; i < 8; ++i) {
            this.iconData[i] = this.iconData[4];
        }
        this.initTransient();
    }

    public synchronized void setMol(Molecule m) {
        this.theMolecule = m;
        if (this.theMolecule != null) {
            this.molcenter = m.getGraphUnion().calcCenter();
            double dphi = 0.0;
            try {
                String s = m.getProperty("rotation.unit");
                if (s != null) {
                    dphi = Double.valueOf(s);
                    dphi *= Math.PI / 180;
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
            if (dphi > 1.0E-6) {
                this.setRotDiff(dphi);
            }
        }
    }

    public final MolPainter getPainter() {
        return this.painter;
    }

    public final synchronized void setPainter(MolPainter painter) {
        this.painter = painter;
        if (painter != null) {
            painter.setCentralized(true);
        }
    }

    public Molecule getMol() {
        return this.theMolecule;
    }

    @Override
    public final synchronized Dimension getPreferredSize() {
        return this.reqsize != null ? this.reqsize : this.getMinimumSize();
    }

    @Override
    public final void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public final void update(Graphics g) {
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        this.paint(g, width, height, depth);
    }

    public static void packParentWindow(JComponent p) {
        if (p != null) {
            p.revalidate();
        }
    }

    final void drawSurf(Graphics g, int width, int height) {
        int s = this.state;
        boolean h3d = (this.style & 2) == 0;
        boolean up = (s & 1) == 0;
        boolean mo = (s & 2) != 0;
        boolean realcb = this.behaviour != 0 && !this.hasIcon() && !this.haslabel;
        int d = 0;
        if (!((this.style & 1) != 0 || (s & 4) != 0 || h3d && up && !mo || realcb && (this.msdown || !mo))) {
            d = depth;
            int[] X = new int[4];
            int[] Y = new int[4];
            X[0] = 0;
            Y[0] = 0;
            X[1] = width;
            Y[1] = 0;
            X[2] = width - d;
            Y[2] = d;
            X[3] = d;
            Y[3] = d;
            Color color = g.getColor();
            Color brighter = color.brighter();
            Color darker = color.darker();
            g.setColor(realcb || up ? brighter : darker);
            g.fillPolygon(X, Y, 4);
            X[1] = 0;
            Y[1] = height;
            X[2] = d;
            Y[2] = height - d;
            g.fillPolygon(X, Y, 4);
            g.setColor(realcb || up ? darker : brighter);
            for (int i = 0; i < 4; ++i) {
                X[i] = width - X[i];
            }
            g.fillPolygon(X, Y, 4);
            X[3] = d;
            Y[3] = height - d;
            X[0] = 0;
            Y[0] = height;
            g.fillPolygon(X, Y, 4);
            g.setColor(color);
        }
        g.fillRect(d, d, width - 2 * d, height - 2 * d);
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        if ((this.state & 4) != 0 || (this.style & 1) != 0) {
            return;
        }
        this.evtc(e.getX(), e.getY());
        this.state |= 2;
        if (this.rotatable && !this.dragged) {
            this.timetorotate = e.getWhen() + (long)this.rotdelay;
        }
        if (this.rotshown) {
            this.rotshown = false;
            this.repaint();
        } else {
            this.repaint1();
        }
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        int y;
        int x = e != null ? e.getX() : 0;
        int n = y = e != null ? e.getY() : 0;
        if ((this.style & 1) != 0) {
            return;
        }
        this.evtc(x, y);
        this.state &= 0xFFFFFFFD;
        if (this.rotmode && !this.dragged) {
            this.rotmode = false;
        }
        if (this.rotshown) {
            this.rotshown = false;
            this.repaint();
        } else {
            this.repaint1();
        }
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        int mod = ev.getModifiers();
        if (mod == 16) {
            this.msdown = true;
            if ((this.state & 4) != 0 || (this.style & 1) != 0) {
                return;
            }
            this.evtc(ev.getX(), ev.getY());
            this.wasDownBeforePress = this.isSelected();
            this.setSelected(true);
            this.downx = this.ptrx;
            this.downy = this.ptry;
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        int mod = ev.getModifiers();
        if (mod == 16) {
            this.msdown = false;
            if ((this.style & 1) != 0) {
                return;
            }
            this.evtc(ev.getX(), ev.getY());
            if ((this.behaviour == 0 || !this.rotshown_lastmove && !this.dragged) && (this.behaviour == 0 || this.wasDownBeforePress && this.behaviour != 2)) {
                this.setSelected(false);
            }
            this.dragged = false;
            this.rotmode = false;
            this.timetorotate = ev.getWhen() + (long)this.rotdelay;
            this.rotshown_lastmove = false;
            if (this.rotshown) {
                this.rotshown = false;
                this.repaint();
            } else {
                this.repaint1();
            }
        }
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        if ((this.state & 4) != 0 || (this.style & 1) != 0) {
            return;
        }
        this.evtc(e.getX(), e.getY());
        if (e.getWhen() < this.timetorotate || this.rotdelay < 0 || !this.isSelected()) {
            // empty if block
        }
        this.dragged = false;
    }

    @Override
    public final void mouseDragged(MouseEvent ev) {
        int mod = ev.getModifiers();
        if (mod == 16) {
            if ((this.state & 4) != 0 || (this.style & 1) != 0) {
                return;
            }
            this.evtc(ev.getX(), ev.getY());
            if (this.ptrx == this.downx && this.ptry == this.downy) {
                return;
            }
            this.dragged = true;
            this.rot();
            this.rotshown_lastmove = this.rotshown;
        }
    }

    protected void paint(Graphics g, int width, int height, int depth) {
        Serializable p;
        boolean realcb;
        int w = width - (depth << 1);
        int h = height - (depth << 1);
        boolean hasicon = this.hasIcon();
        boolean bl = realcb = this.behaviour != 0 && !hasicon && !this.haslabel;
        if (w <= 0 || h <= 0) {
            return;
        }
        this.geom();
        int i = this.state;
        boolean enabled = (i & 4) == 0;
        Color surfcolor = this.getBackground();
        if ((this.style & 1) == 0 && !realcb) {
            if (i == 1) {
                surfcolor = MolButton.brighter(surfcolor, 0.83);
            } else if ((this.style & 2) != 0 && i == 2) {
                surfcolor = MolButton.brighter(surfcolor, 1.2);
            }
        }
        Color darkerthanbg = surfcolor.darker();
        g.setFont(this.getFont());
        g.setColor(surfcolor);
        this.drawSurf(g, width, height);
        this.iconleft[i &= 3] = this.icontop[i] = depth;
        this.iconwidth = w;
        this.iconheight = h;
        if (this.haslabel) {
            g.setColor(enabled ? Color.black : darkerthanbg);
            int y = depth + this.labelascent;
            if (!hasicon) {
                y += (h - this.labelheight) / 2;
            }
            FontMetrics fm = g.getFontMetrics(this.getFont());
            if (this.label[i] != null) {
                StringTokenizer st = new StringTokenizer(this.label[i], "\n");
                while (st.hasMoreTokens()) {
                    LayoutManager lm;
                    String s = st.nextToken();
                    int lw = fm.stringWidth(s);
                    int x = depth;
                    int anchor = 10;
                    p = this.getParent();
                    if (p != null && (lm = p.getLayout()) != null && lm instanceof GridBagLayout) {
                        GridBagLayout gbl = (GridBagLayout)lm;
                        anchor = gbl.getConstraints((Component)this).anchor;
                    }
                    if ((this.style & 1) == 0 || anchor == 11 || anchor == 15 || anchor == 10) {
                        x += (this.iconwidth - lw) / 2;
                    } else if (anchor == 13 || anchor == 12 || anchor == 14) {
                        x += this.iconwidth - lw;
                    }
                    g.drawString(s, x, y);
                    y += fm.getAscent() + fm.getDescent();
                }
            }
            int n = i;
            this.icontop[n] = this.icontop[n] + this.labelheight;
            this.iconheight -= this.labelheight;
        }
        if (realcb) {
            g.setColor(enabled ? Color.black : darkerthanbg);
            g.drawRect(depth << 1, depth << 1, this.cbsize - 1, this.cbsize - 1);
            if ((i & 1) != 0) {
                if (enabled) {
                    g.setColor(Color.blue);
                }
                g.drawLine(this.crossX[0], this.crossX[1], this.crossX[4], this.crossX[5]);
                g.drawLine(this.crossX[6], this.crossX[2], this.crossX[3], this.crossX[7]);
            }
        }
        if (hasicon) {
            g = g.create(this.iconleft[i], this.icontop[i], this.iconwidth, this.iconheight);
            Molecule mol = this.getMol();
            if (this.icons[this.state] != null) {
                Image img = this.icons[this.state];
                int wi = img.getWidth(null);
                int hi = img.getHeight(null);
                g.drawImage(img, (this.iconwidth - wi) / 2, (this.iconheight - hi) / 2, null);
            } else if (mol != null && this.painter != null) {
                Rectangle bounds = this.painter.getBounds();
                this.painter.setScreen(new Dimension(this.iconwidth, this.iconheight));
                if (bounds.height > this.iconheight || bounds.width > this.iconwidth) {
                    double hscale = bounds.height > this.iconheight ? 1.0 * (double)this.iconheight / (double)bounds.height : 1.0;
                    this.painter.setScale(this.painter.getScale() * hscale);
                    double wscale = (double)bounds.width * hscale > (double)this.iconwidth ? 1.0 * (double)this.iconwidth / ((double)bounds.width * hscale) : 1.0;
                    this.painter.setScale(this.painter.getScale() * wscale);
                }
                if (this.rotshown) {
                    int r = this.iconwidth > this.iconheight ? this.iconwidth : this.iconheight;
                    g.setColor(darkerthanbg);
                    double q = 57.29577951308232;
                    for (double f = this.rotphic; f < Math.PI * 2 + this.rotphic; f += 2.0 * this.rotdphi) {
                        p = this.painter.calcGP(this.molcenter.x, this.molcenter.y, this.molcenter.z);
                        g.fillArc(((Point)p).x - r, ((Point)p).y - r, 2 * r, 2 * r, (int)(f * q), (int)(this.rotdphi * q));
                    }
                }
                this.painter.setBackground(surfcolor);
                MDocument doc = mol.getDocument();
                if (doc != null) {
                    this.painter.paintDocument((Graphics2D)g, doc, null);
                } else {
                    this.painter.paintMolecule((Graphics2D)g, mol);
                }
                if (!this.isEnabled()) {
                    Color c = this.getBackground();
                    c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 180);
                    g.setColor(c);
                    g.translate(-(this.iconwidth - bounds.width) / 2, -(this.iconheight - bounds.height) / 2);
                    g.fillRect(0, 0, width, height);
                }
            }
            g.dispose();
        }
    }

    protected final void evtc(int x, int y) {
        int s = this.state & 3;
        this.ptrx = this.iconwidth / 2 - x + this.iconleft[s];
        this.ptry = this.iconheight / 2 - y + this.icontop[s];
    }

    protected void transformMol(CTransform3D t) {
        this.theMolecule.transform(t);
    }

    private void repaint1() {
        this.repaint();
        this.prevstate = this.state;
    }

    private void rot() {
        double phi = Math.atan2(-this.ptry, this.ptrx);
        int r = (int)(Math.sqrt((double)this.ptrx * (double)this.ptrx + (double)this.ptry * (double)this.ptry) + 0.5);
        if (!this.rotatable || r < this.iconwidth / 4) {
            return;
        }
        if (this.rotmode) {
            double pi2 = Math.PI * 2;
            double min = this.rotdphi / 2.0;
            this.rotphic = phi + this.rotphi - this.rotphi0;
            double q = (this.rotphic - this.rotphi) / this.rotdphi;
            double d = Math.IEEEremainder(this.rotdphi * (double)Math.round(q), pi2);
            if (d > Math.PI) {
                d -= pi2;
            } else if (d <= -Math.PI) {
                d += pi2;
            }
            if (d > min || d < -min) {
                this.transformMatrix.setRotation(0.0, 0.0, 1.0, d);
                this.transformMatrix.setRotationCenter(this.molcenter);
                this.transformMol(this.transformMatrix);
                this.rotphi = Math.IEEEremainder(this.rotphi + d, pi2);
                if (this.rotphi > Math.PI) {
                    this.rotphi -= pi2;
                } else if (this.rotphi <= -Math.PI) {
                    this.rotphi += pi2;
                }
                this.rotphi0 += d;
            }
            this.rotshown = true;
            this.repaint();
        } else {
            this.rotmode = true;
            this.rotshown = false;
            this.rotphi0 = phi;
            this.rotphic = this.rotphi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void geom() {
        int h;
        Font font = this.getFont();
        FontMetrics fm = this.getFontMetrics(font);
        int asc = fm.getAscent();
        if (asc == 0 && font.getFamily().equals("sansserif")) {
            Vector vector = fontcache;
            synchronized (vector) {
                Font found = null;
                for (int i = 0; i < fontcache.size() && found == null; ++i) {
                    Font f = (Font)fontcache.elementAt(i);
                    if (!f.getName().toLowerCase().equals("serif") || f.getStyle() != font.getStyle() || f.getSize() != font.getSize()) continue;
                    found = f;
                }
                if (found != null) {
                    font = found;
                } else {
                    font = new Font("Serif", font.getStyle(), font.getSize());
                    fontcache.addElement(font);
                }
            }
            super.setFont(font);
            fm = this.getFontMetrics(font);
            asc = fm.getAscent();
        }
        int rows = 0;
        if (this.labelg != null) {
            this.labelascent = asc;
            this.labelwidth = 0;
            StringTokenizer st = new StringTokenizer(this.labelg, "\n");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                int w = fm.stringWidth(s);
                if (w > this.labelwidth) {
                    this.labelwidth = w;
                }
                ++rows;
            }
        }
        if (rows == 0) {
            rows = 1;
        }
        this.labelheight = h = (asc + fm.getDescent()) * rows + 1;
        this.cbsize = h - (depth << 1);
        if (this.crossreq) {
            this.mkCross();
        }
    }

    private synchronized void mkCross() {
        if (this.cbsize == 0) {
            this.crossreq = true;
        } else {
            int d = depth;
            int l = d + this.cbsize;
            for (int i = 0; i < 8; ++i) {
                this.crossX[i] = d + rnd.nextInt() % d;
                if (i < 4) continue;
                int n = i;
                this.crossX[n] = this.crossX[n] + l;
            }
            this.crossreq = false;
        }
    }

    private static Color brighter(Color c, double f) {
        return new Color(Math.min((int)((double)c.getRed() * f), 255), Math.min((int)((double)c.getGreen() * f), 255), Math.min((int)((double)c.getBlue() * f), 255));
    }

    public static Dimension paintSize(Dimension dim) {
        int d = 2 * depth;
        int w = dim.width > d ? dim.width - d : 0;
        int h = dim.height > d ? dim.height - d : 0;
        return new Dimension(w, h);
    }

    private void initTransient() {
        this.icons = new Image[8];
        for (int i = 0; i < this.iconData.length; ++i) {
            Image icon = null;
            if (this.iconData[i] != null) {
                icon = this.mkImg(this.iconData[i], (i & 4) == 0 ? -16777216 : 0x7F000000);
            }
            this.icons[i] = icon;
        }
        this.transformMatrix = new CTransform3D();
    }

    protected final Image mkImg(String s, int black) {
        int nx;
        switch (s.length()) {
            case 15: {
                nx = 9;
                break;
            }
            case 25: {
                nx = 12;
                break;
            }
            default: {
                nx = 20;
            }
        }
        int n = nx * nx;
        int[] bm = new int[n];
        int[] colors = new int[4];
        int bpp = s.charAt(0) - 48;
        int ppc = 6 / bpp;
        int mask = (1 << bpp) - 1;
        colors[0] = 0xFFFFFF;
        colors[1] = black;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i / ppc + 1);
            int z = c == '+' ? 62 : (c == '-' ? 63 : (c >= 'a' ? c - 97 + 36 : (c >= 'A' ? c - 65 + 10 : c - 48)));
            int ci = z >> bpp * (i % ppc) & mask;
            bm[i] = colors[ci];
        }
        MemoryImageSource mis = new MemoryImageSource(nx, nx, bm, 0, nx);
        return this.createImage(mis);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initTransient();
    }
}

