/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.common.util.ColorParser;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.license.LicenseManager;
import chemaxon.license.LicenseManagerGUI;
import chemaxon.license.LicenseThread;
import chemaxon.marvin.common.MDocPasteListener;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.AboutDialog;
import chemaxon.marvin.common.swing.DispOptsActions;
import chemaxon.marvin.common.swing.MenuBarChangeListener;
import chemaxon.marvin.common.swing.SwingErrorDisplay;
import chemaxon.marvin.common.swing.modules.LoadSave;
import chemaxon.marvin.common.swing.spi.PreferencesDialogProvider;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.cml.MrvExport;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.paint.DispOptConsts;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.services.ServiceDescriptor;
import chemaxon.marvin.services.ServiceDescriptorReader;
import chemaxon.marvin.services.ServiceDescriptorTools;
import chemaxon.marvin.services.ServiceDescriptorWriter;
import chemaxon.marvin.services.ServiceDialogProvider;
import chemaxon.marvin.swing.DelegatingAction;
import chemaxon.marvin.swing.SaveImageTool;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.ErrorDisplay;
import chemaxon.marvin.util.ExternalFileLoader;
import chemaxon.marvin.util.HourglassHandler;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.MolLoader;
import chemaxon.marvin.util.ParentPanelIface;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.util.text.EncodingUtil;
import chemaxon.marvin.util.text.LocaleUtil;
import chemaxon.marvin.util.text.MStringTokenizer;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.prop.MBooleanProp;
import chemaxon.struc.prop.MDoubleProp;
import chemaxon.struc.prop.MFontProp;
import chemaxon.struc.prop.MIntegerProp;
import chemaxon.struc.prop.MStringProp;
import chemaxon.util.ImageExportUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class MolPanel
extends JPanel
implements DispOptConsts,
HourglassHandler,
CallbackIface,
KeyListener,
ActionListener,
PropertyChangeListener,
ParentPanelIface,
MolLoader.Handler {
    private static final long serialVersionUID = 2223718788339149423L;
    public static final String mver = VersionInfo.MARVIN_VERSION;
    public static final int HELP_CONTENTS = 0;
    public static final int HELP_QUICKHELP = 1;
    public static final int HELP_LICENSES = 2;
    public static final int HELP_ABOUTJVM = 4;
    public static final int LS_FILE = 0;
    public static final int LS_FMT = 1;
    public static final int LS_CMD = 2;
    public static final int LS_MOL = 3;
    public static final int LS_MOLCOUNT = 4;
    public static final ResourceBundle GRESOURCES;
    private static Font normalFont;
    private static Font smallFont;
    private transient Object molPanelLock;
    private static boolean isPluginsConfigExists;
    private boolean writeEnabled = true;
    private boolean popupMenusEnabled = true;
    private transient JMenu toolsMenu = null;
    private transient JMenu servicesMenu = null;
    public boolean experimentalEnabled = false;
    private int cleanDim = 2;
    public final MolPainterCommon painterCommon = new MolPainterCommon();
    private Color molbg;
    protected boolean colorSchemeChangedFromGUI = false;
    public PropertyChangeSupport changeListeners = null;
    protected List<MDocPasteListener> pasteListeners = new ArrayList<MDocPasteListener>();
    protected int initlevel = 0;
    protected JApplet applet = null;
    protected ErrorDisplay errorDisplay;
    protected CallbackIface helpModule = null;
    protected boolean javaHelpRequested = false;
    protected boolean autoScale = false;
    protected double bondFudge = 1.12;
    protected boolean guessBonds = false;
    protected int[] maxBonds = new int[256];
    protected Vector<MenuBarChangeListener> menuBarChangeListeners = new Vector();
    protected List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    protected URL defaultHelpURL = null;
    protected URL defaultQuickHelpURL = null;
    protected transient boolean isSavedBeforeExit = false;
    private MolPanel parentMolPanel;
    private transient List<MolLoader> loaders;
    private int autoAromatize = 0;
    private int autoHydrogenize = 0;
    private boolean autoClean = false;
    private Properties properties = new Properties();
    protected UserSettings userSettings;
    private boolean loadingEnabled = true;
    private int debug = 0;
    private String molFormat = "DEFAULT";
    private CallbackIface edsrcwin = null;
    private File moleculeFile = null;
    private File moleculeDirectory = null;
    private SaveImageTool saveImageTool;
    private boolean saveIniEnabled = false;
    private transient CallbackIface loadsave = null;
    private transient CallbackIface multiMoleculeSave = null;
    protected transient MPropertyContainer globalGUIProperties;
    private ServiceDescriptorReader serviceDescriptorReader = null;
    private ServiceDescriptorWriter serviceDescriptorWriter = null;
    private ServiceDialogProvider serviceDialogProvider = null;
    private Map<Window, Integer> vframes = new HashMap<Window, Integer>();
    private Map<String, Molecule[]> molCache = new Hashtable<String, Molecule[]>();
    private boolean cacheMols = false;
    private Cursor cursor = null;
    protected final Cursor[] navmodeCursors;
    private int waitcount = 0;
    private double animFPS;
    private double animDelay;
    private transient CallbackIface pluginManager = null;
    protected transient DelegatingAction[] pluginActions;
    protected transient String[] pluginGroups;
    protected transient char[] pluginGroupMnemonics;
    protected transient boolean[] pluginSeparators;
    protected transient MarvinModule jscripter = null;
    private char escapeChar = '\u0000';
    private boolean printEnabled = true;
    private static boolean pluginConfigChecked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pluginConfigCheck() {
        Class<MolPanel> clazz = MolPanel.class;
        synchronized (MolPanel.class) {
            if (pluginConfigChecked) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            pluginConfigChecked = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            InputStream is = null;
            ExternalFileLoader ppLoader = new ExternalFileLoader("plugins/plugins.properties");
            is = ppLoader.openFileOutJar();
            if (is == null) {
                is = BasicEnvironment.getResourceAsStream(MolPanel.class, "/xjars/plugins.properties");
            }
            if (is != null) {
                try {
                    is.close();
                    isPluginsConfigExists = true;
                }
                catch (IOException e) {
                    System.err.println("Error reading plugin configuration:\n/xjars/plugins.properties.");
                }
            }
            return;
        }
    }

    public MolPanel(Component parent, UserSettings settings) {
        int i;
        this.molbg = Color.WHITE;
        this.userSettings = settings;
        if (parent == null || parent instanceof JApplet) {
            this.parentMolPanel = null;
            this.applet = (JApplet)parent;
            if (settings == null) {
                this.userSettings = new UserSettings();
            }
            this.userSettings.addOwner(this);
            if (this.applet != null) {
                String s = this.getParameter("disablePluginsLookup");
                if (s != null && s.equals("true")) {
                    pluginConfigChecked = true;
                }
                if ((s = this.getParameter("defaultDatatransferPolicy")) != null && s.equals("true")) {
                    Environment.setUseDefaultDatatransferConfig(true);
                }
            }
        } else if (parent instanceof MolPanel) {
            this.parentMolPanel = (MolPanel)parent;
            this.applet = this.parentMolPanel.getApplet();
            if (settings == null) {
                this.userSettings = this.parentMolPanel.userSettings;
            }
            this.userSettings.addPropertyChangeListener(this);
        }
        MolPanel.pluginConfigCheck();
        this.errorDisplay = new SwingErrorDisplay(this, this.applet, this);
        Set<String> e = this.userSettings.getPropertyMap("persistent").keySet();
        for (String key : e) {
            this.properties.put(key.toLowerCase(), this.userSettings.getProperty(key));
        }
        this.cursor = Cursor.getPredefinedCursor(0);
        for (i = 0; i < this.maxBonds.length; ++i) {
            this.maxBonds[i] = Integer.MAX_VALUE;
        }
        if (this.saveImageTool == null) {
            this.saveImageTool = new SaveImageTool(this, this, this);
        }
        this.initActions();
        this.initTransient();
        this.navmodeCursors = new Cursor[8];
        this.navmodeCursors[0] = Cursor.getPredefinedCursor(0);
        for (i = 1; i < this.navmodeCursors.length; ++i) {
            this.navmodeCursors[i] = this.navmodeCursors[0];
        }
        this.navmodeCursors[1] = this.loadCursor("zoom_32x32.png");
        this.navmodeCursors[4] = this.loadCursor("zoomrot_32x32.png");
        this.navmodeCursors[3] = this.loadCursor("rot3d_32x32.png");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("file".equals(evt.getPropertyName()) && evt.getNewValue() instanceof File) {
                    MolPanel.this.addRecentFileToUserSettings((File)evt.getNewValue());
                }
            }
        });
        ClipboardHandler.setWorkOnBackground(true);
        if (this.applet == null) {
            ClipboardHandler.startPermanentResources();
        }
    }

    public boolean isParentWindowDialog() {
        return SwingUtilities.getWindowAncestor(this) instanceof Dialog;
    }

    public Dialog getParentDialog() {
        Window owner = SwingUtilities.getWindowAncestor(this);
        return owner instanceof Dialog ? (Dialog)owner : null;
    }

    public Frame getParentFrame() {
        Window owner = SwingUtilities.getWindowAncestor(this);
        return owner instanceof Frame ? (Frame)owner : null;
    }

    protected Cursor loadCursor(String name) {
        URL u = this.getClass().getResource("/chemaxon/marvin/common/images/" + name);
        Toolkit tk = this.getToolkit();
        Image im = tk.getImage(u);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(im, 0);
        try {
            mt.waitForAll();
            return tk.createCustomCursor(im, new Point(0, 0), "custom");
        }
        catch (Exception ex) {
            if (this.debug > 0) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public MolPanel getParentMolPanel() {
        return this.parentMolPanel;
    }

    public abstract String getAppletInfo();

    public void init() {
        this.init(this.initlevel);
    }

    public void init(int level) {
        Throwable ex = null;
        if (level == 0) {
            this.createVecs();
            ((Component)this).setFont(normalFont);
            String s = this.getParameter("debug");
            if (s != null) {
                int d = Integer.parseInt(s);
                this.setDebug(d);
            }
        }
        String msg = null;
        try {
            switch (level) {
                case 0: {
                    if (this.debug != 0) {
                        String classname = this.getClass().getName();
                        classname = classname.substring(classname.lastIndexOf(".") + 1);
                        System.err.println("INIT " + classname);
                    }
                    this.molInit();
                    this.checkRead();
                    this.checkWrite();
                    break;
                }
                case 1: {
                    if (this.debug != 0) {
                        String classname = this.getClass().getName();
                        classname = classname.substring(classname.lastIndexOf(".") + 1);
                        System.err.println("START " + classname);
                    }
                    this.molStart();
                }
            }
        }
        catch (NumberFormatException e) {
            msg = "cannot read an applet parameter: \"".concat(e.getMessage()).concat("\" is not a number");
            ex = e;
        }
        catch (Throwable e) {
            ex = e;
        }
        if (ex != null) {
            this.removeAll();
            this.errorDisplay.error(msg, ex);
        }
        this.initlevel = level + 1;
    }

    public Object getMolPanelLock() {
        if (this.molPanelLock == null) {
            this.molPanelLock = new Object();
        }
        return this.molPanelLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startstop(boolean stopped) {
        String s;
        if (!stopped && (s = this.getParameter("loadMols")) != null) {
            MStringTokenizer mst = new MStringTokenizer(s, ',', '\u0000');
            int id = 196608;
            while ((s = mst.trimNextToken()) != null) {
                if (!this.molCache.containsKey(s)) {
                    this.startLoader(s, null, id, false);
                }
                ++id;
            }
        }
        Map<Window, Integer> map = this.vframes;
        synchronized (map) {
            this.removeDeadWindows();
            Window[] windows = this.vframes.keySet().toArray(new Window[this.vframes.keySet().size()]);
            for (int j = 0; j < windows.length; ++j) {
                Window f = windows[j];
                Integer iobj = this.vframes.get(f);
                int i = iobj;
                i = stopped ? --i : ++i;
                if (i > 1) {
                    i = 1;
                }
                if (i == 1) {
                    this.showWindow(f);
                    continue;
                }
                this.vframes.put(f, new Integer(i));
                f.setVisible(false);
                f.dispose();
            }
        }
    }

    private void removeDeadWindows() {
        Window parent = SwingUtilities.getWindowAncestor(this);
        HashSet<Window> ownedWindows = null;
        if (parent != null) {
            ownedWindows = new HashSet<Window>(Arrays.asList(parent.getOwnedWindows()));
        }
        Window[] windows = this.vframes.keySet().toArray(new Window[this.vframes.keySet().size()]);
        for (int j = 0; j < windows.length; ++j) {
            Window f = windows[j];
            if (ownedWindows == null || f == parent || ownedWindows.contains(f)) continue;
            this.unregWindow(f);
        }
    }

    public void closeWindows() {
        this.unregWindows();
    }

    public boolean isLoadingEnabled() {
        return this.loadingEnabled;
    }

    public void setLoadingEnabled(boolean v) {
        this.loadingEnabled = v;
    }

    public boolean isExitCanceled() {
        return false;
    }

    public void destroy() {
        this.errorDisplay = null;
        this.closeWindows();
        this.userSettings.removeOwner(this);
    }

    public void exit() {
        this.exit(true);
    }

    public void exit(boolean destroy) {
        if (this.applet == null) {
            try {
                this.userSettings.save("Marvin parameters");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.pluginManager != null) {
            this.pluginManager.callback("saveParameterSettings", null);
        }
        if (destroy) {
            this.destroy();
        }
        if (this.parentMolPanel == null && (this.applet == null || destroy)) {
            ClipboardHandler.releasePermanentResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void unregWindows() {
        Map<Window, Integer> map = this.vframes;
        synchronized (map) {
            for (Window f : this.vframes.keySet()) {
                this.disposeFrame(f);
            }
            this.vframes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unregWindow(Window f) {
        Map<Window, Integer> map = this.vframes;
        synchronized (map) {
            this.vframes.remove(f);
        }
        this.disposeFrame(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void showWindow(Window f) {
        Map<Window, Integer> map = this.vframes;
        synchronized (map) {
            this.vframes.put(f, new Integer(1));
        }
        if (f instanceof Frame) {
            ((Frame)f).setState(0);
        }
        f.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void hideWindow(Window f) {
        if (f != null) {
            Map<Window, Integer> map = this.vframes;
            synchronized (map) {
                this.vframes.put(f, new Integer(0));
            }
            f.setVisible(false);
            f.dispose();
        }
    }

    public final JApplet getApplet() {
        return this.applet;
    }

    public void setProperties(Properties p) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.properties.put(key.toLowerCase(), p.getProperty(key));
        }
        this.init(0);
    }

    public final Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    public final String getParameter(String key) {
        StringTokenizer st = new StringTokenizer(key, "|");
        while (st.hasMoreTokens()) {
            key = st.nextToken();
            String lckey = key.toLowerCase();
            String s = this.properties.getProperty(lckey);
            if (s == null && this.applet != null) {
                if (this.parentMolPanel != null && (lckey.equals("mol") || lckey.startsWith("cell"))) {
                    return null;
                }
                s = this.applet.getParameter(lckey);
            }
            if (s == null) {
                s = this.userSettings.getProperty(key);
            }
            if (s == null) continue;
            String ss = EncodingUtil.decodeJs(s);
            char esc = this.escapeChar;
            if (ss == s && esc != '\u0000') {
                MStringTokenizer mst = new MStringTokenizer(ss, '\u0000', esc);
                ss = mst.nextToken();
            }
            return ss;
        }
        return null;
    }

    public void firePropertyChangeEvent(String name, Object oldval, Object newval) {
        if (this.changeListeners != null) {
            this.changeListeners.firePropertyChange(name, oldval, newval);
        }
    }

    private void forwardPropertyChangeEvent(PropertyChangeEvent evt) {
        PropertyChangeListener[] listeners = this.changeListeners.getPropertyChangeListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (listeners[i] == this) continue;
            listeners[i].propertyChange(evt);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.createVecs();
        super.addPropertyChangeListener(l);
        this.changeListeners.addPropertyChangeListener(l);
        if (this.saveImageTool == null) {
            this.saveImageTool = new SaveImageTool(this, this, this);
        }
        this.saveImageTool.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        this.createVecs();
        this.changeListeners.removePropertyChangeListener(l);
        this.userSettings.removePropertyChangeListener(l);
    }

    public static void setPopupHeavyWeight(Component c) {
        JPopupMenu p = null;
        if (c instanceof JPopupMenu) {
            p = (JPopupMenu)c;
        } else if (c instanceof JMenu) {
            p = ((JMenu)c).getPopupMenu();
        }
        if (p != null) {
            p.setLightWeightPopupEnabled(false);
            for (int i = 0; i < p.getComponentCount(); ++i) {
                MolPanel.setPopupHeavyWeight(p.getComponent(i));
            }
        }
    }

    public void addMenuBarChangeListener(MenuBarChangeListener l) {
        if (this.menuBarChangeListeners.contains(l)) {
            return;
        }
        this.menuBarChangeListeners.addElement(l);
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListeners.contains(l)) {
            return;
        }
        this.actionListeners.add(l);
        this.addActionListenerToPluginActions(l);
    }

    private void addActionListenerToPluginActions(ActionListener l) {
        if (this.pluginActions != null) {
            for (int i = 0; i < this.pluginActions.length; ++i) {
                this.pluginActions[i].addActionListener(l);
            }
        }
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
        if (this.pluginActions != null) {
            for (int i = 0; i < this.pluginActions.length; ++i) {
                this.pluginActions[i].removeActionListener(l);
            }
        }
    }

    public void addPasteListener(MDocPasteListener l) {
        if (this.pasteListeners.contains(l)) {
            return;
        }
        this.pasteListeners.add(l);
    }

    public void removePasteListener(MDocPasteListener l) {
        this.pasteListeners.remove(l);
    }

    @Override
    public void setBackground(Color c) {
        Color old = super.getBackground();
        super.setBackground(c);
        this.changeProperty("background", ColorParser.toString(c));
        if (this.changeListeners != null) {
            this.changeListeners.firePropertyChange("background", old, c);
        }
        if (old == null && c != null || old != null && c == null || old != null && c != null && !c.equals(old)) {
            this.repaintMols();
        }
    }

    public abstract int getMolCount();

    public abstract void updateBounds();

    public abstract MDocument getDocument(int var1);

    public abstract void repaintMolComponent(int var1);

    public abstract String getHelpSetLocation();

    protected abstract String getHelpPropertyName();

    protected abstract String getQuickHelpPropertyName();

    public Color getMolbg() {
        return this.molbg;
    }

    public void setMolbg(Color c) {
        Color old = this.molbg;
        this.molbg = c;
        if (this.changeListeners != null) {
            this.changeListeners.firePropertyChange("molbg", old, c);
        }
        if (old == null || !c.equals(old)) {
            this.repaintMols();
        }
    }

    public final void setSketchMolbg2d(Color c) {
        this.changeProperty("sketchMolbg2d", ColorParser.toString(c));
        this.userSettings.setSketchMolbg2d(c);
    }

    public final void setSketchMolbg3d(Color c) {
        this.changeProperty("sketchMolbg3d", ColorParser.toString(c));
        this.userSettings.setSketchMolbg3d(c);
    }

    public final void setViewMolbg2d(Color c) {
        this.changeProperty("viewMolbg2d", ColorParser.toString(c));
        this.userSettings.setViewMolbg2d(c);
    }

    public final void setViewMolbg3d(Color c) {
        this.changeProperty("viewMolbg3d", ColorParser.toString(c));
        this.userSettings.setViewMolbg3d(c);
    }

    public abstract void addRecentFileToUserSettings(File var1);

    public abstract void setSaveCwdToUserSettings(File var1);

    public abstract void setLoadCwdToUserSettings(File var1);

    public abstract File getSaveCwdFromUserSettings();

    public abstract File getLoadCwdFromUserSettings();

    public abstract Color getDefaultMolbg();

    public abstract void setDefaultMolbg(Color var1);

    public int getDispopts() {
        return this.painterCommon.getDispopts();
    }

    public void setDispopts(int opts, boolean save, boolean setmenus) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setDispopts(opts);
        if (save) {
            this.changeUserDispoptsProperties(opts0, opts);
        }
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
        if ((opts0 & 0x38) != (opts & 0x38)) {
            this.initCursor();
        }
    }

    public String getImplicitH() {
        return this.painterCommon.getImplicitH();
    }

    public boolean isImplicitHEnabled() {
        return this.painterCommon.isImplicitHEnabled();
    }

    public void setSketchImplicitH(String s) {
        MolPainterCommon.getImplicitHFlagsOf(s);
        this.changeProperty("sketchImplicitH", s);
        this.userSettings.setSketchImplicitH(s);
    }

    public void setViewImplicitH(String s) {
        MolPainterCommon.getImplicitHFlagsOf(s);
        this.changeProperty("viewImplicitH", s);
        this.userSettings.setViewImplicitH(s);
    }

    protected abstract String getDefaultImplicitHPropertyName();

    public abstract String getDefaultImplicitH();

    public abstract void setDefaultImplicitH(String var1);

    public String getAnyBond() {
        return this.painterCommon.getAnyBond();
    }

    public void setAnyBond(String s) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setAnyBond(s);
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
    }

    public void setSketchAnyBond(String s) {
        MolPainterCommon.getAnyBondFlagsOf(s);
        this.changeProperty("sketchAnyBond", s);
        this.userSettings.setSketchAnyBond(s);
    }

    public void setViewAnyBond(String s) {
        MolPainterCommon.getAnyBondFlagsOf(s);
        this.changeProperty("viewAnyBond", s);
        this.userSettings.setViewAnyBond(s);
    }

    public abstract String getDefaultAnyBond();

    public abstract String getDefaultAnyBondPropertyName();

    public abstract void setCarbonVisibility(String var1);

    public abstract String getCarbonVisibility();

    public String getDefaultCarbonVisibility() {
        return "inChain";
    }

    public String getDefaultLigandOrderVisibility() {
        return "off";
    }

    public abstract String getDefaultLigandOrderVisibilityPropertyName();

    public abstract String getDefaultCarbonVisibilityPropertyName();

    public boolean isAtomSetVisible(int i) {
        return (this.painterCommon.invisibleSets & (long)(1 << i)) == 0L;
    }

    public void setAtomSetVisible(int i, boolean v) {
        long sets = this.painterCommon.invisibleSets;
        int f = 1 << i;
        sets = v ? sets & (long)(~f) : sets | (long)f;
        this.setInvisibleSets(sets);
    }

    public long getInvisibleSets() {
        return this.painterCommon.invisibleSets;
    }

    public void setInvisibleSets(long v) {
        long old = this.painterCommon.invisibleSets;
        if (old != v) {
            this.painterCommon.invisibleSets = v;
            this.changeListeners.firePropertyChange("invisibleSets", new Long(old), new Long(v));
            this.repaintMols();
        }
    }

    public abstract Color getAtomSetColor(int var1);

    public void setAtomSetColor(int i, Color color) {
        if (this.painterCommon.setAtomSetColor(i, color)) {
            this.repaintMols();
        }
    }

    public void setBondSetColor(int i, Color color) {
        if (i < 1 || i > 63) {
            throw new IllegalArgumentException("invalid bond set sequence number " + i);
        }
        if (this.painterCommon.setBondSetColor(i, color)) {
            this.repaintMols();
        }
    }

    protected abstract void nextTransformMode();

    public void setAtomsize(double l) {
        this.userSettings.setAtomSize(l);
        this.changeProperty("atomsize", String.valueOf(l));
    }

    public double getBondSpacing() {
        return this.painterCommon.getBondSpacing();
    }

    public int getFogFactor() {
        return this.painterCommon.getFogFactor();
    }

    public boolean isAutomaticFogEnabled() {
        return this.painterCommon.isAutomaticFogEnabled();
    }

    public void setBondSpacing(double w) {
        this.painterCommon.setBondSpacing(w);
        this.userSettings.setBondSpacing(w);
        this.changeProperty("bondSpacing", String.valueOf(w));
    }

    public void setFogFactor(int w) {
        this.painterCommon.setFogFactor(w);
        this.userSettings.setFogFactor(w);
        this.changeProperty("fogFactor", String.valueOf(w));
    }

    public void setAutomaticFogEnabled(boolean w) {
        this.painterCommon.setAutomaticFogEnabled(w);
        this.userSettings.setAutomaticFogEnabled(w);
        this.changeProperty("automaticFogEnabled", String.valueOf(w));
    }

    public void setAtomFont(Font f) {
        this.painterCommon.setBaseFont(f);
        this.userSettings.setAtomFont(f);
        this.changeProperty("atomFont", f.getFamily());
    }

    public boolean getAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean as) {
        Boolean old = new Boolean(this.autoScale);
        this.autoScale = as;
        this.changeProperty("autoscale", String.valueOf(as));
        this.changeListeners.firePropertyChange("autoscale", old, new Boolean(as));
    }

    public void setWireThickness(double d) {
        this.painterCommon.setWireThickness(d);
        this.userSettings.setWireThickness(d);
        this.changeProperty("wireThickness", String.valueOf(d));
    }

    public void setStickThickness(double d) {
        this.painterCommon.setStickThickness(d);
        this.userSettings.setStickThickness(d);
        this.changeProperty("stickThickness", String.valueOf(d));
    }

    public double getBallRadius() {
        return this.painterCommon.getBallRadius();
    }

    public void setBallRadius(double r) {
        this.painterCommon.setBallRadius(r);
        this.userSettings.setBallRadius(r);
        this.changeProperty("ballRadius", String.valueOf(r));
    }

    public String getFormat() {
        return this.molFormat;
    }

    public void setFormat(String s) {
        this.createVecs();
        String old = this.molFormat;
        this.molFormat = s;
        this.changeProperty("format", s);
        this.molFormat = s;
        this.changeListeners.firePropertyChange("format", old, this.molFormat);
    }

    public int getChiralitySupport() {
        return this.painterCommon.getChiralitySupport();
    }

    public boolean isAtomSymbolsVisible() {
        return (this.painterCommon.getDispopts() & 0x400) != 0;
    }

    public void setAtomSymbolsVisible(boolean v) {
        int h = v ? 1024 : 0;
        this.setDispopts(this.painterCommon.getDispopts() & 0xFFFFFBFF | h, true, true);
        this.userSettings.setProperty("noAtomSymbols3D", String.valueOf(!v), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startLoader(String s, String fmtopts, long id, boolean script) {
        MolLoader l;
        block18: {
            InputStream in = null;
            if (s == null || s.trim().length() == 0) {
                return;
            }
            if (!script) {
                if (fmtopts == null) {
                    String[] result = MFileFormatUtil.splitFileAndOptions(s);
                    s = result[0];
                    fmtopts = result[1] == null ? "" : result[1];
                }
                in = this.tryToGetResource(s);
            }
            this.beginHourglass();
            l = null;
            try {
                l = this.createLoader(in, s, id, fmtopts, script);
            }
            catch (SecurityException sex) {
                this.errorDisplay.error("Cannot load molecule file " + s + "\n\n", sex);
            }
            catch (MalformedURLException ex) {
                this.errorDisplay.error("Cannot form valid URL for molecule file loading.\nFilename: " + s + "\nInternal molecule id: " + id, ex);
            }
            finally {
                if (l != null) break block18;
                this.endHourglass();
                return;
            }
        }
        int numKilled = 0;
        List<MolLoader> list = this.loaders;
        synchronized (list) {
            numKilled = this.killLoaders0(id, id);
            this.loaders.add(l);
            if (l.contentsSpecified()) {
                l.run();
            } else {
                int n = 0;
                for (int i = 0; i < this.loaders.size(); ++i) {
                    if (!this.loaders.get(i).isAlive()) continue;
                    ++n;
                }
                if (n < 2) {
                    l.startThread();
                }
            }
        }
        for (int i = 0; i < numKilled; ++i) {
            this.endHourglass();
        }
    }

    public double getAnimFPS() {
        return this.animFPS;
    }

    public void setAnimFPS(double r) {
        Double old = new Double(this.animFPS);
        this.animFPS = r;
        Double val = new Double(this.animFPS);
        this.changeListeners.firePropertyChange("animFPS", old, val);
    }

    public double getAnimDelay() {
        return this.animDelay;
    }

    public void setAnimDelay(double d) {
        Double old = new Double(this.animDelay);
        this.animDelay = d;
        Double val = new Double(this.animDelay);
        this.changeListeners.firePropertyChange("animDelay", old, val);
    }

    protected abstract void repaintMols();

    private void changeUserDispoptsProperties(int o0, int o) {
        String v;
        String val;
        String v2;
        String key;
        if ((o & 3) != (o0 & 3)) {
            key = this.getDefaultImplicitHPropertyName();
            v2 = IMPLICITH_LEVELS[o & 3];
            this.userSettings.setProperty(key, v2);
            this.changeProperty(key, v2);
        }
        if ((o & 0xC0) != (o0 & 0xC0)) {
            key = this.getDefaultColorSchemePropertyName();
            val = COLOR_SCHEMES[(o & 0xC0) >> 6];
            this.userSettings.setProperty(key, val);
            this.changeProperty(key, val);
        }
        if ((o & 0xE0000) != (o0 & 0xE0000)) {
            key = this.getDefaultRenderingPropertyName();
            val = RENDERING_STYLES[(o & 0xE0000) >> 17];
            this.userSettings.setProperty(key, val);
            this.changeProperty(key, val);
        }
        if ((o & 0x600000) != (o0 & 0x600000) && (key = this.getDefaultAnyBondPropertyName()) != null) {
            v2 = ANYBOND_STYLES[(o & 0x600000) >> 21];
            this.userSettings.setProperty(key, v2);
            this.changeProperty(key, v2);
        }
        if ((o & 0x30000000) != (o0 & 0x30000000)) {
            key = this.getDefaultCarbonVisibilityPropertyName();
            v2 = CARBON_VIS_STYLES[(o & 0x30000000) >> 28];
            this.userSettings.setProperty(key, v2);
            this.changeProperty(key, v2);
        }
        if ((o & 0x100000) != (o0 & 0x100000)) {
            v = DOWNWEDGE_MODES[(o & 0x100000) >> 20];
            this.userSettings.setProperty("downWedge", v);
            this.changeProperty("downWedge", v);
        }
        if ((o & 0x200) != (o0 & 0x200)) {
            v = COORDINATE_BOND_STYLES[(o & 0x200) >> 9];
            this.userSettings.setProperty("coordinateBondStyle", v);
            this.changeProperty("coordinateBondStyle", v);
        }
        if ((o & 0x100) != (o0 & 0x100)) {
            v = COORDINATE_BOND_AT_MULTICENTER_STYLES[(o & 0x100) >> 8];
            this.userSettings.setProperty("coordinateBondStyleAtMulticenter", v);
            this.changeProperty("coordinateBondStyleAtMulticenter", v);
        }
        if ((o & 0xC000) != (o0 & 0xC000)) {
            v = RS_OPTIONS[(o & 0xC000) >> 14];
            this.userSettings.setChiralitySupport(v);
            this.changeProperty("chiralitySupport", v);
        }
        if ((o & 0x2000000) != (o0 & 0x2000000)) {
            v = (o & 0x2000000) != 0 ? "on" : "off";
            this.userSettings.setAbsoluteLabelVisible(v);
            this.changeProperty("absLabelVisible", v);
        }
    }

    protected boolean fireDispoptsChange(int opts0) {
        int opts = this.painterCommon.getDispopts();
        if (opts0 == opts) {
            return false;
        }
        this.createVecs();
        this.changeListeners.firePropertyChange("implicitH", IMPLICITH_LEVELS[opts0 & 3], IMPLICITH_LEVELS[opts & 3]);
        this.changeListeners.firePropertyChange("navmode", MM_MODES[opts0 >> 3 & 7], MM_MODES[opts >> 3 & 7]);
        this.changeListeners.firePropertyChange("colorScheme", COLOR_SCHEMES[(opts0 & 0xC0) >> 6], COLOR_SCHEMES[(opts & 0xC0) >> 6]);
        this.changeListeners.firePropertyChange("setColoringEnabled", new Boolean((opts0 & 0x100) != 0), new Boolean((opts & 0x100) != 0));
        this.changeListeners.firePropertyChange("grinvVisible", new Boolean((opts0 & 0x200) != 0), new Boolean((opts & 0x200) != 0));
        this.changeListeners.firePropertyChange("atomNumbersVisible", new Boolean((opts0 & 0x800) != 0), new Boolean((opts & 0x800) != 0));
        this.changeListeners.firePropertyChange("atomMappingVisible", new Boolean((opts0 & 0x1000) != 0), new Boolean((opts & 0x1000) != 0));
        this.changeListeners.firePropertyChange("lonePairsVisible", new Boolean((opts0 & 0x1000000) != 0), new Boolean((opts & 0x1000000) != 0));
        this.changeListeners.firePropertyChange("lonePairsAutoCalc", new Boolean((opts0 & 0x8000000) != 0), new Boolean((opts & 0x8000000) != 0));
        this.changeListeners.firePropertyChange("bondLengthVisible", new Boolean((opts0 & 0x2000) != 0), new Boolean((opts & 0x2000) != 0));
        this.changeListeners.firePropertyChange("rgroupsVisible", new Boolean((opts0 & 0x4000000) != 0), new Boolean((opts & 0x4000000) != 0));
        this.changeListeners.firePropertyChange("ezVisible", new Boolean((opts0 & 0x10000) != 0), new Boolean((opts & 0x10000) != 0));
        this.changeListeners.firePropertyChange("atomSymbolsVisible", new Boolean((opts0 & 0x400) != 0), new Boolean((opts & 0x400) != 0));
        this.changeListeners.firePropertyChange("rendering", RENDERING_STYLES[(opts0 & 0xE0000) >> 17], RENDERING_STYLES[(opts & 0xE0000) >> 17]);
        this.changeListeners.firePropertyChange("dispQuality", new Integer((opts0 & 0x800000) >> 23), new Integer((opts & 0x800000) >> 23));
        this.changeListeners.firePropertyChange("downWedge", DOWNWEDGE_MODES[(opts0 & 0x100000) >> 20], DOWNWEDGE_MODES[(opts & 0x100000) >> 20]);
        this.changeListeners.firePropertyChange("anybond", ANYBOND_STYLES[(opts0 & 0x600000) >> 21], ANYBOND_STYLES[(opts & 0x600000) >> 21]);
        this.changeListeners.firePropertyChange("carbonVisibility", CARBON_VIS_STYLES[(opts0 & 0x30000000) >> 28], CARBON_VIS_STYLES[(opts & 0x30000000) >> 28]);
        int oldi = (opts0 & 0xC000) >> 14;
        int newi = (opts & 0xC000) >> 14;
        if (oldi != newi) {
            this.changeListeners.firePropertyChange("chiralitySupport", new Integer(oldi), new Integer(newi));
        }
        this.changeListeners.firePropertyChange("absLabelVisible", new Boolean((opts0 & 0x2000000) != 0), new Boolean((opts & 0x2000000) != 0));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream tryToGetResource(String s) {
        InputStream in = null;
        if (MFileFormatUtil.isURLOrFileName(s)) {
            this.beginHourglass();
            try {
                Container o = this.applet;
                String res = s;
                if (this.applet == null) {
                    o = this;
                    if (!s.startsWith("/")) {
                        res = "/".concat(s);
                    }
                }
                in = BasicEnvironment.getResourceAsStream(o.getClass(), res, true);
            }
            catch (Exception exception) {
            }
            finally {
                this.endHourglass();
            }
        }
        return in;
    }

    protected Molecule[] readMols(File f, String opts) {
        MolInputStream mis = null;
        MRecordImporter imp = null;
        int metaOpts = 0;
        try {
            String[] fopts = MFileFormatUtil.splitFormatAndOptions(opts);
            metaOpts = MFileFormatUtil.preprocessFormatAndOptions(fopts);
            FileInputStream fis = new FileInputStream(f);
            mis = new MolInputStream((InputStream)fis, fopts[0]);
            imp = MolLoader.createImporter(mis, fopts[1], this.debug);
        }
        catch (SecurityException sex) {
            JOptionPane.showMessageDialog(this, "Cannot load file " + f.getName() + ":\n" + sex.toString(), "Security error", 0);
        }
        catch (IncompatibleClassChangeError ex) {
            this.errorDisplay.error(ex);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "File " + f.getName() + " not found", "File not found", 0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Cannot read file " + f.getName() + "\n" + ex.toString(), "File not found", 0);
        }
        if (imp != null) {
            Molecule m = imp.createMol();
            try {
                if ((metaOpts & 1) != 0) {
                    if ((m = MolLoader.readMultiSet(imp, m)) != null) {
                        Molecule[] mols = new Molecule[]{m};
                        return mols;
                    }
                } else {
                    ArrayList<Molecule> v = new ArrayList<Molecule>();
                    while (imp.readMol(m) != null) {
                        v.add(m);
                        m = imp.createMol();
                    }
                    if (v.size() > 0) {
                        Molecule[] mols = new Molecule[v.size()];
                        v.toArray(mols);
                        return mols;
                    }
                }
            }
            catch (MRecordParseException ex) {
                JOptionPane.showMessageDialog(this, "Cannot split file into records: " + f.getName() + "\nError in line " + mis.getLineCount() + "\n" + ex.toString(), "Read error", 0);
            }
            catch (MolFormatException ex) {
                JOptionPane.showMessageDialog(this, "Cannot read molecule from file " + f.getName() + "\nError in line " + mis.getLineCount() + "\n" + ex.toString(), "Read error", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Cannot read file " + f.getName() + "\nError in line " + mis.getLineCount() + "\n" + ex.toString(), "Read error", 0);
            }
        }
        return null;
    }

    private MolLoader createLoader(InputStream in, String s, long id, String fmtopts, boolean script) throws MalformedURLException, SecurityException {
        MolLoader l = null;
        if (in != null) {
            String[] r = MFileFormatUtil.splitFormatAndOptions(fmtopts);
            if (r[0] == null && (r[0] = MFileFormatUtil.getUnguessableFormat(s)) != null) {
                fmtopts = r[0] + ":";
                if (r[1] != null) {
                    fmtopts = fmtopts + r[1];
                }
            }
            l = new MolLoader(in, fmtopts, id, this, this.getErrorDisplay(), this, script, this.getDebug());
        } else {
            URL base = this.applet == null ? null : this.applet.getDocumentBase();
            l = new MolLoader(base, s, id, this, this.getErrorDisplay(), this, fmtopts, script, this.getDebug());
        }
        return l;
    }

    protected final void killLoaders(long minId, long maxId) {
        int numKilled = this.killLoaders0(minId, maxId);
        for (int i = 0; i < numKilled; ++i) {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int killLoaders0(long minId, long maxId) {
        int numKilled = 0;
        List<MolLoader> list = this.loaders;
        synchronized (list) {
            for (int i = this.loaders.size() - 1; i >= 0; --i) {
                MolLoader l = this.loaders.get(i);
                long id = l.getId();
                if (id < minId || id > maxId) continue;
                this.loaders.remove(i);
                ++numKilled;
                l.die();
            }
        }
        return numKilled;
    }

    public File getFile() {
        return this.moleculeFile;
    }

    public static String getColorChooserTitle() {
        return GRESOURCES.getString("colorChooseDialogTitle");
    }

    public Color showColorChooserDialog(Color initialColor) {
        return JColorChooser.showDialog(this, GRESOURCES.getString("colorChooseDialogTitle"), initialColor == null ? Color.WHITE : initialColor);
    }

    public void setFile(File f) {
        File old = this.moleculeFile;
        if (f == null) {
            this.moleculeFile = null;
            this.setDirectory(null);
        } else if (f.isDirectory()) {
            this.moleculeFile = null;
            this.setDirectory(f);
        } else {
            this.moleculeFile = f;
            String dir = f.getParent();
            this.setDirectory(dir != null ? new File(dir) : null);
            this.setLoadCwdToUserSettings(new File(f.getAbsolutePath()));
        }
        this.changeListeners.firePropertyChange("file", old, f);
    }

    public File getDirectory() {
        return this.moleculeDirectory;
    }

    public final void setDirectory(File wd) {
        if (wd == null) {
            return;
        }
        this.moleculeDirectory = wd;
        this.loadLoadSaveModule(false);
        this.loadsave.callback("setCwd", wd);
        this.setLoadCwdToUserSettings(wd);
        this.setSaveCwdToUserSettings(wd);
    }

    public final SaveImageTool getSaveImageTool() {
        return this.saveImageTool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean molLoaderFinished(MolLoader l) {
        long id = l.getId();
        File f = l.getFile();
        if (f != null && id == 0L && l.isSecondRun()) {
            Object object = this.getMolPanelLock();
            synchronized (object) {
                this.setFile(f);
            }
        }
        if (l.isSecondRun()) {
            this.endHourglass();
        } else {
            boolean preloaded;
            boolean bl = preloaded = id >= 196608L && id < 262144L;
            if (!l.isSecondRun()) {
                Molecule[] mols = l.getMols();
                String path = l.getPath();
                if ((preloaded || this.cacheMols) && path != null && mols != null) {
                    int size = this.molCache.size();
                    this.molCache.put(path, mols);
                    if (this.debug > 0 && this.molCache.size() > size) {
                        System.err.println("CACHE <-- " + path);
                    }
                }
            }
            List<MolLoader> list = this.loaders;
            synchronized (list) {
                int n = this.loaders.size();
                this.loaders.remove(l);
                if (this.loaders.size() == n - 1) {
                    for (MolLoader ll : this.loaders) {
                        if (ll.isAlive()) continue;
                        ll.startThread();
                        break;
                    }
                } else {
                    return true;
                }
            }
            l.initSecondRun(this, this);
            SwingUtilities.invokeLater(l);
        }
        return false;
    }

    @Override
    public Molecule[] getFromMolCache(String arg) {
        Molecule[] o = this.molCache.get(arg);
        if (o != null && this.debug > 0) {
            System.err.println("CACHE --> " + arg);
        }
        return o;
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setFileFromLoadSave")) {
            File f = (File)this.loadsave.callback("getFile", null);
            this.setFile(f);
            ActionEvent ev = new ActionEvent(this, 0, "file");
            this.fireActionEvent(ev);
            return null;
        }
        if (method.equals("getParameter")) {
            return this.getParameter((String)arg);
        }
        if (method.equals("setAutoScale")) {
            this.setAutoScale((Boolean)arg);
        } else {
            if (method.equals("getApplet")) {
                return this.getApplet();
            }
            if (method.equals("getDebug")) {
                return new Integer(this.debug);
            }
            if (method.equals("savePerformed")) {
                this.addRecentFileToUserSettings((File)((LoadSave)arg).callback("getFile", null));
                this.setSaveCwdToUserSettings((File)((LoadSave)arg).callback("getCwd", null));
                return null;
            }
        }
        return null;
    }

    protected final void fireActionEvent(ActionEvent ev) {
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            ActionListener l = this.actionListeners.get(i);
            l.actionPerformed(ev);
        }
    }

    public void setMarvinViewVisible(boolean in3d, MDocument doc, String text, String title) {
        CallbackIface f = null;
        try {
            f = (CallbackIface)MarvinModule.load("view.swing.MViewFrame", this);
        }
        catch (SecurityException sex) {
            this.errorDisplay.firewallError(sex, null);
        }
        if (f != null) {
            f.callback("setIndex", new Integer(0));
            f.callback("setMolPanel", this);
            f.callback("setSketchDoc", doc);
            f.callback("setText", text);
            f.callback("newPanel", new Object[]{new Integer(in3d ? 3 : 2), title});
        }
    }

    public abstract void doSaveImage();

    public abstract void doOpenMSpace();

    public abstract void doSource();

    public abstract void doCopy();

    public abstract void doCopySMILES();

    public abstract void doCopyAs();

    public abstract void doPaste();

    public abstract void doAromatize(boolean var1);

    public final void doAromatizeMethod(int method) {
        this.setAromatizeMethod(method);
        this.doAromatize(true);
    }

    public void setAromatizeMethod(int method) {
        this.userSettings.setAromatizeMethod(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void aromatize(Molecule[] mols, String arom) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            if (mols != null) {
                for (int i = 0; i < mols.length; ++i) {
                    Molecule m = mols[i];
                    Object object2 = m.getLock();
                    synchronized (object2) {
                        if (arom.equals("dearomatize")) {
                            m.dearomatize();
                        } else if (arom.startsWith("aromatize")) {
                            m.aromatize(this.userSettings.getAromatizeMethod());
                        }
                        continue;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dearomatize(Molecule[] mols) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            if (mols != null) {
                for (int i = 0; i < mols.length; ++i) {
                    Molecule m = mols[i];
                    Object object2 = m.getLock();
                    synchronized (object2) {
                        m.aromatize(false);
                        continue;
                    }
                }
            }
        }
    }

    public int getAtomMappingMethod() {
        return this.userSettings.getAtomMappingMethod();
    }

    public void setAtomMappingMethod(int method) {
        this.userSettings.setAtomMappingMethod(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPreferences() {
        this.beginHourglass();
        try {
            PreferencesDialogProvider provider = (PreferencesDialogProvider)MarvinModule.load("common.swing.Preferences", this);
            if (provider != null) {
                this.showPreferencesDialog(provider);
            }
        }
        catch (SecurityException sex) {
            this.errorDisplay.firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    protected abstract void showPreferencesDialog(PreferencesDialogProvider var1);

    public final void doChoosebg() {
        Color c = this.showColorChooserDialog(this.molbg);
        if (c != null) {
            this.doBg(c);
        }
    }

    public final void doBg(Color c) {
        this.setDefaultMolbg(c);
        this.setMolbg(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHelp(int which) {
        this.beginHourglass();
        CallbackIface m = null;
        try {
            URL u = null;
            if (which == 0) {
                if (this.applet == null) {
                    Window parent;
                    Window window = parent = this.isParentWindowDialog() ? this.getParentDialog() : this.getParentFrame();
                    if (this.doHelp(parent)) {
                        this.helpModule.callback("setDisplayed", Boolean.TRUE);
                        return;
                    }
                }
                u = this.getHelpURL();
            } else if (which == 1) {
                u = this.getQuickHelpURL();
            }
            if (which == 4) {
                AboutDialog about = (AboutDialog)MarvinModule.load("common.swing.AboutDialogImpl", this);
                Window parent = this.isParentWindowDialog() ? this.getParentDialog() : this.getParentFrame();
                about.setParent(parent);
                about.setProgramName(this.getProgName());
                about.setVersion(this.getVersion());
                about.show();
            } else if (which == 2) {
                JDialog d = LicenseManagerGUI.createDialog(this);
                d.setVisible(true);
                LicenseManagerGUI.doLicenseCheck(d);
            } else if (this.applet == null) {
                m = (CallbackIface)MarvinModule.load("common.swing.Help", this);
                m.callback("setMolPanel", this);
                m.callback("showURL", u);
            } else {
                this.applet.getAppletContext().showDocument(u, "_blank");
            }
        }
        catch (SecurityException sex) {
            this.errorDisplay.firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    public void enableHelpOnButton(JButton button, String helpID) {
        Window parent = this.isParentWindowDialog() ? this.getParentDialog() : this.getParentFrame();
        this.doHelp(parent);
        if (this.helpModule != null) {
            this.helpModule.callback("enableHelpOnButton", new Object[]{button, helpID});
        }
    }

    boolean doHelp(Window parent) throws SecurityException {
        if (this.javaHelpRequested && this.helpModule != null) {
            return true;
        }
        if (!this.javaHelpRequested) {
            try {
                Class.forName("javax.help.JHelp");
            }
            catch (ClassNotFoundException cnfe) {
                this.javaHelpRequested = true;
                return false;
            }
            this.helpModule = (CallbackIface)MarvinModule.load("common.swing.JavaHelp", this);
            if (this.helpModule == null) {
                this.javaHelpRequested = true;
                return false;
            }
            this.helpModule.callback("setParent", parent);
            this.helpModule.callback("setMolPanel", this);
            this.helpModule.callback("doJavaHelp", null);
            this.javaHelpRequested = true;
            return true;
        }
        return false;
    }

    public abstract void doRegenBonds();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean regenBonds(int icell) {
        this.beginHourglass();
        CallbackIface ci = null;
        try {
            ci = (CallbackIface)MarvinModule.load("common.swing.RegenBonds", this);
        }
        catch (SecurityException sex) {
            this.errorDisplay.firewallError(sex, null);
            boolean bl = false;
            return bl;
        }
        finally {
            this.endHourglass();
        }
        if (ci != null) {
            Object[] args = new Object[]{this, new Integer(icell), new Double(this.bondFudge), new Boolean(this.guessBonds), this.maxBonds};
            ci.callback("show", args);
            this.bondFudge = (Double)ci.callback("getBondFudge", null);
            this.guessBonds = (Boolean)ci.callback("getGuessBonds", null);
            this.maxBonds = (int[])ci.callback("getMaxBonds", null);
            return true;
        }
        return false;
    }

    public abstract void doHydrogenize(boolean var1);

    public abstract void doExpandSgroup(Object var1);

    public abstract void doContractSgroup(Object var1);

    public abstract void doClean(int var1);

    public abstract void doClean2dWedgeBonds();

    public boolean getCleanHOption() {
        return this.userSettings.isCleanHOptionEnabled();
    }

    public void setCleanHOption(boolean b) {
        this.changeProperty("cleanHOption", String.valueOf(b));
        this.userSettings.setCleanHOption(b);
    }

    protected final void clean2dWedgeBonds(final int icell, final Molecule m) {
        if (m == null || m.isEmpty()) {
            this.errorDisplay.error("No molecule to clean", new Exception("No molecule to clean"));
            return;
        }
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MolPanel.this.beginHourglass();
                try {
                    if (m.stereoClean()) {
                        MolPanel.this.updateMol(icell, m);
                    } else {
                        MolPanel.this.errorDisplay.error("Unsuccessful wedge bonds cleaning", null);
                    }
                }
                finally {
                    MolPanel.this.endHourglass();
                }
            }
        };
        t.start();
    }

    public abstract void doClean3dSelConf();

    protected void clean3dSelConf(final int icell, final Molecule m) {
        if (m == null || m.isEmpty()) {
            this.errorDisplay.warning("No molecule.", null);
            return;
        }
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MolPanel.this.beginHourglass();
                try {
                    MolPanel.this.showConformers(icell, m);
                }
                finally {
                    MolPanel.this.endHourglass();
                }
            }
        };
        t.start();
    }

    public abstract void doResetView();

    public void doSetNavmode(String s) {
        int opts0 = this.getDispopts();
        int m = MolPanel.getNavmodeFlags(s);
        if (m < 0) {
            m = 0;
        }
        this.setDispopts(opts0 & 0xFFFFFFC7 | m, true, false);
        this.setDefaultNavmode(s);
    }

    public void setViewNavmode2d(String s) {
        this.userSettings.setViewNavmode2d(s);
    }

    public void setViewNavmode3d(String s) {
        this.userSettings.setViewNavmode3d(s);
    }

    public abstract void setDefaultNavmode(String var1);

    public String getNavmode() {
        return MM_MODES[this.painterCommon.getDispopts() >> 3 & 7];
    }

    public void setNavmode(String s) {
        int m = MolPanel.getNavmodeFlags(s);
        if (m >= 0) {
            this.setDispopts(this.painterCommon.getDispopts() & 0xFFFFFFC7 | m, false, true);
            return;
        }
        throw new IllegalArgumentException("setNavmode(\"" + s + "\"): bad argument");
    }

    private static int getNavmodeFlags(String s) {
        for (int i = 0; i < MM_MODES.length; ++i) {
            if (!MM_MODES[i].equals(s)) continue;
            int m = i << 3;
            return m;
        }
        return -1;
    }

    public void doSetImplicitH(int h) {
        int opts0 = this.getDispopts();
        this.setDispopts(opts0 & 0xFFFFFFFC | h, true, false);
    }

    public void setImplicitH(String s) {
        int i = MolPainterCommon.getImplicitHFlagsOf(s);
        this.setDispopts(this.painterCommon.getDispopts() & 0xFFFFFFFC | i, true, true);
    }

    public void doSetColorScheme(int k) {
        int opts0 = this.getDispopts();
        int prev = (opts0 & 0xC0) >> 6;
        this.setDispopts(opts0 & 0xFFFFFF3F | k << 6, true, false);
        if (k != prev) {
            this.colorSchemeChangedFromGUI = true;
        }
    }

    public void doSetRendering(int k) {
        int opts0 = this.getDispopts();
        this.setDispopts(opts0 & 0xFFF1FFFF | k << 17, true, false);
        this.setDefaultRendering(RENDERING_STYLES[k]);
    }

    public String getRendering() {
        return this.painterCommon.getRendering();
    }

    public void setRendering(String s) {
        MolPainterCommon.getRenderingFlagsOf(s);
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setRendering(s);
        this.setDefaultRendering(s);
        if (opts0 != this.painterCommon.getDispopts()) {
            this.repaintMols();
        }
    }

    public void setSketchRendering2d(String s) {
        MolPainterCommon.getRenderingFlagsOf(s);
        this.changeProperty("sketchRendering2d", s);
        this.userSettings.setSketchRendering2d(s);
    }

    public void setSketchRendering3d(String s) {
        MolPainterCommon.getRenderingFlagsOf(s);
        this.changeProperty("sketchRendering3d", s);
        this.userSettings.setSketchRendering3d(s);
    }

    public void setViewRendering2d(String s) {
        MolPainterCommon.getRenderingFlagsOf(s);
        this.changeProperty("viewRendering2d", s);
        this.userSettings.setViewRendering2d(s);
    }

    public void setViewRendering3d(String s) {
        MolPainterCommon.getRenderingFlagsOf(s);
        this.changeProperty("viewRendering3d", s);
        this.userSettings.setViewRendering3d(s);
    }

    public abstract String getDefaultRendering();

    public abstract void setDefaultRendering(String var1);

    public abstract String getDefaultRenderingPropertyName();

    public void doSetDispQuality(int k) {
        int opts0 = this.getDispopts();
        this.setDispopts(opts0 & 0xFF7FFFFF | k << 23, true, false);
        this.userSettings.setProperty("noAntialias", k >= 1 ? "false" : "true", false);
    }

    public int getDispQuality() {
        return this.painterCommon.getDispQuality();
    }

    public void setDispQuality(int k) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setDispQuality(k);
        this.changeProperty("dispQuality", String.valueOf(k));
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
        this.userSettings.setProperty("noAntialias", k >= 1 ? "false" : "true", false);
    }

    public void doSetChiralitySupport(int k) {
        this.setChiralitySupport(k);
    }

    public void setChiralitySupport(int l) {
        this.setDispopts(this.painterCommon.getDispopts() & 0xFFFF3FFF | l << 14, true, true);
        this.userSettings.setChiralitySupport(String.valueOf(RS_OPTIONS[(this.painterCommon.getDispopts() & 0xC000) >> 14]));
    }

    public void doSetSetColoringEnabled(boolean s) {
        int opts0 = this.getDispopts();
        this.setDispopts(opts0 & 0xFFFFFEFF | (s ? 256 : 0), true, false);
    }

    public void doSetAtomSymbolsVisible(boolean s) {
        int opts0 = this.getDispopts();
        this.setDispopts(opts0 & 0xFFFFFBFF | (s ? 1024 : 0), true, false);
        this.userSettings.setProperty("noAtomSymbols3D", String.valueOf(!s), false);
    }

    public void doSetGrinvVisible(boolean s) {
        int opts0 = this.getDispopts();
        this.setDispopts(opts0 & 0xFFFFFDFF | (s ? 512 : 0), true, false);
    }

    public boolean isGrinvVisible() {
        return this.painterCommon.isGrinvVisible();
    }

    public void setGrinvVisible(boolean v) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setGrinvVisible(v);
        this.changeProperty("grinvVisible", String.valueOf(v));
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
    }

    public void doSetAtomNumbersVisible(boolean s) {
        int opts0 = this.getDispopts();
        this.setDispopts(opts0 & 0xFFFFF7FF | (s ? 2048 : 0), true, false);
        this.userSettings.setProperty("atomNumbersVisible", String.valueOf(s), false);
    }

    public boolean isAtomNumbersVisible() {
        return this.painterCommon.isAtomNumbersVisible();
    }

    public void setAtomNumbersVisible(boolean v) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setAtomNumbersVisible(v);
        this.changeProperty("atomNumbersVisible", String.valueOf(v));
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
        this.userSettings.setProperty("atomNumbersVisible", String.valueOf(v), false);
    }

    public void doSetAtomPropertiesVisible(boolean s) {
        int opts0 = this.painterCommon.getDispoptsExt();
        this.painterCommon.setDispoptsExt(opts0 & 0xFFFFFFF7 | (s ? 8 : 0));
        this.changeListeners.firePropertyChange("atomPropertiesVisible", new Boolean((opts0 & 8) != 0), new Boolean((this.painterCommon.getDispoptsExt() & 8) != 0));
        if (opts0 != this.painterCommon.getDispoptsExt()) {
            this.repaintMols();
        }
        this.userSettings.setAtomPropertiesVisible(s);
    }

    public boolean isAtomPropertiesVisible() {
        return this.painterCommon.isAtomPropertiesVisible();
    }

    public void setAtomPropertiesVisible(boolean v) {
        this.doSetAtomPropertiesVisible(v);
    }

    public boolean isValencePropertyVisible() {
        return this.painterCommon.isValencePropertyVisible();
    }

    public void setValencePropertyVisible(boolean v) {
        boolean v0 = this.isValencePropertyVisible();
        if (v0 == v) {
            return;
        }
        this.painterCommon.setValencePropertyVisible(v);
        this.changeListeners.firePropertyChange("valencePropertyVisible", v0, v);
        this.repaintMols();
        this.userSettings.setValencePropertyVisible(v);
    }

    public boolean isLigandErrorVisible() {
        return this.painterCommon.isLigandErrorVisible();
    }

    public void setLigandErrorVisible(boolean v) {
        boolean v0 = this.isLigandErrorVisible();
        if (v0 == v) {
            return;
        }
        this.painterCommon.setLigandErrorVisible(v);
        this.changeListeners.firePropertyChange("ligandErrorVisible", v0, v);
        this.repaintMols();
        this.userSettings.setLigandErrorVisible(v);
    }

    public void doSetAtomMappingVisible(boolean s) {
        int opts0 = this.getDispopts();
        this.setDispopts(opts0 & 0xFFFFEFFF | (s ? 4096 : 0), true, false);
        this.userSettings.setProperty("atomMappingVisible", String.valueOf(s), false);
    }

    public boolean isAtomMappingVisible() {
        return this.painterCommon.isAtomMappingVisible();
    }

    public void setAtomMappingVisible(boolean v) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setAtomMappingVisible(v);
        this.changeProperty("atomMappingVisible", String.valueOf(v));
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
        this.userSettings.setProperty("atomMappingVisible", String.valueOf(v), false);
    }

    public void doSetLonePairsVisible(boolean s) {
        int opts0 = this.getDispopts();
        this.setDispopts(opts0 & 0xFEFFFFFF | (s ? 0x1000000 : 0), true, false);
        this.userSettings.setProperty("lonePairsVisible", String.valueOf(s), false);
    }

    public void doSetLonePairsAutoCalc(boolean s) {
        int opts0 = this.getDispopts();
        this.setDispopts(opts0 & 0xF7FFFFFF | (s ? 0x8000000 : 0), true, false);
    }

    public boolean getLonePairsVisible() {
        return this.painterCommon.areLonePairsVisible();
    }

    public void setLonePairsVisible(boolean v) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setLonePairsVisible(v);
        this.changeProperty("lonePairsVisible", String.valueOf(v));
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
        this.userSettings.setProperty("lonePairsVisible", String.valueOf(v), false);
    }

    public void setLonePairsAutoCalc(boolean v) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setLonePairsAutoCalc(v);
        this.changeProperty("lonePairsAutoCalc", String.valueOf(v));
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
        this.userSettings.setLonePairAutoCalc(v);
    }

    public void doSetBondLengthVisible(boolean s) {
        int opts0 = this.painterCommon.getDispopts();
        this.setDispopts(opts0 & 0xFFFFDFFF | (s ? 8192 : 0), true, false);
    }

    public boolean isBondLengthVisible() {
        return (this.painterCommon.getDispopts() & 0x2000) != 0;
    }

    public void setBondLengthVisible(boolean v) {
        int h = v ? 8192 : 0;
        this.setDispopts(this.painterCommon.getDispopts() & 0xFFFFDFFF | h, false, true);
    }

    public void doSetRgroupsVisible(boolean v) {
        int opts0 = this.painterCommon.getDispopts();
        int h = v ? 0x4000000 : 0;
        this.setDispopts(opts0 & 0xFBFFFFFF | h, true, false);
        this.properties.setProperty("rgroupsVisible".toLowerCase(), Boolean.toString(v));
        this.updateBounds();
    }

    public boolean isRgroupsVisible() {
        return this.painterCommon.isRgDefinitionVisible();
    }

    public void setRgroupsVisible(boolean v) {
        if (this.isRgroupsVisible() == v) {
            return;
        }
        this.painterCommon.setRgDefinitionVisible(v);
        this.firePropertyChange("rgroupsVisible", !v, v);
        this.repaintMols();
    }

    public void doSetEzVisible(boolean v) {
        int opts0 = this.painterCommon.getDispopts();
        int h = v ? 65536 : 0;
        this.setDispopts(opts0 & 0xFFFEFFFF | h, true, false);
        this.userSettings.setEZVisible(v);
    }

    public boolean isEzVisible() {
        return (this.painterCommon.getDispopts() & 0x10000) != 0;
    }

    public void setEzVisible(boolean v) {
        int opts0 = this.painterCommon.getDispopts();
        int h = v ? 65536 : 0;
        this.setDispopts(opts0 & 0xFFFEFFFF | h, true, true);
        this.userSettings.setEZVisible(v);
    }

    public void doSetAbsLabelVisible(boolean v) {
        int opts0 = this.painterCommon.getDispopts();
        int h = v ? 0x2000000 : 0;
        this.setDispopts(opts0 & 0xFDFFFFFF | h, true, false);
    }

    public boolean isAbsLabelVisible() {
        return this.painterCommon.isAbsLabelVisible();
    }

    public void setAbsLabelVisible(boolean l) {
        int opts0 = this.painterCommon.getDispopts();
        int h = l ? 0x2000000 : 0;
        this.setDispopts(opts0 & 0xFDFFFFFF | h, true, true);
    }

    public void doSetRLogicVisible(boolean l) {
        this.setRLogicVisible(l);
    }

    public boolean isRLogicVisible() {
        return this.painterCommon.isRLogicVisible();
    }

    public void setRLogicVisible(boolean l) {
        boolean old = this.painterCommon.isRLogicVisible();
        this.painterCommon.setRLogicVisible(l);
        if (old != l) {
            String v = l ? "on" : "off";
            this.userSettings.setRLogicVisible(v);
            this.changeProperty("rLogicVisible", v);
            this.changeListeners.firePropertyChange("rLogicVisible", new Boolean(old), new Boolean(l));
            this.repaintMols();
        }
    }

    public void doSetClean2dOpts(String v) {
        this.setClean2dOpts(v);
        this.doClean(2);
    }

    public MStringTokenizer createMStringTokenizer(String s) {
        if (s != null) {
            MStringTokenizer mst = new MStringTokenizer(s);
            if (mst.getEscapeChar() == '\u0000') {
                mst.setEscapeChar(this.escapeChar);
            }
            return mst;
        }
        return null;
    }

    public String getClean2dOpts() {
        return this.userSettings.getClean2dOpts();
    }

    public void setClean2dOpts(String s) {
        this.userSettings.setClean2dOpts(s);
    }

    public String getClean3dOpts() {
        return this.userSettings.getClean3dOpts();
    }

    public void setClean3dOpts(String s) {
        this.userSettings.setClean3dOpts(s);
    }

    public Clipboard getMClipboard() {
        return ClipboardHandler.getClipboard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openCopyAsDialog(MDocument doc, MolPainter painter) throws SecurityException {
        CallbackIface copyAsDialog;
        block16: {
            Class[] argcl = new Class[2];
            Object[] args = new Object[2];
            args[0] = this.getParentDialog();
            argcl[0] = Dialog.class;
            if (args[0] == null) {
                args[0] = this.getParentFrame();
                argcl[0] = Frame.class;
            }
            args[1] = this.userSettings.getCopyAsFormat();
            argcl[1] = String.class;
            copyAsDialog = null;
            ReflectiveOperationException e = null;
            try {
                copyAsDialog = (CallbackIface)MarvinModule.loadClass("chemaxon.marvin.modules.datatransfer.CopyAsDialog", argcl, args, this);
            }
            catch (IllegalAccessException iaex) {
                e = iaex;
            }
            catch (InstantiationException instex) {
                e = instex;
            }
            catch (NoSuchMethodException nsmex) {
                e = nsmex;
            }
            catch (ClassNotFoundException cnfex) {
                e = cnfex;
            }
            catch (InvocationTargetException itex) {
                e = itex;
            }
            finally {
                if (e == null) break block16;
                SecurityException sex = new SecurityException();
                sex.setStackTrace(e.getStackTrace());
                throw sex;
            }
        }
        if (copyAsDialog != null) {
            copyAsDialog.callback("open", null);
            if (!Boolean.parseBoolean((String)copyAsDialog.callback("canceled", null))) {
                String selfmt = (String)copyAsDialog.callback("getFormat", null);
                Molecule mol = (Molecule)doc.getMainMoleculeGraph();
                Rectangle r = painter.getBoundsFor(mol.getDocument(), painter.getScale());
                boolean tmp = this.userSettings.getSaveGUIPropertiesInMRV();
                this.userSettings.setSaveGUIPropertiesInMRV(true);
                mol.getDocument().setGUIPropertyContainer(this.getGlobalGUIProperties());
                Properties props = ImageExportUtil.mergeProperties(this.userSettings, this.getGlobalGUIProperties(), r);
                this.userSettings.setSaveGUIPropertiesInMRV(tmp);
                this.beginHourglass();
                ClipboardHandler.putMoleculeToClipboard(mol, props, selfmt);
                this.endHourglass();
                this.userSettings.setCopyAsFormat(selfmt);
            }
        }
    }

    public void setMClipboardMol(MDocument doc, MolPainter painter, String fmt) throws SecurityException {
        MObject selobj;
        MObject mObject = selobj = doc == null ? null : doc.getObjectContainingSelection();
        if (selobj != null && selobj instanceof MTextBox) {
            MTextBox tb = (MTextBox)selobj;
            this.beginHourglass();
            ClipboardHandler.putStringToClipboard(tb.getSelectedString());
            this.endHourglass();
        } else {
            if ("dialog".equals(fmt)) {
                this.openCopyAsDialog(doc, painter);
                return;
            }
            Molecule mol = (Molecule)doc.getMainMoleculeGraph();
            if ("smiles".equals(fmt)) {
                try {
                    String[] tmp = MFileFormatUtil.convertToSmilingFormat(mol);
                    this.beginHourglass();
                    ClipboardHandler.putStringToClipboard(tmp[0]);
                    this.endHourglass();
                    return;
                }
                catch (MolExportException e) {
                    e.printStackTrace();
                }
            }
            Rectangle r = painter.getBoundsFor(mol.getDocument(), painter.getScale());
            boolean tmp = this.userSettings.getSaveGUIPropertiesInMRV();
            this.userSettings.setSaveGUIPropertiesInMRV(true);
            mol.getDocument().setGUIPropertyContainer(this.getGlobalGUIProperties());
            Properties props = ImageExportUtil.mergeProperties(this.userSettings, this.getGlobalGUIProperties(), r);
            this.userSettings.setSaveGUIPropertiesInMRV(tmp);
            ClipboardHandler.putMoleculeToClipboard(mol, props, null);
        }
    }

    public Molecule getMClipboardMol() {
        try {
            return (Molecule)ClipboardHandler.getObjectFromClipboard();
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    @Override
    public abstract String getProgName();

    public abstract String getAboutPath();

    private URL getURLProperty(String propname) {
        String s = this.getParameter(propname);
        if (s != null) {
            if (!s.startsWith("/")) {
                s = "/".concat(s);
            }
            try {
                return this.getClass().getResource(s);
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public URL getHelpURL() {
        URL u = this.getURLProperty(this.getHelpPropertyName());
        return u != null ? u : this.defaultHelpURL;
    }

    public URL getQuickHelpURL() {
        URL u = this.getURLProperty(this.getQuickHelpPropertyName());
        return u != null ? u : this.defaultQuickHelpURL;
    }

    public JMenu addToolsMenu(Container parentMenu, Object target) {
        if (!this.pluginsAvailable()) {
            return null;
        }
        this.initPluginActions();
        this.toolsMenu = MolPanel.createMenuG("tools");
        if (parentMenu != null) {
            parentMenu.add(this.toolsMenu);
        }
        this.toolsMenu.setName("tools");
        return this.toolsMenu;
    }

    protected JMenu addServicesMenu(Container parentMenu) {
        if (this.servicesMenu == null) {
            this.servicesMenu = MolPanel.createMenuG("services");
            this.servicesMenu.setName("services");
        }
        this.updateServices();
        parentMenu.add(this.servicesMenu);
        return this.servicesMenu;
    }

    protected void updateServices() {
        if (this.servicesMenu != null) {
            this.servicesMenu.removeAll();
            if (this.getServiceDescriptorReader() != null) {
                ArrayList<ServiceDescriptor> descriptorList = new ArrayList<ServiceDescriptor>();
                InputStream stream = ServiceDescriptorTools.getServiceDescriptorConfigurationAsStream(this.getUserSettings());
                if (stream != null) {
                    descriptorList.addAll(this.getServiceDescriptorReader().readServiceDescriptors(stream));
                }
                Iterator i$ = descriptorList.iterator();
                while (i$.hasNext()) {
                    ServiceDescriptor descriptor;
                    final ServiceDescriptor sd = descriptor = (ServiceDescriptor)i$.next();
                    AbstractAction serviceAction = new AbstractAction(descriptor.getName()){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            if (MolPanel.this.getServiceDialogProvider() != null) {
                                Dialog dialog = MolPanel.this.getServiceDialogProvider().getDialog(MolPanel.this, sd);
                                dialog.setVisible(true);
                            }
                        }
                    };
                    serviceAction.setEnabled(descriptor.isAvailable());
                    this.servicesMenu.add(serviceAction);
                }
            }
            this.servicesMenu.setEnabled(this.servicesMenu.getSubElements().length > 0);
        }
    }

    public JMenu addHelpMenu(Container menu, boolean popup, Object target) {
        JMenu submenu = MolPanel.createMenuG("help", !popup);
        menu.add(submenu);
        this.makeHelpMenu(submenu, popup, target);
        return submenu;
    }

    public abstract void makeHelpMenu(Container var1, boolean var2, Object var3);

    protected boolean isImagePosted() {
        return !this.writeEnabled && this.saveImageTool.getImageSaveURL() != null;
    }

    public boolean showSaveImageFileChooser(int types) {
        if (this.isImagePosted()) {
            return true;
        }
        String defname = this.moleculeFile != null ? this.moleculeFile.getName() : null;
        return this.saveImageTool.showFileChooser(types, defname);
    }

    public int getCleanDim() {
        return this.cleanDim;
    }

    public void setCleanDim(int dim) {
        this.cleanDim = dim;
        this.userSettings.setProperty("dimension", Integer.toString(dim), false);
    }

    public String getCleanOpts(int dim) {
        return dim == 3 ? this.userSettings.getClean3dOpts() : this.userSettings.getClean2dOpts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeEditSource(Window w) {
        Map<Window, Integer> map = this.vframes;
        synchronized (map) {
            if (this.vframes.containsKey(w)) {
                this.unregWindow(w);
            }
        }
        this.edsrcwin = null;
    }

    protected void editSource(MDocument doc, int icell, MolPainter p) {
        this.editSource(doc, icell, p, false);
    }

    protected void editSource(MDocument doc, int icell, MolPainter p, boolean naming) {
        p.storeRTransformInDocument(doc);
        CallbackIface f = this.edsrcwin;
        try {
            if (f == null) {
                f = (CallbackIface)MarvinModule.load("common.swing.EditMolfileFrame", null, null, this);
                f.callback("setMolPanel", this);
                this.edsrcwin = f;
            }
        }
        catch (SecurityException sex) {
            this.errorDisplay.firewallError(sex, null);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        f.callback("setNaming", naming);
        f.callback("setIndex", new Integer(icell));
        f.callback("show", doc);
    }

    protected void cleanActionPerformed(int dim, final int icell) {
        this.setCleanDim(dim);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MolPanel.this.beginHourglass();
                try {
                    MolPanel.this.clean(icell);
                }
                finally {
                    MolPanel.this.endHourglass();
                }
            }
        }.start();
    }

    public abstract void updateMol(int var1, Molecule var2);

    protected abstract void showConformers(int var1, Molecule var2);

    protected void pluginActionPerformed(String cmd, int icell) {
        if (this.pluginManager == null) {
            this.initPluginManager();
        }
        if (cmd.startsWith("plugin_") && this.pluginManager != null) {
            final String key = cmd.substring("plugin_".length());
            final Integer index = new Integer(icell);
            final Molecule mol = (Molecule)this.callback("getMol", index);
            if (mol == null) {
                return;
            }
            if (this.toolsMenu != null) {
                this.toolsMenu.setEnabled(false);
            }
            LicenseThread thread = new LicenseThread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MolPanel.this.beginHourglass();
                    try {
                        if (MolPanel.this.pluginManager == null) {
                            MolPanel.this.initPluginManager();
                        }
                        try {
                            MolPanel.this.pluginManager.callback("runPlugin", new Object[]{key, mol, index, ""});
                        }
                        finally {
                            if (MolPanel.this.toolsMenu != null) {
                                MolPanel.this.toolsMenu.setEnabled(MolPanel.this.isEnabled());
                            }
                        }
                    }
                    finally {
                        MolPanel.this.endHourglass();
                    }
                }
            };
            thread.start();
        }
    }

    public void showStatus(String s) {
        if (this.applet != null) {
            this.applet.showStatus(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPage(String urlstr) {
        CallbackIface m = null;
        URL u = null;
        this.beginHourglass();
        if (this.applet != null) {
            try {
                u = new URL(this.applet.getCodeBase(), urlstr);
                this.applet.getAppletContext().showDocument(u, "_blank");
            }
            catch (MalformedURLException muex) {
                this.errorDisplay.error("Invalid URL:" + urlstr, muex);
            }
            catch (SecurityException ex) {
                this.errorDisplay.firewallError(ex, null);
            }
            finally {
                this.endHourglass();
            }
            return;
        }
        if (!urlstr.startsWith("/")) {
            urlstr = "/".concat(urlstr);
        }
        try {
            u = this.getClass().getResource(urlstr);
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            urlstr = null;
        }
        if (u == null) {
            this.errorDisplay.error(urlstr + " is not found", new IOException());
            this.endHourglass();
            return;
        }
        try {
            m = (CallbackIface)MarvinModule.load("common.swing.Help", this);
            m.callback("setMolPanel", this);
            m.callback("showURL", u);
        }
        catch (SecurityException ex) {
            this.errorDisplay.firewallError(ex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void beginHourglass() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.showStatus("Module is loading...");
            ++this.waitcount;
            if (this.waitcount <= 1) {
                this.initCursor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void endHourglass() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            --this.waitcount;
            if (this.waitcount <= 0) {
                this.initCursor();
            }
            this.showStatus("");
        }
    }

    public ErrorDisplay getErrorDisplay() {
        return this.errorDisplay;
    }

    public String getColorScheme() {
        return this.painterCommon.getColorScheme();
    }

    public void setColorScheme(String v) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setColorScheme(v);
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
        this.userSettings.setProperty("setColorScheme", v, false);
    }

    public boolean isSetColoringEnabled() {
        return this.painterCommon.isSetColoringEnabled();
    }

    public void setSetColoringEnabled(boolean v) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setSetColoringEnabled(v);
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
    }

    public void setSketchColorScheme(String c) {
        this.changeProperty("sketchColorScheme", c);
        this.userSettings.setSketchColorScheme(c);
    }

    public void setViewColorScheme(String c) {
        this.changeProperty("viewColorScheme", c);
        this.userSettings.setViewColorScheme(c);
    }

    protected abstract String getDefaultColorSchemePropertyName();

    public abstract String getDefaultColorScheme();

    public abstract void setDefaultColorScheme(String var1);

    public void setDownWedge(String s) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setDownWedge(s);
        int opts = this.painterCommon.getDispopts();
        this.changeProperty("downWedge", s);
        this.userSettings.setDownWedge(s);
        if ((opts0 & 0x100000) != (opts & 0x100000)) {
            this.repaintMols();
        }
    }

    public void setCoordinateBondStyle(String s) {
        int opts0 = this.painterCommon.getDispoptsExt();
        this.painterCommon.setCoordinateBondStyle(s);
        int opts = this.painterCommon.getDispoptsExt();
        this.changeProperty("coordinateBondStyle", s);
        this.userSettings.setCoordinateBondStyle(s);
        if ((opts0 & 0x200) != (opts & 0x200)) {
            this.repaintMols();
        }
    }

    public void setCoordinateBondStyleAtMulticenter(String s) {
        int opts0 = this.painterCommon.getDispoptsExt();
        this.painterCommon.setCoordinateBondStyleAtMulticenter(s);
        int opts = this.painterCommon.getDispoptsExt();
        this.changeProperty("coordinateBondStyleAtMulticenter", s);
        this.userSettings.setCoordinateBondStyleAtMulticenter(s);
        if ((opts0 & 0x100) != (opts & 0x100)) {
            this.repaintMols();
        }
    }

    public void setBondDraggedAlong(boolean v) {
        this.changeProperty("bondDraggedAlong", String.valueOf(v));
        this.userSettings.setBondDraggedAlong(v);
    }

    public void setValenceErrorVisible(boolean v) {
        this.changeProperty("valenceErrorVisible", String.valueOf(v));
        this.userSettings.setValenceErrorVisible(v);
    }

    public void setValenceErrorVisibleInView(boolean v) {
        this.changeProperty("valenceErrorVisibleInView", String.valueOf(v));
        this.userSettings.setValenceErrorVisibleInView(v);
    }

    public boolean arePopupMenusEnabled() {
        return this.popupMenusEnabled;
    }

    public void setPopupMenusEnabled(boolean b) {
        boolean old = this.arePopupMenusEnabled();
        this.popupMenusEnabled = b;
        this.changeProperty("popupMenusEnabled", String.valueOf(b));
        this.changeListeners.firePropertyChange("popupMenusEnabled", old, b);
    }

    public int getAutoAromatize() {
        return this.autoAromatize;
    }

    public void setAutoAromatize(int v) {
        this.autoAromatize = v;
    }

    public int getAutoHydrogenize() {
        return this.autoHydrogenize;
    }

    public void setAutoHydrogenize(int v) {
        this.autoHydrogenize = v;
    }

    public boolean getAutoClean() {
        return this.autoClean;
    }

    public void setAutoClean(boolean b) {
        this.autoClean = b;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int d) {
        Integer old = new Integer(this.debug);
        this.debug = d;
        this.changeProperty("debug", String.valueOf(d));
        this.changeListeners.firePropertyChange("debug", old, new Integer(d));
    }

    public abstract Object[] getLoadSaveArgs(File var1, String var2, String var3, Molecule var4);

    public final void saveMolfile(File f, String opts, String what, Molecule mol, MolPainter p, boolean inNewFile) {
        this.saveMolfile(f, opts, what, mol, p, inNewFile, true);
    }

    public final void saveMolfile(File f, String opts, String what, Molecule mol, MolPainter p, boolean inNewFile, boolean inNewThread) {
        this.saveMolfile(f, opts, what, mol, p, inNewFile, inNewThread, false);
    }

    protected final void saveMolfile(File f, String opts, String what, Molecule mol, MolPainter p, boolean inNewFile, boolean inNewThread, boolean silentMode) {
        MDocument doc;
        if (mol != null && (doc = mol.getDocument()) != null && p != null) {
            p.storeRTransformInDocument(doc);
            if (this.userSettings != null && this.userSettings.getSaveLoadZoomFactorToMRV()) {
                doc.properties().setObject("scale", new Double(p.getScale()));
            }
        }
        this.loadLoadSaveModule(inNewFile);
        Object[] v = this.getLoadSaveArgs(f, opts, what, mol);
        this.loadsave.callback("silentMode", silentMode);
        this.loadsave.callback("setCwd", this.getSaveCwdFromUserSettings());
        this.loadsave.callback("setInNewThread", new Boolean(inNewThread));
        this.loadsave.callback("setCommand", v);
    }

    public final void openMolfile(File f, String opts) {
        this.loadLoadSaveModule(false);
        Object[] v = this.getLoadSaveArgs(f, opts, "open", null);
        if (f == null) {
            this.loadsave.callback("setCwd", this.getLoadCwdFromUserSettings());
        }
        this.loadsave.callback("setCommand", v);
    }

    protected String getLoadSaveModuleName() {
        return "common.swing.LoadSave";
    }

    private void loadLoadSaveModule(boolean inNewFile) {
        if (this.loadsave == null) {
            this.loadsave = (CallbackIface)MarvinModule.load(this.getLoadSaveModuleName(), this);
            if (this.loadsave != null) {
                this.loadsave.callback("setMolPanel", this);
                File ff = null;
                if (!inNewFile) {
                    ff = this.moleculeFile;
                }
                if (ff == null) {
                    ff = this.moleculeDirectory;
                }
                if (ff != null) {
                    this.loadsave.callback("setFile", ff);
                }
            }
        }
    }

    public final void showMultiMoleculeSaveDialog(Molecule[] mols) {
        if (this.multiMoleculeSave == null) {
            this.multiMoleculeSave = (CallbackIface)MarvinModule.load("common.swing.MultiMoleculeSave", this);
            if (this.multiMoleculeSave != null) {
                this.multiMoleculeSave.callback("setMolPanel", this);
                File f = this.moleculeDirectory;
                if (f != null) {
                    this.multiMoleculeSave.callback("setFile", f);
                }
            }
        }
        this.multiMoleculeSave.callback("setMols", mols);
    }

    public static int getNavMode(Object name) {
        for (int i = 0; i < MM_MODES.length; ++i) {
            if (!MM_MODES[i].equals(name)) continue;
            return i;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void molLoaded(Molecule[] mols, long id) {
        if (mols != null) {
            try {
                this.beginHourglass();
                int a = this.getAutoAromatize();
                int h = this.getAutoHydrogenize();
                for (int i = 0; i < mols.length; ++i) {
                    Molecule m = mols[i];
                    if (m == null) continue;
                    m.setGUIContracted(true);
                    if (a != 0) {
                        m.aromatize(a > 0);
                    }
                    if (h != 0) {
                        m.hydrogenize(h > 0);
                    }
                    if (m.getDim() != 0 && !this.getAutoClean()) continue;
                    m.clean(this.cleanDim, this.getCleanOpts(this.cleanDim));
                }
            }
            catch (SecurityException sex) {
                this.errorDisplay.firewallError(sex, null);
            }
            catch (Throwable ex) {
                this.errorDisplay.error("Error in module Clean" + this.cleanDim + "D", ex);
            }
            finally {
                this.endHourglass();
            }
        }
    }

    protected void molInit() throws Throwable {
        int i;
        Color c;
        Color background;
        String s;
        if (this.applet != null && !Environment.UNTRUSTED) {
            this.setLoadingEnabled(true);
        }
        if ((s = this.getParameter("licenseFile")) != null) {
            LicenseManager.setLicenseFile(s);
        }
        if ((s = this.getParameter("license")) != null) {
            LicenseManager.setLicense(s);
        }
        if ((s = this.getParameter("devel")) != null) {
            this.experimentalEnabled = MolPanel.isTrue(s);
        }
        if ((s = this.getParameter("escapeChar")) != null) {
            char c2 = this.escapeChar = s.length() != 0 ? s.charAt(0) : (char)'\u0000';
        }
        if ((s = this.getParameter("cleanDim")) != null) {
            this.setCleanDim(Integer.parseInt(s));
        }
        if ((s = this.getParameter("cleanOpts")) != null) {
            if (this.cleanDim == 3) {
                if (s.equals("O0")) {
                    s = "S{fast}";
                } else if (s.equals("OD")) {
                    s = "S{fine}";
                }
                this.setClean3dOpts(s);
            } else {
                this.setClean2dOpts(s);
            }
        }
        if ((s = this.getParameter("clean2dOpts")) != null) {
            this.setClean2dOpts(s);
        }
        if ((s = this.getParameter("clean3dOpts")) != null) {
            if (s.equals("O0")) {
                s = "S{fast}";
            } else if (s.equals("OD")) {
                s = "S{fine}";
            }
            this.setClean3dOpts(s);
        }
        if ((background = this.getBackground()) == null && this.applet != null) {
            background = this.applet.getBackground();
        }
        if ((s = this.getParameter("sketchMolbg2d|sketchMolbg")) != null && s.length() != 0 && s.charAt(0) == '#') {
            c = Color.decode(s);
            this.setSketchMolbg2d(c);
        } else {
            this.setSketchMolbg2d(background);
        }
        s = this.getParameter("sketchMolbg3d");
        if (s != null && s.length() != 0 && s.charAt(0) == '#') {
            c = Color.decode(s);
            this.setSketchMolbg3d(c);
        } else {
            this.setSketchMolbg3d(background);
        }
        s = this.getParameter("viewMolbg2d");
        if (s != null && s.length() != 0 && s.charAt(0) == '#') {
            c = Color.decode(s);
            this.setViewMolbg2d(c);
        } else if (this.cleanDim != 3) {
            this.setViewMolbg2d(background);
        }
        s = this.getParameter("viewMolbg3d");
        if (s != null && s.length() != 0 && s.charAt(0) == '#') {
            c = Color.decode(s);
            this.setViewMolbg3d(c);
        } else {
            this.setViewMolbg3d(Color.black);
        }
        s = this.getParameter("molbg");
        if (s != null && s.length() != 0 && s.charAt(0) == '#') {
            int i2 = s.indexOf(44);
            if (i2 >= 0) {
                s = s.substring(0, i2);
            }
            Color bgcolor = Color.decode(s);
            this.setSketchMolbg2d(bgcolor);
            this.setSketchMolbg3d(bgcolor);
            this.setViewMolbg2d(bgcolor);
            this.setViewMolbg3d(bgcolor);
            this.setMolbg(bgcolor);
        } else {
            this.setMolbg(this.getDefaultMolbg());
        }
        s = this.getParameter("atomFont");
        if (s != null) {
            this.setAtomFont(new Font(s, 0, 12));
        }
        if ((s = this.getParameter("atomsize")) != null) {
            this.setAtomsize(Double.parseDouble(s));
        }
        if ((s = this.getParameter("bondSpacing|bondWidth")) != null) {
            this.setBondSpacing(Double.parseDouble(s));
        }
        if ((s = this.getParameter("fogFactor")) != null) {
            this.setFogFactor(Integer.parseInt(s));
        }
        if ((s = this.getParameter("automaticFogEnabled")) != null) {
            this.setAutomaticFogEnabled(Boolean.parseBoolean(s));
        }
        if ((s = this.getParameter("wireThickness")) != null) {
            this.setWireThickness(Double.parseDouble(s));
        }
        if ((s = this.getParameter("stickThickness")) != null) {
            this.setStickThickness(Double.parseDouble(s));
        }
        if ((s = this.getParameter("ballRadius")) != null) {
            this.setBallRadius(Double.parseDouble(s));
        }
        if ((s = this.getParameter("sketchArrowHeadLength")) != null) {
            this.userSettings.setSketchArrowHeadLength(Double.parseDouble(s));
        }
        if ((s = this.getParameter("sketchArrowHeadWidth")) != null) {
            this.userSettings.setSketchArrowHeadWidth(Double.parseDouble(s));
        }
        if ((s = this.getParameter("sketchArrowTailLength")) != null) {
            this.userSettings.setSketchArrowTailLength(Double.parseDouble(s));
        }
        if ((s = this.getParameter("sketchArrowTailWidth")) != null) {
            this.userSettings.setSketchArrowTailWidth(Double.parseDouble(s));
        }
        if ((s = this.getParameter("molFormat")) != null) {
            this.molFormat = s;
        }
        if ((s = this.getParameter("rLogicVisible")) != null) {
            this.setRLogicVisible(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("showSets")) != null) {
            MStringTokenizer st = new MStringTokenizer(s, ',', '\u0000');
            long f = -1L;
            while ((s = st.trimNextToken()) != null) {
                int id = Integer.parseInt(s);
                f &= (long)(~(1 << id));
            }
            this.painterCommon.invisibleSets = f;
        }
        if ((s = this.getParameter("cacheMols")) != null) {
            this.cacheMols = MolPanel.isTrue(s);
        }
        if ((s = this.getParameter("imageSaveURL")) != null) {
            if (this.applet != null) {
                this.saveImageTool.setImageSaveURL(new URL(this.applet.getDocumentBase(), s));
            } else {
                this.saveImageTool.setImageSaveURL(new URL(s));
            }
        }
        if ((s = this.getParameter("imageSaveFormat")) != null) {
            this.saveImageTool.setFormat(s);
        }
        if ((s = this.getParameter("imageShowURL")) != null) {
            if (this.applet != null) {
                this.saveImageTool.setImageShowURL(new URL(this.applet.getDocumentBase(), s));
            } else {
                this.saveImageTool.setImageShowURL(new URL(s));
            }
        }
        if ((s = this.getParameter("sketchColorScheme")) != null) {
            this.setSketchColorScheme(s);
        }
        if ((s = this.getParameter("viewColorScheme")) != null) {
            this.setViewColorScheme(s);
        }
        if ((s = this.getParameter("colorScheme")) != null) {
            this.setColorScheme(s);
        } else {
            this.setColorScheme(this.getDefaultColorScheme());
        }
        s = this.getParameter("setColoringEnabled");
        if (s != null) {
            this.setSetColoringEnabled(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("sketchRendering2d|sketchRendering")) != null) {
            this.setSketchRendering2d(s);
        }
        if ((s = this.getParameter("sketchRendering3d")) != null) {
            this.setSketchRendering3d(s);
        }
        if ((s = this.getParameter("viewRendering2d")) != null) {
            this.setViewRendering2d(s);
        }
        if ((s = this.getParameter("viewRendering3d")) != null) {
            this.setViewRendering3d(s);
        }
        if ((s = this.getParameter("rLogicVisible")) != null) {
            this.setRLogicVisible(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("rendering")) != null) {
            this.setSketchRendering2d(s);
            this.setSketchRendering3d(s);
            this.setViewRendering2d(s);
            this.setViewRendering3d(s);
            this.setRendering(s);
        } else {
            this.setRendering(this.getDefaultRendering());
        }
        s = this.getParameter("dispQuality");
        if (s != null) {
            int v = Integer.parseInt(s);
            this.setDispQuality(v);
        }
        if ((s = this.getParameter("bondDraggedAlong")) != null) {
            this.setBondDraggedAlong(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("simpView")) != null) {
            this.setBondDraggedAlong(Integer.parseInt(s) == 0);
        }
        if ((s = this.getParameter("downWedge")) != null) {
            this.setDownWedge(s);
        }
        if ((s = this.getParameter("coordinateBondStyle")) != null) {
            this.setCoordinateBondStyle(s);
        }
        if ((s = this.getParameter("coordinateBondStyleAtMulticenter")) != null) {
            this.setCoordinateBondStyleAtMulticenter(s);
        }
        if ((s = this.getParameter("valenceErrorVisible")) != null) {
            this.setValenceErrorVisible(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("valenceErrorVisibleInView")) != null) {
            this.setValenceErrorVisibleInView(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("atomNumbersVisible")) != null) {
            this.setAtomNumbersVisible(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("atomPropertiesVisible")) != null) {
            this.setAtomPropertiesVisible(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("atomMappingVisible")) != null) {
            this.setAtomMappingVisible(MolPanel.isTrue(s));
        } else {
            this.setAtomMappingVisible(true);
        }
        s = this.getParameter("lonePairsVisible");
        if (s != null) {
            this.setLonePairsVisible(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("lonePairsAutoCalc")) != null) {
            this.setLonePairsAutoCalc(MolPanel.isTrue(s));
        } else {
            this.setLonePairsAutoCalc(true);
        }
        s = this.getParameter("grinvVisible|grinv");
        if (s != null) {
            this.setGrinvVisible(Boolean.valueOf(s));
        }
        if ((s = this.getParameter("skin")) != null && Environment.isSkinEnabled()) {
            this.setSkin(s);
        }
        if ((s = this.getParameter("autoscale")) != null) {
            this.setAutoScale(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("sketchAnyBond")) != null) {
            this.setSketchAnyBond(s);
        }
        if ((s = this.getParameter("viewAnyBond")) != null) {
            this.setViewAnyBond(s);
        }
        if ((s = this.getParameter("anybond")) != null) {
            this.setAnyBond(s);
        } else {
            this.setAnyBond(this.getDefaultAnyBond());
        }
        s = this.getParameter("importConv");
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, ", \t");
            while (st.hasMoreTokens()) {
                String ss = st.nextToken();
                int sign = 1;
                for (int i3 = 0; i3 < ss.length(); ++i3) {
                    char c3 = ss.charAt(i3);
                    if (c3 == '+' || c3 == '-') {
                        sign = c3 == '+' ? 1 : -1;
                        continue;
                    }
                    if (c3 == 'a') {
                        this.setAutoAromatize(sign);
                        continue;
                    }
                    if (c3 == 'H') {
                        this.setAutoHydrogenize(sign);
                        continue;
                    }
                    if (c3 != 'c') continue;
                    this.setAutoClean(true);
                }
            }
        }
        if ((s = this.getParameter("sketchImplicitH")) != null) {
            this.setSketchImplicitH(s);
        }
        if ((s = this.getParameter("viewImplicitH")) != null) {
            this.setViewImplicitH(s);
        }
        if ((s = this.getParameter("implicitH")) != null) {
            this.setImplicitH(s);
        } else {
            this.setImplicitH(this.getDefaultImplicitH());
        }
        s = this.getParameter("viewNavMode2d");
        if (s != null) {
            this.setViewNavmode2d(s);
        }
        if ((s = this.getParameter("viewNavMode3d")) != null) {
            this.setViewNavmode3d(s);
        }
        if ((s = this.getParameter("navmode")) != null) {
            this.setNavmode(s);
        }
        if ((s = this.getParameter("chiralitySupport")) != null) {
            for (int i4 = RS_OPTIONS.length - 1; i4 >= 0; --i4) {
                if (!RS_OPTIONS[i4].equals(s)) continue;
                this.setChiralitySupport(i4);
                break;
            }
        }
        if ((s = this.getParameter("absLabelVisible|absLabel")) != null) {
            this.setAbsLabelVisible(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("ezVisible")) != null) {
            this.setEzVisible(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("valencePropertyVisible")) != null) {
            this.setValencePropertyVisible(MolPanel.isTrue(s));
        } else {
            this.setValencePropertyVisible(true);
            this.userSettings.setValencePropertyVisible(true);
        }
        s = this.getParameter("ligandErrorVisible");
        if (s != null) {
            this.setLigandErrorVisible(MolPanel.isTrue(s));
        } else {
            this.setLigandErrorVisible(true);
            this.userSettings.setLigandErrorVisible(true);
        }
        s = this.getParameter("bondLengthVisible");
        if (s != null) {
            this.setBondLengthVisible(MolPanel.isTrue(s));
        }
        if ((s = this.getParameter("rgroupsVisible")) != null) {
            this.setRgroupsVisible(MolPanel.isTrue(s));
        } else {
            this.setRgroupsVisible(this.getDefaultRgroupVisibility());
        }
        s = this.getParameter("label|atomSymbolsVisible");
        if (s != null) {
            this.setAtomSymbolsVisible(MolPanel.isTrue(s));
        } else {
            this.setAtomSymbolsVisible(true);
        }
        for (i = 0; i <= 63; ++i) {
            s = this.getParameter("setColor" + i + "|" + "atomSetColor" + i);
            if (s == null || s.length() == 0 || s.charAt(0) != '#') continue;
            this.painterCommon.setAtomSetColor(i, Color.decode(s));
        }
        for (i = 0; i <= 63; ++i) {
            s = this.getParameter("bondSetColor" + i);
            if (s == null || s.length() == 0 || s.charAt(0) != '#') continue;
            this.painterCommon.setBondSetColor(i, Color.decode(s));
        }
        this.animFPS = 10.0;
        s = this.getParameter("animFPS");
        if (s != null) {
            this.animFPS = Double.parseDouble(s);
        }
        this.animDelay = 0.0;
        s = this.getParameter("animDelay");
        if (s != null) {
            this.animDelay = Double.parseDouble(s);
        }
        if ((s = this.getParameter("copyAsFormat")) != null) {
            this.userSettings.setCopyAsFormat(s);
        }
        if ((s = this.getParameter("defaultSaveFormat")) != null) {
            this.userSettings.setDefaultSaveFormat(s);
        }
    }

    protected abstract boolean getDefaultRgroupVisibility();

    protected void molStart() {
    }

    protected void checkWrite() {
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                String home = System.getProperty("user.home");
                File f = new File(home, "test.mol");
                security.checkWrite(f.getPath());
            }
            this.checkWriteEnableActions(true);
        }
        catch (SecurityException sex) {
            this.checkWriteEnableActions(false);
        }
    }

    protected void checkRead() {
        this.checkReadEnableActions(this.isReadEnabled());
    }

    public boolean isReadEnabled() {
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                String home = System.getProperty("user.home");
                File f = new File(home, "test.mol");
                security.checkRead(f.getPath());
            }
            return true;
        }
        catch (SecurityException sex) {
            return false;
        }
    }

    protected abstract void checkReadEnableActions(boolean var1);

    public boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    protected void checkWriteEnableActions(boolean v) {
        this.writeEnabled = v;
    }

    public static void setColors(Container container, Color bg, Color fg) {
        container.setBackground(bg);
        container.setForeground(fg);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component c = container.getComponent(i);
            c.setBackground(bg);
            c.setForeground(fg);
            if (!(c instanceof Container)) continue;
            MolPanel.setColors((Container)c, bg, fg);
        }
    }

    protected final void changeProperty(String name, String val) {
        if (this.properties != null) {
            if (val != null) {
                this.properties.put(name.toLowerCase(), val);
            } else {
                this.properties.remove(name.toLowerCase());
            }
        }
    }

    public Cursor getCurrentCursor() {
        if (this.waitcount > 0) {
            return Cursor.getPredefinedCursor(3);
        }
        return this.navmodeCursors[(this.getDispopts() & 0x38) >> 3];
    }

    protected void initCursor() {
        this.initCursor(this);
    }

    protected final void initCursor(Component c) {
        while (c != null && !(c instanceof Window)) {
            c = c.getParent();
        }
        if (c != null) {
            this.cursor = this.getCurrentCursor();
            if (EventQueue.isDispatchThread()) {
                this.setMarvinCursor(this.cursor, c);
                return;
            }
            try {
                final Component fc = c;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    MolPanel.this.setMarvinCursor(MolPanel.this.cursor, fc);
                                }
                            });
                        }
                        catch (InterruptedException ex) {
                            System.err.println("MolPanel.run: invokeAndWait: " + ex.toString());
                        }
                        catch (InvocationTargetException ex) {
                            System.err.println("MolPanel.run: invokeAndWait: " + ex.toString());
                        }
                    }
                };
                new Thread(r, "MRV-setCursor").start();
            }
            catch (SecurityException sex) {
                System.err.print("security -> cannot start cursor setting thread -> DEADLOCK danger...");
                System.err.flush();
                this.setMarvinCursor(this.cursor, c);
                System.err.println(" survived!");
            }
        }
    }

    protected abstract void setMarvinCursor(Cursor var1);

    private void setMarvinCursor(Cursor cursor, Component c) {
        int t;
        int n = t = cursor != null ? cursor.getType() : 0;
        if (t == 0 || t == 3) {
            this.setCursor(cursor);
            c.setCursor(cursor);
        } else {
            Cursor defcrsr = Cursor.getPredefinedCursor(0);
            this.setCursor(defcrsr);
            c.setCursor(defcrsr);
        }
        this.setMarvinCursor(cursor);
    }

    protected abstract void clean(int var1);

    public static boolean isTrue(String s) {
        if (s != null) {
            return (s = s.toLowerCase()).equals("true") || s.equals("on") || s.equals("all");
        }
        return false;
    }

    public Image getImage(String s) {
        Image img = null;
        if (this.applet != null) {
            try {
                URL u = new URL(this.applet.getDocumentBase(), s);
                img = this.applet.getImage(u);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            img = Toolkit.getDefaultToolkit().getImage(s);
        }
        return img;
    }

    private void disposeFrame(Window f) {
        if (f instanceof PropertyChangeListener && this.changeListeners != null) {
            this.changeListeners.removePropertyChangeListener((PropertyChangeListener)((Object)f));
        }
        if (f.isVisible()) {
            f.setVisible(false);
        }
        f.dispose();
    }

    protected void createVecs() {
        if (this.changeListeners == null) {
            this.changeListeners = new PropertyChangeSupport(this);
        }
    }

    private void initActions() {
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control shift meta alt altGraph MINUS"), "none");
    }

    protected final void initAccelerators(Action action, KeyStroke[] strokes) {
        Object key = action.getValue("ActionCommandKey");
        for (int i = 0; i < strokes.length; ++i) {
            KeyStroke stroke = strokes[i];
            this.getInputMap(0).put(stroke, key);
            this.getInputMap(1).put(stroke, key);
        }
        this.getActionMap().put(key, action);
    }

    private boolean pluginsAvailable() {
        return isPluginsConfigExists || this.getParameter("toolfiles") != null;
    }

    private void initTransient() {
        this.loaders = new ArrayList<MolLoader>();
        this.molPanelLock = new Object();
    }

    private void initPluginManager() {
        if (!this.pluginsAvailable()) {
            return;
        }
        try {
            Class<?> cl = Class.forName("chemaxon.marvin.plugin.PluginManager");
            this.pluginManager = (CallbackIface)cl.newInstance();
            if (this.pluginManager.callback("init", this) == null) {
                this.pluginManager = null;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initPluginActions() {
        if (this.pluginActions != null) {
            return;
        }
        if (this.pluginManager == null) {
            this.initPluginManager();
        }
        if (this.pluginManager == null) {
            this.pluginActions = new DelegatingAction[0];
            return;
        }
        int n = (Integer)this.pluginManager.callback("getCount", null);
        this.pluginActions = new DelegatingAction[n];
        this.pluginGroups = new String[n];
        this.pluginGroupMnemonics = new char[n];
        this.pluginSeparators = new boolean[n];
        for (int i = 0; i < n; ++i) {
            Integer I = new Integer(i);
            String menu = (String)this.pluginManager.callback("getMenu", I);
            String key = (String)this.pluginManager.callback("getKey", I);
            Character mnemonic = (Character)this.pluginManager.callback("getMnemonic", I);
            if (mnemonic != null) {
                menu = "'" + mnemonic + "'" + menu;
            }
            String group = (String)this.pluginManager.callback("getGroup", I);
            Character groupmnemonic = (Character)this.pluginManager.callback("getGroupMnemonic", I);
            this.pluginSeparators[i] = (Boolean)this.pluginManager.callback("getSeparator", I);
            this.pluginActions[i] = new DelegatingAction("plugin_" + key, menu);
            this.pluginGroups[i] = group;
            this.pluginGroupMnemonics[i] = groupmnemonic.charValue();
        }
        this.addActionListenerToPluginActions(this);
    }

    public Action getPluginAction(String key) {
        this.initPluginActions();
        for (DelegatingAction action : this.pluginActions) {
            if (!key.equals(action.getValue("ActionCommandKey"))) continue;
            return action;
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initTransient();
        Iterator<Window> it = this.vframes.keySet().iterator();
        while (it.hasNext()) {
            Window f;
            Integer v = this.vframes.get(f = it.next());
            f.setVisible(v != null && v != 0);
        }
    }

    public boolean setSkin(String skin) {
        try {
            UIManager.setLookAndFeel(skin);
            this.userSettings.setProperty("skin", skin);
            this.changeProperty("skin", skin);
        }
        catch (Exception e) {
            return false;
        }
        Window parent = SwingUtilities.getWindowAncestor(this);
        HashSet<Window> updated = new HashSet<Window>();
        if (parent != null) {
            SwingUtilities.updateComponentTreeUI(parent);
            parent.validate();
            updated.add(parent);
        }
        if (!(this.applet == null || parent != null && SwingUtilities.isDescendingFrom(this.applet, parent))) {
            SwingUtilities.updateComponentTreeUI(this.applet);
            this.applet.validate();
        }
        if (!(parent != null || this.applet != null && SwingUtilities.isDescendingFrom(this, this.applet))) {
            SwingUtilities.updateComponentTreeUI(this);
            this.validate();
        }
        for (Window win : this.vframes.keySet()) {
            if (updated.contains(win)) continue;
            try {
                SwingUtilities.updateComponentTreeUI(win);
                win.pack();
                updated.add(win);
            }
            catch (ClassCastException cce) {}
        }
        return true;
    }

    public static String getColorSchemeName(String key) {
        return DispOptsActions.getColorSchemeName(key);
    }

    public boolean isSaveIniEnabled() {
        return this.saveIniEnabled;
    }

    public void setSaveIniEnabled(boolean v) {
        if (this.getParentMolPanel() != null) {
            throw new IllegalArgumentException("Cannot enable ini file saving for child window");
        }
        this.saveIniEnabled = v;
    }

    public UserSettings getUserSettings() {
        return this.userSettings;
    }

    public void setUserSettings(UserSettings settings) {
        this.userSettings.removeAllProperty();
        Map<String, String> persprops = settings.getPropertyMap("persistent");
        for (String s : persprops.keySet()) {
            this.userSettings.setProperty(s, persprops.get(s));
        }
        Map<String, String> sessprops = settings.getPropertyMap("transient");
        for (String s : sessprops.keySet()) {
            this.userSettings.setProperty(s, sessprops.get(s), false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (this.painterCommon == null) {
            return;
        }
        Object src = ev.getSource();
        String key = ev.getPropertyName();
        if (key.equals("downWedge")) {
            this.painterCommon.setDownWedge(this.userSettings.getDownWedge());
            this.repaintMols();
        } else if (key.equals("atomFont")) {
            this.setAtomFont(this.userSettings.getAtomFont());
            this.repaintMols();
        } else if (key.equals("atomsize")) {
            this.setAtomsize(this.userSettings.getAtomSize());
            this.repaintMols();
        } else if (key.equals("wireThickness")) {
            this.painterCommon.setWireThickness(this.userSettings.getWireThickness());
            this.repaintMols();
        } else if (key.equals("stickThickness")) {
            this.painterCommon.setStickThickness(this.userSettings.getStickThickness());
            this.repaintMols();
        } else if (key.equals("ballRadius")) {
            this.painterCommon.setBallRadius(this.userSettings.getBallRadius());
            this.repaintMols();
        } else if (key.equals("coordinateBondStyle")) {
            this.setCoordinateBondStyle(this.userSettings.getCoordinateBondStyle());
            this.repaintMols();
        } else if (key.equals("coordinateBondStyleAtMulticenter")) {
            this.setCoordinateBondStyleAtMulticenter(this.userSettings.getCoordinateBondStyleAtMulticenter());
            this.repaintMols();
        } else if (src == this.userSettings) {
            if (key.equals("clean2dOpts")) {
                this.setClean2dOpts(this.userSettings.getClean2dOpts());
            } else if (key.equals("clean3dOpts")) {
                this.setClean3dOpts(this.userSettings.getClean3dOpts());
            } else if (key.equals("aromatizeMethod")) {
                this.setAromatizeMethod(this.userSettings.getAromatizeMethod());
            }
            this.properties.setProperty(key.toLowerCase(), this.userSettings.getProperty(key));
            this.forwardPropertyChangeEvent(ev);
        } else if (key.equals("atomMarked")) {
            this.forwardPropertyChangeEvent(ev);
        } else if (key.equals("dimension") && !this.userSettings.getProperty("dimension").isEmpty()) {
            this.setCleanDim(Integer.valueOf(this.userSettings.getProperty("dimension")));
            this.repaintMols();
        }
    }

    public Font getSmallFont() {
        return smallFont;
    }

    private static Component getMarvinMenuBarContainer(JRootPane root) {
        for (Container c = root; c != null; c = c.getParent()) {
            JMenuBar mb = null;
            if (c instanceof JRootPane) {
                mb = c.getJMenuBar();
            }
            if (c instanceof JFrame) {
                mb = ((JFrame)c).getJMenuBar();
            }
            if (mb == null) continue;
            return c;
        }
        return null;
    }

    public static JMenuBar getMarvinMenuBar(JRootPane root) {
        Component c = MolPanel.getMarvinMenuBarContainer(root);
        if (c == null) {
            return null;
        }
        if (c instanceof JRootPane) {
            return ((JRootPane)c).getJMenuBar();
        }
        if (c instanceof JFrame) {
            return ((JFrame)c).getJMenuBar();
        }
        return null;
    }

    protected static boolean updateMarvinMenuBar(JRootPane root, JMenuBar mb) {
        Component c = MolPanel.getMarvinMenuBarContainer(root);
        if (c != null) {
            if (c instanceof JRootPane) {
                JRootPane croot = (JRootPane)c;
                croot.setJMenuBar(mb);
                c.validate();
                return true;
            }
            if (c instanceof JFrame) {
                JFrame f = (JFrame)c;
                f.setJMenuBar(mb);
                return true;
            }
        }
        return false;
    }

    public static JMenu createMenuG(String key) {
        return SwingUtil.createMenu(GRESOURCES, key, true);
    }

    public static JMenu createMenuG(String key, boolean mnemo) {
        return SwingUtil.createMenu(GRESOURCES, key, mnemo);
    }

    protected static String getDefaultLocales() {
        String locales = null;
        if (GRESOURCES != null) {
            try {
                locales = GRESOURCES.getString("LOCALES");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return locales;
    }

    public static ResourceBundle getResourceBundle(String name) {
        String locales = MolPanel.getDefaultLocales();
        return LocaleUtil.getResourceBundle(name, locales);
    }

    public static String getLabelResource(ResourceBundle rc, String key) {
        String label = rc.getString(key);
        if (label.startsWith("'") && label.length() > 3 && label.charAt(2) == '\'') {
            return label.substring(3);
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void js(String script) {
        if (this.applet == null) {
            return;
        }
        try {
            this.beginHourglass();
            try {
                if (this.jscripter == null) {
                    this.jscripter = (MarvinModule)MarvinModule.load("view.JavaScripter", null);
                    if (this.jscripter != null) {
                        this.jscripter.modfunc(this.applet);
                    }
                }
            }
            finally {
                this.endHourglass();
            }
            if (this.jscripter != null) {
                this.jscripter.modfunc(script);
            }
        }
        catch (SecurityException sex) {
            this.errorDisplay.firewallError(sex, null);
        }
    }

    @Override
    public final String getVersion() {
        return mver;
    }

    public void storeGlobalGUIProperties(MolExportModule cv) {
        if (cv != null && cv instanceof MrvExport && this.userSettings.getSaveGUIPropertiesInMRV()) {
            if (this.globalGUIProperties == null) {
                this.globalGUIProperties = new MPropertyContainer();
            }
            this.globalGUIProperties.clear();
            String rgb = ColorParser.toString(this.getMolbg());
            MStringProp backgroundRGB = new MStringProp(rgb);
            this.globalGUIProperties.set("backgroundRGB", backgroundRGB);
            ((MrvExport)cv).setGlobalGUIProperties(this.globalGUIProperties);
        }
    }

    public void setGlobalGUIProperties(MPropertyContainer gp) {
        this.globalGUIProperties = gp;
        if (this.globalGUIProperties != null) {
            MFontProp fontProp;
            MDoubleProp dProp;
            MStringProp sProp;
            MIntegerProp iProp;
            boolean ve;
            MBooleanProp bProp = (MBooleanProp)this.globalGUIProperties.get("setColoringEnabled");
            if (bProp != null) {
                this.setSetColoringEnabled(bProp.booleanValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("atomNumbersVisible")) != null) {
                this.setAtomNumbersVisible(bProp.booleanValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("atomPropertiesVisible")) != null) {
                this.setAtomPropertiesVisible(bProp.booleanValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("atomMappingVisible")) != null) {
                this.setAtomMappingVisible(bProp.booleanValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("grinvVisible")) != null) {
                this.setGrinvVisible(bProp.booleanValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("ezVisible")) != null) {
                this.setEzVisible(bProp.booleanValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("bondLengthVisible")) != null) {
                this.setBondLengthVisible(bProp.booleanValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("bondDraggedAlong")) != null) {
                this.userSettings.setBondDraggedAlong(bProp.booleanValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("valenceErrorVisible")) != null) {
                ve = bProp.booleanValue();
                this.setValenceErrorVisible(ve);
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("valenceErrorVisibleInView")) != null) {
                ve = bProp.booleanValue();
                this.setValenceErrorVisibleInView(ve);
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("automaticFogEnabled")) != null) {
                ve = bProp.booleanValue();
                this.setAutomaticFogEnabled(ve);
            }
            if ((iProp = (MIntegerProp)this.globalGUIProperties.get("fogFactor")) != null) {
                this.setFogFactor(iProp.intValue());
            }
            if ((iProp = (MIntegerProp)this.globalGUIProperties.get("dispQuality")) != null) {
                this.setDispQuality(iProp.intValue());
            }
            if ((iProp = (MIntegerProp)this.globalGUIProperties.get("chiralitySupport")) != null) {
                this.setChiralitySupport(iProp.intValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("invisibleSets")) != null) {
                Long lVal = new Long(sProp.stringValue());
                this.setInvisibleSets(lVal);
            }
            if ((dProp = (MDoubleProp)this.globalGUIProperties.get("atomsize")) != null) {
                this.setAtomsize(dProp.doubleValue());
            }
            if ((dProp = (MDoubleProp)this.globalGUIProperties.get("bondSpacing")) != null) {
                this.setBondSpacing(dProp.doubleValue());
            }
            if ((dProp = (MDoubleProp)this.globalGUIProperties.get("wireThickness")) != null) {
                this.setWireThickness(dProp.doubleValue());
            }
            if ((dProp = (MDoubleProp)this.globalGUIProperties.get("stickThickness")) != null) {
                this.setStickThickness(dProp.doubleValue());
            }
            if ((dProp = (MDoubleProp)this.globalGUIProperties.get("ballRadius")) != null) {
                this.setBallRadius(dProp.doubleValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("rendering")) != null) {
                this.setRendering(sProp.stringValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("downWedge")) != null) {
                this.setDownWedge(sProp.stringValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("coordinateBondStyle")) != null) {
                this.setCoordinateBondStyle(sProp.stringValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("coordinateBondStyleAtMulticenter")) != null) {
                this.setCoordinateBondStyleAtMulticenter(sProp.stringValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("anybond")) != null) {
                this.setAnyBond(sProp.stringValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("viewCarbonVisibility")) != null) {
                this.setCarbonVisibility(sProp.stringValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("sketchCarbonVisibility")) != null) {
                this.setCarbonVisibility(sProp.stringValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("viewLigandOrderVisibility")) != null) {
                this.setLigandOrderVisibility(sProp.stringValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("sketchLigandOrderVisibility")) != null) {
                this.setLigandOrderVisibility(sProp.stringValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("atomSymbolVisible3D")) != null) {
                this.setAtomSymbolsVisible(bProp.booleanValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("implicitH")) != null) {
                this.setImplicitH(sProp.stringValue());
            }
            String s = null;
            sProp = (MStringProp)this.globalGUIProperties.get("molbg");
            if (sProp != null && (s = sProp.stringValue()).length() != 0 && s.charAt(0) == '#') {
                Color c = Color.decode(s);
                this.setMolbg(c);
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("lonePairsVisible")) != null) {
                this.setLonePairsVisible(bProp.booleanValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("rgroupsVisible")) != null) {
                this.setRgroupsVisible(bProp.booleanValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("viewNavMode2d")) != null) {
                this.setViewNavmode2d(sProp.stringValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("viewNavMode3d")) != null) {
                this.setViewNavmode3d(sProp.stringValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("autoscale")) != null) {
                this.setAutoScale(bProp.booleanValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("absLabelVisible")) != null) {
                this.setAbsLabelVisible(bProp.booleanValue());
            }
            if ((sProp = (MStringProp)this.globalGUIProperties.get("colorScheme")) != null) {
                this.setColorScheme(sProp.stringValue());
            }
            if ((bProp = (MBooleanProp)this.globalGUIProperties.get("lonePairsAutoCalc")) != null) {
                this.setLonePairsAutoCalc(bProp.booleanValue());
            }
            if ((fontProp = (MFontProp)this.globalGUIProperties.get("atomFont")) != null) {
                this.setAtomFont(fontProp.getFont().getAWTFont());
            }
        }
    }

    public MPropertyContainer getGlobalGUIProperties() {
        boolean doSaveProperties = this.userSettings.getSaveGUIPropertiesInMRV();
        if (doSaveProperties) {
            MPropertyContainer newPC = new MPropertyContainer();
            MBooleanProp doSave = new MBooleanProp(true);
            newPC.set("saveproperties", doSave);
            newPC.set("setColoringEnabled", new MBooleanProp(this.isSetColoringEnabled()));
            newPC.set("atomNumbersVisible", new MBooleanProp(this.isAtomNumbersVisible()));
            newPC.set("atomPropertiesVisible", new MBooleanProp(this.isAtomPropertiesVisible()));
            newPC.set("atomMappingVisible", new MBooleanProp(this.isAtomMappingVisible()));
            newPC.set("grinvVisible", new MBooleanProp(this.isGrinvVisible()));
            newPC.set("ezVisible", new MBooleanProp(this.isEzVisible()));
            newPC.set("bondLengthVisible", new MBooleanProp(this.isBondLengthVisible()));
            newPC.set("bondDraggedAlong", new MBooleanProp(this.userSettings.isBondDraggedAlong()));
            newPC.set("valenceErrorVisible", new MBooleanProp(this.userSettings.isValenceErrorVisible()));
            newPC.set("valenceErrorVisibleInView", new MBooleanProp(this.userSettings.isValenceErrorVisibleInView()));
            newPC.set("atomSymbolVisible3D", new MBooleanProp(this.isAtomSymbolsVisible()));
            newPC.set("rgroupsVisible", new MBooleanProp(this.isRgroupsVisible()));
            newPC.set("lonePairsAutoCalc", new MBooleanProp(this.userSettings.isLonePairAutoCalc()));
            try {
                Color molbg = this.getMolbg();
                String molbgStr = ColorParser.toString(molbg);
                newPC.set("molbg", new MStringProp(molbgStr));
            }
            catch (IllegalArgumentException iaex) {
                // empty catch block
            }
            newPC.set("dispQuality", new MIntegerProp(this.getDispQuality()));
            newPC.set("chiralitySupport", new MIntegerProp(this.getChiralitySupport()));
            newPC.set("invisibleSets", new MStringProp(Long.toString(this.getInvisibleSets())));
            newPC.set("atomsize", new MDoubleProp(this.userSettings.getAtomSize()));
            newPC.set("bondSpacing", new MDoubleProp(this.userSettings.getBondSpacing()));
            newPC.set("wireThickness", new MDoubleProp(this.userSettings.getWireThickness()));
            newPC.set("stickThickness", new MDoubleProp(this.userSettings.getStickThickness()));
            newPC.set("ballRadius", new MDoubleProp(this.getBallRadius()));
            newPC.set("rendering", new MStringProp(this.getRendering()));
            newPC.set("downWedge", new MStringProp(this.userSettings.getDownWedge()));
            newPC.set("coordinateBondStyle", new MStringProp(this.userSettings.getCoordinateBondStyle()));
            newPC.set("coordinateBondStyleAtMulticenter", new MStringProp(this.userSettings.getCoordinateBondStyleAtMulticenter()));
            newPC.set("anybond", new MStringProp(this.getAnyBond()));
            newPC.set("atomFont", new MFontProp(this.userSettings.getAtomFont()));
            newPC.set("implicitH", new MStringProp(this.getImplicitH()));
            newPC.set("lonePairsVisible", new MBooleanProp(this.getLonePairsVisible()));
            newPC.set("viewNavMode2d", new MStringProp(this.userSettings.getViewNavmode2d()));
            newPC.set("viewNavMode3d", new MStringProp(this.userSettings.getViewNavmode3d()));
            newPC.set("autoscale", new MBooleanProp(this.getAutoScale()));
            newPC.set("absLabelVisible", new MBooleanProp(this.isAbsLabelVisible()));
            newPC.set("colorScheme", new MStringProp(this.getColorScheme()));
            newPC.set("viewCarbonVisibility", new MStringProp(this.userSettings.getViewCarbonVisibility()));
            newPC.set("sketchCarbonVisibility", new MStringProp(this.userSettings.getSketchCarbonVisibility()));
            newPC.set("viewLigandOrderVisibility", new MStringProp(this.userSettings.getViewLigandOrderVisibility()));
            newPC.set("sketchLigandOrderVisibility", new MStringProp(this.userSettings.getSketchLigandOrderVisibility()));
            newPC.set("rLogicVisible", new MStringProp(this.userSettings.getRLogicVisible()));
            this.globalGUIProperties = newPC;
        } else {
            this.globalGUIProperties = null;
        }
        return this.globalGUIProperties;
    }

    public boolean getSaveGlobalGUIProperties() {
        boolean saveProps = this.userSettings.getSaveGUIPropertiesInMRV();
        if (this.globalGUIProperties == null) {
            this.globalGUIProperties = new MPropertyContainer();
        }
        MBooleanProp sp = new MBooleanProp(saveProps);
        this.globalGUIProperties.set("saveguiproperties", sp);
        return saveProps;
    }

    public void setSaveGlobalGUIProperties(boolean flag) {
        this.userSettings.setSaveGUIPropertiesInMRV(flag);
        if (this.globalGUIProperties == null) {
            this.globalGUIProperties = new MPropertyContainer();
        }
        MBooleanProp sp = new MBooleanProp(flag);
        this.globalGUIProperties.set("saveguiproperties", sp);
    }

    protected CallbackIface loadMSpaceViewer(String mspaceViewerClassName) throws Exception {
        try {
            Class.forName("chemaxon.marvin.space.gui.MSpace");
        }
        catch (ClassNotFoundException cne) {
            this.errorDisplay.error("MarvinSpace is not available", cne);
        }
        try {
            Class.forName("com.sun.opengl.impl.NativeLibLoader");
        }
        catch (ClassNotFoundException cne) {
            this.errorDisplay.error("Jogl is not available", cne);
        }
        Class<?> MSpaceViewerClass = Class.forName(mspaceViewerClassName);
        CallbackIface msw = null;
        msw = this.applet != null ? (CallbackIface)MSpaceViewerClass.getConstructor(Boolean.TYPE, URL.class, Boolean.TYPE).newInstance(Boolean.TRUE, this.applet.getCodeBase(), Boolean.FALSE) : (CallbackIface)MSpaceViewerClass.getConstructor(Boolean.TYPE, URL.class).newInstance(Boolean.TRUE, null);
        return msw;
    }

    protected CallbackIface loadMSpaceViewer() throws Exception {
        return this.loadMSpaceViewer("chemaxon.marvin.space.gui.MSpaceViewer");
    }

    protected Window getMSpaceViewer(CallbackIface msw) throws Exception {
        if (msw == null) {
            return null;
        }
        Object msf = msw.callback("getMSpaceViewer", this);
        Window mspaceDialog = null;
        try {
            mspaceDialog = (Window)msf;
        }
        catch (ClassCastException e) {
            if (msf instanceof UnsatisfiedLinkError) {
                UnsatisfiedLinkError ule = (UnsatisfiedLinkError)msf;
                if (ule.getMessage().lastIndexOf("already loaded in another classloader") > 0) {
                    this.errorDisplay.error("MarvinSpace libraries are already loaded in another classloader. Please restart your browser.", ule);
                }
                throw ule;
            }
            if (msf instanceof Exception) {
                throw (Exception)msf;
            }
            this.errorDisplay.error("Internal error creating MarvinSpace Viewer", e);
        }
        return mspaceDialog;
    }

    protected JDialog getMSpaceDialog(CallbackIface msw) throws Exception {
        if (msw == null) {
            return null;
        }
        Object msf = msw.callback("getMSpaceDialog", this);
        JDialog mspaceDialog = null;
        try {
            mspaceDialog = (JDialog)msf;
        }
        catch (ClassCastException e) {
            if (msf instanceof UnsatisfiedLinkError) {
                UnsatisfiedLinkError ule = (UnsatisfiedLinkError)msf;
                if (ule.getMessage().lastIndexOf("already loaded in another classloader") > 0) {
                    this.errorDisplay.error("MarvinSpace libraries are already loaded in another classloader. Please restart your browser.", ule);
                }
                throw ule;
            }
            if (msf instanceof Exception) {
                throw (Exception)msf;
            }
            this.errorDisplay.error("Internal error creating MarvinSpace Viewer", e);
        }
        return mspaceDialog;
    }

    public void prepareMol(MoleculeGraph molecule) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            MolAtom atom = molecule.getAtom(i);
            if (atom.getCharge() != 0 || atom.getRadical() != 0) continue;
            molecule.getAtom(i).setFlags(-65537, 65536);
        }
    }

    public boolean isPrintEnabled() {
        return this.printEnabled;
    }

    public void setPrintEnabled(boolean b) {
        boolean oldValue = this.isPrintEnabled();
        this.printEnabled = b;
        this.firePropertyChange("printEnabled", oldValue, b);
    }

    public abstract void setLigandOrderVisibility(String var1);

    public String getLigandOrderVisibility() {
        return "off";
    }

    protected void setServiceDescriptorReader(ServiceDescriptorReader reader) {
        this.serviceDescriptorReader = reader;
    }

    public ServiceDescriptorReader getServiceDescriptorReader() {
        if (this.serviceDescriptorReader == null) {
            this.serviceDescriptorReader = ServiceDescriptorTools.getDefaultServiceDescriptorReader();
        }
        return this.serviceDescriptorReader;
    }

    protected void setServiceDescriptorWriter(ServiceDescriptorWriter writer) {
        this.serviceDescriptorWriter = writer;
    }

    public ServiceDescriptorWriter getServiceDescriptorWriter() {
        if (this.serviceDescriptorWriter == null) {
            this.serviceDescriptorWriter = ServiceDescriptorTools.getDefaultServiceDescriptorWriter();
        }
        return this.serviceDescriptorWriter;
    }

    protected void setServiceDialogProvider(ServiceDialogProvider provider) {
        this.serviceDialogProvider = provider;
    }

    public ServiceDialogProvider getServiceDialogProvider() {
        if (this.serviceDialogProvider == null) {
            this.serviceDialogProvider = ServiceDescriptorTools.getDefaultServiceDialogProvider();
        }
        return this.serviceDialogProvider;
    }

    static {
        normalFont = new Font("SansSerif", 0, 12);
        smallFont = new Font("SansSerif", 0, 10);
        isPluginsConfigExists = false;
        pluginConfigChecked = false;
        GRESOURCES = MolPanel.getResourceBundle(MolPanel.class.getName());
    }
}

