/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing;

import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.ErrorDisplay;
import chemaxon.marvin.util.HourglassHandler;
import chemaxon.marvin.util.MarvinModule;
import java.awt.Component;
import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JOptionPane;

public class SwingErrorDisplay
implements ErrorDisplay {
    private Component theComponent;
    private JApplet theApplet;
    private HourglassHandler theHourglassHandler;
    private long lastFirewallErrorTime = 0L;
    private boolean incompatibleClassErrorDisplayed = false;
    private long lastErrorTime = 0L;
    private String lastErrorMessage = null;

    public SwingErrorDisplay(Component comp) {
        this(comp, null, null);
    }

    SwingErrorDisplay(Component comp, JApplet applet, HourglassHandler hh) {
        this.theComponent = comp;
        this.theApplet = applet;
        this.theHourglassHandler = hh;
    }

    @Override
    public void error(String msg, Throwable ex) {
        long time = System.currentTimeMillis();
        long dt = time - this.lastErrorTime;
        if (msg != null) {
            if (this.lastErrorMessage != null && this.lastErrorMessage.equals(msg) && dt < 2000L) {
                this.lastErrorTime = time;
                return;
            }
            this.lastErrorTime = time;
            this.lastErrorMessage = msg;
        }
        try {
            CallbackIface m = (CallbackIface)MarvinModule.load("common.swing.ExceptionFrame", this.theHourglassHandler);
            m.callback("setMessage", msg);
            m.callback("setException", ex);
            m.callback("show", this.theComponent);
        }
        catch (SecurityException sex) {
            this.firewallError(sex, null);
        }
        catch (IncompatibleClassChangeError ex2) {
            this.incompatibleClassChangeError(ex2);
        }
    }

    @Override
    public void error(Throwable t) {
        if (t instanceof SecurityException) {
            this.firewallError((SecurityException)t, null);
        } else if (t instanceof IncompatibleClassChangeError) {
            this.incompatibleClassChangeError((IncompatibleClassChangeError)t);
        } else {
            this.error(t.getMessage(), t);
        }
    }

    @Override
    public void warning(String msg, String details) {
        try {
            CallbackIface m = (CallbackIface)MarvinModule.load("common.swing.ExceptionFrame", this.theHourglassHandler);
            m.callback("setMessage", msg);
            m.callback("setIsWarning", Boolean.TRUE);
            m.callback("setDetails", details);
            m.callback("show", this.theComponent);
        }
        catch (SecurityException sex) {
            this.firewallError(sex, null);
        }
        catch (IncompatibleClassChangeError ex2) {
            this.incompatibleClassChangeError(ex2);
        }
    }

    private void incompatibleClassChangeError(IncompatibleClassChangeError ex) {
        if (this.incompatibleClassErrorDisplayed) {
            return;
        }
        this.incompatibleClassErrorDisplayed = true;
        System.err.println("Incompatible classes. Check your CLASSPATH.");
        ex.printStackTrace();
        if (EventQueue.isDispatchThread()) {
            this.incompatibleClassChangeError2();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingErrorDisplay.this.incompatibleClassChangeError2();
                }
            });
        }
    }

    private void incompatibleClassChangeError2() {
        String msg = "I loaded a class file that is incompatible with me.\nYou might have the Marvin class library in your CLASSPATH,\nand it interferes with my classes.\nPlease do not use global CLASSPATH settings!";
        String title = "Incompatible class loaded";
        JOptionPane.showMessageDialog(null, msg, title, 0);
    }

    @Override
    public void firewallError(SecurityException sex, String protocol) {
        sex.printStackTrace();
        if (this.theApplet != null) {
            URL base = this.theApplet.getCodeBase();
            String file = protocol == null && base.getProtocol().equals("file") || protocol != null && protocol.equals("file") ? "chemaxon/marvin/filesecurity.html" : "chemaxon/marvin/firewall.html";
            this.displayErrorInBrowser(file);
        }
    }

    private void displayErrorInBrowser(String file) {
        long time = System.currentTimeMillis();
        long dt = time - this.lastFirewallErrorTime;
        if (dt > 5000L || this.lastFirewallErrorTime == 0L) {
            try {
                URL u = new URL(this.theApplet.getCodeBase(), file);
                this.theApplet.getAppletContext().showDocument(u, "_blank");
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.lastFirewallErrorTime = time;
    }
}

