/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.action;

import chemaxon.marvin.common.swing.MolPanel;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class RecentFileActions {
    protected final MolPanel panel;
    protected Delegate[] delegates;

    public RecentFileActions(MolPanel panel) {
        this.panel = panel;
    }

    public Action[] getActions() {
        if (this.delegates == null) {
            this.delegates = this.createDelegates();
        }
        return this.updateDelegates();
    }

    private Action[] updateDelegates() {
        List<String> files = this.panel.getUserSettings().getSketchRecentFileList();
        Action[] result = new Action[Math.min(files.size(), this.delegates.length)];
        for (int i = 0; i < result.length; ++i) {
            Delegate delegate = this.delegates[i];
            delegate.setFileName(files.get(i).toString());
            result[i] = delegate;
        }
        return result;
    }

    private Delegate[] createDelegates() {
        Delegate[] result = new Delegate[this.panel.getUserSettings().getSketchRecentFileListSize()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Delegate(this.panel, i + 1);
        }
        return result;
    }

    protected static class Delegate
    extends AbstractAction {
        private static final String SEPARATOR = File.separator + "..." + File.separator;
        private static final int MAX_PATH_LENGTH = 50;
        private int index;
        private String fileName;
        private MolPanel panel;

        public Delegate(MolPanel panel, int index) {
            this.index = index;
            this.panel = panel;
        }

        public void setFileName(String fileName) {
            String name;
            this.fileName = fileName;
            if (this.fileName == null) {
                this.setEnabled(false);
                this.fileName = "";
            }
            if ((name = fileName).length() > 50) {
                File file = new File(name);
                name = Delegate.findDirectory(file.getParentFile(), 50 - file.getName().length() - SEPARATOR.length()) + SEPARATOR + file.getName();
            }
            this.putValue("Name", this.index + " " + name);
            this.putValue("ShortDescription", fileName);
            if (this.index <= 10) {
                this.putValue("MnemonicKey", new Integer(48 + this.index % 10));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = new File(this.fileName);
            this.panel.openMolfile(f, null);
        }

        private static String findDirectory(File directory, int maxLength) {
            for (File currentDirectory = directory; currentDirectory != null; currentDirectory = currentDirectory.getParentFile()) {
                if (currentDirectory.getAbsolutePath().length() < maxLength) {
                    return currentDirectory.getAbsolutePath();
                }
                if (currentDirectory.getParentFile() != null) {
                    continue;
                }
                return currentDirectory.getAbsolutePath();
            }
            return "";
        }
    }
}

