/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.license.LicenseException;
import chemaxon.license.LicenseManager;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.util.CallbackIface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ExceptionFrame
implements CallbackIface {
    private Component parentComponent;
    private String message = null;
    private String details = null;
    private int myId;
    private static int currentId = 0;
    private static int displayedId;
    private static boolean displayed;
    private static final Dimension SMALL_SCROLLPANE_DIMENSION;
    private static final Dimension LARGE_SCROLLPANE_DIMENSION;
    private boolean isWarning = false;
    private LicenseException licExc = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setMessage")) {
            this.message = (String)arg;
        } else if (method.equals("setException")) {
            String msg = this.message;
            Throwable ex = (Throwable)arg;
            if (ex instanceof LicenseException) {
                this.licExc = (LicenseException)ex;
            }
            if (msg != null && msg.length() == 0) {
                msg = null;
            }
            if (msg == null && ex != null) {
                msg = ex.getMessage();
            }
            if (msg == null || msg.length() == 0) {
                msg = "Unknown error.";
            }
            this.message = msg;
            if (ex != null) {
                CharArrayWriter chars = new CharArrayWriter();
                ex.printStackTrace(new PrintWriter(chars));
                this.details = chars.toString();
            }
        } else if (method.equals("setDetails")) {
            this.details = (String)arg;
        } else if (method.equals("setIsWarning")) {
            this.isWarning = (Boolean)arg;
        } else if (method.equals("show")) {
            boolean show;
            this.parentComponent = (Component)arg;
            Class<?> ex = this.getClass();
            synchronized (ex) {
                this.myId = currentId++;
                boolean bl = show = !displayed;
                if (show) {
                    displayedId = this.myId;
                    displayed = true;
                }
            }
            if (show) {
                final Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        ExceptionFrame.this.runDialog();
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            EventQueue.invokeLater(r);
                        }
                    };
                    t.start();
                } else {
                    EventQueue.invokeLater(r);
                }
            } else {
                String msg = this.message;
                if (msg != null) {
                    System.err.println(msg);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDialog() {
        Object[] opts;
        JComponent msgObj;
        int messageType;
        String detailsButtonText;
        String title;
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setBackground(null);
        textArea.setMargin(new Insets(0, 0, 50, 50));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(textArea);
        if (this.isWarning) {
            title = "Warning";
            detailsButtonText = MolPanel.getLabelResource(MolPanel.GRESOURCES, "details");
            messageType = 2;
        } else {
            title = "Error";
            detailsButtonText = "Stack Trace";
            messageType = 0;
        }
        if (this.licExc != null) {
            msgObj = LicenseManager.getLicenseExceptionPanel(this.licExc);
        } else {
            textArea.setText(this.message);
            this.scrollUp(scrollPane);
            scrollPane.setPreferredSize(SMALL_SCROLLPANE_DIMENSION);
            msgObj = scrollPane;
        }
        if (this.details == null) {
            opts = new Object[]{MolPanel.getLabelResource(MolPanel.GRESOURCES, "ok")};
            opts[1] = "Copy to Clipboard";
            int r = JOptionPane.showOptionDialog(this.parentComponent, msgObj, title, -1, messageType, null, opts, opts[0]);
            if (r == 1) {
                ClipboardHandler.putStringToClipboard(title.toUpperCase() + ": \n" + this.message);
                JOptionPane.showMessageDialog(this.parentComponent, "The " + title.toLowerCase() + " message has been placed to the clipboard.");
            }
        } else {
            scrollPane.setPreferredSize(SMALL_SCROLLPANE_DIMENSION);
            textArea.setText(this.message);
            this.scrollUp(scrollPane);
            opts = new Object[]{MolPanel.getLabelResource(MolPanel.GRESOURCES, "ok"), this.isWarning ? "Details" : "Stack Trace", "Copy to Clipboard"};
            int r = JOptionPane.showOptionDialog(this.parentComponent, scrollPane, title, -1, messageType, null, opts, opts[0]);
            switch (r) {
                case 1: {
                    scrollPane.setPreferredSize(LARGE_SCROLLPANE_DIMENSION);
                    textArea.setText(this.details);
                    this.scrollUp(scrollPane);
                    textArea.setLineWrap(false);
                    textArea.setWrapStyleWord(false);
                    Object[] opts2 = new Object[]{opts[0], opts[2]};
                    int retVal = JOptionPane.showOptionDialog(this.parentComponent, scrollPane, title + ": " + detailsButtonText, -1, messageType, null, opts2, opts2[0]);
                    if (retVal != 1) break;
                    ClipboardHandler.putStringToClipboard(title.toUpperCase() + ": \n" + this.message + "\n\n" + detailsButtonText.toUpperCase() + ":\n" + this.details);
                    JOptionPane.showMessageDialog(this.parentComponent, "The " + title.toLowerCase() + " message and the " + detailsButtonText.toLowerCase() + " have been placed to the clipboard.");
                    break;
                }
                case 2: {
                    ClipboardHandler.putStringToClipboard(title.toUpperCase() + ": \n" + this.message + "\n\n" + detailsButtonText.toUpperCase() + ":\n" + this.details);
                    JOptionPane.showMessageDialog(this.parentComponent, "The " + title.toLowerCase() + " message and the " + detailsButtonText.toLowerCase() + " have been placed to the clipboard.");
                    break;
                }
            }
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (displayedId == this.myId) {
                displayed = false;
            }
        }
    }

    private void scrollUp(final JScrollPane sp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                sp.getVerticalScrollBar().setValue(0);
            }
        });
    }

    static {
        displayed = false;
        SMALL_SCROLLPANE_DIMENSION = new Dimension(400, 160);
        LARGE_SCROLLPANE_DIMENSION = new Dimension(600, 320);
    }
}

