/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.modules.FontFamilySizeComponents;
import chemaxon.marvin.util.SwingUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontAttrPanel
extends JPanel
implements ActionListener {
    public static final int F_NO_STYLE = 1;
    public static final int F_COLOR = 2;
    public static final int F_FONT_LINE = 4;
    public static final int F_ALIGNMENT = 8;
    private static final ResourceBundle RESOURCES;
    private static final String[] FONT_STYLES;
    private static final String[] HALIGNMENTS;
    private static final String[] VALIGNMENTS;
    private String panelTitle;
    private FontFamilySizeComponents fontFamilySizeComps;
    private JLabel fontStyleLabel;
    private int lastStyleVal;
    private JComboBox fontStyleCombo;
    private boolean fontStyleSet = false;
    private JLabel textColorLabel;
    private JButton textColorButton;
    private Color textColorVal;
    private boolean textColorSet = false;
    private JButton resetColorButton;
    private JLabel alignLabel;
    private JComboBox halignCombo;
    private boolean halignSet = false;
    private int lastHalignVal;
    private JComboBox valignCombo;
    private boolean valignSet = false;
    private int lastValignVal;

    public FontAttrPanel(String title, int opts, String fontFamily, int style, double size, Color color, int halign, int valign, Component msgcomponent) {
        this.panelTitle = title;
        if (title != null) {
            SwingUtil.decorateSubPanel(this, title);
        }
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        JPanel fpanel = this.createFontPanel(opts, fontFamily, size, style);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.gridwidth = 2;
        gbc.gridheight = 2;
        gbl.setConstraints(this.add(fpanel), gbc);
        JPanel cpanel = this.createColorPanel(opts, color, gbc);
        gbl.setConstraints(this.add(cpanel), gbc);
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridy;
        gbc.gridx = 2;
        if ((opts & 8) != 0) {
            JPanel apanel = this.createAlignPanel(halign, valign);
            gbl.setConstraints(this.add(apanel), gbc);
            ++gbc.gridy;
        }
        JPanel msgpanel = FontAttrPanel.createMessagePanel(msgcomponent);
        gbl.setConstraints(this.add(msgpanel), gbc);
    }

    private JPanel createFontPanel(int opts, String fontFamily, double size, int style) {
        ResourceBundle rc = RESOURCES;
        JPanel fpanel = new JPanel();
        GridBagLayout fgbl = new GridBagLayout();
        GridBagConstraints fgbc = SwingUtil.createTopLeftConstraints();
        fpanel.setLayout(fgbl);
        fgbc.insets.right = 10;
        this.fontFamilySizeComps = new FontFamilySizeComponents(rc.getString("fontLabel"), fontFamily, rc.getString("fontSizeLabel"), size);
        JComponent[] comps = this.fontFamilySizeComps.getJComponents();
        for (int i = 0; i < comps.length; ++i) {
            fgbl.setConstraints(fpanel.add(comps[i]), fgbc);
            ++fgbc.gridx;
        }
        this.fontStyleCombo = new JComboBox<String>(FONT_STYLES);
        this.lastStyleVal = style;
        this.fontStyleCombo.setSelectedIndex(this.lastStyleVal);
        this.fontStyleCombo.setActionCommand("fontStyle");
        this.fontStyleCombo.addActionListener(this);
        if ((opts & 1) == 0) {
            this.fontStyleLabel = new JLabel(rc.getString("fontStyleLabel"));
            if ((opts & 4) != 0) {
                ++fgbc.gridx;
            } else {
                fgbc.gridx = 0;
                ++fgbc.gridy;
                fgbc.insets.top = 5;
                fgbc.fill = 2;
                fgbc.weightx = 1.0;
                this.fontStyleLabel.setHorizontalAlignment(4);
            }
            fgbl.setConstraints(fpanel.add(this.fontStyleLabel), fgbc);
            ++fgbc.gridx;
            fgbc.fill = 0;
            fgbc.weightx = 0.0;
            fgbl.setConstraints(fpanel.add(this.fontStyleCombo), fgbc);
        }
        return fpanel;
    }

    private JPanel createColorPanel(int opts, Color color, GridBagConstraints gbc) {
        ResourceBundle rc = RESOURCES;
        JPanel cpanel = new JPanel();
        GridBagLayout cgbl = new GridBagLayout();
        GridBagConstraints cgbc = SwingUtil.createTopLeftConstraints();
        cgbc.insets.right = 10;
        cpanel.setLayout(cgbl);
        this.textColorLabel = new JLabel(rc.getString("colorLabel"));
        this.textColorVal = color;
        this.textColorButton = FontAttrPanel.createColorChooser(this, "textColor", this.textColorVal);
        this.textColorSet = false;
        if ((opts & 2) != 0) {
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            ++cgbc.gridx;
            cgbc.insets.top = 0;
            gbc.insets.left = 10;
            gbc.gridx += 2;
            cgbl.setConstraints(cpanel.add(this.textColorLabel), cgbc);
            ++cgbc.gridx;
            cgbl.setConstraints(cpanel.add(this.textColorButton), cgbc);
            ++cgbc.gridx;
            cgbc.weightx = 1.0;
            cgbc.weighty = 1.0;
            this.resetColorButton = FontAttrPanel.createResetColorButton(this, "resetTextColor");
            cgbl.setConstraints(cpanel.add(this.resetColorButton), cgbc);
        }
        return cpanel;
    }

    private JPanel createAlignPanel(int halign, int valign) {
        ResourceBundle rc = RESOURCES;
        JPanel fpanel = new JPanel();
        GridBagLayout fgbl = new GridBagLayout();
        GridBagConstraints fgbc = SwingUtil.createTopLeftConstraints();
        fpanel.setLayout(fgbl);
        this.halignSet = false;
        this.valignSet = false;
        fgbc.insets.right = 10;
        fgbc.insets.top = 5;
        this.halignCombo = new JComboBox<String>(HALIGNMENTS);
        this.lastHalignVal = halign;
        this.halignCombo.setSelectedIndex(this.lastHalignVal);
        this.halignCombo.setActionCommand("halign");
        this.halignCombo.addActionListener(this);
        this.valignCombo = new JComboBox<String>(VALIGNMENTS);
        this.lastValignVal = valign;
        this.valignCombo.setSelectedIndex(this.lastValignVal);
        this.valignCombo.setActionCommand("valign");
        this.valignCombo.addActionListener(this);
        this.alignLabel = new JLabel(rc.getString("alignLabel"));
        fgbl.setConstraints(fpanel.add(this.alignLabel), fgbc);
        ++fgbc.gridx;
        fgbc.fill = 0;
        fgbc.weightx = 0.0;
        fgbl.setConstraints(fpanel.add(this.halignCombo), fgbc);
        ++fgbc.gridx;
        fgbl.setConstraints(fpanel.add(this.valignCombo), fgbc);
        return fpanel;
    }

    private static JPanel createMessagePanel(Component comp) {
        JPanel p = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        p.setLayout(gbl);
        if (comp != null) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 14;
            comp.setBackground(p.getBackground());
            comp.setForeground(p.getForeground());
            gbl.setConstraints(p.add(comp), gbc);
        }
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (cmd.equals("fontStyle")) {
            if (!this.fontStyleSet && this.lastStyleVal != this.fontStyleCombo.getSelectedIndex()) {
                this.lastStyleVal = this.fontStyleCombo.getSelectedIndex();
                this.fontStyleSet = true;
                FontFamilySizeComponents.setProp(this.fontStyleLabel);
            }
        } else if (cmd.equals("textColor")) {
            Color c = JColorChooser.showDialog(this, MolPanel.getColorChooserTitle(), this.textColorVal == null ? Color.WHITE : this.textColorVal);
            if (c != null) {
                this.setTextColorProp(c);
            }
        } else if (cmd.equals("resetTextColor")) {
            this.setTextColorProp(null);
        } else if (cmd.equals("halign")) {
            if (!this.halignSet && this.lastHalignVal != this.halignCombo.getSelectedIndex()) {
                this.lastHalignVal = this.halignCombo.getSelectedIndex();
                this.halignSet = true;
                FontFamilySizeComponents.setProp(this.alignLabel);
            }
        } else if (cmd.equals("valign") && !this.valignSet && this.lastValignVal != this.valignCombo.getSelectedIndex()) {
            this.lastHalignVal = this.valignCombo.getSelectedIndex();
            this.valignSet = true;
            FontFamilySizeComponents.setProp(this.alignLabel);
        }
    }

    public String getSelectedFontFamily() {
        return this.fontFamilySizeComps.getSelectedFontFamily();
    }

    public void setFontFamilyLabel(String s) {
        this.fontFamilySizeComps.setFontFamilyLabel(s);
    }

    public void setFontFamilyToolTip(String s) {
        this.fontFamilySizeComps.setFontFamilyToolTip(s);
    }

    public void setSizeLabel(String s) {
        this.fontFamilySizeComps.setSizeLabel(s);
    }

    public void setSizeToolTip(String s) {
        this.fontFamilySizeComps.setSizeToolTip(s);
    }

    public void setSelectedFontFamily(String name) {
        this.fontFamilySizeComps.setSelectedFontFamily(name);
    }

    public int getSelectedStyle() {
        return this.fontStyleCombo.getSelectedIndex();
    }

    public void setSelectedStyle(int style) {
        this.lastStyleVal = style;
        this.fontStyleCombo.setSelectedIndex(this.lastStyleVal);
    }

    public String getSelectedStyleStr() {
        return (String)this.fontStyleCombo.getSelectedItem();
    }

    public void setSelectedStyleStr(String str) {
        for (int i = 0; i < this.fontStyleCombo.getItemCount(); ++i) {
            if (!this.fontStyleCombo.getItemAt(i).equals(str)) continue;
            this.fontStyleCombo.setSelectedItem(str);
        }
    }

    public double getSelectedSize() {
        return this.fontFamilySizeComps.getSelectedSize();
    }

    public void setSelectedSize(double size) {
        this.fontFamilySizeComps.setSelectedSize(size);
    }

    public Font getSelectedFont() {
        return this.fontFamilySizeComps.getSelectedFont(this.getSelectedStyle());
    }

    public Color getSelectedColor() {
        return this.textColorVal;
    }

    public void setSelectedColor(Color c) {
        this.textColorVal = c;
    }

    public boolean isFontFamilyChanged() {
        return this.fontFamilySizeComps.isFontFamilyChanged();
    }

    public boolean isFontStyleChanged() {
        return this.fontStyleSet;
    }

    public boolean isFontSizeChanged() {
        return this.fontFamilySizeComps.isFontSizeChanged();
    }

    public boolean isColorChanged() {
        return this.textColorSet;
    }

    public int getSelectedHalign() {
        return this.halignCombo.getSelectedIndex();
    }

    public boolean isHalignChanged() {
        return this.halignSet;
    }

    public int getSelectedValign() {
        return this.valignCombo.getSelectedIndex();
    }

    public boolean isValignChanged() {
        return this.valignSet;
    }

    public static JButton createColorChooser(ActionListener l, String cmd, Color c) {
        ResourceBundle rc = RESOURCES;
        JButton b = new JButton(rc.getString("colorChoose"));
        b.setToolTipText(rc.getString("colorChooseToolTip"));
        b.setActionCommand(cmd);
        b.addActionListener(l);
        Class<FontAttrPanel> cl = FontAttrPanel.class;
        b.setIcon(new ImageIcon(cl.getResource("/chemaxon/icons/marvin/color16.png")));
        b.setBackground(c);
        return b;
    }

    public static JButton createResetColorButton(ActionListener l, String cmd) {
        return FontAttrPanel.createResetButton(l, cmd, RESOURCES.getString("colorResetToolTip"));
    }

    private static JButton createResetButton(ActionListener l, String cmd, String tip) {
        ResourceBundle rc = RESOURCES;
        JButton b = new JButton(rc.getString("reset"));
        b.setActionCommand(cmd);
        b.setToolTipText(tip);
        b.addActionListener(l);
        return b;
    }

    public void setTextColorProp(Color c) {
        if (this.textColorButton != null) {
            this.textColorVal = c;
            this.textColorButton.setBackground(c);
            if (!this.textColorSet) {
                this.textColorSet = true;
                FontFamilySizeComponents.setProp(this.textColorLabel);
            }
        }
    }

    public void setTextColor(Color c) {
        if (this.textColorButton != null) {
            this.textColorVal = c;
            this.textColorButton.setBackground(c);
        }
    }

    public void setPanelEnabled(boolean enabled) {
        this.setEnabled(enabled);
        if (!enabled) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, this.panelTitle, 4, 2, null, Color.gray), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        } else {
            SwingUtil.decorateSubPanel(this, this.panelTitle);
        }
        int compn = this.getComponentCount();
        for (int i = 0; i < compn; ++i) {
            Component c = this.getComponent(i);
            c.setEnabled(enabled);
        }
        JComponent[] jcs = this.fontFamilySizeComps.getJComponents();
        for (int i = 0; i < jcs.length; ++i) {
            JComponent jcp = jcs[i];
            int jcpn = jcp.getComponentCount();
            for (int j = 0; j < jcpn; ++j) {
                Component c = jcp.getComponent(j);
                c.setEnabled(enabled);
            }
            jcp.setEnabled(enabled);
        }
        this.fontStyleLabel.setEnabled(enabled);
        this.fontStyleCombo.setEnabled(enabled);
        this.textColorLabel.setEnabled(enabled);
        this.textColorButton.setEnabled(enabled);
        this.resetColorButton.setEnabled(enabled);
        if (this.alignLabel != null) {
            this.alignLabel.setEnabled(enabled);
        }
        if (this.halignCombo != null) {
            this.halignCombo.setEnabled(enabled);
        }
        if (this.valignCombo != null) {
            this.valignCombo.setEnabled(enabled);
        }
    }

    static {
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(FontAttrPanel.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("FontAttrPanel.properties not found");
        }
        RESOURCES = rc;
        FONT_STYLES = new String[4];
        FontAttrPanel.FONT_STYLES[0] = rc.getString("fontStyle.Plain");
        FontAttrPanel.FONT_STYLES[1] = rc.getString("fontStyle.Bold");
        FontAttrPanel.FONT_STYLES[2] = rc.getString("fontStyle.Italic");
        FontAttrPanel.FONT_STYLES[3] = rc.getString("fontStyle.BoldItalic");
        HALIGNMENTS = new String[3];
        FontAttrPanel.HALIGNMENTS[0] = rc.getString("alignment.left");
        FontAttrPanel.HALIGNMENTS[2] = rc.getString("alignment.right");
        FontAttrPanel.HALIGNMENTS[1] = rc.getString("alignment.center");
        VALIGNMENTS = new String[3];
        FontAttrPanel.VALIGNMENTS[0] = rc.getString("alignment.top");
        FontAttrPanel.VALIGNMENTS[2] = rc.getString("alignment.bottom");
        FontAttrPanel.VALIGNMENTS[1] = rc.getString("alignment.center");
    }
}

