/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class FontFamilySizeComponents
implements ActionListener {
    private static final ResourceBundle RESOURCES;
    private static final String[] FONT_SIZE_STRINGS;
    private Hashtable fontHash;
    private JLabel fontFamilyLabel;
    private JComboBox fontFamilyCombo;
    private String lastFontFamilyVal;
    private JLabel fontSizeLabel;
    private JComboBox fontSizeCombo;
    private String lastFontSizeStr;
    private boolean fontFamilySet = false;
    private boolean fontSizeSet = false;
    private EventListenerList actionListeners = new EventListenerList();

    public FontFamilySizeComponents(String fontlabel, String family, String sizelabel, double size) {
        ResourceBundle rc = RESOURCES;
        this.fontHash = new Hashtable();
        this.fontFamilyLabel = fontlabel != null ? new JLabel(fontlabel) : null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(ge.getAvailableFontFamilyNames());
        this.fontFamilyCombo = new JComboBox<String>(model);
        this.selectFontFamily(family);
        this.fontFamilyCombo.setToolTipText(rc.getString("fontFamilyToolTip"));
        this.fontFamilyCombo.setActionCommand("fontFamily");
        this.fontFamilyCombo.addActionListener(this);
        this.fontSizeLabel = sizelabel != null ? new JLabel(sizelabel) : null;
        this.fontSizeCombo = new JComboBox<String>(FONT_SIZE_STRINGS);
        this.fontSizeCombo.setToolTipText(rc.getString("fontSizeToolTip"));
        this.fontSizeCombo.setActionCommand("fontSize");
        this.fontSizeCombo.addActionListener(this);
        this.setSelectedSize(size);
    }

    public JComponent[] getJComponents() {
        int n = 2;
        if (this.fontFamilyLabel != null) {
            ++n;
        }
        if (this.fontSizeLabel != null) {
            ++n;
        }
        JComponent[] comps = new JComponent[n];
        int k = 0;
        if (this.fontFamilyLabel != null) {
            comps[k++] = this.fontFamilyLabel;
        }
        comps[k++] = this.fontFamilyCombo;
        if (this.fontSizeLabel != null) {
            comps[k++] = this.fontSizeLabel;
        }
        comps[k] = this.fontSizeCombo;
        return comps;
    }

    private double[] getFontSizes() {
        int n = this.fontSizeCombo.getItemCount();
        double[] sizes = new double[n];
        for (int i = 0; i < n; ++i) {
            String s = (String)this.fontSizeCombo.getItemAt(i);
            NumberFormat nf = NumberFormat.getNumberInstance();
            Number ns = 0;
            try {
                ns = nf.parse(s);
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
            sizes[i] = ns.doubleValue();
        }
        return sizes;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (cmd.equals("fontFamily")) {
            if (!this.fontFamilySet && this.lastFontFamilyVal != this.fontFamilyCombo.getSelectedItem()) {
                this.lastFontFamilyVal = (String)this.fontFamilyCombo.getSelectedItem();
                this.fontFamilySet = true;
                FontFamilySizeComponents.setProp(this.fontFamilyLabel);
            }
            this.fireActionPerformed(cmd);
            this.startWatchingPopup(this.fontFamilyCombo);
        } else if (cmd.equals("fontSize")) {
            if (!this.fontSizeSet && this.lastFontSizeStr != this.fontSizeCombo.getSelectedItem()) {
                this.lastFontSizeStr = (String)this.fontSizeCombo.getSelectedItem();
                this.fontSizeSet = true;
                FontFamilySizeComponents.setProp(this.fontSizeLabel);
            }
            this.fireActionPerformed(cmd);
            this.startWatchingPopup(this.fontSizeCombo);
        }
    }

    public void setFontFamilyLabel(String s) {
        if (this.fontFamilyLabel != null) {
            this.fontFamilyLabel.setText(s);
        }
    }

    public void setFontFamilyToolTip(String s) {
        this.fontFamilyCombo.setToolTipText(s);
    }

    public void setSizeLabel(String s) {
        if (this.fontSizeLabel != null) {
            this.fontSizeLabel.setText(s);
        }
    }

    public void setSizeToolTip(String s) {
        this.fontSizeCombo.setToolTipText(s);
    }

    public String getSelectedFontFamily() {
        return (String)this.fontFamilyCombo.getSelectedItem();
    }

    public void setSelectedFontFamily(String name) {
        this.fontFamilyCombo.removeActionListener(this);
        this.selectFontFamily(name);
        this.fontFamilyCombo.addActionListener(this);
    }

    private void selectFontFamily(String family) {
        boolean familyAvailable = ((DefaultComboBoxModel)this.fontFamilyCombo.getModel()).getIndexOf(family) != -1;
        this.lastFontFamilyVal = familyAvailable ? family : this.fontFamilyCombo.getModel().getElementAt(0).toString();
        this.fontFamilyCombo.setSelectedItem(this.lastFontFamilyVal);
    }

    public double getSelectedSize() {
        String s = (String)this.fontSizeCombo.getSelectedItem();
        return s != null ? Double.valueOf(s) : 0.0;
    }

    public void setSelectedSize(double size) {
        int i;
        String sizestr;
        if (size <= 0.0) {
            this.lastFontSizeStr = null;
            this.fontSizeCombo.removeActionListener(this);
            this.fontSizeCombo.setSelectedIndex(-1);
            this.fontSizeCombo.addActionListener(this);
            return;
        }
        this.lastFontSizeStr = sizestr = FontFamilySizeComponents.formatFontSize(size);
        int n = this.fontSizeCombo.getItemCount();
        double[] sizes = this.getFontSizes();
        for (i = 0; i < n; ++i) {
            if (sizes[i] != size) continue;
            this.fontSizeCombo.removeActionListener(this);
            this.fontSizeCombo.setSelectedIndex(i);
            this.fontSizeCombo.addActionListener(this);
            return;
        }
        for (i = 0; i < n; ++i) {
            if (!(size < sizes[i])) continue;
            this.fontSizeCombo.insertItemAt(sizestr, i);
            this.fontSizeCombo.removeActionListener(this);
            this.fontSizeCombo.setSelectedIndex(i);
            this.fontSizeCombo.addActionListener(this);
            return;
        }
        this.fontSizeCombo.addItem(sizestr);
        this.fontSizeCombo.removeActionListener(this);
        this.fontSizeCombo.setSelectedIndex(sizes.length);
        this.fontSizeCombo.addActionListener(this);
    }

    public Font getSelectedFont(int style) {
        String name = this.getSelectedFontFamily();
        double size = this.getSelectedSize();
        String key = name + "-" + style + "-" + size;
        Font f = (Font)this.fontHash.get(key);
        if (f == null) {
            f = new Font(name, style, (int)size);
            f = f.deriveFont((float)size);
            this.fontHash.put(key, f);
        }
        return f;
    }

    public boolean isFontFamilyChanged() {
        return this.fontFamilySet;
    }

    public boolean isFontSizeChanged() {
        return this.fontSizeSet;
    }

    private void fireActionPerformed(String propname) {
        Object[] listeners = this.actionListeners.getListenerList();
        ActionEvent ev = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (ev == null) {
                ev = new ActionEvent(this, 1001, propname, 0);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(ev);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(ActionListener.class, l);
    }

    public static String formatFontSize(double pt) {
        double ipt = Math.round(pt);
        if (ipt == pt) {
            return String.valueOf((int)ipt);
        }
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(3);
        String s = fmt.format(pt);
        return s;
    }

    static void setProp(JLabel l) {
        if (l != null) {
            String s = l.getText();
            l.setText("<html><small>*</small>" + s + "</html>");
            Window w = FontFamilySizeComponents.findWindow(l);
            if (w != null) {
                w.pack();
            }
        }
    }

    private static Window findWindow(Component p) {
        while (p != null && !(p instanceof Window)) {
            p = p.getParent();
        }
        return (Window)p;
    }

    private void startWatchingPopup(final JComboBox combo) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (combo.isPopupVisible()) {
                        Thread.sleep(100L);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FontFamilySizeComponents.this.fireActionPerformed("fontFamilySizePopupClosed");
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    static {
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(FontFamilySizeComponents.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("FontFamilySizeComponents.properties not found");
        }
        RESOURCES = rc;
        StringTokenizer st = new StringTokenizer("5 6 7 8 9 10 11 12 13 14 15 16 18 20 22 24 26 28 32 36 40 44 48 54 60 66 72 80 88 96");
        int n = st.countTokens();
        FONT_SIZE_STRINGS = new String[n];
        for (int i = 0; i < n; ++i) {
            String s;
            FontFamilySizeComponents.FONT_SIZE_STRINGS[i] = s = st.nextToken();
        }
    }
}

