/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.edu.stanford.ejalbert.BrowserLauncher;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.swing.ActionButton;
import chemaxon.marvin.swing.ActionMenuItem;
import chemaxon.marvin.swing.MAction;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.version.VersionInfo;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class Help
implements CallbackIface,
WindowListener,
HyperlinkListener,
MouseListener {
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle(Help.class.getName());
    private Window window = null;
    private JEditorPane htmlPane;
    private URL url;
    private MolPanel mpan;
    private Vector history = new Vector();
    private int historyPos = -1;
    private JPanel searchPanel;
    private JButton searchButton;
    private JTextField searchText;
    private int lastIndex = 0;
    private String lastSearch = null;
    private Action forwardAction = new ForwardAction();
    private Action backAction = new BackAction();
    private Action findNextAction = new FindNextAction();

    @Override
    public Object callback(String method, Object o) {
        if (method.equals("setMolPanel")) {
            Frame f = null;
            Dialog d = null;
            for (Container p = this.mpan = (MolPanel)o; p != null && f == null && d == null; p = p.getParent()) {
                if (p instanceof Frame) {
                    f = (Frame)p;
                    continue;
                }
                if (!(p instanceof Dialog)) continue;
                d = (Dialog)p;
            }
            this.window = f != null ? new JDialog(f, "Marvin Help") : (d != null ? new JDialog(d, "Marvin Help") : null);
        } else if (method.equals("showURL")) {
            URL u = this.url = (URL)o;
            this.htmlPane = new JEditorPane();
            if (this.setPage(this.htmlPane, u)) {
                this.addHistory(u);
            }
            this.htmlPane.setEditable(false);
            this.htmlPane.addHyperlinkListener(this);
            this.htmlPane.addMouseListener(this);
            JScrollPane htmlView = new JScrollPane(this.htmlPane);
            htmlView.setPreferredSize(new Dimension(720, 450));
            this.searchPanel = new JPanel();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.searchPanel.setLayout(gb);
            this.searchText = new JTextField(25);
            this.searchText.addActionListener(this.findNextAction);
            c.fill = 1;
            this.searchButton = new ActionButton(this.findNextAction);
            ActionButton backButton = new ActionButton(this.backAction);
            backButton.setEnabled(false);
            ActionButton fwdButton = new ActionButton(this.forwardAction);
            fwdButton.setEnabled(false);
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.insets = new Insets(1, 1, 1, 3);
            gb.setConstraints(backButton, c);
            this.searchPanel.add(backButton);
            c.gridx = 1;
            c.insets = new Insets(1, 1, 1, 5);
            gb.setConstraints(fwdButton, c);
            this.searchPanel.add(fwdButton);
            c.gridx = 2;
            c.weightx = 0.5;
            c.insets = new Insets(1, 1, 5, 3);
            gb.setConstraints(this.searchText, c);
            this.searchPanel.add(this.searchText);
            c.gridx = 3;
            c.weightx = 0.0;
            c.insets = new Insets(1, 1, 1, 1);
            gb.setConstraints(this.searchButton, c);
            this.searchPanel.add(this.searchButton);
            Dimension d = new Dimension(400, 50);
            this.searchPanel.setPreferredSize(d);
            this.searchPanel.setMinimumSize(d);
            this.searchPanel.setMaximumSize(d);
            Container contentPane = this.window instanceof JFrame ? ((JFrame)this.window).getContentPane() : ((JDialog)this.window).getContentPane();
            gb = new GridBagLayout();
            contentPane.setLayout(gb);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            gb.setConstraints(this.searchPanel, c);
            contentPane.add(this.searchPanel);
            c.gridy = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 10;
            c.fill = 1;
            gb.setConstraints(htmlView, c);
            contentPane.add(htmlView);
            this.window.pack();
            this.window.addWindowListener(this);
            this.mpan.showWindow(this.window);
        }
        return null;
    }

    private boolean setPage(JEditorPane pane, URL u) {
        String s = u.toString();
        if (s.endsWith(".txt")) {
            pane.setContentType("text/plain");
        } else if (s.endsWith(".html")) {
            pane.setContentType("text/html");
        }
        pane.setCursor(Cursor.getPredefinedCursor(0));
        try {
            pane.setPage(u);
            return true;
        }
        catch (IOException ex) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("<html><body><font SIZE=\"+2\" COLOR=\"#ff0000\">Cannot load page ");
            sbuf.append(u.toString());
            sbuf.append("</font></body></html>");
            pane.setContentType("text/html");
            pane.setText(sbuf.toString());
            return false;
        }
    }

    @Override
    public void windowOpened(WindowEvent ev) {
    }

    @Override
    public void windowClosing(WindowEvent ev) {
        if (this.window != null) {
            this.mpan.hideWindow(this.window);
            this.mpan.unregWindow(this.window);
        }
    }

    @Override
    public void windowClosed(WindowEvent ev) {
    }

    @Override
    public void windowIconified(WindowEvent ev) {
    }

    @Override
    public void windowDeiconified(WindowEvent ev) {
    }

    @Override
    public void windowActivated(WindowEvent ev) {
    }

    @Override
    public void windowDeactivated(WindowEvent ev) {
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent ev) {
        JEditorPane pane = (JEditorPane)ev.getSource();
        HyperlinkEvent.EventType type = ev.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            if (ev instanceof HTMLFrameHyperlinkEvent) {
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)ev);
            } else {
                URL u = ev.getURL();
                if ((u = Help.getOnlineVersion(u)).getHost().equals(this.url.getHost())) {
                    if (this.setPage(pane, u)) {
                        this.addHistory(u);
                        this.backAction.setEnabled(true);
                        this.forwardAction.setEnabled(false);
                    }
                } else {
                    try {
                        BrowserLauncher.openURL(u.toString());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        } else if (type == HyperlinkEvent.EventType.ENTERED) {
            pane.setCursor(Cursor.getPredefinedCursor(12));
        } else if (type == HyperlinkEvent.EventType.EXITED) {
            pane.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (ev.isPopupTrigger() && this.mpan.arePopupMenusEnabled()) {
            JPopupMenu popup = this.createPopup();
            popup.show(ev.getComponent(), ev.getX(), ev.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (ev.isPopupTrigger() && this.mpan.arePopupMenusEnabled()) {
            JPopupMenu popup = this.createPopup();
            popup.setVisible(true);
            popup.show(ev.getComponent(), ev.getX(), ev.getY());
        }
    }

    public JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new ActionMenuItem(this.backAction));
        popup.add(new ActionMenuItem(this.forwardAction));
        return popup;
    }

    public void addHistory(URL u) {
        this.history.setSize(++this.historyPos);
        this.history.addElement(u);
    }

    public void forward() {
        ++this.historyPos;
        this.setPage(this.htmlPane, (URL)this.history.elementAt(this.historyPos));
        this.backAction.setEnabled(true);
        if (this.historyPos == this.history.size() - 1) {
            this.forwardAction.setEnabled(false);
        }
    }

    public void back() {
        if (this.historyPos > 0) {
            --this.historyPos;
            this.setPage(this.htmlPane, (URL)this.history.elementAt(this.historyPos));
        }
        this.forwardAction.setEnabled(true);
        if (this.historyPos == 0) {
            this.backAction.setEnabled(false);
        }
    }

    public void findNext() {
        String text = this.searchText.getText();
        if (!text.equals(this.lastSearch)) {
            this.lastIndex = 0;
        }
        this.lastSearch = text;
        String helptxt = null;
        try {
            helptxt = this.htmlPane.getDocument().getText(0, this.htmlPane.getDocument().getLength());
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        text = text.toLowerCase();
        helptxt = helptxt.toLowerCase();
        int i = helptxt.indexOf(text, this.lastIndex);
        if (i > 0) {
            this.lastIndex = i + text.length();
            this.htmlPane.select(i, this.lastIndex);
            this.htmlPane.getCaret().setSelectionVisible(true);
        } else if (i == -1) {
            this.lastIndex = 0;
            JOptionPane.showMessageDialog(this.window, RESOURCES.getString("findNoMoreMessage"), RESOURCES.getString("messageDialogTitle"), 1);
            this.htmlPane.getCaret().setSelectionVisible(false);
        }
    }

    private static URL getOnlineVersion(URL u) {
        String version = VersionInfo.MARVIN_VERSION;
        String ustr = u.toString();
        if (ustr.startsWith("jar:file:")) {
            try {
                u.getContent();
                return u;
            }
            catch (IOException e) {
                ustr = ustr.substring(ustr.indexOf("!") + 1);
                URL url = null;
                try {
                    url = new URL("http://www.chemaxon.com/marvin-archive/" + version + "/marvin" + ustr);
                    url.getContent();
                    return url;
                }
                catch (Exception e2) {
                    try {
                        url = new URL("http://www.chemaxon.com/marvin" + ustr);
                        return url;
                    }
                    catch (MalformedURLException mex) {
                        // empty catch block
                    }
                }
            }
        }
        return u;
    }

    class BackAction
    extends MAction {
        public BackAction() {
            super("back", RESOURCES.getString("back"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Help.this.back();
        }
    }

    class ForwardAction
    extends MAction {
        public ForwardAction() {
            super("forward", RESOURCES.getString("forward"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Help.this.forward();
        }
    }

    class FindNextAction
    extends MAction {
        public FindNextAction() {
            super("find", RESOURCES.getString("find"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Help.this.findNext();
        }
    }
}

