/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.modules.EditMolfileFrame;
import chemaxon.marvin.uif.util.swing.AbstractDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ImportDialog
extends AbstractDialog {
    private static final String IMPORT_AS_KEY = "importdialog.importAs";
    private static final String IMPORT_DEFAULT = "importdialog.importDefault";
    private static final String TITLE_KEY = "importdialog.title";
    private static final String IMPORT_KEY = "importdialog.import";
    private static final String IMPORT_MODE = "importdialog.importMode";
    private Action importAction;
    private JRadioButton importRecognizedButton;
    private JRadioButton importAsButton;
    private JList selectorList;
    private ResourceBundle bundle;
    private EditMolfileFrame parent;
    private MFileFormat defaultFormat;
    private MFileFormat recognizedFormat;
    private List importFormats;

    public ImportDialog(Dialog dialog, EditMolfileFrame parent, MFileFormat recognizedFormat, MFileFormat defaultFormat) {
        super((Window)dialog);
        this.parent = parent;
        this.defaultFormat = defaultFormat;
        this.recognizedFormat = recognizedFormat;
        this.importFormats = this.getImportFormats();
        this.bundle = MolPanel.getResourceBundle(ImportDialog.class.getName());
        this.setTitle(this.bundle.getString(TITLE_KEY));
        this.importAction = new ImportAction(this.bundle.getString(IMPORT_KEY));
    }

    private void doImport(final MFileFormat format2) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ImportDialog.this.parent.doImport(format2);
            }
        }).run();
    }

    private MFileFormat getSelectedFormat() {
        if (this.importRecognizedButton.isSelected()) {
            return this.recognizedFormat;
        }
        if (this.importAsButton.isSelected() && this.selectorList.getSelectedIndex() != -1) {
            return (MFileFormat)this.importFormats.get(this.selectorList.getSelectedIndex());
        }
        return null;
    }

    private List getImportFormats() {
        HashMap<String, MFileFormat> formatMap = new HashMap<String, MFileFormat>();
        MFileFormat[] formats = MFileFormatUtil.findFormats(null, 2L, 2L);
        for (int i = 0; i < formats.length; ++i) {
            formatMap.put(formats[i].getDescription(), formats[i]);
        }
        ArrayList result = new ArrayList(formatMap.values());
        Collections.sort(result, new FormatComparator());
        return result;
    }

    private String[] collectFormatNames() {
        ArrayList<String> result = new ArrayList<String>(this.importFormats.size());
        for (MFileFormat format2 : this.importFormats) {
            result.add(format2.getDescription());
        }
        return result.toArray(new String[result.size()]);
    }

    private void initComponents() {
        this.selectorList = new JList<String>(this.collectFormatNames());
        this.selectorList.setAlignmentX(0.0f);
        this.selectorList.setSelectionMode(0);
        if (this.defaultFormat != null) {
            this.selectorList.setSelectedValue(this.defaultFormat.getDescription(), true);
        }
        if (this.selectorList.getSelectedIndex() == -1 && this.selectorList.getModel().getSize() > 0) {
            this.selectorList.setSelectedIndex(0);
        }
        this.importRecognizedButton = new JRadioButton(MessageFormat.format(this.bundle.getString(IMPORT_DEFAULT), this.getRecognizedFormatDescriptor()));
        this.importAsButton = new JRadioButton(this.bundle.getString(IMPORT_AS_KEY));
        ButtonGroup group = new ButtonGroup();
        group.add(this.importRecognizedButton);
        group.add(this.importAsButton);
        if (this.recognizedFormat != null) {
            this.importRecognizedButton.setSelected(true);
        } else {
            this.importAsButton.setSelected(true);
        }
        this.updateView();
    }

    private void initEventHandling() {
        SelectionHandler handler = new SelectionHandler();
        this.selectorList.addListSelectionListener(handler);
        this.importAsButton.addItemListener(handler);
        this.importRecognizedButton.addItemListener(handler);
    }

    private void updateView() {
        this.importRecognizedButton.setEnabled(this.recognizedFormat != null);
        this.selectorList.setEnabled(this.importAsButton.isSelected());
        this.importAction.setEnabled(this.getSelectedFormat() != null);
        if (this.selectorList.getSelectedIndex() != -1) {
            this.selectorList.ensureIndexIsVisible(this.selectorList.getSelectedIndex());
        }
    }

    private String getRecognizedFormatDescriptor() {
        return this.recognizedFormat != null ? this.recognizedFormat.getDescription() : this.bundle.getString("importdialog.formatNotRecognized");
    }

    @Override
    protected Action getOKAction() {
        return this.importAction;
    }

    @Override
    protected JComponent buildButtonBar() {
        return this.buildOKCancelButtonBar();
    }

    @Override
    protected JComponent buildContentPanel() {
        this.initComponents();
        this.initEventHandling();
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(BorderFactory.createTitledBorder(this.bundle.getString(IMPORT_MODE)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        gbc.insets = new Insets(0, 0, 0, 0);
        result.add((Component)this.importRecognizedButton, gbc);
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.gridy = 1;
        result.add((Component)this.importAsButton, gbc);
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 20, 0, 0);
        gbc.fill = 1;
        result.add((Component)new JScrollPane(this.selectorList), gbc);
        this.updateView();
        return result;
    }

    @Override
    public void apply() {
        this.doImport(this.getSelectedFormat());
    }

    private class SelectionHandler
    implements ListSelectionListener,
    ItemListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ImportDialog.this.updateView();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ImportDialog.this.updateView();
        }
    }

    private class ImportAction
    extends AbstractAction {
        public ImportAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImportDialog.this.doOk();
        }
    }

    private class FormatComparator
    implements Comparator {
        private Collator collator = Collator.getInstance();

        private FormatComparator() {
            this.collator.setStrength(0);
        }

        public int compare(Object o1, Object o2) {
            MFileFormat f1 = (MFileFormat)o1;
            MFileFormat f2 = (MFileFormat)o2;
            return this.collator.compare(f1.getDescription(), f2.getDescription());
        }
    }
}

