/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.io.Encoding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;

public abstract class LoadSaveBase {
    protected MolPanel molPanel = null;

    protected boolean simpleWrite(File f, String content, boolean append) {
        return this.simpleWrite(f, content, append, System.getProperty("line.separator"));
    }

    protected boolean simpleWrite(File f, String content, boolean append, String eol) {
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(f.getPath(), append), Encoding.DEFAULT.name());
            int index = 0;
            if (content != null) {
                int eolindex;
                do {
                    if ((eolindex = content.indexOf(10, index)) == -1) {
                        eolindex = content.length();
                    }
                    fw.write(content.substring(index, eolindex));
                    fw.write(eol);
                } while ((index = eolindex + 1) < content.length());
            }
            fw.close();
        }
        catch (IOException ex) {
            this.molPanel.getErrorDisplay().error("Cannot write file " + f.getPath(), ex);
            return false;
        }
        return true;
    }

    protected boolean simpleWrite(File f, byte[] content, boolean append) {
        try {
            FileOutputStream os = new FileOutputStream(f.getPath(), append);
            if (content != null) {
                ((OutputStream)os).write(content);
            }
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            this.molPanel.getErrorDisplay().error("Cannot write file " + f.getPath(), ex);
            return false;
        }
        return true;
    }

    protected void replaceFileContents(RandomAccessFile raf, long start, long end, byte[] data) throws IOException {
        byte[] chunk = new byte[65536];
        long length = raf.length();
        raf.seek(start);
        if (start + (long)data.length <= end) {
            raf.write(data);
            int delta = (int)(end - start - (long)data.length);
            if (delta != 0) {
                int l;
                for (long pos = end; pos < length; pos += (long)l) {
                    raf.seek(pos);
                    l = raf.read(chunk);
                    raf.seek(pos - (long)delta);
                    raf.write(chunk, 0, l);
                }
            }
            if (delta != 0) {
                length -= (long)delta;
                try {
                    Method m = RandomAccessFile.class.getMethod("setLength", Long.TYPE);
                    m.invoke((Object)raf, new Long(length));
                }
                catch (NoSuchMethodException ex) {
                    raf.seek(length);
                    byte[] tmp = new byte[delta];
                    raf.write(tmp);
                    JOptionPane.showMessageDialog(this.molPanel, "Cannot truncate file in a Java 1.1 VM.\nEnd of file filled with zero bytes instead.\nPlease upgrade your JVM to 1.2 or later.", "Cannot truncate file in Java 1.1", 2);
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            int d;
            long pos;
            int delta = (int)(start + (long)data.length - end);
            byte[] deltabuf = new byte[delta];
            raf.seek(length);
            raf.write(deltabuf);
            for (pos = length - (long)chunk.length; pos > end; pos -= (long)chunk.length) {
                int d2;
                raf.seek(pos);
                int l = 0;
                do {
                    if ((d2 = raf.read(chunk, l, chunk.length - l)) >= 0) continue;
                    throw new IOException("read error in replaceFileContents");
                } while ((l += d2) != chunk.length);
                raf.seek(pos + (long)delta);
                raf.write(chunk, 0, chunk.length);
            }
            int ll = (int)((pos += (long)chunk.length) - end);
            pos = end;
            raf.seek(pos);
            for (int l = 0; l < ll; l += d) {
                d = raf.read(chunk, l, ll - l);
                if (d >= 0) continue;
                throw new IOException("read error in replaceFileContents");
            }
            raf.seek(pos + (long)delta);
            raf.write(chunk, 0, ll);
            raf.seek(start);
            raf.write(data);
        }
    }
}

