/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class MolFileFilter
extends FileFilter {
    private String[] exts;
    private String description;
    private String format;
    private String extension;

    public MolFileFilter(String format2) {
        this.format = format2;
        String desc = "";
        MFileFormat mff = MFileFormatUtil.getFormat(format2);
        if (format2.equals("ALL_STRUCTURE_FILES")) {
            desc = "All structure files";
            this.exts = MFileFormatUtil.getMolfileExtensions();
            this.extension = "";
        } else if (mff != null) {
            desc = mff.getDescription();
            this.initExtensions(mff);
        } else {
            this.extension = format2;
            this.exts = new String[]{"." + this.extension};
        }
        this.initDescription(format2, desc);
    }

    public MolFileFilter(MFileFormat mff) {
        this.format = mff.getName();
        this.initExtensions(mff);
        this.initDescription(this.format, mff.getDescription());
    }

    private void initExtensions(MFileFormat mff) {
        this.exts = mff.getExtensions();
        this.extension = this.exts[0];
        for (int i = 0; i < this.exts.length; ++i) {
            this.exts[i] = "." + this.exts[i];
        }
    }

    private void initDescription(String fmt, String desc) {
        StringBuffer sbuf = new StringBuffer(desc);
        if (!fmt.equals("ALL_STRUCTURE_FILES")) {
            sbuf.append(" (");
            for (int i = 0; i < this.exts.length; ++i) {
                sbuf.append('*');
                sbuf.append(this.exts[i]);
                if (i >= this.exts.length - 1) continue;
                sbuf.append(' ');
            }
            sbuf.append(')');
        }
        this.description = sbuf.toString();
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String s = f.getName().toLowerCase();
            for (int i = 0; i < this.exts.length; ++i) {
                String ext = this.exts[i];
                if (!s.endsWith(ext) && !ext.equals("*")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getFormat() {
        return this.format;
    }

    public String getExtension() {
        return this.extension;
    }

    public String toString() {
        String s = super.toString();
        int i = s.lastIndexOf(46);
        StringBuffer sb = new StringBuffer(i >= 0 ? s.substring(i + 1) : s);
        sb.append('[');
        sb.append(this.format);
        sb.append(']');
        return sb.toString();
    }
}

