/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.Molecule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;

public class MultiMoleculeSave
implements CallbackIface,
ActionListener,
Runnable {
    private static final int SAVE_CANCEL = 0;
    private static final int SAVE_NO = 1;
    private static final int SAVE_SIMPLEOVERWRITE = 2;
    private MultiMoleculeSave parent = null;
    private boolean secondRun = false;
    private MolPanel molPanel = null;
    private File moleculeFile = null;
    private File cwd = null;
    private String format = null;
    private Molecule[] molecules = null;
    private String moleculeStr = null;
    private int saveMode = 0;

    public MultiMoleculeSave() {
        try {
            this.cwd = new File(System.getProperty("user.dir"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private MultiMoleculeSave(MultiMoleculeSave p, File f) {
        this.parent = p;
        this.molPanel = p.molPanel;
        this.moleculeFile = f;
        this.cwd = p.cwd;
        this.format = p.format;
        this.molecules = p.molecules;
        this.moleculeStr = p.moleculeStr;
        this.saveMode = p.saveMode;
        new Thread(this).start();
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setMolPanel")) {
            this.molPanel = (MolPanel)arg;
        } else if (method.equals("setFile")) {
            File f = (File)arg;
            this.moleculeFile = f.isDirectory() ? null : f;
            this.setCwd(f);
        } else if (method.equals("setMols")) {
            this.molecules = (Molecule[])arg;
            Timer t = new Timer(20, this);
            t.setRepeats(false);
            t.start();
        }
        return null;
    }

    private JFileChooser createChooser() {
        File cwd = this.cwd;
        JFileChooser w = cwd != null ? new JFileChooser(cwd) : new JFileChooser();
        String[] formats = MFileFormatUtil.getMolfileFormats();
        FileFilter ff = w.getAcceptAllFileFilter();
        String fmt = this.format;
        for (int i = 0; i < formats.length; ++i) {
            String s = formats[i];
            MolFileFilter mff = new MolFileFilter(s);
            w.addChoosableFileFilter(mff);
            if (fmt == null || !fmt.equals(s)) continue;
            ff = mff;
        }
        w.setFileFilter(ff);
        if (this.moleculeFile != null) {
            w.setSelectedFile(this.moleculeFile);
        }
        return w;
    }

    private void setCwd(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                this.cwd = f;
            } else {
                String s = f.getParent();
                if (s != null) {
                    this.cwd = new File(s);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object t = e.getSource();
        if (t instanceof Timer) {
            JFileChooser w = this.createChooser();
            do {
                this.saveAs(w);
            } while (this.saveMode == 1);
        }
    }

    private void saveAs(JFileChooser w) {
        File newfile;
        int r = w.showSaveDialog(this.molPanel);
        this.saveMode = 0;
        if (r == 0 && (newfile = w.getSelectedFile()) != null) {
            String fmt = this.format;
            this.setCwd(newfile);
            String ext = MFileFormatUtil.getFileExtensionLC(newfile);
            MolFileFilter mff = null;
            FileFilter ff = w.getFileFilter();
            if (ff instanceof MolFileFilter) {
                mff = (MolFileFilter)ff;
                fmt = mff.getFormat();
                if (ext == null) {
                    ext = mff.getExtension();
                    newfile = new File(newfile.getPath() + "." + ext);
                }
            }
            if (ext == null) {
                if (fmt != null) {
                    ext = fmt;
                    newfile = new File(newfile.getPath() + "." + ext);
                }
            } else if (!(mff != null && mff.accept(newfile) || fmt != null && fmt.equals("sybyl") && ext.equals("mol"))) {
                fmt = MFileFormatUtil.getMostLikelyMolFormat("." + ext);
            }
            if (fmt == null) {
                JOptionPane.showMessageDialog(null, "Cannot determine output format from extension for file " + newfile.getName(), "Unknown output file format", 0);
                this.saveMode = 1;
                return;
            }
            this.format = fmt;
            this.saveMode = this.prepareSaving(newfile);
            if (this.saveMode != 0 && this.saveMode != 1) {
                new MultiMoleculeSave(this, newfile);
            }
            this.moleculeStr = null;
        }
    }

    @Override
    public void run() {
        if (this.secondRun) {
            this.parent.moleculeFile = this.moleculeFile;
            this.parent.format = this.format;
            this.parent.cwd = this.cwd;
            this.parent.molecules = this.molecules;
            return;
        }
        boolean success = this.save(this.moleculeFile);
        this.molecules = null;
        if (success) {
            this.secondRun = true;
            SwingUtilities.invokeLater(this);
        }
    }

    private int prepareSaving(File f) {
        String msg;
        int r;
        Molecule[] mols = this.molecules;
        this.moleculeStr = null;
        for (int i = 0; i < mols.length && this.format == null; ++i) {
            this.format = mols[i].getInputFormat();
        }
        if (this.format == null) {
            this.format = "cssdf";
        }
        int maxdim = 0;
        for (int i = 0; i < mols.length; ++i) {
            if (mols[i].getDim() <= maxdim) continue;
            maxdim = mols[i].getDim();
        }
        if (maxdim <= 2 && (this.format.equals("xyz") || this.format.equals("pov")) && (r = JOptionPane.showConfirmDialog(this.molPanel, msg = "Are you sure you want to save these 2D structures in " + this.format.toUpperCase() + " format?!?", "Don't save 2D molecules in a 3D format", 1, 2)) != 0) {
            return r == 1 ? 1 : 0;
        }
        try {
            this.moleculeStr = this.toFormat(this.format);
        }
        catch (SecurityException sex) {
            this.molPanel.getErrorDisplay().firewallError(sex, null);
            this.molecules = null;
            return 0;
        }
        catch (Throwable ex) {
            this.molPanel.getErrorDisplay().error("Cannot convert molecule to `" + this.format + "' format", ex);
            this.molecules = null;
            return 0;
        }
        if (f.exists()) {
            int mode = JOptionPane.showConfirmDialog(this.molPanel, "File " + f.getName() + " exists. Overwrite?", "File exists", 0, 2);
            return mode == 0 ? 2 : 1;
        }
        return 2;
    }

    private boolean save(File f) {
        switch (this.saveMode) {
            case 2: {
                return this.simpleWrite(f, this.moleculeStr);
            }
        }
        return false;
    }

    private boolean simpleWrite(File f, String molstr) {
        String eol = System.getProperty("line.separator");
        try {
            int eolindex;
            FileWriter fw = new FileWriter(f.getPath());
            int index = 0;
            do {
                if ((eolindex = molstr.indexOf(10, index)) == -1) {
                    eolindex = molstr.length();
                }
                fw.write(molstr.substring(index, eolindex));
                fw.write(eol);
            } while ((index = eolindex + 1) < molstr.length());
            fw.close();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.molPanel, "Cannot write file " + f.getPath(), "Write error", 0);
            return false;
        }
        return true;
    }

    private String toFormat(String fmt) {
        Molecule[] mols = this.molecules;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mols.length; ++i) {
            String s = mols[i].toFormat(fmt);
            sb.append(s);
            if (s.endsWith("\n")) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

