/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.checkers.runner.configuration.reader.XMLBasedConfigurationReader;
import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.modules.FontAttrPanel;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.marvin.common.swing.spi.PreferencesDialogProvider;
import chemaxon.marvin.modules.win.Jacob;
import chemaxon.marvin.modules.win.registry.RegistryUtil;
import chemaxon.marvin.paint.DispOptConsts;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.services.ServiceDescriptorReader;
import chemaxon.marvin.services.ServiceDescriptorTools;
import chemaxon.marvin.services.ServiceDescriptorWriter;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerConfigurationPanel;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerConfigurationPanelFactory;
import chemaxon.marvin.sketch.swing.modules.services.ServicePreferencesPanel;
import chemaxon.marvin.swing.DelegatingAction;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.util.DotfileUtil;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Preferences
extends PreferencesDialogProvider
implements ActionListener,
FocusListener,
DispOptConsts {
    private static final boolean DEFAULT_SKETCH_VALENCEERR = true;
    private static final boolean DEFAULT_VALIDATE_SGROUPS_ON_CREATION = true;
    private static final boolean DEFAULT_VIEW_VALENCEERR = false;
    private static final ResourceBundle RESOURCES;
    private MolPanel molPanel;
    private JDialog dialog = null;
    private JTabbedPane tabbedPane;
    private boolean canceled;
    private boolean badvalue = false;
    private JRadioButton carbonAlwaysRB;
    private JRadioButton carbonNeverRB;
    private JRadioButton carbonVisibleRB;
    private JRadioButton ligandOrderAlwaysRB;
    private JRadioButton ligandOrderNeverRB;
    private JRadioButton ligandOrderWithDefinitionRB;
    private JRadioButton bondsDownWedgeMDLRB;
    private JRadioButton bondsDownWedgeDaylightRB;
    private JRadioButton[] bondsViewAnyBondRB;
    private JRadioButton[] bondsSketchAnyBondRB;
    private JRadioButton withAtomTerminalBondDeletionStyleRB;
    private JRadioButton withoutAtomTerminalBondDeletionStyleRB;
    private JRadioButton bondsCoordMulticentSolidRB;
    private JRadioButton bondsCoordMulticentHashedRB;
    private JRadioButton bondsCoordSolidRB;
    private JRadioButton bondsCoordArrowRB;
    private FontAttrPanel atomFontPanel;
    private double bondSpacingVal;
    private JTextField bondSpacingTF;
    private JSlider fogSlider;
    private JComponent fogTitle;
    private double wireThicknessVal;
    private JTextField wireThicknessTF;
    private double threedimStickwVal;
    private JTextField threedimStickwTF;
    private double threedimRadiusVal;
    private JTextField threedimRadiusTF;
    private JCheckBox sketchValenceErrCB;
    private JCheckBox viewValenceErrCB;
    private JCheckBox sketchBondDraggedAlongCB;
    private JCheckBox lonePairAutoCalcCB;
    private JCheckBox validateSgroupsAtCreationCB;
    private Action okAction = this.createAction("ok");
    private Action cancelAction = this.createAction("cancel");
    private Action restoreDefaultsAction = this.createAction("restoreDefaults");
    private Action helpAction = this.createAction("help");
    private CheckerConfigurationPanel checkerConfigurationPanel = null;
    private ServicePreferencesPanel serviceConfigurationPanel = null;
    private PreferencesDialogProvider.ServiceContainer serviceContainer = null;
    private PreferencesDialogProvider.CheckerContainer checkerContainer = null;
    private JCheckBox oleEditNeedConfirmation;
    private JCheckBox oleStandaloneModeOn;
    private JComboBox appearanceSkinCombo;
    private JComboBox marvinViewLayoutCombo;
    private JTextField locationTextField;
    private ButtonGroup locationRBGroup;
    private JButton saveBrowseButton;
    private JComboBox defaultSaveFormatCombo;
    private JSpinner recentFileEntriesSpinner;
    private MolFileFilter[] mff = null;
    private static String[] skinIds;
    private static Hashtable<String, String> skinClassNames;
    public static final LookAndFeel DEFAULT_LOOKANDFEEL;
    private static final String OLE_SETTINGS_REGKEY = "Software\\ChemAxon\\MarvinOLE\\Settings";
    private static final String OLE_NEED_CONFIRMATION_REGVALNAME = "ConfirmationDialog";
    private static final String OLE_STANDALONE_MODE_REGVALNAME = "StandaloneMode";
    private static final String OLE_STANDALONE_MODE_VERB_VALUE = "&Edit,0,2";
    private static final String OLE_STANDALONE_MODE_ON_KEY = "CLSID\\{E9C44309-37DA-4892-8D55-349568E1208A}\\Verb\\-3";
    private static final String OLE_STANDALONE_MODE_OFF_KEY = "CLSID\\{E9C44309-37DA-4892-8D55-349568E1208A}\\Verb\\0";
    private static final String OLE_STANDALONE_MODE_DISTURBING_KEY = "CLSID\\{E9C44309-37DA-4892-8D55-349568E1208A}\\Verb\\-1";

    private static void initSkins() {
        UIManager.LookAndFeelInfo[] lafi = UIManager.getInstalledLookAndFeels();
        skinIds = new String[lafi.length];
        skinClassNames = new Hashtable();
        for (int i = 0; i < lafi.length; ++i) {
            Preferences.skinIds[i] = lafi[i].getName();
            skinClassNames.put(lafi[i].getName(), lafi[i].getClassName());
        }
    }

    private Action createAction(String id) {
        DelegatingAction result = new DelegatingAction(id, MolPanel.GRESOURCES.getString(id));
        result.addActionListener(this);
        return result;
    }

    @Override
    public void show(MolPanel panel, PreferencesDialogProvider.ServiceContainer servicesContainer, PreferencesDialogProvider.CheckerContainer checkersContainer) {
        this.molPanel = panel;
        this.serviceContainer = servicesContainer;
        this.checkerContainer = checkersContainer;
        this.init();
        this.showDialog();
    }

    public void setPreferencesFor(MolPanel MolPanel2) {
        this.molPanel = MolPanel2;
    }

    private void init() {
        Window parent;
        if (this.molPanel.isParentWindowDialog()) {
            this.dialog = new JDialog(this.molPanel.getParentDialog(), true);
            parent = this.molPanel.getParentDialog();
        } else {
            this.dialog = new JDialog(this.molPanel.getParentFrame(), true);
            parent = this.molPanel.getParentFrame();
        }
        this.handleEsc();
        ResourceBundle rc = RESOURCES;
        this.dialog.setTitle(rc.getString("Preferences"));
        this.dialog.getContentPane().setLayout(new BorderLayout());
        JPanel dialogPane = new JPanel();
        dialogPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.TABBED_DIALOG_BORDER);
        CellConstraints cc = new CellConstraints();
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(rc.getString("Display"), this.createDisplayPanel());
        this.tabbedPane.add(rc.getString("Bonds"), this.createBondsPanel());
        this.tabbedPane.add(rc.getString("Structure"), this.createStructurePanel());
        this.tabbedPane.add(rc.getString("Checkers"), this.getCheckersPanel());
        this.tabbedPane.add(rc.getString("Services"), this.getServiceConfigurationPanel());
        this.tabbedPane.add(rc.getString("Save"), this.createSavePanel());
        JPanel panel = null;
        if (Environment.MSWINDOWS && Jacob.getInstance().isSupported() && Jacob.getInstance().getOLEDocument().isUsable()) {
            panel = this.createOLEServerPanel();
            this.tabbedPane.add(rc.getString("OLEServer"), panel);
        }
        contentPane.add((Component)this.tabbedPane, "North");
        dialogPane.add((Component)contentPane, "Center");
        dialogPane.add((Component)this.addOkCancelPanel(cc), "South");
        this.dialog.getContentPane().add((Component)dialogPane, "Center");
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
    }

    private void handleEsc() {
        JRootPane rootPane = this.dialog.getRootPane();
        InputMap iMap = rootPane.getInputMap(1);
        iMap.put(KeyStroke.getKeyStroke(27, 0), "escape");
        ActionMap aMap = rootPane.getActionMap();
        aMap.put("escape", new AbstractAction(){
            private static final long serialVersionUID = -1008562546846185747L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.dialog.setVisible(false);
            }
        });
    }

    private JPanel addOkCancelPanel(CellConstraints cc) {
        JPanel buttonBar = new JPanel();
        buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        buttonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        JButton helpButton = new JButton(this.helpAction);
        buttonBar.add((Component)helpButton, cc.xy(2, 1));
        buttonBar.add((Component)new JButton(this.restoreDefaultsAction), cc.xy(4, 1));
        buttonBar.add((Component)new JButton(this.okAction), cc.xy(6, 1));
        buttonBar.add((Component)new JButton(this.cancelAction), cc.xy(8, 1));
        try {
            this.molPanel.enableHelpOnButton(helpButton, "Gui.Dialogs.Preferences");
        }
        catch (Exception e) {
            // empty catch block
        }
        return buttonBar;
    }

    private JPanel createDisplayPanel() {
        JPanel panel = new JPanel();
        panel.setName("display");
        panel.setBorder(Borders.TABBED_DIALOG_BORDER);
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.PREF_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        CellConstraints cc = new CellConstraints();
        UserSettings settings = this.molPanel.getUserSettings();
        String fname = settings.getAtomFont().getFamily();
        double fsize = 12.0 * (settings.getAtomSize() / 0.4);
        this.atomFontPanel = new FontAttrPanel(null, 5, fname, 0, fsize, null, 0, 0, null);
        JLabel title1 = DefaultComponentFactory.getInstance().createTitle(RESOURCES.getString("Display.AtomSymbols"));
        panel.add((Component)title1, cc.xywh(1, 1, 5, 1));
        panel.add((Component)this.atomFontPanel, cc.xywh(1, 3, 5, 1));
        this.addDisplayDrawSettings(panel, cc);
        this.addObjectSettings(panel, cc);
        this.addLookAndFeel(panel, cc, Environment.isSkinEnabled());
        this.addMarvinViewLayout(panel, cc);
        this.addDepthCueSlider(panel, cc);
        return panel;
    }

    private void addMarvinViewLayout(JPanel panel, CellConstraints cc) {
        JLabel title1 = DefaultComponentFactory.getInstance().createTitle(RESOURCES.getString("Display.MarvinViewLayout"));
        panel.add((Component)title1, cc.xy(5, 9));
        this.marvinViewLayoutCombo = new JComboBox();
        this.marvinViewLayoutCombo.insertItemAt("Automatic", 0);
        this.marvinViewLayoutCombo.insertItemAt("Molecule matrix", 1);
        this.marvinViewLayoutCombo.insertItemAt("Spreadsheet", 2);
        panel.add((Component)this.marvinViewLayoutCombo, cc.xy(5, 11));
        this.marvinViewLayoutCombo.setActionCommand("marvinViewLayout");
        this.marvinViewLayoutCombo.addActionListener(this);
        this.marvinViewLayoutCombo.setSelectedIndex(this.molPanel.getUserSettings().getViewLayout());
    }

    private void addDepthCueSlider(JPanel panel, CellConstraints cc) {
        this.fogTitle = DefaultComponentFactory.getInstance().createTitle(RESOURCES.getString("Display.FogSlider") + ": ");
        panel.add((Component)this.fogTitle, cc.xy(5, 13));
        this.fogTitle.setEnabled(true);
        this.fogSlider = new JSlider(0, 0, 100, this.molPanel.getUserSettings().getFogFactor());
        panel.add((Component)this.fogSlider, cc.xy(5, 15));
        this.fogSlider.setMajorTickSpacing(10);
        this.fogSlider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel(RESOURCES.getString("Display.FogNoFog")));
        labelTable.put(new Integer(33), new JLabel(RESOURCES.getString("Display.FogWeak")));
        labelTable.put(new Integer(66), new JLabel(RESOURCES.getString("Display.FogMedium")));
        labelTable.put(new Integer(100), new JLabel(RESOURCES.getString("Display.FogStrong")));
        this.fogSlider.setLabelTable(labelTable);
        this.fogSlider.setPaintLabels(true);
    }

    private void addCarbonLabelSettings(JPanel panel, CellConstraints cc) {
        JLabel title1 = DefaultComponentFactory.getInstance().createTitle(RESOURCES.getString("carbonLabel"));
        panel.add((Component)title1, cc.xy(1, 9));
        this.carbonAlwaysRB = new JRadioButton(RESOURCES.getString("carbonAlways"));
        panel.add((Component)this.carbonAlwaysRB, cc.xy(3, 9));
        this.carbonNeverRB = new JRadioButton(RESOURCES.getString("carbonNever"));
        panel.add((Component)this.carbonNeverRB, cc.xy(3, 11));
        this.carbonVisibleRB = new JRadioButton(RESOURCES.getString("carbonVisible"));
        panel.add((Component)this.carbonVisibleRB, cc.xy(3, 13));
        String cv = null;
        cv = this.molPanel.getCarbonVisibility();
        if (cv.equals("on")) {
            this.carbonAlwaysRB.setSelected(true);
        } else if (cv.equals("off")) {
            this.carbonNeverRB.setSelected(true);
        } else {
            this.carbonVisibleRB.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.carbonAlwaysRB);
        group.add(this.carbonNeverRB);
        group.add(this.carbonVisibleRB);
    }

    private void addLigandOrderLabelSettings(JPanel panel, CellConstraints cc) {
        JLabel title1 = DefaultComponentFactory.getInstance().createTitle(RESOURCES.getString("ligandOrderLabel"));
        panel.add((Component)title1, cc.xy(1, 15));
        this.ligandOrderAlwaysRB = new JRadioButton(RESOURCES.getString("ligandOrderAlways"));
        panel.add((Component)this.ligandOrderAlwaysRB, cc.xy(3, 15));
        this.ligandOrderNeverRB = new JRadioButton(RESOURCES.getString("ligandOrderNever"));
        panel.add((Component)this.ligandOrderNeverRB, cc.xy(3, 17));
        this.ligandOrderWithDefinitionRB = new JRadioButton(RESOURCES.getString("ligandOrderWithDefinition"));
        panel.add((Component)this.ligandOrderWithDefinitionRB, cc.xy(3, 19));
        String cv = this.molPanel.getLigandOrderVisibility();
        if (cv == "on") {
            this.ligandOrderAlwaysRB.setSelected(true);
        } else if (cv == "off") {
            this.ligandOrderNeverRB.setSelected(true);
        } else if (cv == "showOnlyWithDefinition") {
            this.ligandOrderWithDefinitionRB.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.ligandOrderAlwaysRB);
        group.add(this.ligandOrderNeverRB);
        group.add(this.ligandOrderWithDefinitionRB);
    }

    private void addDisplayDrawSettings(JPanel panel, CellConstraints cc) {
        UserSettings settings = this.molPanel.getUserSettings();
        ResourceBundle rc = RESOURCES;
        JLabel title = DefaultComponentFactory.getInstance().createTitle(rc.getString("Display.DrawSettings"));
        panel.add((Component)title, cc.xywh(1, 5, 5, 1));
        this.bondSpacingVal = settings.getBondSpacing();
        this.wireThicknessVal = settings.getWireThickness();
        JLabel label1 = new JLabel(rc.getString("Display.bondSpacing") + ":");
        panel.add((Component)label1, cc.xy(1, 7));
        this.bondSpacingTF = new JTextField(5);
        this.bondSpacingTF.setText(String.valueOf(this.bondSpacingVal));
        this.bondSpacingTF.addFocusListener(this);
        panel.add((Component)this.bondSpacingTF, cc.xy(3, 7));
        JLabel label2 = new JLabel(rc.getString("Display.wireThickness") + ":");
        panel.add((Component)label2, cc.xy(1, 9));
        this.wireThicknessTF = new JTextField(5);
        this.wireThicknessTF.setText(String.valueOf(this.wireThicknessVal));
        this.wireThicknessTF.addFocusListener(this);
        panel.add((Component)this.wireThicknessTF, cc.xy(3, 9));
        this.threedimStickwVal = settings.getStickThickness();
        this.threedimRadiusVal = settings.getBallRadius();
        JLabel label3 = new JLabel(rc.getString("Display.stickDiameter") + ":");
        panel.add((Component)label3, cc.xy(1, 11));
        this.threedimStickwTF = new JTextField(5);
        this.threedimStickwTF.setText(String.valueOf(this.threedimStickwVal));
        this.threedimStickwTF.addFocusListener(this);
        panel.add((Component)this.threedimStickwTF, cc.xy(3, 11));
        JLabel label4 = new JLabel(rc.getString("Display.ballRadius") + ":");
        panel.add((Component)label4, cc.xy(1, 13));
        this.threedimRadiusTF = new JTextField(5);
        this.threedimRadiusTF.setText(String.valueOf(this.threedimRadiusVal));
        this.threedimRadiusTF.addFocusListener(this);
        panel.add((Component)this.threedimRadiusTF, cc.xy(3, 13));
    }

    private void addObjectSettings(JPanel panel, CellConstraints cc) {
        ResourceBundle rc = RESOURCES;
        JLabel title = DefaultComponentFactory.getInstance().createTitle(rc.getString("Display.ObjectSettings"));
        panel.add((Component)title, cc.xywh(5, 5, 3, 1));
        this.sketchBondDraggedAlongCB = new JCheckBox(rc.getString("Display.BondInHand"));
        this.sketchBondDraggedAlongCB.setActionCommand("sketchBondDraggedAlong");
        this.sketchBondDraggedAlongCB.addActionListener(this);
        this.setSketchBondDraggedAlong(this.molPanel.getUserSettings().isBondDraggedAlong());
        panel.add((Component)this.sketchBondDraggedAlongCB, cc.xywh(5, 7, 3, 1));
    }

    private void addLookAndFeel(JPanel panel, CellConstraints cc, boolean enabled) {
        ResourceBundle rc = RESOURCES;
        JLabel title = DefaultComponentFactory.getInstance().createTitle(rc.getString("Display.LookAndFeel"));
        panel.add((Component)title, cc.xywh(1, 15, 3, 1));
        this.appearanceSkinCombo = new JComboBox<String>(skinIds);
        panel.add((Component)this.appearanceSkinCombo, cc.xywh(1, 17, 3, 1));
        this.appearanceSkinCombo.setActionCommand("appearanceSkin");
        this.appearanceSkinCombo.addActionListener(this);
        for (String name : skinClassNames.keySet()) {
            if (!UIManager.getLookAndFeel().getClass().getName().equals(skinClassNames.get(name))) continue;
            this.appearanceSkinCombo.setSelectedItem(name);
        }
        this.appearanceSkinCombo.setEnabled(enabled);
    }

    private JPanel createSavePanel() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        CellConstraints cc = new CellConstraints();
        UserSettings settings = this.molPanel.getUserSettings();
        JPanel panel = new JPanel();
        panel.setName("save");
        panel.setBorder(Borders.TABBED_DIALOG_BORDER);
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel defaultLocationTitle = compFactory.createTitle(RESOURCES.getString("Save.defaultLocation"));
        panel.add((Component)defaultLocationTitle, cc.xy(1, 1));
        this.locationTextField = new JTextField();
        if (settings.getLoadWorkingDir() != null) {
            this.locationTextField.setText(settings.getLoadWorkingDir().getAbsolutePath());
        } else {
            this.locationTextField.setText("");
        }
        panel.add((Component)this.locationTextField, cc.xy(3, 7));
        this.saveBrowseButton = new JButton(RESOURCES.getString("Save.browseButton"));
        this.saveBrowseButton.setName("saveBrowseButton");
        this.saveBrowseButton.setActionCommand("saveBrowseButton");
        this.saveBrowseButton.addActionListener(this);
        panel.add((Component)this.saveBrowseButton, cc.xy(5, 7));
        JRadioButton locationRB1 = new JRadioButton();
        locationRB1.setText(RESOURCES.getString("Save.startup"));
        locationRB1.setActionCommand("saveStartupLocation");
        if ("saveStartupLocation".equals(settings.getLoadSaveLocation())) {
            locationRB1.setSelected(true);
            this.locationTextField.setEnabled(false);
            this.locationTextField.setEditable(false);
            this.saveBrowseButton.setEnabled(false);
            this.locationTextField.setText("");
        }
        locationRB1.addActionListener(this);
        panel.add((Component)locationRB1, cc.xy(3, 1));
        JRadioButton locationRB2 = new JRadioButton();
        locationRB2.setText(RESOURCES.getString("Save.lastLocation"));
        locationRB2.setActionCommand("saveLastLocation");
        if ("saveLastLocation".equals(settings.getLoadSaveLocation())) {
            locationRB2.setSelected(true);
            this.locationTextField.setEnabled(false);
            this.locationTextField.setEditable(false);
            this.locationTextField.setText("");
            this.saveBrowseButton.setEnabled(false);
        }
        locationRB2.addActionListener(this);
        panel.add((Component)locationRB2, cc.xy(3, 3));
        JRadioButton locationRB3 = new JRadioButton();
        locationRB3.setText(RESOURCES.getString("Save.customDir"));
        locationRB3.setActionCommand("saveCustomLocation");
        if ("saveCustomLocation".equals(settings.getLoadSaveLocation())) {
            locationRB3.setSelected(true);
            this.locationTextField.setEnabled(true);
            this.locationTextField.setEditable(true);
            this.saveBrowseButton.setEnabled(true);
            if (settings.getLoadWorkingDir() != null) {
                this.locationTextField.setText(settings.getLoadWorkingDir().getAbsolutePath());
            } else {
                this.locationTextField.setText("");
            }
        }
        locationRB3.addActionListener(this);
        panel.add((Component)locationRB3, cc.xy(3, 5));
        this.locationRBGroup = new ButtonGroup();
        this.locationRBGroup.add(locationRB1);
        this.locationRBGroup.add(locationRB2);
        this.locationRBGroup.add(locationRB3);
        long flags = 0L;
        MFileFormat[] formats = MFileFormatUtil.findFormats(null, flags |= 1L, flags | 0x80L | 0x100L);
        this.mff = new MolFileFilter[formats.length];
        String[] formatIds = new String[formats.length];
        int selectedIndex = 0;
        String dffmt = settings.getDefaultSaveFormat();
        for (int i = 0; i < formats.length; ++i) {
            this.mff[i] = new MolFileFilter(formats[i]);
            formatIds[i] = this.mff[i].getDescription();
            if (!dffmt.equals(this.mff[i].getFormat())) continue;
            selectedIndex = i;
        }
        JLabel defaultSaveFormatLabel = compFactory.createTitle(RESOURCES.getString("Save.defaultSaveFormat_Label"));
        panel.add((Component)defaultSaveFormatLabel, cc.xy(1, 9));
        this.defaultSaveFormatCombo = new JComboBox<String>(formatIds);
        this.defaultSaveFormatCombo.setSelectedIndex(selectedIndex);
        panel.add((Component)this.defaultSaveFormatCombo, cc.xywh(3, 9, 3, 1));
        JLabel saveControlLabel = compFactory.createTitle(RESOURCES.getString("Save.saveSettingsIntoMRV"));
        panel.add((Component)saveControlLabel, cc.xy(1, 11));
        boolean isChecked = settings.getSaveGUIPropertiesInMRV();
        JCheckBox saveLoadGUISettings_CB = new JCheckBox(RESOURCES.getString("Save.saveLoadGUISettings_CB"), isChecked);
        saveLoadGUISettings_CB.setEnabled(true);
        saveLoadGUISettings_CB.setActionCommand("saveLoadGUISettings");
        saveLoadGUISettings_CB.addActionListener(this);
        panel.add((Component)saveLoadGUISettings_CB, cc.xy(3, 11));
        isChecked = settings.getSaveLoadZoomFactorToMRV();
        JCheckBox saveLoadZoomFactor_CB = new JCheckBox(RESOURCES.getString("Save.saveLoadZoomFactor_CB"), isChecked);
        saveLoadZoomFactor_CB.setEnabled(true);
        panel.add((Component)saveLoadZoomFactor_CB, cc.xy(3, 13));
        saveLoadZoomFactor_CB.setActionCommand("saveLoadZoomFactor");
        saveLoadZoomFactor_CB.addActionListener(this);
        JLabel recentEntriesLabel = compFactory.createTitle(RESOURCES.getString("Save.recentEntries_Label"));
        panel.add((Component)recentEntriesLabel, cc.xy(1, 15));
        this.recentFileEntriesSpinner = new JSpinner();
        if (this.molPanel instanceof ViewPanel) {
            this.recentFileEntriesSpinner.setModel(new SpinnerNumberModel(settings.getViewRecentFileListSize(), 1, 50, 1));
        } else {
            this.recentFileEntriesSpinner.setModel(new SpinnerNumberModel(settings.getSketchRecentFileListSize(), 1, 50, 1));
        }
        panel.add((Component)this.recentFileEntriesSpinner, cc.xy(5, 15));
        return panel;
    }

    private JPanel createBondsPanel() {
        JPanel panel = new JPanel();
        panel.setName("bonds");
        panel.setBorder(Borders.TABBED_DIALOG_BORDER);
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.GLUE_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.GLUE_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.GLUE_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.GLUE_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.GLUE_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        CellConstraints cc0 = new CellConstraints();
        CellConstraints cc1 = new CellConstraints();
        this.addBondsDownWedgeComponents(panel1, cc0);
        this.addBondsAnyBondComponents(panel2, cc1);
        this.addBondDeletionStylePanel(panel1, cc0);
        this.addBondsCoordinateStyleComponents(panel2, cc1);
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.DEFAULT, (Size)Sizes.DEFAULT, 0.0)}, new RowSpec[]{new RowSpec(RowSpec.TOP, (Size)Sizes.DEFAULT, 1.0)}));
        CellConstraints cc = new CellConstraints();
        panel.add((Component)panel1, cc.xy(1, 1));
        panel.add((Component)panel2, cc.xy(3, 1));
        return panel;
    }

    private void addBondDeletionStylePanel(JPanel panel, CellConstraints cc) {
        JLabel title = DefaultComponentFactory.getInstance().createTitle(RESOURCES.getString("bondDeletionStyleTitle"));
        panel.add((Component)title, cc.xy(1, 11));
        String dsc = RESOURCES.getString("bondDeletionStyleDesc");
        JTextArea textArea = new JTextArea(dsc);
        textArea.setEditable(false);
        textArea.setFont(new Font("Tahoma", 0, 9));
        textArea.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        textArea.setBackground(UIManager.getColor("Panel.background"));
        panel.add((Component)textArea, cc.xy(1, 13));
        String s = this.molPanel.getUserSettings().getTerminalBondDeletionStyle();
        this.withAtomTerminalBondDeletionStyleRB = new JRadioButton(RESOURCES.getString("withAtomTerminalBondDeletionStyle"), s.equals("withAtom"));
        panel.add((Component)this.withAtomTerminalBondDeletionStyleRB, cc.xy(1, 15));
        this.withoutAtomTerminalBondDeletionStyleRB = new JRadioButton(RESOURCES.getString("withoutAtomTerminalBondDeletionStyle"), s.equals("withoutAtom"));
        panel.add((Component)this.withoutAtomTerminalBondDeletionStyleRB, cc.xy(1, 17));
        ButtonGroup group = new ButtonGroup();
        group.add(this.withAtomTerminalBondDeletionStyleRB);
        group.add(this.withoutAtomTerminalBondDeletionStyleRB);
    }

    private void addBondsDownWedgeComponents(JPanel panel, CellConstraints cc) {
        UserSettings settings = this.molPanel.getUserSettings();
        JLabel title1 = DefaultComponentFactory.getInstance().createTitle(RESOURCES.getString("downWedgeTitle"));
        panel.add((Component)title1, cc.xy(1, 1));
        String dsc = RESOURCES.getString("downWedgeDesc");
        JTextArea textArea = new JTextArea(dsc);
        textArea.setEditable(false);
        textArea.setFont(new Font("Tahoma", 0, 9));
        textArea.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        textArea.setBackground(UIManager.getColor("Panel.background"));
        panel.add((Component)textArea, cc.xy(1, 3));
        String s = settings.getDownWedge();
        this.bondsDownWedgeMDLRB = new JRadioButton(RESOURCES.getString("downWedgeMDL"), s.equals("mdl"));
        panel.add((Component)this.bondsDownWedgeMDLRB, cc.xy(1, 5));
        this.bondsDownWedgeDaylightRB = new JRadioButton(RESOURCES.getString("downWedgeDaylight"), s.equals("daylight"));
        panel.add((Component)this.bondsDownWedgeDaylightRB, cc.xy(1, 7));
        ButtonGroup group = new ButtonGroup();
        group.add(this.bondsDownWedgeMDLRB);
        group.add(this.bondsDownWedgeDaylightRB);
    }

    private JPanel addBondsAnyBondComponents(JPanel panel, CellConstraints cc) {
        ResourceBundle rc = RESOURCES;
        UserSettings settings = this.molPanel.getUserSettings();
        JLabel title1 = DefaultComponentFactory.getInstance().createTitle(RESOURCES.getString("anyBondTitle"));
        panel.add((Component)title1, cc.xywh(1, 1, 3, 1));
        String dsc = rc.getString("anyBondDesc");
        JTextArea textArea = new JTextArea(dsc);
        textArea.setEditable(false);
        textArea.setFont(new Font("Tahoma", 0, 9));
        textArea.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        textArea.setBackground(UIManager.getColor("Panel.background"));
        panel.add((Component)textArea, cc.xywh(1, 3, 5, 1));
        JLabel title2 = DefaultComponentFactory.getInstance().createTitle(rc.getString("InSketcher"));
        panel.add((Component)title2, cc.xy(1, 5));
        this.bondsSketchAnyBondRB = new JRadioButton[ANYBOND_STYLES.length];
        String sketchAnyBond = settings.getSketchAnyBond();
        ButtonGroup group1 = new ButtonGroup();
        String[] labels = new String[]{rc.getString("anyBondAuto"), rc.getString("anyBondDashed"), rc.getString("anyBondSolid")};
        for (int i = 0; i < ANYBOND_STYLES.length; ++i) {
            this.bondsSketchAnyBondRB[i] = new JRadioButton(labels[i], sketchAnyBond.equals(ANYBOND_STYLES[i]));
            group1.add(this.bondsSketchAnyBondRB[i]);
            panel.add((Component)this.bondsSketchAnyBondRB[i], cc.xy(1, 7 + 2 * i));
        }
        JLabel title3 = DefaultComponentFactory.getInstance().createTitle(rc.getString("InViewer"));
        panel.add((Component)title3, cc.xy(3, 5));
        String viewAnyBond = settings.getViewAnyBond();
        this.bondsViewAnyBondRB = new JRadioButton[ANYBOND_STYLES.length];
        ButtonGroup group2 = new ButtonGroup();
        for (int i = 0; i < ANYBOND_STYLES.length; ++i) {
            this.bondsViewAnyBondRB[i] = new JRadioButton(labels[i], viewAnyBond.equals(ANYBOND_STYLES[i]));
            group2.add(this.bondsViewAnyBondRB[i]);
            panel.add((Component)this.bondsViewAnyBondRB[i], cc.xy(3, 7 + 2 * i));
        }
        return panel;
    }

    private void addBondsCoordinateStyleComponents(JPanel panel, CellConstraints cc) {
        UserSettings settings = this.molPanel.getUserSettings();
        JLabel title1 = DefaultComponentFactory.getInstance().createTitle(RESOURCES.getString("coordinateBondStyleTitle"));
        panel.add((Component)title1, cc.xywh(1, 13, 3, 1));
        String dsc = RESOURCES.getString("coordinateBondStyleDesc");
        JTextArea textArea = new JTextArea(dsc);
        textArea.setEditable(false);
        textArea.setFont(new Font("Tahoma", 0, 9));
        textArea.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        textArea.setBackground(UIManager.getColor("Panel.background"));
        panel.add((Component)textArea, cc.xywh(1, 15, 5, 1));
        JLabel title2 = DefaultComponentFactory.getInstance().createTitle(RESOURCES.getString("coordinateBondSingleTitle"));
        panel.add((Component)title2, cc.xy(1, 17));
        String s = settings.getCoordinateBondStyle();
        this.bondsCoordArrowRB = new JRadioButton(RESOURCES.getString("coordinateBondStyleArrow"), s.equals("arrow"));
        panel.add((Component)this.bondsCoordArrowRB, cc.xy(1, 19));
        this.bondsCoordSolidRB = new JRadioButton(RESOURCES.getString("coordinateBondStyleSolid"), s.equals("solid"));
        panel.add((Component)this.bondsCoordSolidRB, cc.xy(1, 21));
        ButtonGroup group0 = new ButtonGroup();
        group0.add(this.bondsCoordArrowRB);
        group0.add(this.bondsCoordSolidRB);
        JLabel title3 = DefaultComponentFactory.getInstance().createTitle(RESOURCES.getString("coordinateBondMulticenterTitle"));
        panel.add((Component)title3, cc.xy(3, 17));
        s = settings.getCoordinateBondStyleAtMulticenter();
        this.bondsCoordMulticentHashedRB = new JRadioButton(RESOURCES.getString("coordinateBondStyleHashed"), s.equals("hashed"));
        panel.add((Component)this.bondsCoordMulticentHashedRB, cc.xy(3, 19));
        this.bondsCoordMulticentSolidRB = new JRadioButton(RESOURCES.getString("coordinateBondStyleSolid"), s.equals("solid"));
        panel.add((Component)this.bondsCoordMulticentSolidRB, cc.xy(3, 21));
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.bondsCoordMulticentHashedRB);
        group1.add(this.bondsCoordMulticentSolidRB);
    }

    private JPanel createStructurePanel() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        CellConstraints cc = new CellConstraints();
        JPanel panel = new JPanel();
        panel.setName("structure");
        panel.setBorder(Borders.TABBED_DIALOG_BORDER);
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        UserSettings settings = this.molPanel.getUserSettings();
        JLabel sketchTitle = compFactory.createTitle(RESOURCES.getString("MarvinSketch"));
        panel.add((Component)sketchTitle, cc.xy(1, 1));
        this.sketchValenceErrCB = new JCheckBox(RESOURCES.getString("ValenceErrors"), settings.isValenceErrorVisible());
        panel.add((Component)this.sketchValenceErrCB, cc.xy(3, 1));
        this.lonePairAutoCalcCB = new JCheckBox(RESOURCES.getString("LonePairsAutoCalc"), settings.isLonePairAutoCalc());
        panel.add((Component)this.lonePairAutoCalcCB, cc.xy(3, 3));
        this.validateSgroupsAtCreationCB = new JCheckBox(RESOURCES.getString("validateSgroupsAtCreation"), settings.isvalidateSgroupsAtCreation());
        panel.add((Component)this.validateSgroupsAtCreationCB, cc.xy(3, 5));
        JLabel viewTitle = compFactory.createTitle(RESOURCES.getString("MarvinView"));
        panel.add((Component)viewTitle, cc.xy(1, 7));
        this.viewValenceErrCB = new JCheckBox(RESOURCES.getString("ValenceErrorsView"), settings.isValenceErrorVisibleInView());
        panel.add((Component)this.viewValenceErrCB, cc.xy(3, 7));
        this.addCarbonLabelSettings(panel, cc);
        this.addLigandOrderLabelSettings(panel, cc);
        return panel;
    }

    private CheckerConfigurationPanel getCheckersPanel() {
        if (this.checkerConfigurationPanel == null) {
            XMLBasedConfigurationReader reader = null;
            InputStream inputStream = null;
            File userFile = DotfileUtil.getDotFile("/" + this.molPanel.getUserSettings().getCheckerConfigFileName());
            if (userFile.exists()) {
                try {
                    inputStream = new FileInputStream(userFile);
                }
                catch (FileNotFoundException e) {}
            } else {
                inputStream = this.getClass().getResourceAsStream("/chemaxon/marvin/sketch/swing/modules/checker/resources/default.xml");
            }
            if (inputStream != null) {
                reader = new XMLBasedConfigurationReader(inputStream);
            }
            this.checkerConfigurationPanel = CheckerConfigurationPanelFactory.createDefaultCheckerConfigPanel(reader);
            this.checkerConfigurationPanel.readCheckers();
            this.checkerConfigurationPanel.setName("checkers");
            this.checkerConfigurationPanel.setPreferredSize(new Dimension(100, 100));
            this.checkerConfigurationPanel.setAcceptAction(this.okAction);
        }
        this.checkerConfigurationPanel.setPanelEnabled(!"false".equalsIgnoreCase(this.molPanel.getUserSettings().getProperty("CheckerConfigurationPanelEnabled")));
        return this.checkerConfigurationPanel;
    }

    private ServicePreferencesPanel getServiceConfigurationPanel() {
        if (this.serviceConfigurationPanel == null) {
            this.serviceConfigurationPanel = new ServicePreferencesPanel(this.molPanel.getServiceDescriptorReader(), this.molPanel.getServiceDescriptorWriter(), ServiceDescriptorTools.getServiceDescriptorConfigurationAsStream(this.molPanel.getUserSettings()));
            this.serviceConfigurationPanel.getEditorPanel().putClientProperty("UserSettings", this.molPanel.getUserSettings());
            this.serviceConfigurationPanel.setName("services");
            this.serviceConfigurationPanel.setPreferredSize(new Dimension(100, 100));
        }
        return this.serviceConfigurationPanel;
    }

    private JPanel createOLEServerPanel() {
        ResourceBundle rc = RESOURCES;
        CellConstraints cc = new CellConstraints();
        JPanel panel = new JPanel();
        panel.setName("oleserver");
        panel.setBorder(Borders.TABBED_DIALOG_BORDER);
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.oleEditNeedConfirmation = new JCheckBox(rc.getString("OLEEditNeedConfirmation"));
        this.oleEditNeedConfirmation.setToolTipText(rc.getString("OLEEditNeedConfirmationHelp"));
        RegistryUtil util = Jacob.getInstance().getRegistryUtil();
        util.open(-2147483647, OLE_SETTINGS_REGKEY, false);
        boolean registryval = util.getLongValue(OLE_NEED_CONFIRMATION_REGVALNAME) != 0L;
        util.close();
        this.oleEditNeedConfirmation.setEnabled(!Environment.UNTRUSTED);
        this.oleEditNeedConfirmation.setSelected(registryval);
        this.oleStandaloneModeOn = new JCheckBox(rc.getString("OLEStandaloneMode"));
        this.oleStandaloneModeOn.setToolTipText(rc.getString("OLEStandaloneModeHelp"));
        util.open(-2147483647, OLE_SETTINGS_REGKEY, false);
        registryval = util.getLongValue(OLE_STANDALONE_MODE_REGVALNAME) != 0L;
        util.close();
        this.oleStandaloneModeOn.setEnabled(util.isHKCRAccessible());
        this.oleStandaloneModeOn.setSelected(registryval);
        panel.add((Component)this.oleEditNeedConfirmation, cc.xy(1, 5));
        panel.add((Component)this.oleStandaloneModeOn, cc.xy(1, 7));
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object t = ev.getSource();
        if (t instanceof Action) {
            String cmd = ev.getActionCommand();
            if (cmd.equals("ok")) {
                if (!this.badvalue) {
                    int x;
                    String newformat;
                    if (this.mff != null && !(newformat = this.mff[x = this.defaultSaveFormatCombo.getSelectedIndex()].getFormat()).equals(this.molPanel.getUserSettings().getDefaultSaveFormat())) {
                        this.molPanel.getUserSettings().setDefaultSaveFormat(newformat);
                    }
                    this.dialog.setVisible(false);
                    this.canceled = false;
                }
            } else if (cmd.equals("cancel")) {
                this.dialog.setVisible(false);
            } else if (cmd.equals("restoreDefaults")) {
                String s;
                Component tab = this.tabbedPane.getSelectedComponent();
                String string = s = tab != null ? tab.getName() : "";
                if (s == null) {
                    s = "";
                }
                if (s.equals("bonds")) {
                    this.bondsDownWedgeMDLRB.setSelected(true);
                    this.bondsDownWedgeDaylightRB.setSelected(false);
                    this.bondsSketchAnyBondRB[0].setSelected(true);
                    this.bondsViewAnyBondRB[0].setSelected(true);
                    this.withAtomTerminalBondDeletionStyleRB.setSelected(true);
                    this.withoutAtomTerminalBondDeletionStyleRB.setSelected(false);
                    this.bondsCoordMulticentHashedRB.setSelected(true);
                    this.bondsCoordMulticentSolidRB.setSelected(false);
                    this.bondsCoordArrowRB.setSelected(true);
                    this.bondsCoordSolidRB.setSelected(false);
                } else if (s.equals("display")) {
                    if (Environment.isSkinEnabled()) {
                        this.appearanceSkinCombo.setSelectedItem(DEFAULT_LOOKANDFEEL.getName());
                        this.setLookAndFeelForDialog();
                    }
                    this.atomFontPanel.setSelectedFontFamily(MolPainterCommon.DEFAULT_BASE_FONT.getFamily());
                    this.atomFontPanel.setSelectedSize(12.0);
                    this.bondSpacingVal = 0.18;
                    this.bondSpacingTF.setText(String.valueOf(this.bondSpacingVal));
                    this.wireThicknessVal = 0.064;
                    this.wireThicknessTF.setText(String.valueOf(this.wireThicknessVal));
                    this.threedimStickwVal = 0.1;
                    this.threedimStickwTF.setText(String.valueOf(this.threedimStickwVal));
                    this.threedimRadiusVal = 0.5;
                    this.threedimRadiusTF.setText(String.valueOf(this.threedimRadiusVal));
                    this.sketchBondDraggedAlongCB.setSelected(Boolean.parseBoolean(this.molPanel.getUserSettings().getDefaultProperty("bondDraggedAlong")));
                    this.fogSlider.setValue(Integer.parseInt(this.molPanel.getUserSettings().getDefaultProperty("fogFactor")));
                } else if (s.equals("save")) {
                    String deffmt = this.molPanel.getUserSettings().getDefaultSaveFormat();
                    for (int i = 0; i < this.mff.length; ++i) {
                        if (!this.mff[i].getFormat().equals(deffmt)) continue;
                        this.defaultSaveFormatCombo.setSelectedIndex(i);
                        break;
                    }
                } else if (s.equals("structure")) {
                    this.sketchValenceErrCB.setSelected(true);
                    this.viewValenceErrCB.setSelected(false);
                    this.validateSgroupsAtCreationCB.setSelected(true);
                    this.lonePairAutoCalcCB.setSelected(Boolean.parseBoolean(this.molPanel.getUserSettings().getDefaultProperty("lonePairsAutoCalc")));
                    String cv = this.molPanel instanceof ViewPanel ? this.molPanel.getUserSettings().getDefaultProperty("viewCarbonVisibility") : this.molPanel.getUserSettings().getDefaultProperty("sketchCarbonVisibility");
                    if (cv.equals("on")) {
                        this.carbonAlwaysRB.setSelected(true);
                    } else if (cv.equals("off")) {
                        this.carbonNeverRB.setSelected(true);
                    } else {
                        this.carbonVisibleRB.setSelected(true);
                    }
                    String lo = this.molPanel instanceof ViewPanel ? this.molPanel.getUserSettings().getDefaultProperty("viewLigandOrderVisibility") : this.molPanel.getUserSettings().getDefaultProperty("sketchLigandOrderVisibility");
                    if (lo.equals("on")) {
                        this.ligandOrderAlwaysRB.setSelected(true);
                    } else if (lo.equals("off")) {
                        this.ligandOrderNeverRB.setSelected(true);
                    } else {
                        this.ligandOrderWithDefinitionRB.setSelected(true);
                    }
                } else if (s.equals("checkers")) {
                    if (!"false".equalsIgnoreCase(this.molPanel.getUserSettings().getProperty("CheckerConfigurationPanelEnabled"))) {
                        this.getCheckersPanel().readCheckers(this.getClass().getResourceAsStream("/chemaxon/marvin/sketch/swing/modules/checker/resources/default.xml"));
                    }
                } else if (s.equals("services")) {
                    ServiceDescriptorReader reader = this.molPanel.getServiceDescriptorReader();
                    if (reader != null) {
                        this.getServiceConfigurationPanel().loadConfiguration(reader, ServiceDescriptorTools.getServiceDescriptorConfigurationAsStream(this.molPanel.getUserSettings()));
                    } else {
                        this.getServiceConfigurationPanel().clear();
                    }
                }
            }
        } else {
            String cmd = ev.getActionCommand();
            if (cmd.equals("appearanceSkin")) {
                if (Environment.isSkinEnabled()) {
                    this.setLookAndFeelForDialog();
                }
            } else if (cmd.equals("sketchBondDraggedAlong")) {
                boolean s = ((JCheckBox)t).isSelected();
                this.setSketchBondDraggedAlong(s);
            } else if (cmd.equals("saveLoadGUISettings")) {
                this.molPanel.setSaveGlobalGUIProperties(((JCheckBox)t).isSelected());
            } else if (cmd.equals("saveLoadZoomFactor")) {
                UserSettings settings = this.molPanel.getUserSettings();
                if (settings != null) {
                    settings.setSaveLoadZoomFactorToMRV(((JCheckBox)t).isSelected());
                }
            } else if (cmd.equals("copyHelp")) {
                this.molPanel.showPage("help/datatransfer.html");
            } else if (cmd.equals("saveStartupLocation") || cmd.equals("saveLastLocation")) {
                this.locationTextField.setEditable(false);
                this.locationTextField.setEnabled(false);
                this.locationTextField.setText("");
                this.saveBrowseButton.setEnabled(false);
            } else if (cmd.equals("saveCustomLocation")) {
                UserSettings settings = this.molPanel.getUserSettings();
                this.locationTextField.setEditable(true);
                this.locationTextField.setEnabled(true);
                if (settings != null && settings.getLoadWorkingDir() != null) {
                    this.locationTextField.setText(settings.getLoadWorkingDir().getAbsolutePath());
                } else {
                    this.locationTextField.setText("");
                }
                this.saveBrowseButton.setEnabled(true);
            } else if (cmd.equals("saveBrowseButton")) {
                UserSettings settings = this.molPanel.getUserSettings();
                if (settings != null) {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(1);
                    fc.setCurrentDirectory(settings.getLoadWorkingDir());
                    int fcRetVal = fc.showDialog(this.dialog, RESOURCES.getString("Save.fileChooserOkButtonText"));
                    if (fcRetVal == 0) {
                        this.locationTextField.setText(fc.getSelectedFile().getAbsolutePath());
                        settings.setLoadWorkingDir(fc.getSelectedFile().getAbsolutePath());
                    }
                }
            } else if (cmd.equals("marvinViewLayout")) {
                this.molPanel.getUserSettings().setViewLayout(((JComboBox)t).getSelectedIndex());
            }
            this.badvalue = false;
        }
    }

    private void showDialog() {
        this.canceled = true;
        String prevSkin = null;
        if (Environment.isSkinEnabled()) {
            prevSkin = UIManager.getLookAndFeel().getName();
        }
        this.dialog.setVisible(true);
        String skin = null;
        if (Environment.isSkinEnabled()) {
            skin = (String)this.appearanceSkinCombo.getSelectedItem();
            String cl = skinClassNames.get(prevSkin);
            if (cl != null) {
                Preferences.setLookandFeel(cl);
            }
        }
        if (!this.canceled) {
            int i;
            String skincl;
            if (Environment.isSkinEnabled() && (skincl = skinClassNames.get(skin)) != null && !skincl.equals(UIManager.getLookAndFeel().getClass().getName())) {
                this.molPanel.setSkin(skincl);
            }
            this.molPanel.setDownWedge(this.bondsDownWedgeMDLRB.isSelected() ? "mdl" : "daylight");
            for (i = 0; i < this.bondsSketchAnyBondRB.length; ++i) {
                if (!this.bondsSketchAnyBondRB[i].isSelected()) continue;
                this.molPanel.setSketchAnyBond(ANYBOND_STYLES[i]);
                break;
            }
            for (i = 0; i < this.bondsViewAnyBondRB.length; ++i) {
                if (!this.bondsViewAnyBondRB[i].isSelected()) continue;
                this.molPanel.setViewAnyBond(ANYBOND_STYLES[i]);
                break;
            }
            this.molPanel.setAnyBond(this.molPanel.getDefaultAnyBond());
            if (this.withAtomTerminalBondDeletionStyleRB.isSelected()) {
                this.molPanel.getUserSettings().setTerminalBondDeletionStyle("withAtom");
            } else {
                this.molPanel.getUserSettings().setTerminalBondDeletionStyle("withoutAtom");
            }
            this.molPanel.setCoordinateBondStyle(this.bondsCoordSolidRB.isSelected() ? "solid" : "arrow");
            this.molPanel.setCoordinateBondStyleAtMulticenter(this.bondsCoordMulticentSolidRB.isSelected() ? "solid" : "hashed");
            this.molPanel.setAtomFont(new Font(this.atomFontPanel.getSelectedFontFamily(), 0, 12));
            this.molPanel.setAtomsize(0.4 * this.atomFontPanel.getSelectedSize() / 12.0);
            String cv = this.carbonAlwaysRB.isSelected() ? "on" : (this.carbonNeverRB.isSelected() ? "off" : "inChain");
            String ligandSettings = "off";
            if (this.ligandOrderAlwaysRB.isSelected()) {
                ligandSettings = "on";
            } else if (this.ligandOrderNeverRB.isSelected()) {
                ligandSettings = "off";
            } else if (this.ligandOrderWithDefinitionRB.isSelected()) {
                ligandSettings = "showOnlyWithDefinition";
            }
            UserSettings settings = this.molPanel.getUserSettings();
            this.molPanel.setLigandOrderVisibility(ligandSettings);
            this.molPanel.setCarbonVisibility(cv);
            this.molPanel.setBondSpacing(this.bondSpacingVal);
            this.molPanel.setWireThickness(this.wireThicknessVal);
            this.molPanel.setStickThickness(this.threedimStickwVal);
            this.molPanel.setBallRadius(this.threedimRadiusVal);
            this.molPanel.setValenceErrorVisible(this.sketchValenceErrCB.isSelected());
            settings.setvalidateSgroupsAtCreation(this.validateSgroupsAtCreationCB.isSelected());
            this.molPanel.setValenceErrorVisibleInView(this.viewValenceErrCB.isSelected());
            this.molPanel.setLonePairsAutoCalc(this.lonePairAutoCalcCB.isSelected());
            this.molPanel.setBondDraggedAlong(this.sketchBondDraggedAlongCB.isSelected());
            this.molPanel.setFogFactor(this.fogSlider.getValue());
            settings.setLoadSaveLocation(this.locationRBGroup.getSelection().getActionCommand());
            if ("saveCustomLocation".equals(this.locationRBGroup.getSelection().getActionCommand())) {
                settings.setLoadWorkingDir(this.locationTextField.getText());
            } else {
                settings.setLoadWorkingDir("");
            }
            if (this.molPanel instanceof ViewPanel) {
                settings.setViewRecentFileListSize(Integer.parseInt(this.recentFileEntriesSpinner.getValue().toString()));
                ((ViewPanel)this.molPanel).updateRecentFileListMenu();
                ((ViewPanel)this.molPanel).getTableSupport().getTableOptions().setViewHandlerType(this.marvinViewLayoutCombo.getSelectedIndex());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((ViewPanel)Preferences.this.molPanel).getTableSupport().enqueueUpdate();
                    }
                });
            } else {
                settings.setSketchRecentFileListSize(Integer.parseInt(this.recentFileEntriesSpinner.getValue().toString()));
            }
            if (!"false".equalsIgnoreCase(this.molPanel.getUserSettings().getProperty("CheckerConfigurationPanelEnabled"))) {
                try {
                    File file = DotfileUtil.getDotFile("/" + this.molPanel.getUserSettings().getCheckerConfigFileName());
                    if (file.getParentFile() != null) {
                        file.getParentFile().mkdirs();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    this.getCheckersPanel().writeCheckers(fileOutputStream);
                    if (this.checkerContainer != null) {
                        this.checkerContainer.updateCheckers();
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            this.getServiceConfigurationPanel().getEditorPanel().putClientProperty("UserSettings", null);
            ServiceDescriptorWriter writer = this.molPanel.getServiceDescriptorWriter();
            if (writer != null) {
                String path = this.molPanel.getUserSettings().getServicesConfigURL();
                File file = null;
                if (path != null && !"".equals(path)) {
                    try {
                        URL url = new URL(path);
                        if (!"".equals(url.getPath())) {
                            file = new File(url.toURI());
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (file == null) {
                    file = DotfileUtil.getDotFile("servicesconfig.xml");
                }
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                try {
                    this.getServiceConfigurationPanel().saveConfiguration(writer, new FileOutputStream(file));
                    if (this.serviceContainer != null) {
                        this.serviceContainer.updateServices();
                    }
                }
                catch (IOException e) {
                    System.err.println("Can not save service configuration: " + e.getMessage());
                }
            }
            if (Environment.MSWINDOWS && Jacob.getInstance().isSupported() && Jacob.getInstance().getOLEDocument().isUsable()) {
                RegistryUtil util = Jacob.getInstance().getRegistryUtil();
                util.open(-2147483647, OLE_SETTINGS_REGKEY, true);
                util.putLongValue(OLE_NEED_CONFIRMATION_REGVALNAME, this.oleEditNeedConfirmation.isSelected() ? 1L : 0L);
                util.close();
                if (util.isHKCRAccessible()) {
                    util.open(-2147483647, OLE_SETTINGS_REGKEY, true);
                    util.putLongValue(OLE_STANDALONE_MODE_REGVALNAME, this.oleStandaloneModeOn.isSelected() ? 1L : 0L);
                    util.close();
                    if (this.oleStandaloneModeOn.isSelected()) {
                        util.open(Integer.MIN_VALUE, OLE_STANDALONE_MODE_ON_KEY, true);
                        util.putStringValue("", OLE_STANDALONE_MODE_VERB_VALUE);
                        util.close();
                        util.deleteKey(Integer.MIN_VALUE, OLE_STANDALONE_MODE_OFF_KEY);
                    } else {
                        util.open(Integer.MIN_VALUE, OLE_STANDALONE_MODE_OFF_KEY, true);
                        util.putStringValue("", OLE_STANDALONE_MODE_VERB_VALUE);
                        util.close();
                        util.deleteKey(Integer.MIN_VALUE, OLE_STANDALONE_MODE_ON_KEY);
                    }
                    util.deleteKey(Integer.MIN_VALUE, OLE_STANDALONE_MODE_DISTURBING_KEY);
                }
            }
        }
    }

    private static void setLookandFeel(String cl) {
        if (cl == null || cl.equals(UIManager.getLookAndFeel().getClass().getName())) {
            return;
        }
        try {
            UIManager.setLookAndFeel(cl);
        }
        catch (ClassNotFoundException e) {
            System.err.println("The LookAndFeel class could not be found: " + cl);
        }
        catch (InstantiationException e) {
            System.err.println("A new instance of the class couldn't be created: " + cl);
        }
        catch (IllegalAccessException e) {
            System.err.println("The class or initializer isn't accessible: " + cl);
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println("The Look & Feel depends on special resources or legal agreements that aren't defined for the current platform: " + cl);
        }
    }

    private void setSketchBondDraggedAlong(boolean v) {
        this.sketchBondDraggedAlongCB.setSelected(v);
    }

    private void setLookAndFeelForDialog() {
        String s = (String)this.appearanceSkinCombo.getSelectedItem();
        if (skinClassNames.get(s) != null) {
            // empty if block
        }
        this.dialog.pack();
    }

    @Override
    public void focusGained(FocusEvent ev) {
    }

    @Override
    public void focusLost(FocusEvent ev) {
        Object src = ev.getSource();
        this.badvalue = false;
        if (src instanceof JTextField) {
            JTextField t = (JTextField)src;
            double x = -1.0;
            try {
                x = Double.valueOf(t.getText());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (t == this.bondSpacingTF || t == this.wireThicknessTF || t == this.threedimStickwTF || t == this.threedimRadiusTF) {
                if (x > 0.0) {
                    if (t == this.bondSpacingTF) {
                        this.bondSpacingVal = x;
                        this.bondSpacingTF.setText(String.valueOf(x));
                    } else if (t == this.wireThicknessTF) {
                        this.wireThicknessVal = x;
                        this.wireThicknessTF.setText(String.valueOf(x));
                    } else if (t == this.threedimStickwTF) {
                        this.threedimStickwVal = x;
                        this.threedimStickwTF.setText(String.valueOf(x));
                    } else if (t == this.threedimRadiusTF) {
                        this.threedimRadiusVal = x;
                        this.threedimRadiusTF.setText(String.valueOf(x));
                    }
                } else {
                    if (t == this.bondSpacingTF) {
                        x = this.bondSpacingVal;
                        this.bondSpacingTF.setText(String.valueOf(x));
                    } else if (t == this.wireThicknessTF) {
                        x = this.wireThicknessVal;
                        this.wireThicknessTF.setText(String.valueOf(x));
                    } else if (t == this.threedimStickwTF) {
                        x = this.threedimStickwVal;
                        this.threedimStickwTF.setText(String.valueOf(x));
                    } else if (t == this.threedimRadiusTF) {
                        x = this.threedimRadiusVal;
                        this.threedimRadiusTF.setText(String.valueOf(x));
                    }
                    this.badvalue = true;
                    JOptionPane.showMessageDialog(this.dialog, "Positive number expected.", "Invalid value", 0);
                }
            }
        }
    }

    static {
        skinIds = null;
        skinClassNames = null;
        DEFAULT_LOOKANDFEEL = UIManager.getLookAndFeel();
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(Preferences.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("Preferences.properties not found");
        }
        RESOURCES = rc;
        if (Environment.isSkinEnabled()) {
            Preferences.initSkins();
        } else {
            skinIds = new String[0];
            skinClassNames = new Hashtable();
        }
    }
}

