/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.common.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RegenBonds
implements CallbackIface,
ActionListener {
    private MolPanel molPanel;
    private int cellIndex;
    private JDialog dialog;
    private boolean canceled;
    private JTextField bondFudgeTextField;
    private double bondFudgeValue;
    private JTextField maxBondsTextField;
    private JCheckBox guessBondsCheckBox;
    private boolean guessBondsValue;
    private int[] maxBonds;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("show")) {
            Object[] args = (Object[])arg;
            this.molPanel = (MolPanel)args[0];
            this.cellIndex = (Integer)args[1];
            this.bondFudgeValue = (Double)args[2];
            this.guessBondsValue = (Boolean)args[3];
            int[] maxb = (int[])args[4];
            this.maxBonds = new int[maxb.length];
            System.arraycopy(maxb, 0, this.maxBonds, 0, this.maxBonds.length);
            Container parent = this.molPanel;
            while (!(parent instanceof Frame)) {
                parent = parent.getParent();
            }
            this.dialog = new JDialog((Frame)parent, "Regenerate Bonds from Atomic Coordinates", true);
            Container contentPane = this.dialog.getContentPane();
            GridBagLayout gbl = new GridBagLayout();
            contentPane.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.insets.left = 10;
            gbc.insets.right = 10;
            gbl.setConstraints(this.addBondFudgePanel(this.dialog), gbc);
            ++gbc.gridy;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbl.setConstraints(this.addMaxConnectionsPanel(this.dialog), gbc);
            ++gbc.gridy;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbl.setConstraints(this.addGuessBondsPanel(this.dialog), gbc);
            gbc.anchor = 10;
            gbc.insets.top = 20;
            ++gbc.gridy;
            gbc.gridwidth = 2;
            gbc.fill = 0;
            gbl.setConstraints(this.addOkCancelPanel(this.dialog), gbc);
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(this.molPanel);
            this.showDialog();
        } else {
            if (method.equals("getBondFudge")) {
                return new Double(this.bondFudgeValue);
            }
            if (method.equals("getGuessBonds")) {
                return new Boolean(this.guessBondsValue);
            }
            if (method.equals("getMaxBonds")) {
                int[] x = new int[this.maxBonds.length];
                System.arraycopy(this.maxBonds, 0, x, 0, x.length);
                return x;
            }
        }
        return null;
    }

    protected JPanel addOkCancelPanel(JDialog dial) {
        JPanel panel = new JPanel();
        dial.getContentPane().add(panel);
        JButton btn = new JButton("OK");
        panel.add(btn);
        btn.setActionCommand("ok");
        btn.setMnemonic('O');
        btn.addActionListener(this);
        btn = new JButton("Cancel");
        panel.add(btn);
        btn.setActionCommand("cancel");
        btn.setMnemonic('C');
        btn.addActionListener(this);
        return panel;
    }

    protected JPanel addBondFudgePanel(JDialog dial) {
        JPanel panel = new JPanel();
        dial.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Bond length cut-off"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        JLabel label = new JLabel("Value:");
        panel.add(label);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.gridwidth = 1;
        gbc1.weightx = 1.0;
        gbc1.anchor = 18;
        gbc1.insets.right = 10;
        gbl1.setConstraints(label, gbc1);
        this.bondFudgeTextField = new JTextField(5);
        panel.add(this.bondFudgeTextField);
        this.bondFudgeTextField.setText(String.valueOf(this.bondFudgeValue));
        ++gbc1.gridx;
        gbl1.setConstraints(this.bondFudgeTextField, gbc1);
        label = new JLabel("Two atoms can be connected if they are closer than the");
        panel.add(label);
        ++gbc1.gridy;
        gbl1.setConstraints(label, gbc1);
        label = new JLabel("sum of their covalent radii times the cut-off value.");
        panel.add(label);
        ++gbc1.gridy;
        gbl1.setConstraints(label, gbc1);
        return panel;
    }

    protected JPanel addMaxConnectionsPanel(JDialog dial) {
        JPanel panel = new JPanel();
        dial.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Maximum Number of Connections"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        JLabel label = new JLabel("Values:");
        panel.add(label);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.gridwidth = 1;
        gbc1.weightx = 1.0;
        gbc1.anchor = 18;
        gbc1.insets.right = 10;
        gbl1.setConstraints(label, gbc1);
        this.maxBondsTextField = new JTextField(20);
        panel.add(this.maxBondsTextField);
        StringBuffer sbuf = new StringBuffer();
        boolean first = true;
        for (int i = 1; i < this.maxBonds.length; ++i) {
            if (this.maxBonds[i] >= Integer.MAX_VALUE) continue;
            if (!first) {
                sbuf.append(", ");
            }
            sbuf.append(MolAtom.symbolOf(i));
            sbuf.append(String.valueOf(this.maxBonds[i]));
            first = false;
        }
        this.maxBondsTextField.setText(sbuf.toString());
        ++gbc1.gridx;
        gbl1.setConstraints(this.maxBondsTextField, gbc1);
        label = new JLabel("Comma-separated list of elements and maximum");
        panel.add(label);
        ++gbc1.gridy;
        gbl1.setConstraints(label, gbc1);
        label = new JLabel("co-ordination numbers. Example: \"H1, C4, Cl1\"");
        panel.add(label);
        ++gbc1.gridy;
        gbl1.setConstraints(label, gbc1);
        return panel;
    }

    protected JPanel addGuessBondsPanel(JDialog dial) {
        JPanel panel = new JPanel();
        dial.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Bond types, atom charges, implicit hydrogens"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        this.guessBondsCheckBox = new JCheckBox("Try to guess");
        panel.add(this.guessBondsCheckBox);
        this.guessBondsCheckBox.setSelected(this.guessBondsValue);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.gridwidth = 1;
        gbc1.weightx = 1.0;
        gbc1.anchor = 18;
        gbc1.insets.right = 10;
        gbl1.setConstraints(this.guessBondsCheckBox, gbc1);
        ++gbc1.gridy;
        JLabel label = new JLabel("Warning! This information cannot be determined from");
        panel.add(label);
        gbl1.setConstraints(label, gbc1);
        ++gbc1.gridy;
        label = new JLabel("atomic coordinates accurately.");
        panel.add(label);
        gbl1.setConstraints(label, gbc1);
        return panel;
    }

    private void showDialog() {
        double prevBondFudge = this.bondFudgeValue;
        this.canceled = true;
        this.dialog.setVisible(true);
        if (this.canceled) {
            this.bondFudgeValue = prevBondFudge;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (cmd.equals("ok")) {
            double bondFudge = this.bondFudgeValue;
            try {
                String s = this.bondFudgeTextField.getText();
                bondFudge = Double.valueOf(s);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.dialog, "Bond cut-off must be a real number", "Invalid value", 0);
                return;
            }
            int[] maxb = new int[this.maxBonds.length];
            try {
                for (int i = 0; i < maxb.length; ++i) {
                    maxb[i] = Integer.MAX_VALUE;
                }
                StringTokenizer st = new StringTokenizer(this.maxBondsTextField.getText(), ",; \t\r\n");
                while (st.hasMoreTokens()) {
                    char c;
                    char c2;
                    int j;
                    String tok = st.nextToken();
                    for (j = 0; j < tok.length() - 1 && ((c2 = tok.charAt(j)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z'); ++j) {
                    }
                    if (j <= 0) continue;
                    String s = tok.substring(0, j);
                    int atno = 0;
                    try {
                        atno = MolAtom.getAtomicNumber(s);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    if (atno <= 0) continue;
                    int i = j;
                    int max = 0;
                    while (j < tok.length() && (c = tok.charAt(j)) >= '0' && c <= '9') {
                        max = 10 * max + (c - 48);
                        ++j;
                    }
                    if (j <= i) continue;
                    maxb[atno] = max;
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.dialog, "Syntax error in definition of the maximum number of connection", "Invalid value", 0);
                return;
            }
            this.bondFudgeValue = bondFudge;
            System.arraycopy(maxb, 0, this.maxBonds, 0, maxb.length);
            this.guessBondsValue = this.guessBondsCheckBox.isSelected();
            this.dialog.setVisible(false);
            this.calc();
            this.canceled = false;
        } else if (cmd.equals("cancel")) {
            this.dialog.setVisible(false);
        }
    }

    private void clearBonds(Molecule[] mols) {
        for (int j = 0; j < mols.length; ++j) {
            mols[j].removeAllBonds();
        }
    }

    private void calc() {
        CallbackIface ci = (CallbackIface)MarvinModule.load("BondsFromCoords", this.molPanel);
        try {
            int icell = this.cellIndex;
            Object[] args = new Object[4];
            args[1] = new Double(this.bondFudgeValue);
            args[2] = new Integer(this.guessBondsValue ? 1 : 0);
            args[3] = this.maxBonds;
            MDocument doc = this.molPanel.getDocument(icell);
            if (doc != null) {
                Molecule[] mols = doc.getAllNonEmptyMolecules();
                this.clearBonds(mols);
                args[0] = mols;
                ci.callback(null, args);
                this.molPanel.repaintMolComponent(icell);
            }
        }
        catch (SecurityException sex) {
            this.molPanel.getErrorDisplay().firewallError(sex, null);
        }
        catch (Throwable ex) {
            this.molPanel.getErrorDisplay().error("Error in module BondsFromCoords", ex);
        }
    }
}

