/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.io.MDocSource;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.util.List;

public class ArrayMDocSource
extends MDocSource {
    private int index;
    private MDocument[] documents;

    public ArrayMDocSource(List<?> list) {
        int n = list.size();
        this.documents = new MDocument[n];
        if (n > 0) {
            Object o = list.get(0);
            if (o instanceof MDocument) {
                for (int i = 0; i < n; ++i) {
                    this.documents[i] = (MDocument)list.get(i);
                }
            } else if (o instanceof Molecule) {
                for (int i = 0; i < n; ++i) {
                    Molecule mol = (Molecule)list.get(i);
                    MDocument doc = mol.getDocument();
                    if (doc == null) {
                        doc = new MDocument(mol);
                    }
                    this.documents[i] = doc;
                }
            }
        }
        this.index = 0;
    }

    public ArrayMDocSource(MDocument[] docs) {
        this.documents = new MDocument[docs.length];
        System.arraycopy(docs, 0, this.documents, 0, docs.length);
        this.index = 0;
    }

    public ArrayMDocSource(Molecule[] mols) {
        this.documents = new MDocument[mols.length];
        for (int i = 0; i < this.documents.length; ++i) {
            MDocument doc = mols[i].getDocument();
            if (doc == null) {
                doc = new MDocument(mols[i]);
            }
            this.documents[i] = doc;
        }
    }

    @Override
    public MDocument nextDoc() {
        return this.index < this.documents.length ? this.documents[this.index++] : null;
    }

    @Override
    public boolean skipRecord() {
        if (this.index < this.documents.length) {
            ++this.index;
        }
        return this.index < this.documents.length;
    }

    @Override
    public boolean isRewindable() {
        return true;
    }

    @Override
    public void seekRecord(int k, MProgressMonitor pmon) {
        this.index = k;
    }

    @Override
    protected void seekVisitedRecord(int k) {
        this.index = k;
    }

    @Override
    public boolean isEndReached() {
        return true;
    }

    @Override
    public int getRecordCount() {
        return this.index;
    }

    @Override
    public int getRecordCountMax() {
        return this.documents.length;
    }

    @Override
    public int estimateNumRecords() {
        return this.documents.length;
    }
}

