/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.io.MDocSource;
import chemaxon.struc.MDocument;
import chemaxon.struc.MoleculeGraph;
import java.io.EOFException;
import java.io.IOException;

public class CleanedMDocSource
extends MDocSource {
    private MDocSource docSource;
    private int cleanDim;
    private String cleanOpts;

    public CleanedMDocSource(MDocSource dp, int dim, String opts) {
        this.docSource = dp;
        this.cleanDim = dim;
        this.cleanOpts = opts;
    }

    @Override
    public MDocument nextDoc() throws IOException {
        MDocument doc = this.docSource.nextDoc();
        if (doc != null) {
            MoleculeGraph mol = doc.getMainMoleculeGraph();
            mol.clean(this.cleanDim, this.cleanOpts);
        }
        return doc;
    }

    @Override
    public void close() throws IOException {
        this.docSource.close();
    }

    @Override
    public String getDocLabel(int k, MDocument doc) {
        return this.docSource.getDocLabel(k, doc);
    }

    @Override
    public boolean skipRecord() throws IOException {
        return this.docSource.skipRecord();
    }

    @Override
    public boolean isRewindable() {
        return this.docSource.isRewindable();
    }

    @Override
    public void seekRecord(int k, MProgressMonitor pmon) throws EOFException, IOException {
        this.docSource.seekRecord(k, pmon);
    }

    @Override
    protected void seekVisitedRecord(int k) throws IOException {
        this.docSource.seekVisitedRecord(k);
    }

    @Override
    public boolean isEndReached() {
        return this.docSource.isEndReached();
    }

    @Override
    public int getRecordCount() {
        return this.docSource.getRecordCount();
    }

    @Override
    public int getRecordCountMax() {
        return this.docSource.getRecordCountMax();
    }

    @Override
    public int estimateNumRecords() {
        return this.docSource.estimateNumRecords();
    }
}

