/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public final class Encoding
implements Externalizable {
    public static final Encoding DEFAULT;
    private static final int T_FAIL = 1;
    private static final int T_NONASCII = 2;
    private static final int T_MULTIBYTE = 4;
    private static final Map NAME_ENCODING_MAP;
    private static final String ASCII = "09 0a 0d 20-7e";
    private static final String UTF16BE_ASCII = "00,09 00,0a 00,0d 00,20-7e";
    private static final String UTF16LE_ASCII = "09,00 0a,00 0d,00 20-7e,00";
    private static final Recognizer ASCII_RECOGNIZER;
    private static final Recognizer UTF16BE_ASCII_RECOGNIZER;
    private static final Recognizer UTF16LE_ASCII_RECOGNIZER;
    private static final Recognizer ISO8859_RECOGNIZER;
    private static final Encoding UTF8;
    private static final Encoding ISO8859_1;
    private static final Encoding ISO8859_2;
    private static final Encoding ISO8859_3;
    private static final Encoding ISO8859_4;
    private static final Encoding ISO8859_5;
    private static final Encoding ISO8859_6;
    private static final Encoding ISO8859_7;
    private static final Encoding ISO8859_8;
    private static final Encoding ISO8859_9;
    private static final Encoding ISO8859_10;
    private static final Encoding ISO8859_11;
    private static final Encoding ISO8859_12;
    private static final Encoding ISO8859_13;
    private static final Encoding ISO8859_14;
    private static final Encoding ISO8859_15;
    private static final Encoding ISO8859_16;
    private static final Encoding WINDOWS1250;
    private static final Encoding WINDOWS1251;
    private static final Encoding WINDOWS1252;
    private static final Encoding WINDOWS1253;
    private static final Encoding WINDOWS1254;
    private static final Encoding WINDOWS1255;
    private static final Encoding WINDOWS1256;
    private static final Encoding WINDOWS1257;
    private static final Encoding WINDOWS1258;
    private static final Encoding EUC_JP;
    private static final Encoding Shift_JIS;
    private static final Encoding UTF16BE;
    private static final Encoding UTF16BE_WITH_BOM;
    private static final Encoding UTF16LE;
    private static final Encoding UTF16LE_WITH_BOM;
    private static final Encoding UTF32BE;
    private static final Encoding UTF32BE_WITH_BOM;
    private static final Encoding UTF32LE;
    private static final Encoding UTF32LE_WITH_BOM;
    private String theName;
    private int theWordLength;
    private ByteOrder theByteOrder;
    private byte[] byteOrderMark;
    private String noBOMencoding;
    private Recognizer recognizer;

    public Encoding(String name, int wordLength, ByteOrder order) {
        this(name, wordLength, order, null, null, null);
    }

    private Encoding(String name, int wordLength, ByteOrder order, byte[] bom, String noBOMenc, Recognizer recog) {
        if (name == null) {
            throw new NullPointerException("null Encoding name specified");
        }
        this.theName = name;
        this.theWordLength = wordLength;
        this.theByteOrder = order;
        if (bom != null) {
            this.byteOrderMark = new byte[bom.length];
            System.arraycopy(bom, 0, this.byteOrderMark, 0, bom.length);
        } else {
            this.byteOrderMark = null;
        }
        this.noBOMencoding = noBOMenc;
        this.recognizer = recog;
    }

    public static Encoding forName(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        Encoding e = (Encoding)NAME_ENCODING_MAP.get(name = Encoding.canonicalName(name));
        if (e != null) {
            return e;
        }
        if (name.equals("UTF-16")) {
            return new Encoding(name, 2, null);
        }
        if (name.equals("UTF-32")) {
            return new Encoding(name, 4, null);
        }
        return new Encoding(name, 1, null);
    }

    public static Encoding recognize(byte[] buf, int off, int len) {
        Encoding encoding = Encoding.recognizeByBOM(buf, off, len);
        if (encoding != null) {
            return encoding;
        }
        if (Encoding.DEFAULT.recognizer == null) {
            return null;
        }
        if ((DEFAULT.test(buf, off, len) & 1) == 0) {
            return null;
        }
        if ((UTF8.test(buf, off, len) & 5) == 4) {
            return UTF8;
        }
        if ((UTF16BE.test16(buf, off, len) & 5) == 4) {
            return UTF16BE;
        }
        if ((UTF16LE.test16(buf, off, len) & 5) == 4) {
            return UTF16LE;
        }
        if ((EUC_JP.test(buf, off, len) & 5) == 4) {
            return EUC_JP;
        }
        if ((Shift_JIS.test(buf, off, len) & 5) == 4) {
            return Shift_JIS;
        }
        if ((ISO8859_1.test(buf, off, len) & 3) == 2) {
            return ISO8859_1;
        }
        if ((WINDOWS1252.test(buf, off, len) & 3) == 2) {
            return WINDOWS1252;
        }
        return null;
    }

    public static Encoding recognizeByBOM(byte[] buf, int off, int len) {
        if (UTF8.bomMatches(buf, off, len)) {
            return UTF8;
        }
        if (UTF16BE_WITH_BOM.bomMatches(buf, off, len)) {
            return UTF16BE_WITH_BOM;
        }
        if (UTF16LE_WITH_BOM.bomMatches(buf, off, len)) {
            return UTF16LE_WITH_BOM;
        }
        if (UTF32BE_WITH_BOM.bomMatches(buf, off, len)) {
            return UTF32BE_WITH_BOM;
        }
        if (UTF32LE_WITH_BOM.bomMatches(buf, off, len)) {
            return UTF32LE_WITH_BOM;
        }
        return null;
    }

    public String name() {
        return this.theName;
    }

    public int wordLength() {
        return this.theWordLength;
    }

    public ByteOrder order() {
        return this.theByteOrder;
    }

    public String convert(byte[] buf, int offset, int numbytes) throws UnsupportedEncodingException {
        String otherenc = this.noBOMencoding;
        if (this.byteOrderMark != null && offset == 0 && this.bomMatches(buf, offset, numbytes)) {
            for (int i = 0; i < this.byteOrderMark.length && i < buf.length; ++i) {
                ++offset;
                --numbytes;
            }
        }
        if (otherenc != null && !this.bomMatches(buf, offset, numbytes)) {
            return new String(buf, offset, numbytes, otherenc);
        }
        return new String(buf, offset, numbytes, this.theName);
    }

    private boolean bomMatches(byte[] buf, int offset, int len) {
        byte[] bom = this.byteOrderMark;
        if (bom.length <= len) {
            for (int i = 0; i < bom.length; ++i) {
                if (buf[offset + i] == bom[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.theName;
    }

    public boolean equals(Encoding o) {
        return this.theName.equals(o.theName) && this.theWordLength == o.theWordLength && this.theByteOrder == o.theByteOrder;
    }

    public boolean equals(Object o) {
        return o instanceof Encoding && this.equals((Encoding)o);
    }

    public static String canonicalName(String enc) {
        if (enc == null || enc.length() == 0) {
            return null;
        }
        Charset cs = Charset.forName(enc);
        return cs.name();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.theName);
        int f = this.wordLength() & 0x1F | 0x20;
        if (this.theByteOrder == ByteOrder.LITTLE_ENDIAN) {
            f |= 0x40;
        } else if (this.theByteOrder == ByteOrder.BIG_ENDIAN) {
            f |= 0x80;
        }
        out.writeByte((byte)f);
        if (this.byteOrderMark == null) {
            out.writeByte(0);
        } else {
            out.writeByte(this.byteOrderMark.length);
            for (int i = 0; i < this.byteOrderMark.length; ++i) {
                out.writeByte(this.byteOrderMark[i]);
            }
        }
        f = 0;
        if (this.noBOMencoding != null) {
            f |= 1;
        }
        out.writeByte((byte)f);
        if ((f & 1) != 0) {
            out.writeUTF(this.noBOMencoding);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.theName = in.readUTF();
        byte f = in.readByte();
        int ord = f & 0xC0;
        this.theByteOrder = ord == 64 ? ByteOrder.LITTLE_ENDIAN : (ord == 128 ? ByteOrder.BIG_ENDIAN : null);
        this.theWordLength = f & 0x1F;
        if ((f & 0x20) == 0) {
            return;
        }
        int n = in.readByte() & 0xFF;
        if (n == 0) {
            this.byteOrderMark = null;
        } else {
            this.byteOrderMark = new byte[n];
            for (int i = 0; i < n; ++i) {
                this.byteOrderMark[i] = in.readByte();
            }
        }
        f = in.readByte();
        this.noBOMencoding = (f & 1) != 0 ? in.readUTF() : null;
    }

    public static Encoding read(ObjectInput in) throws IOException {
        Encoding e = new Encoding("", 0, null);
        e.readExternal(in);
        return e;
    }

    private static void registerEncoding(Encoding e) {
        NAME_ENCODING_MAP.put(e.name(), e);
    }

    private int test(byte[] buf, int off, int len) {
        int k;
        int ret = 0;
        for (int i = off; i < off + len; i += k) {
            k = this.recognizer.next(buf, i);
            if (k == 0) {
                if (i >= off + len - this.theWordLength) break;
                return ret |= 1;
            }
            if (k == 1) {
                if (ASCII_RECOGNIZER.isAllowedByte(buf[i] & 0xFF)) continue;
                ret |= 2;
                continue;
            }
            if (k <= 1) continue;
            ret |= 6;
        }
        return ret;
    }

    private int test16(byte[] buf, int off, int len) {
        int ret = 0;
        int i = off;
        int numAsciiLE = 0;
        int numAsciiBE = 0;
        int nchars = 0;
        while (i < off + len) {
            int k = this.recognizer.next(buf, i);
            if (k == 0) {
                if (i >= off + len - this.theWordLength) break;
                return ret |= 1;
            }
            if (k == 1) {
                ret |= 1;
            } else if (k > 1) {
                if (UTF16LE_ASCII_RECOGNIZER.next(buf, i) == k) {
                    ++numAsciiLE;
                } else if (UTF16BE_ASCII_RECOGNIZER.next(buf, i) == k) {
                    ++numAsciiBE;
                } else {
                    ret |= 2;
                }
            }
            i += k;
            ++nchars;
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            if (numAsciiBE > 2 * numAsciiLE && numAsciiBE > nchars / 32) {
                ret |= 4;
                if (numAsciiBE < nchars) {
                    ret |= 2;
                }
            } else {
                ret |= 1;
            }
        } else if (this.order() == ByteOrder.LITTLE_ENDIAN) {
            if (numAsciiLE > 2 * numAsciiBE && numAsciiLE > nchars / 32) {
                ret |= 4;
                if (numAsciiLE < nchars) {
                    ret |= 2;
                }
            } else {
                ret |= 1;
            }
        } else {
            ret |= 1;
        }
        return ret;
    }

    static {
        ASCII_RECOGNIZER = new Recognizer(ASCII);
        UTF16BE_ASCII_RECOGNIZER = new Recognizer("", UTF16BE_ASCII);
        UTF16LE_ASCII_RECOGNIZER = new Recognizer("", UTF16LE_ASCII);
        ISO8859_RECOGNIZER = new Recognizer("09 0a 0d 20-7e a0-ff");
        UTF8 = new Encoding("UTF-8", 1, null, new byte[]{-17, -69, -65}, null, new Recognizer(ASCII, "c2-df,80-bf e0-ef,80-bf,80-bf f0-f7,80-bf,80-bf,80-bf f8-fb,80-bf,80-bf,80-bf,80-bf fc-fd,80-bf,80-bf,80-bf,80-bf,80-bf"));
        ISO8859_1 = new Encoding("ISO-8859-1", 1, null, null, null, ISO8859_RECOGNIZER);
        ISO8859_2 = new Encoding("ISO-8859-2", 1, null, null, null, ISO8859_RECOGNIZER);
        ISO8859_3 = new Encoding("ISO-8859-3", 1, null, null, null, new Recognizer("01-7f a0-a4 a6-ad af-bd bf-c2 c4-cf d1-e2 e4-ef f1-ff"));
        ISO8859_4 = new Encoding("ISO-8859-4", 1, null, null, null, ISO8859_RECOGNIZER);
        ISO8859_5 = new Encoding("ISO-8859-5", 1, null, null, null, ISO8859_RECOGNIZER);
        ISO8859_6 = new Encoding("ISO-8859-6", 1, null, null, null, new Recognizer("01-7f a0 a4 ac ad bb bf c1-da e0-f2"));
        ISO8859_7 = new Encoding("ISO-8859-7", 1, null, null, null, new Recognizer("01-7f a0-ad af-d1 d3-f2"));
        ISO8859_8 = new Encoding("ISO-8859-8", 1, null, null, null, new Recognizer("01-7f a0 a2-be df-fa fd fe"));
        ISO8859_9 = new Encoding("ISO-8859-9", 1, null, null, null, ISO8859_RECOGNIZER);
        ISO8859_10 = new Encoding("ISO-8859-10", 1, null, null, null, ISO8859_RECOGNIZER);
        ISO8859_11 = new Encoding("ISO-8859-11", 1, null, null, null, new Recognizer("01-7f a0-da df-fb"));
        ISO8859_12 = new Encoding("ISO-8859-12", 1, null, null, null, ISO8859_RECOGNIZER);
        ISO8859_13 = new Encoding("ISO-8859-13", 1, null, null, null, ISO8859_RECOGNIZER);
        ISO8859_14 = new Encoding("ISO-8859-14", 1, null, null, null, ISO8859_RECOGNIZER);
        ISO8859_15 = new Encoding("ISO-8859-15", 1, null, null, null, ISO8859_RECOGNIZER);
        ISO8859_16 = new Encoding("ISO-8859-16", 1, null, null, null, ISO8859_RECOGNIZER);
        WINDOWS1250 = new Encoding("windows-1250", 1, null, null, null, new Recognizer("09 0a 0d 20-7e 80 82 84-87 89-8f 91-97 99-ff"));
        WINDOWS1251 = new Encoding("windows-1251", 1, null, null, null, new Recognizer("09 0a 0d 20-7e 80-97 99-ff"));
        WINDOWS1252 = new Encoding("windows-1252", 1, null, null, null, new Recognizer("09 0a 0d 20-7e 80 82-8c 8e 91-9c 9e-ff"));
        WINDOWS1253 = new Encoding("windows-1253", 1, null, null, null, new Recognizer("09 0a 0d 20-7e 80 82-87 89 8b 91-97 99 9b a0-a9 ab-d1 d3-fe"));
        WINDOWS1254 = new Encoding("windows-1254", 1, null, null, null, new Recognizer("09 0a 0d 20-7e 80 82-8c 91-9c 9f-ff"));
        WINDOWS1255 = new Encoding("windows-1255", 1, null, null, null, new Recognizer("09 0a 0d 20-7e 80 82-89 8b 91-99 9b a0-c9 cb-d8 e0-fa fd fe"));
        WINDOWS1256 = new Encoding("windows-1256", 1, null, null, null, new Recognizer("09 0a 0d 20-7e 80-ff"));
        WINDOWS1257 = new Encoding("windows-1257", 1, null, null, null, new Recognizer("09 0a 0d 20-7e 80 82 84-87 89 8b 8d-8f 91-97 99 9b 9d 9e a0 a2-a4 a6-ff"));
        WINDOWS1258 = new Encoding("windows-1258", 1, null, null, null, new Recognizer("09 0a 0d 20-7e 80 82-89 8b 8c 91-99 9b 9c 9f-ff"));
        EUC_JP = new Encoding("EUC-JP", 1, null, null, null, new Recognizer(ASCII, "a1-fe,a1-fe 8e,a1-df 8f,a1-fe,a1-fe"));
        Shift_JIS = new Encoding("Shift_JIS", 1, null, null, null, new Recognizer(ASCII, "81-9f,40-7e 81-9f,80-fc e0-ef,40-7e e0-ef,80-fc"));
        UTF16BE = new Encoding("UTF-16BE", 2, ByteOrder.BIG_ENDIAN, null, null, new Recognizer("", "00,09 00,0a 00,0d 00,20-7e 01-d7,00-ff dc-fd,00-ff fe,00-fe d8-db,00-ff,dc-df,00-ff"));
        UTF16BE_WITH_BOM = new Encoding("UTF-16", 2, ByteOrder.BIG_ENDIAN, new byte[]{-2, -1}, "UTF-16BE", null);
        UTF16LE = new Encoding("UTF-16LE", 2, ByteOrder.LITTLE_ENDIAN, null, null, new Recognizer("", "09,00 0a,00 0d,00 20-7e,00 00-ff,01-d7 00-ff,dc-fd 00-fe,fe 00-ff,d8-db,00-ff,dc-df"));
        UTF16LE_WITH_BOM = new Encoding("UTF-16", 2, ByteOrder.LITTLE_ENDIAN, new byte[]{-1, -2}, "UTF-16LE", null);
        UTF32BE = new Encoding("UTF-32BE", 4, ByteOrder.BIG_ENDIAN);
        UTF32BE_WITH_BOM = new Encoding("UTF-32", 4, ByteOrder.BIG_ENDIAN, new byte[]{0, 0, -2, -1}, "UTF-32BE", null);
        UTF32LE = new Encoding("UTF-32LE", 4, ByteOrder.LITTLE_ENDIAN);
        UTF32LE_WITH_BOM = new Encoding("UTF-32", 4, ByteOrder.LITTLE_ENDIAN, new byte[]{-1, -2, 0, 0}, "UTF-32LE", null);
        NAME_ENCODING_MAP = new TreeMap();
        Encoding.registerEncoding(UTF8);
        Encoding.registerEncoding(ISO8859_1);
        Encoding.registerEncoding(ISO8859_2);
        Encoding.registerEncoding(ISO8859_3);
        Encoding.registerEncoding(ISO8859_4);
        Encoding.registerEncoding(ISO8859_5);
        Encoding.registerEncoding(ISO8859_6);
        Encoding.registerEncoding(ISO8859_7);
        Encoding.registerEncoding(ISO8859_8);
        Encoding.registerEncoding(ISO8859_9);
        Encoding.registerEncoding(ISO8859_10);
        Encoding.registerEncoding(ISO8859_11);
        Encoding.registerEncoding(ISO8859_12);
        Encoding.registerEncoding(ISO8859_13);
        Encoding.registerEncoding(ISO8859_14);
        Encoding.registerEncoding(ISO8859_15);
        Encoding.registerEncoding(ISO8859_16);
        Encoding.registerEncoding(WINDOWS1250);
        Encoding.registerEncoding(WINDOWS1251);
        Encoding.registerEncoding(WINDOWS1252);
        Encoding.registerEncoding(WINDOWS1253);
        Encoding.registerEncoding(WINDOWS1254);
        Encoding.registerEncoding(WINDOWS1255);
        Encoding.registerEncoding(WINDOWS1256);
        Encoding.registerEncoding(WINDOWS1257);
        Encoding.registerEncoding(WINDOWS1258);
        Encoding.registerEncoding(UTF16BE);
        Encoding.registerEncoding(UTF16LE);
        Encoding.registerEncoding(UTF32BE);
        Encoding.registerEncoding(UTF32LE);
        String enc = null;
        try {
            Method defaultCharset = Charset.class.getMethod("defaultCharset", null);
            Charset cs = (Charset)defaultCharset.invoke(null, (Object[])null);
            enc = cs.name();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (enc == null) {
            try {
                enc = System.getProperty("file.encoding");
            }
            catch (SecurityException ex) {
                enc = "UTF-8";
            }
        }
        try {
            DEFAULT = Encoding.forName(enc);
        }
        catch (UnsupportedCharsetException ex) {
            throw new RuntimeException("The default system encoding \"" + enc + "\" is unsupported");
        }
        catch (IllegalCharsetNameException ex) {
            throw new RuntimeException("The default system encoding name \"" + enc + "\" is illegal");
        }
    }

    private static class Recognizer {
        boolean[] allowed1 = new boolean[256];
        boolean[][][] allowed = null;

        Recognizer(String singleBytes) {
            this(singleBytes, "");
        }

        Recognizer(String singleBytes, String multiBytes) {
            StringTokenizer st0 = new StringTokenizer(singleBytes, " ");
            while (st0.hasMoreTokens()) {
                Recognizer.parseRange(st0.nextToken(), this.allowed1);
            }
            st0 = new StringTokenizer(multiBytes, " ");
            int numRules = st0.countTokens();
            this.allowed = new boolean[numRules][][];
            for (int i = 0; i < numRules; ++i) {
                StringTokenizer st = new StringTokenizer(st0.nextToken(), ",");
                int nbytes = st.countTokens();
                this.allowed[i] = new boolean[nbytes][256];
                for (int j = 0; j < nbytes; ++j) {
                    Recognizer.parseRange(st.nextToken(), this.allowed[i][j]);
                }
            }
        }

        private static void parseRange(String range, boolean[] allowed) {
            int eq = range.indexOf(45);
            if (eq >= 0) {
                int low = Integer.parseInt(range.substring(0, eq), 16);
                int high = Integer.parseInt(range.substring(eq + 1), 16);
                for (int i = low; i <= high; ++i) {
                    allowed[i] = true;
                }
            } else {
                int b = Integer.parseInt(range, 16);
                allowed[b] = true;
            }
        }

        public boolean isAllowedByte(int b) {
            return this.allowed1[b];
        }

        public int next(byte[] buf, int i) {
            int b;
            if (this.allowed != null) {
                for (int j = 0; j < this.allowed.length; ++j) {
                    boolean matches = true;
                    for (int k = 0; k < this.allowed[j].length && matches && i + k < buf.length; ++k) {
                        int b2 = buf[i + k] & 0xFF;
                        if (this.allowed[j][k][b2]) continue;
                        matches = false;
                    }
                    if (!matches) continue;
                    return this.allowed[j].length;
                }
            }
            return this.allowed1[b = buf[i] & 0xFF] ? 1 : 0;
        }
    }
}

