/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.cml.MrvImport;
import chemaxon.struc.MDocument;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.prop.MBooleanProp;
import chemaxon.struc.prop.MByteArrayProp;
import chemaxon.struc.prop.MDoubleArrayProp;
import chemaxon.struc.prop.MDoubleProp;
import chemaxon.struc.prop.MFontProp;
import chemaxon.struc.prop.MHCoords3DProp;
import chemaxon.struc.prop.MHashProp;
import chemaxon.struc.prop.MIntegerArrayProp;
import chemaxon.struc.prop.MIntegerProp;
import chemaxon.struc.prop.MListProp;
import chemaxon.struc.prop.MMoleculeProp;
import chemaxon.struc.prop.MObjectProp;
import chemaxon.struc.prop.MStringProp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public final class MPropHandler {
    private static final Properties XSD_TYPE_MAP;

    public static MProp createScalar(String type, String sval) throws MolFormatException {
        return MPropHandler.createScalar(type, sval, null);
    }

    public static MProp createScalar(String type, String sval, MProgressMonitor pmon) throws MolFormatException {
        try {
            if (type.equals("string")) {
                return new MStringProp(sval);
            }
            if (type.equals("boolean")) {
                return new MBooleanProp(sval);
            }
            if (type.equals("integer")) {
                return new MIntegerProp(sval);
            }
            if (type.equals("double")) {
                return new MDoubleProp(sval);
            }
            if (type.equals("mfont")) {
                return new MFontProp(sval);
            }
            if (type.equals("Molecule")) {
                try {
                    return MPropHandler.createMMoleculeProp(sval);
                }
                catch (IOException e) {
                    throw new MolFormatException(e);
                }
            }
            if (type.equals("MDocument")) {
                return MDocument.parseMRV(sval).getMProp();
            }
            if (type.equals("MHCoords3D")) {
                return new MHCoords3DProp(sval);
            }
            if (type.equals("object")) {
                try {
                    return new MObjectProp(sval);
                }
                catch (IOException e) {
                    throw new MolFormatException(e);
                }
            }
            int dot = type.indexOf(46);
            String clname = dot < 0 ? "chemaxon.marvin.modules.mprop." + type : type;
            Constructor<?> c = null;
            Class<?> cl = null;
            try {
                cl = Class.forName(clname);
            }
            catch (Exception ex) {
                throw new MolFormatException("Invalid property class " + clname, ex);
            }
            int n = 2;
            try {
                c = cl.getConstructor(String.class, MProgressMonitor.class);
            }
            catch (NoSuchMethodException e) {
                try {
                    c = cl.getConstructor(String.class);
                    n = 1;
                }
                catch (Exception ex) {
                    throw new MolFormatException("Invalid property class " + clname, ex);
                }
            }
            catch (Exception ex) {
                throw new MolFormatException("Invalid property class " + clname, ex);
            }
            try {
                return n == 2 ? (MProp)c.newInstance(sval, pmon) : (MProp)c.newInstance(sval);
            }
            catch (InstantiationException ex) {
                throw new MolFormatException("Cannot create " + clname + ": " + ex.getMessage(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new MolFormatException("Cannot create " + clname + ": " + ex.getMessage(), ex);
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getTargetException();
                if (t instanceof MolFormatException) {
                    throw (MolFormatException)t;
                }
                throw new MolFormatException(t);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MolFormatException(ex);
        }
    }

    public static MProp createArray(String type, String sval, int arrsize, int delim) throws MolFormatException, IllegalArgumentException {
        if (type.equals("integer")) {
            return new MIntegerArrayProp(sval, arrsize, delim);
        }
        if (type.equals("double")) {
            return new MDoubleArrayProp(sval, arrsize, delim);
        }
        if (type.equals("byte")) {
            return new MByteArrayProp(sval, arrsize, delim);
        }
        int dot = type.indexOf(46);
        String clname = dot < 0 ? "chemaxon.marvin.modules.mprop." + type : type;
        Constructor<?> c = null;
        try {
            Class<?> cl = Class.forName(clname);
            c = cl.getConstructor(String.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception ex) {
            throw new MolFormatException("Invalid property class " + clname, ex);
        }
        try {
            return (MProp)c.newInstance(sval, new Integer(arrsize), new Integer(delim));
        }
        catch (InstantiationException ex) {
            throw new MolFormatException("Cannot create " + clname + ": " + ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new MolFormatException("Cannot create " + clname + ": " + ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof MolFormatException) {
                throw (MolFormatException)t;
            }
            throw new MolFormatException(t);
        }
    }

    public static MProp createScalarXSD(String xsdtype, String sval) throws MolFormatException {
        String type = XSD_TYPE_MAP.getProperty(xsdtype);
        return type != null ? MPropHandler.createScalar(type, sval) : new MStringProp(sval);
    }

    public static MProp createArrayXSD(String xsdtype, String sval, int size, int delim) throws MolFormatException {
        String type = XSD_TYPE_MAP.getProperty(xsdtype);
        return MPropHandler.createArray(type, sval, size, delim);
    }

    public static String convertToString(MProp p, String fmt) throws IllegalArgumentException {
        if (p instanceof MStringProp) {
            return ((MStringProp)p).stringValue();
        }
        if (p instanceof MHashProp) {
            return MPropHandler.convertToString((MHashProp)p, fmt);
        }
        if (p instanceof MListProp) {
            return MPropHandler.convertToString((MListProp)p, fmt);
        }
        if (p instanceof MMoleculeProp) {
            return MPropHandler.convertToString((MMoleculeProp)p, fmt);
        }
        return p == null ? null : p.toString();
    }

    private static String convertToString(MHashProp p, String fmt) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < p.size(); ++i) {
            String key = p.getKey(i);
            MProp prop = p.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("[");
            sb.append(key);
            sb.append("=");
            sb.append(MPropHandler.convertToString(prop, fmt));
            sb.append("]");
        }
        return sb.toString();
    }

    private static String convertToString(MListProp p, String fmt) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < p.size(); ++i) {
            MProp prop = p.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("[");
            if (p != null) {
                sb.append(MPropHandler.convertToString(prop, fmt));
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private static String convertToString(MMoleculeProp p, String fmt) {
        Molecule molecule = p.getMolecule();
        if (fmt == null) {
            fmt = molecule.getInputFormat();
        }
        if (fmt == null) {
            fmt = "mrv";
        } else if (fmt.equals("rdf")) {
            fmt = molecule.isReaction() ? "rxn" : "mol";
        }
        String s = null;
        try {
            s = MolExporter.exportToFormat(molecule, fmt);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        if (s.startsWith("<?xml") || s.startsWith("<?XML")) {
            int i = s.indexOf("?>");
            return s.substring(i + 2).trim();
        }
        return s;
    }

    public static String convertToString(MPropertyContainer p, String key) {
        MProp o = p.get(key);
        if (o != null) {
            try {
                return MPropHandler.convertToString(o, null);
            }
            catch (IllegalArgumentException ex) {
                return "";
            }
        }
        return null;
    }

    public static MProp stringToScalar(String xsdtype, String sval) throws IOException {
        if (xsdtype == null) {
            return new MStringProp(sval);
        }
        if (xsdtype.startsWith("xsd:")) {
            xsdtype = xsdtype.substring(4);
        }
        if (xsdtype.equals("ENTITY")) {
            if (sval.startsWith("MProp:")) {
                int k = sval.indexOf(58, 6);
                if (k >= 0) {
                    return MPropHandler.createScalar(sval.substring(6, k), sval.substring(k + 1));
                }
                throw new MolFormatException("Cannot read ENTITY type property, \"MProp:\" is not followed by type name");
            }
            throw new MolFormatException("Cannot read ENTITY type property, value does not start with \"MProp:\"");
        }
        return MPropHandler.createScalarXSD(xsdtype, sval);
    }

    public static MProp stringToArray(String xsdtype, String sval, int size, int delim) throws IOException {
        if (xsdtype == null) {
            return new MByteArrayProp(sval, size, delim);
        }
        if (xsdtype.startsWith("xsd:")) {
            xsdtype = xsdtype.substring(4);
        }
        return MPropHandler.createArrayXSD(xsdtype, sval, size, delim);
    }

    public static Molecule parseMolecule(String sval) throws IOException {
        Molecule result = null;
        byte[] data = sval.getBytes();
        MolInputStream mis = new MolInputStream(new ByteArrayInputStream(data));
        String format2 = mis.getFormat();
        if (format2 != null && format2.equals("mrv")) {
            MrvImport mi = new MrvImport();
            ((MolImportModule)mi).initMolImport(mis);
            MDocument d = ((MolImportModule)mi).readDocument(new MDocument(new Molecule()));
            result = d.getPrimaryMolecule();
        } else {
            throw new IOException("argument is not in MRV format");
        }
        return result;
    }

    public static MMoleculeProp createMMoleculeProp(String sval) throws IOException {
        MMoleculeProp prop = new MMoleculeProp(MPropHandler.parseMolecule(sval));
        return prop;
    }

    static {
        Properties p = new Properties();
        p.put("string", "string");
        p.put("boolean", "boolean");
        p.put("int", "integer");
        p.put("integer", "integer");
        p.put("double", "double");
        p.put("decimal", "double");
        p.put("byte", "byte");
        p.put("mfont", "mfont");
        XSD_TYPE_MAP = p;
    }
}

