/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.license.LicenseException;
import chemaxon.marvin.io.Encoding;
import chemaxon.marvin.io.MHeaderReader;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MRecordReader;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.struc.MDocument;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.prop.MMoleculeProp;
import chemaxon.struc.prop.MMoleculeStringProp;
import chemaxon.util.concurrent.ConcurrentProcessor;
import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.processors.ConcurrentProcessors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;

public class MRecordImporter {
    private static final int RETURN_ANY = 0;
    private static final int RETURN_MDOCUMENT = 1;
    private static final int RETURN_MOLECULE = 2;
    private MolInputStream molInputStream;
    private MRecordReader recordReader;
    private int recordNumber;
    private MRecord lastRecord;
    private String importModuleOptions;
    private MolImportModule molImportModule;
    private String lastMoleculeString;
    private boolean queryMode;
    private int threadCount = 1;
    private int returnType = 0;
    private ConcurrentProcessor concurrentProcessor = null;
    private boolean isSeekableCalled = false;

    public MRecordImporter(MolInputStream in, String opts) throws MolFormatException, IOException {
        this.molInputStream = in;
        this.recordReader = MFileFormatUtil.createRecordReader(in, opts);
        if (this.recordReader == null) {
            String fmt = in.getFormat();
            if (fmt != null && fmt.length() != 0) {
                throw new MolFormatException("Cannot create record reader for the \"" + fmt + "\" format");
            }
            throw new MolFormatException("File format not recognized");
        }
        MolInputStream mis2 = this.recordReader.getMolInputStream();
        this.molImportModule = MRecordImporter.createImportMod(mis2);
        this.molImportModule.setOptions(this.recordReader.getOptions());
        this.molImportModule.initMolImport(mis2);
        this.lastMoleculeString = null;
        this.queryMode = false;
    }

    public void setThreadCount(int threadCount) throws IllegalStateException {
        if (this.isSeekableCalled) {
            throw new IllegalStateException("setThreadCount() should be called before isSeekable().");
        }
        if (this.concurrentProcessor != null) {
            throw new IllegalStateException("setThreadCount() should be called before readMol() / readDoc().");
        }
        this.threadCount = threadCount;
    }

    private void startConcurrentProcessor(int type) throws ExecutionException {
        int processorType = 1;
        MInputProducer inputProducer = new MInputProducer();
        String format2 = this.recordReader.getMolInputStream().getFormat();
        String options = this.recordReader.getOptions();
        MWorkUnitFactory workUnitFactory = type == 1 ? new MDocWorkUnitFactory(format2, options, this.molInputStream.getPath()) : new MolWorkUnitFactory(format2, options, this.molInputStream.getPath());
        try {
            this.concurrentProcessor = ConcurrentProcessors.create(processorType, inputProducer, workUnitFactory);
            if (this.threadCount > 0) {
                this.concurrentProcessor.setWorkerThreadCount(this.threadCount);
            }
            this.concurrentProcessor.start();
        }
        catch (ExecutionException e) {
            if (this.concurrentProcessor != null) {
                try {
                    this.concurrentProcessor.cleanup();
                }
                catch (Exception f) {
                    // empty catch block
                }
            }
            this.concurrentProcessor = null;
            throw e;
        }
    }

    public void setProgressMonitor(MProgressMonitor pmon) {
        this.recordReader.setProgressMonitor(pmon);
    }

    public static MolImportModule createImportMod(MolInputStream mis) throws IOException, MolFormatException {
        return MRecordImporter.createImportMod(mis.getFormat());
    }

    public static MolImportModule createImportMod(String fmt) throws IOException, MolFormatException {
        MFileFormat[] formats = MFileFormatUtil.findFormats(fmt, 0L, 0L);
        MolImportModule mod = null;
        for (int i = 0; i < formats.length && mod == null; ++i) {
            mod = formats[i].createImportModule();
        }
        return mod;
    }

    public String getOptions() {
        return this.importModuleOptions;
    }

    public void setOptions(String opts) {
        if (this.concurrentProcessor != null) {
            throw new IllegalStateException("setOptions() should be called before readMol() / readDoc().");
        }
        this.importModuleOptions = opts;
        this.molImportModule.setOptions(opts);
    }

    public MDocument readDoc() throws MRecordParseException, MolFormatException, IOException {
        if (this.concurrentProcessor == null && this.threadCount != 1) {
            try {
                this.startConcurrentProcessor(1);
                this.returnType = 1;
            }
            catch (ExecutionException e) {
                System.err.println("MRecordImporter could not start concurrent processor: " + e);
            }
        }
        return this.concurrentProcessor != null ? this.readDocConcurrent() : this.readDoc0();
    }

    private MDocument readDocConcurrent() throws MRecordParseException, MolFormatException, IOException {
        if (this.returnType != 1) {
            throw new IOException("This importer returns Molecule objects instead of MDocument objects.");
        }
        Object o = null;
        this.lastRecord = null;
        this.lastMoleculeString = null;
        try {
            o = this.concurrentProcessor.hasNext() ? this.concurrentProcessor.getNext() : null;
        }
        catch (Exception e) {
            this.close();
            throw new MolFormatException(e);
        }
        if (o instanceof Exception) {
            MRecordImporter.handleException(o);
        }
        if (o == null) {
            return null;
        }
        MDocResult result = o;
        this.lastRecord = result.record;
        this.lastMoleculeString = this.lastRecord.getMolString();
        ++this.recordNumber;
        return result.doc;
    }

    private MDocument readDoc0() throws MRecordParseException, MolFormatException, IOException {
        this.lastRecord = this.readRecord();
        if (this.lastRecord == null) {
            this.lastMoleculeString = null;
            return null;
        }
        this.lastMoleculeString = this.lastRecord.getMolString();
        ++this.recordNumber;
        return this.readDoc(this.lastRecord);
    }

    public Molecule readMol(Molecule mol) throws MRecordParseException, MolFormatException, IOException {
        if (mol == null && this.concurrentProcessor == null && this.threadCount != 1) {
            try {
                this.startConcurrentProcessor(2);
                this.returnType = 2;
            }
            catch (ExecutionException e) {
                System.err.println("MRecordImporter could not start concurrent processor: " + e);
            }
        }
        return this.concurrentProcessor != null ? this.readMolConcurrent(mol) : this.readMol0(mol);
    }

    private Molecule readMolConcurrent(Molecule mol) throws MRecordParseException, MolFormatException, IOException {
        if (this.returnType != 2) {
            throw new IOException("This importer returns MDocument objects instead of Molecule objects.");
        }
        Object o = null;
        this.lastRecord = null;
        this.lastMoleculeString = null;
        try {
            o = this.concurrentProcessor.hasNext() ? this.concurrentProcessor.getNext() : null;
        }
        catch (Exception e) {
            this.close();
            throw new MolFormatException(e);
        }
        if (o instanceof Exception) {
            MRecordImporter.handleException(o);
        }
        if (o == null) {
            return null;
        }
        MolResult result = o;
        this.lastRecord = result.record;
        this.lastMoleculeString = this.lastRecord.getMolString();
        ++this.recordNumber;
        Molecule m = result.mol;
        if (mol == null) {
            mol = m;
        } else if (m != null) {
            if (m.getClass().equals(mol.getClass())) {
                m.clonecopy(mol);
            } else {
                String fmt;
                String clfmt = fmt = m.getInputFormat();
                if (fmt.endsWith("smarts")) {
                    clfmt = "smarts";
                } else if (fmt.endsWith("smiles")) {
                    clfmt = "smiles";
                }
                mol.clearForImport(clfmt);
                mol.setInputFormat(fmt);
                mol.fuse(m);
            }
        } else {
            mol = null;
        }
        return mol;
    }

    private Molecule readMol0(Molecule mol) throws MRecordParseException, MolFormatException, IOException {
        this.lastRecord = this.readRecord();
        if (this.lastRecord == null) {
            this.lastMoleculeString = null;
            return null;
        }
        this.lastMoleculeString = this.lastRecord.getMolString();
        ++this.recordNumber;
        return this.readMol(this.lastRecord, mol);
    }

    public Molecule readMultiSet(Molecule m) throws MRecordParseException, MolFormatException, IOException {
        Molecule tmp = (Molecule)m.newInstance();
        if ((m = this.readMol(m)) == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(this.lastMoleculeString);
        int setSeq = 1;
        while ((tmp = this.readMol(tmp)) != null) {
            if (!this.lastMoleculeString.endsWith("\n")) {
                sb.append('\n');
            }
            sb.append(this.lastMoleculeString);
            tmp.setAtomSetSeqs(setSeq++);
            m.fuse(tmp);
            m.setEndPosition(tmp.getEndPosition());
            tmp = (Molecule)m.newInstance();
        }
        this.lastMoleculeString = sb.toString();
        return m;
    }

    public MDocument readMolMovie(MDocument doc) throws MolFormatException, IOException {
        ArrayList<Molecule> v = new ArrayList<Molecule>();
        if (doc == null) {
            doc = new MDocument(new Molecule());
        }
        Molecule m = (Molecule)doc.getMainMoleculeGraph();
        try {
            while (this.readMol(m) != null) {
                v.add(m);
                m = this.createMol();
            }
        }
        catch (MRecordParseException ex) {
            throw new MolFormatException(ex);
        }
        int n = v.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return doc;
        }
        Molecule[] mols = new Molecule[v.size()];
        v.toArray(mols);
        return new MDocument(mols);
    }

    private MRecord readRecord() throws MRecordParseException, MolFormatException, IOException {
        MRecord rec = this.startReadingNext();
        if (rec == null) {
            return null;
        }
        if (this.recordReader.isPropertyRecord()) {
            rec = this.startReadingNext();
        }
        return rec;
    }

    private Molecule readMol(MRecord rec, Molecule mol) throws MolFormatException, IOException {
        return MRecordImporter.readMol(rec, this.molImportModule, mol, this.molInputStream.getPath());
    }

    private static Molecule readMol(MRecord rec, MolImportModule importMod, Molecule mol, String path) throws MolFormatException, IOException {
        MDocument doc;
        importMod.initMolImport(rec, path);
        boolean newmol = false;
        if (mol == null) {
            mol = importMod.createMol();
            newmol = true;
        }
        MRecordImporter.initMol(mol, rec);
        if (importMod.isDocumentImporter()) {
            doc = mol.getDocument();
            if (doc == null) {
                doc = new MDocument(mol);
            } else {
                doc.clear();
            }
            doc = importMod.readDocument(doc);
            if (doc == null) {
                throw new MolFormatException("Document cannot be imported");
            }
            if (newmol) {
                doc.simplifyMolecule();
            }
            mol = (Molecule)doc.getMainMoleculeGraph();
        } else {
            MRecordImporter.readStructure(rec, importMod, mol);
            if (newmol) {
                mol = mol.getSimplifiedMolecule();
            }
            doc = mol.getDocument();
        }
        long startpos = rec.getStartPosition();
        long endpos = rec.getEndPosition();
        if (doc != null) {
            doc.setStartPosition(startpos);
            doc.setEndPosition(endpos);
        }
        mol.setStartPosition(startpos);
        mol.setEndPosition(endpos);
        return mol;
    }

    private MDocument readDoc(MRecord rec) throws MolFormatException, IOException {
        return MRecordImporter.readDoc(rec, this.molImportModule, this.molInputStream.getPath());
    }

    private static MDocument readDoc(MRecord rec, MolImportModule importMod, String path) throws MolFormatException, IOException {
        importMod.initMolImport(rec, path);
        Molecule mol = importMod.createMol();
        MRecordImporter.initMol(mol, rec);
        MDocument doc = new MDocument(mol);
        if (importMod.isDocumentImporter()) {
            MDocument d = importMod.readDocument(doc);
            if (d == null) {
                throw new MolFormatException("Document cannot be imported");
            }
            d.simplifyMolecule();
            doc = d;
            mol = (Molecule)doc.getMainMoleculeGraph();
        } else {
            MRecordImporter.readStructure(rec, importMod, mol);
            doc.simplifyMolecule();
        }
        long startpos = rec.getStartPosition();
        long endpos = rec.getEndPosition();
        doc.setStartPosition(startpos);
        doc.setEndPosition(endpos);
        mol.setStartPosition(startpos);
        mol.setEndPosition(endpos);
        return doc;
    }

    private static void readStructure(MRecord rec, MolImportModule importMod, Molecule mol) throws MolFormatException {
        try {
            if (!importMod.readMol(mol)) {
                throw new MolFormatException("Molecule cannot be imported");
            }
        }
        catch (MolFormatException ex) {
            MRecordImporter.handleException(ex, rec, importMod.getLineCount());
            throw ex;
        }
        catch (LicenseException lex) {
            throw lex;
        }
        catch (Throwable t) {
            MolFormatException ex = new MolFormatException(t);
            MRecordImporter.handleException(ex, rec, importMod.getLineCount());
            throw ex;
        }
    }

    public String readRecordAsText() throws MRecordParseException, IOException {
        if (this.concurrentProcessor != null) {
            throw new IllegalStateException("readRecordAsText() should be called before readMol() / readDoc().");
        }
        this.lastMoleculeString = null;
        this.lastRecord = this.recordReader.nextRecord();
        if (this.lastRecord == null) {
            return null;
        }
        this.lastMoleculeString = this.lastRecord.getString();
        ++this.recordNumber;
        return this.lastMoleculeString;
    }

    public MPropertyContainer getGlobalProperties() {
        if (this.recordReader instanceof MHeaderReader) {
            return ((MHeaderReader)((Object)this.recordReader)).getMarvinProperties();
        }
        return null;
    }

    public boolean isSeekable() {
        this.isSeekableCalled = true;
        return this.threadCount == 1 && this.recordReader.isSeekable();
    }

    public String getFormat() {
        return MRecordImporter.getFormat(this.recordReader);
    }

    public boolean getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(boolean q) {
        if (this.concurrentProcessor != null) {
            throw new IllegalStateException("setQueryMode() should be called before readMol() / readDoc().");
        }
        String fmt = this.getFormat();
        MFileFormat[] formats = MFileFormatUtil.findFormats(fmt, 0L, 0L);
        for (int i = 0; i < formats.length; ++i) {
            MFileFormat ass;
            MFileFormat f = formats[i];
            MFileFormat mFileFormat = ass = q ? f.getAssociatedQueryFormat() : f.getAssociatedNonQueryFormat();
            if (ass == null) continue;
            String newfmt = ass.getName();
            this.molInputStream.setFormat(newfmt);
            break;
        }
        this.queryMode = q;
    }

    public long getFilePointer() {
        return this.lastRecord != null ? this.lastRecord.getEndPosition() : this.molInputStream.getFilePointer();
    }

    public long length() throws IOException {
        return this.molInputStream.length();
    }

    public int getLineCount() {
        return this.lastRecord != null ? this.lastRecord.getEndLineCount() : this.molInputStream.getLineCount();
    }

    public void seek(long p, int lcount, int k) throws IOException {
        if (!this.isSeekable()) {
            throw new UnsupportedOperationException("MRecordImporter is not seekable.\nPossible reasons:\n1. The record reader is not seekable.\n2. seek() method is not available in concurrent mode.\n   Call setThreadCount(1) to set single-threaded mode.");
        }
        this.recordReader.seek(p, lcount, k);
        this.recordNumber = k;
    }

    public MRecord skipRecord() throws MRecordParseException, MolFormatException, IOException {
        if (this.concurrentProcessor != null) {
            if (this.returnType == 2) {
                this.readMol(null);
            } else {
                this.readDoc();
            }
        } else {
            this.lastRecord = this.recordReader.skipRecord();
        }
        if (this.lastRecord != null) {
            ++this.recordNumber;
        }
        return this.lastRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.recordReader.close();
        }
        finally {
            if (this.concurrentProcessor != null) {
                try {
                    this.concurrentProcessor.cleanup();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.concurrentProcessor = null;
            }
        }
    }

    public MolImportModule getMolImportModule() {
        return this.molImportModule;
    }

    public String getMoleculeString() {
        return this.lastMoleculeString;
    }

    public Molecule createMolIfNeeded() {
        return this.threadCount == 1 ? this.createMol() : null;
    }

    public Molecule createMol() {
        return this.molImportModule.createMol();
    }

    public MRecordReader getRecordReader() {
        return this.recordReader;
    }

    private MRecord startReadingNext() throws MRecordParseException, MolFormatException, IOException {
        Encoding enco;
        String enc;
        MRecord rec = this.recordReader.nextRecord();
        if (rec == null) {
            return null;
        }
        String header = this.recordReader.getHeaderAsString();
        String footer = this.recordReader.getFooterAsString();
        String molstr = rec.getString();
        if (header.length() + footer.length() != 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(header);
            sb.append(molstr);
            sb.append(footer);
            molstr = sb.toString();
        }
        String string = enc = (enco = this.molInputStream.getEncoding()) != null ? enco.name() : null;
        if (enc != null) {
            try {
                molstr.getBytes(enc);
            }
            catch (UnsupportedOperationException ex) {
                enc = "UTF-8";
            }
        }
        rec.setEncoding(enc);
        rec.setFormat(this.molInputStream.getFormat());
        rec.setMolString(molstr);
        rec.setEndLineCount(this.molInputStream.getLineCount());
        rec.setHeaderNewLineCount(MRecordImporter.countNewLines(header));
        rec.setInputFormat(MRecordImporter.getFormat(this.recordReader));
        return rec;
    }

    private static void initMol(Molecule mol, MRecord rec) throws MolFormatException, IOException {
        mol.clearProperties();
        mol.setInputFormat(rec.getInputFormat());
        MPropertyContainer source = rec.getPropertyContainer();
        if (source != null) {
            MPropertyContainer target = mol.properties();
            for (int i = 0; i < source.size(); ++i) {
                String key = source.getKey(i);
                MProp p = source.get(key);
                if (p instanceof MMoleculeStringProp) {
                    String molstr = ((MMoleculeStringProp)p).stringValue();
                    byte[] data = molstr.getBytes();
                    ByteArrayInputStream is = new ByteArrayInputStream(data);
                    MolInputStream mis = new MolInputStream(is);
                    mis.setEncoding(rec.getEncoding());
                    MolImportModule mod = MRecordImporter.createImportMod(mis);
                    mod.initMolImport(mis);
                    Molecule m = mod.createMol();
                    m.setInputFormat(mis.getFormat());
                    mod.readMol(m);
                    m = m.getSimplifiedMolecule();
                    p = new MMoleculeProp(m);
                }
                target.set(key, p);
            }
        }
    }

    private static String getFormat(MRecordReader r) {
        StringBuffer sb = new StringBuffer();
        while (r != null) {
            String s = r.getRecognizedFormat();
            if (sb.length() != 0) {
                sb.append(':');
            }
            sb.append(s);
            r = r.getEncapsulatedReader();
        }
        return sb.toString();
    }

    private static void handleException(Exception e) throws MRecordParseException, MolFormatException, IOException {
        if (e instanceof MRecordParseException) {
            throw (MRecordParseException)e;
        }
        if (e instanceof MolFormatException) {
            throw (MolFormatException)e;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
    }

    private static void handleException(MolFormatException ex, MRecord rec, int lineCount) {
        ex.setLineNumberInRecord(lineCount);
        ex.setLineNumberInFile(MRecordImporter.getLineNumberInFile(rec, lineCount));
    }

    private static int getLineNumberInFile(MRecord rec, int lineCount) {
        int l = lineCount;
        int[] map = rec.getLineNumberMap();
        if (map != null) {
            int l2 = l < map.length ? map[l] : map[map.length - 1] + 1;
            return l2 -= rec.getHeaderNewLineCount();
        }
        return l;
    }

    private static int countNewLines(String s) {
        if (s != null) {
            int n = 0;
            char nl = '\u0000';
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (nl == '\u0000' && (c == '\n' || c == '\r')) {
                    nl = c;
                }
                if (c != nl) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    private static class MolWorkUnitFactory
    extends MWorkUnitFactory {
        private String filePath;

        public MolWorkUnitFactory(String format2, String options, String path) {
            super(format2, options);
            this.filePath = path;
        }

        @Override
        public WorkUnit createWorkUnit() throws Exception {
            MolImportModule importMod = MRecordImporter.createImportMod(this.format);
            importMod.setOptions(this.options);
            return new MolWorkUnit(importMod, this.filePath);
        }
    }

    private static class MDocWorkUnitFactory
    extends MWorkUnitFactory {
        private String filePath;

        public MDocWorkUnitFactory(String format2, String options, String path) {
            super(format2, options);
            this.filePath = path;
        }

        @Override
        public WorkUnit createWorkUnit() throws Exception {
            MolImportModule importMod = MRecordImporter.createImportMod(this.format);
            importMod.setOptions(this.options);
            return new MDocWorkUnit(importMod, this.filePath);
        }
    }

    private static abstract class MWorkUnitFactory
    implements WorkUnitFactory {
        protected String format;
        protected String options;

        public MWorkUnitFactory(String format2, String options) {
            this.format = format2;
            this.options = options;
        }

        @Override
        public abstract WorkUnit createWorkUnit() throws Exception;
    }

    private static class MolWorkUnit
    extends MWorkUnit {
        private String filePath;

        public MolWorkUnit(MolImportModule importMod, String path) {
            super(importMod);
            this.filePath = path;
        }

        public Object call() throws Exception {
            if (this.error != null) {
                return this.error;
            }
            try {
                return new MolResult(this.rec, MRecordImporter.readMol(this.rec, this.importMod, null, this.filePath));
            }
            catch (Exception e) {
                return e;
            }
        }
    }

    private static class MDocWorkUnit
    extends MWorkUnit {
        private String filePath;

        public MDocWorkUnit(MolImportModule importMod, String path) {
            super(importMod);
            this.filePath = path;
        }

        public Object call() throws Exception {
            if (this.error != null) {
                return this.error;
            }
            try {
                return new MDocResult(this.rec, MRecordImporter.readDoc(this.rec, this.importMod, this.filePath));
            }
            catch (Exception e) {
                return e;
            }
        }
    }

    private static abstract class MWorkUnit
    implements WorkUnit {
        protected MRecord rec = null;
        protected Exception error = null;
        protected MolImportModule importMod = null;

        public MWorkUnit(MolImportModule importMod) {
            this.importMod = importMod;
        }

        @Override
        public void setInput(Object obj) throws ExecutionException {
            if (obj instanceof MRecord) {
                this.rec = (MRecord)obj;
                this.error = null;
            } else {
                this.rec = null;
                this.error = (Exception)obj;
            }
        }
    }

    private static class MDocResult
    extends MResult {
        MDocument doc = null;

        MDocResult(MRecord record, MDocument doc) {
            super(record);
            this.doc = doc;
        }
    }

    private static class MolResult
    extends MResult {
        Molecule mol = null;

        MolResult(MRecord record, Molecule mol) {
            super(record);
            this.mol = mol;
        }
    }

    private static abstract class MResult {
        protected MRecord record = null;

        MResult(MRecord record) {
            this.record = record;
        }
    }

    private class MInputProducer
    implements InputProducer<Object> {
        private MRecord rec = null;
        private Exception error = null;
        private boolean more = true;

        private MInputProducer() {
        }

        @Override
        public boolean hasNext() throws InterruptedException, ExecutionException {
            if (!this.more) {
                return false;
            }
            if (this.rec == null && this.error == null) {
                try {
                    this.rec = MRecordImporter.this.readRecord();
                    this.error = null;
                }
                catch (Exception e) {
                    this.rec = null;
                    this.error = e;
                }
            }
            this.more = this.rec != null || this.error != null;
            return this.more;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getNext() throws InterruptedException, ExecutionException {
            try {
                if (this.hasNext()) {
                    Object object = this.rec != null ? this.rec : this.error;
                    return object;
                }
                Object var1_2 = null;
                return var1_2;
            }
            finally {
                this.rec = null;
                this.error = null;
            }
        }
    }
}

